/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.ingredients.criteria;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.ValidationException;
import ptolemy.actor.gt.ingredients.criteria.ChoiceCriterionElement;
import ptolemy.actor.gt.ingredients.criteria.Criterion;
import ptolemy.actor.gt.ingredients.criteria.CriterionElement;
import ptolemy.actor.gt.ingredients.criteria.StringCriterionElement;
import ptolemy.actor.gt.util.PtolemyExpressionString;
import ptolemy.actor.gt.util.RegularExpressionString;
import ptolemy.actor.gt.util.VariableScope;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class AttributeCriterion
extends Criterion {
    private static final CriterionElement[] _ELEMENTS = new CriterionElement[]{new StringCriterionElement("name", false, false, false), new ChoiceCriterionElement("type", true, false, true, true), new StringCriterionElement("value", true, false, true)};
    private static final ParseTreeEvaluator _TYPE_EVALUATOR = new ParseTreeEvaluator();
    private static final PtParser _TYPE_PARSER = new PtParser();
    private RegularExpressionString _attributeName;
    private PtolemyExpressionString _attributeType;
    private PtolemyExpressionString _attributeValue;

    public AttributeCriterion(GTIngredientList owner) {
        this(owner, "");
    }

    public AttributeCriterion(GTIngredientList owner, String values) {
        this(owner, null, null, null);
        this.setValues(values);
    }

    public AttributeCriterion(GTIngredientList owner, String attributeName, String attributeType, String attributeValue) {
        super(owner, 3);
        NamedObj container = owner.getOwner().getContainer();
        this._attributeName = new RegularExpressionString(attributeName);
        this._attributeType = new PtolemyExpressionString(container, attributeType);
        this._attributeValue = new PtolemyExpressionString(container, attributeValue);
    }

    @Override
    public GTIngredientElement[] getElements() {
        return _ELEMENTS;
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this._attributeName;
            }
            case 1: {
                return this._attributeType;
            }
            case 2: {
                return this._attributeValue;
            }
        }
        return null;
    }

    @Override
    public String getValues() {
        StringBuffer buffer = new StringBuffer();
        this._encodeStringField(buffer, 0, this._attributeName.get());
        this._encodeStringField(buffer, 1, this._attributeType.get());
        this._encodeStringField(buffer, 2, this._attributeValue.get());
        return buffer.toString();
    }

    public boolean isAttributeNameEnabled() {
        return this.isEnabled(0);
    }

    public boolean isAttributeTypeEnabled() {
        return this.isEnabled(1);
    }

    public boolean isAttributeValueEnabled() {
        return this.isEnabled(2);
    }

    @Override
    public GTIngredient.NamedObjMatchResult match(NamedObj object) {
        for (Object attributeObject : object.attributeList()) {
            Pattern pattern;
            Matcher matcher;
            Attribute attribute = (Attribute)attributeObject;
            if (this.isAttributeNameEnabled() && !(matcher = (pattern = this._attributeName.getPattern()).matcher(attribute.getName())).matches()) continue;
            if (this.isAttributeTypeEnabled() || this.isAttributeValueEnabled()) {
                if (!(attribute instanceof Settable)) continue;
                Settable settable = (Settable)((Object)attribute);
                String expression = settable.getExpression();
                VariableScope scope = new VariableScope(object);
                try {
                    BooleanToken equality;
                    Type tokenType;
                    Type ruleType;
                    ASTPtRootNode tree = _TYPE_PARSER.generateParseTree(expression);
                    Token token = _TYPE_EVALUATOR.evaluateParseTree(tree, scope);
                    if (this.isAttributeTypeEnabled() && !(ruleType = this._attributeType.getToken().getType()).isCompatible(tokenType = token.getType())) continue;
                    if (this.isAttributeValueEnabled() && !(equality = token.isEqualTo(this._attributeValue.getToken())).booleanValue()) {
                    }
                }
                catch (IllegalActionException e) {}
                continue;
            }
            return GTIngredient.NamedObjMatchResult.MATCH;
        }
        return GTIngredient.NamedObjMatchResult.NOT_MATCH;
    }

    public void setAttributeNameEnabled(boolean enabled) {
        this.setEnabled(0, enabled);
    }

    public void setAttributeTypeEnabled(boolean enabled) {
        this.setEnabled(1, enabled);
    }

    public void setAttributeValueEnabled(boolean enabled) {
        this.setEnabled(2, enabled);
    }

    @Override
    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this._attributeName.set((String)value);
                break;
            }
            case 1: {
                this._attributeType.set((String)value);
                break;
            }
            case 2: {
                this._attributeValue.set((String)value);
            }
        }
    }

    @Override
    public void setValues(String values) {
        GTIngredient.FieldIterator fieldIterator = new GTIngredient.FieldIterator(values);
        this._attributeName.set(this._decodeStringField(0, fieldIterator));
        this._attributeType.set(this._decodeStringField(1, fieldIterator));
        this._attributeValue.set(this._decodeStringField(2, fieldIterator));
    }

    @Override
    public void validate() throws ValidationException {
        if (this.isAttributeNameEnabled()) {
            if (this._attributeName.get().equals("")) {
                throw new ValidationException("Attribute name must not be empty.");
            }
            try {
                this._attributeName.getPattern();
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException("Regular expression \"" + this._attributeName + "\" cannot be compiled.", e);
            }
        }
        if (this.isAttributeTypeEnabled()) {
            if (this._attributeType.get().equals("")) {
                throw new ValidationException("Port type must not be empty.");
            }
            try {
                this._attributeType.getToken().getType();
            }
            catch (IllegalActionException e) {
                throw new ValidationException("Type expression \"" + this._attributeType + "\" cannot be parsed.", e);
            }
        }
        if (this.isAttributeValueEnabled()) {
            try {
                this._attributeValue.getToken();
            }
            catch (IllegalActionException e) {
                throw new ValidationException("Value expression \"" + this._attributeValue + "\" cannot be parsed.", e);
            }
        }
    }

    static {
        ChoiceCriterionElement attributeTypes = (ChoiceCriterionElement)_ELEMENTS[1];
        attributeTypes.addChoices(Constants.types().keySet());
        attributeTypes.addChoice("arrayType(int)");
        attributeTypes.addChoice("arrayType(int,5)");
        attributeTypes.addChoice("[double]");
        attributeTypes.addChoice("{x=double, y=double}");
    }
}

