/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.data;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import ptolemy.kernel.util.KernelRuntimeException;

public class FastLinkedList<E>
implements Collection<E> {
    private Entry _head;
    private boolean _recalculateSize;
    private int _size;
    private Entry _tail;

    @Override
    public boolean add(E element) {
        Entry entry = new Entry(this, element);
        this.addEntryToTail(entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E element : collection) {
            this.add(element);
        }
        return true;
    }

    public void addEntryAfter(Entry entry, Entry previousEntry) {
        if (previousEntry == null) {
            this.addEntryToHead(entry);
        } else {
            entry._previous = previousEntry;
            entry._next = previousEntry._next;
            entry._list = this;
            previousEntry._next = entry;
            if (entry._next != null) {
                entry._next._previous = entry;
            } else {
                this._tail = entry;
            }
            ++this._size;
        }
    }

    public void addEntryBefore(Entry entry, Entry nextEntry) {
        if (nextEntry == null) {
            this.addEntryToTail(entry);
        } else {
            entry._next = nextEntry;
            entry._previous = nextEntry._previous;
            entry._list = this;
            nextEntry._previous = entry;
            if (entry._previous != null) {
                entry._previous._next = entry;
            } else {
                this._head = entry;
            }
            ++this._size;
        }
    }

    public void addEntryToHead(Entry entry) {
        entry._previous = null;
        entry._next = this._head;
        if (this._head == null) {
            this._head = this._tail = entry;
        } else {
            this._head._previous = entry;
            this._head = entry;
        }
        ++this._size;
    }

    public void addEntryToTail(Entry entry) {
        entry._previous = this._tail;
        entry._next = null;
        entry._list = this;
        if (this._head == null) {
            this._head = this._tail = entry;
        } else {
            this._tail._next = entry;
            this._tail = entry;
        }
        ++this._size;
    }

    @Override
    public void clear() {
        this._tail = null;
        this._head = null;
        this._size = 0;
        this._recalculateSize = false;
    }

    @Override
    public boolean contains(Object element) {
        return this.findEntry(element) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public Entry findEntry(E element) {
        Entry entry = this._head;
        while (entry != null) {
            if (entry._value == element || entry._value.equals(element)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    public Entry getHead() {
        return this._head;
    }

    public Entry getTail() {
        return this._tail;
    }

    @Override
    public boolean isEmpty() {
        return this._head == null;
    }

    @Override
    public Iterator<E> iterator() {
        throw new KernelRuntimeException("Not implemented.");
    }

    @Override
    public boolean remove(Object o) {
        Entry entry = this.findEntry(o);
        if (entry == null) {
            return false;
        }
        if (entry == this._head) {
            this._head = entry._next;
        }
        if (entry == this._tail) {
            this._tail = entry._previous;
        }
        if (entry._previous != null) {
            entry._previous._next = entry._next;
        }
        if (entry._next != null) {
            entry._next._previous = entry._previous;
        }
        --this._size;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object element : c) {
            modified |= this.remove(element);
        }
        return modified;
    }

    public boolean removeAllAfter(Entry entry) {
        if (entry == this._tail) {
            return false;
        }
        if (entry == null) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        entry._next = null;
        this._tail = entry;
        this._recalculateSize = true;
        return true;
    }

    public boolean removeAllBefore(Entry entry) {
        if (entry == this._head) {
            return false;
        }
        if (entry == null) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        entry._previous = null;
        this._head = entry;
        this._recalculateSize = true;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        Entry entry = this._head;
        while (entry != null) {
            if (!collection.contains(entry._value)) {
                this.remove(entry);
                modified = true;
            }
            entry = entry._next;
        }
        return modified;
    }

    @Override
    public int size() {
        if (this._recalculateSize) {
            this._size = 0;
            Entry entry = this._head;
            while (entry != null) {
                ++this._size;
                entry = entry._next;
            }
        }
        return this._size;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        Entry entry = this._head;
        int i = 0;
        while (entry != null) {
            array[i++] = entry._value;
            entry = entry._next;
        }
        return array;
    }

    @Override
    public <S> S[] toArray(S[] array) {
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        int i = 0;
        Entry entry = this._head;
        while (entry != null) {
            array[i++] = entry._value;
            entry = entry._next;
        }
        return array;
    }

    public class Entry {
        private FastLinkedList<E> _list;
        private Entry _next;
        private Entry _previous;
        private E _value;

        public FastLinkedList<E> getList() {
            return this._list;
        }

        public Entry getNext() {
            return this._next;
        }

        public Entry getPrevious() {
            return this._previous;
        }

        public E getValue() {
            return this._value;
        }

        public boolean hasNext() {
            return this._next != null;
        }

        public boolean hasPrevious() {
            return this._previous != null;
        }

        public void remove() {
            if (this._previous != null) {
                this._previous._next = this._next;
            } else {
                this._list._head = this._next;
            }
            if (this._next != null) {
                this._next._previous = this._previous;
            } else {
                this._list._tail = this._previous;
            }
            this._list._size--;
        }

        private Entry(FastLinkedList<E> list, E value) {
            this._list = list;
            this._value = value;
        }
    }
}

