/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.data;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.KernelRuntimeException;

public class CombinedCollection<E>
implements Collection<E> {
    private List<Collection<? extends E>> _collectionList = new LinkedList<Collection<? extends E>>();
    private boolean _isLastListModifiable = false;

    public CombinedCollection() {
    }

    public CombinedCollection(Collection<? extends E> ... collections) {
        for (Collection<? extends E> collection : collections) {
            this._collectionList.add(collection);
        }
    }

    @Override
    public boolean add(E o) {
        Collection<Object> collection;
        if (this._isLastListModifiable) {
            collection = this._collectionList.get(this._collectionList.size() - 1);
        } else {
            collection = new LinkedList();
            this._collectionList.add(collection);
            this._isLastListModifiable = true;
        }
        collection.add(o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this._collectionList.add(c);
        this._isLastListModifiable = false;
        return true;
    }

    @Override
    public void clear() {
        this._collectionList.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> collection : this._collectionList) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> collection : this._collectionList) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<E> iterator() {
        return new Iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new KernelRuntimeException("Not implemented.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new KernelRuntimeException("Not implemented.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new KernelRuntimeException("Not implemented.");
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> collection : this._collectionList) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        int i = 0;
        T[] result = array;
        for (Collection<E> collection : this._collectionList) {
            for (E object : collection) {
                result[i++] = object;
            }
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    protected List<Collection<? extends E>> _getCollectionList() {
        return this._collectionList;
    }

    private class Iterator
    implements java.util.Iterator<E> {
        private java.util.Iterator<Collection<? extends E>> _collectionIterator;
        private java.util.Iterator<? extends E> _objectIterator;

        @Override
        public boolean hasNext() {
            return this._objectIterator != null;
        }

        @Override
        public E next() {
            Object next = this._objectIterator.next();
            this._ensureNext();
            return next;
        }

        @Override
        public void remove() {
            throw new KernelRuntimeException("Not implemented.");
        }

        Iterator() {
            this._collectionIterator = CombinedCollection.this._collectionList.iterator();
            this._ensureNext();
        }

        private void _ensureNext() {
            if (this._objectIterator == null || !this._objectIterator.hasNext()) {
                this._objectIterator = null;
                while (this._collectionIterator.hasNext()) {
                    Collection collection = this._collectionIterator.next();
                    if (collection.isEmpty()) continue;
                    this._objectIterator = collection.iterator();
                    break;
                }
            }
        }
    }
}

