/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import ptolemy.actor.Director;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gt.GraphMatcher;
import ptolemy.actor.gt.GraphTransformer;
import ptolemy.actor.gt.MatchCallback;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.TransformationException;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.actor.lib.hoc.MultiCompositeActor;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ActorToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;

public class TransformationRule
extends MultiCompositeActor
implements MatchCallback,
ValueListener {
    public TypedIOPort matchInput;
    public TypedIOPort matchOutput;
    public StringParameter mode;
    public TypedIOPort modelInput;
    public TypedIOPort modelOutput;
    public TypedIOPort modified;
    public TypedIOPort remaining;
    public Parameter repeatUntilFixpoint;
    public TypedIOPort trigger;
    private static final List<?> _EMPTY_LIST = new LinkedList();
    private boolean _collectAllMatches;
    private CompositeEntity _lastModel;
    private LinkedList<MatchResult> _lastResults = new LinkedList();
    private LastResultsOperation _lastResultsOperation;
    private Random _random = new Random();

    public TransformationRule(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public TransformationRule(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        String modeString = this.mode.getExpression();
        boolean singleRunMode = modeString.equals(Mode.REPLACE_FIRST.toString()) || modeString.equals(Mode.REPLACE_ANY.toString()) || modeString.equals(Mode.REPLACE_ALL.toString());
        boolean repeat = ((BooleanToken)this.repeatUntilFixpoint.getToken()).booleanValue();
        if (repeat && !singleRunMode) {
            throw new IllegalActionException("When the mode is set to \"" + modeString + "\", " + "repeatUntilFixpoint must be false.");
        }
        super.attributeChanged(attribute);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TransformationRule actor = (TransformationRule)super.clone();
        actor._lastModel = null;
        actor._lastResults = new LinkedList();
        actor._random = new Random();
        return actor;
    }

    @Override
    public void fire() throws IllegalActionException {
        try {
            MatchResult match;
            Token token;
            for (Object parameterObject : this.attributeList()) {
                if (!(parameterObject instanceof PortParameter)) continue;
                ((PortParameter)parameterObject).update();
            }
            if (this.modelInput.hasToken(0)) {
                token = (ActorToken)this.modelInput.get(0);
                this._lastModel = (CompositeEntity)((ActorToken)token).getEntity();
                this._lastModel.setDeferringChangeRequests(false);
                Mode mode = this._getMode();
                GraphMatcher matcher = new GraphMatcher();
                matcher.setMatchCallback(this);
                this._collectAllMatches = mode != Mode.REPLACE_FIRST;
                this._lastResults.clear();
                matcher.match(this.getPattern(), this._lastModel);
                if (mode == Mode.REPLACE_FIRST || mode == Mode.REPLACE_ANY || mode == Mode.REPLACE_ALL) {
                    boolean foundMatch;
                    boolean bl = foundMatch = !this._lastResults.isEmpty();
                    if (foundMatch) {
                        boolean repeat = ((BooleanToken)this.repeatUntilFixpoint.getToken()).booleanValue();
                        while (!this._lastResults.isEmpty()) {
                            switch (mode) {
                                case REPLACE_FIRST: {
                                    MatchResult result = this._lastResults.peek();
                                    GraphTransformer.transform(this, result);
                                    break;
                                }
                                case REPLACE_ANY: {
                                    MatchResult result = this._lastResults.get(this._random.nextInt(this._lastResults.size()));
                                    GraphTransformer.transform(this, result);
                                    break;
                                }
                                case REPLACE_ALL: {
                                    GraphTransformer.transform(this, this._lastResults);
                                }
                            }
                            if (!repeat) break;
                            this._lastResults.clear();
                            matcher.match(this.getPattern(), this._lastModel);
                        }
                    }
                    this.modelOutput.send(0, new ActorToken(this._lastModel));
                    this.modified.send(0, BooleanToken.getInstance(foundMatch));
                    return;
                }
            }
            if (this.matchInput.getWidth() > 0 && this.matchInput.hasToken(0) && this._lastModel != null && (match = (MatchResult)((ObjectToken)(token = (ObjectToken)this.matchInput.get(0))).getValue()) != null) {
                CompositeEntity host = (CompositeEntity)match.get(this.getPattern());
                if (this._lastModel != host && !this._lastModel.deepContains(host)) {
                    throw new IllegalActionException((Nameable)this, "The match result cannot be used with the current model.");
                }
                GraphTransformer.transform(this, match);
                this.modelOutput.send(0, new ActorToken(this._lastModel));
            }
            if (this.trigger.getWidth() > 0 && this.trigger.hasToken(0) && !this._lastResults.isEmpty()) {
                this.trigger.get(0);
                this._lastResultsOperation = LastResultsOperation.REMOVE_FIRST;
                MatchResult result = this._lastResults.peek();
                this.matchOutput.send(0, new ObjectToken(result));
            }
        }
        catch (TransformationException e) {
            throw new IllegalActionException((Nameable)this, e, "Unable to transform model.");
        }
        this.remaining.send(0, new IntToken(this._lastResults.size()));
    }

    @Override
    public boolean foundMatch(GraphMatcher matcher) {
        this._lastResults.add((MatchResult)matcher.getMatchResult().clone());
        return !this._collectAllMatches;
    }

    public Pattern getPattern() {
        return (Pattern)this.getEntity("Pattern");
    }

    public Replacement getReplacement() {
        return (Replacement)this.getEntity("Replacement");
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._lastModel = null;
        this._lastResults.clear();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        switch (this._lastResultsOperation) {
            case CLEAR: {
                this._lastResults.clear();
                break;
            }
            case NONE: {
                break;
            }
            case REMOVE_FIRST: {
                this._lastResults.poll();
            }
        }
        return true;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._lastResultsOperation = LastResultsOperation.NONE;
        String modeString = this.mode.getExpression();
        if (modeString.equals(Mode.REPLACE_FIRST.toString()) || modeString.equals(Mode.REPLACE_ANY.toString()) || modeString.equals(Mode.REPLACE_ALL.toString())) {
            return this.modelInput.hasToken(0);
        }
        return this.modelInput.hasToken(0) || this.matchInput.getWidth() > 0 && this.matchInput.hasToken(0) && this._lastModel != null || this.trigger.getWidth() > 0 && this.trigger.hasToken(0) && !this._lastResults.isEmpty();
    }

    @Override
    public List<?> typeConstraintList() {
        return _EMPTY_LIST;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void valueChanged(Settable settable) {
        boolean singleRunMode;
        if (settable != this.mode) return;
        String modeString = this.mode.getExpression();
        boolean bl = singleRunMode = modeString.equals(Mode.REPLACE_FIRST.toString()) || modeString.equals(Mode.REPLACE_ANY.toString()) || modeString.equals(Mode.REPLACE_ALL.toString());
        if (singleRunMode) {
            try {
                if (this.matchInput != null) {
                    this.matchInput.setContainer(null);
                    this.matchInput = null;
                }
                if (this.matchOutput != null) {
                    this.matchOutput.setContainer(null);
                    this.matchOutput = null;
                }
                if (this.trigger != null) {
                    this.trigger.setContainer(null);
                    this.trigger = null;
                }
                if (this.remaining != null) {
                    this.remaining.setContainer(null);
                    this.remaining = null;
                }
                if (this.modified != null) return;
                this.modified = new TypedIOPort(this, "modified", false, true);
                this.modified.setTypeEquals(BaseType.BOOLEAN);
                this.modified.setPersistent(false);
                new StringAttribute(this.modified, "_cardinal").setExpression("SOUTH");
                return;
            }
            catch (KernelException e) {
                throw new InternalErrorException(this, (Throwable)e, "Cannot remove port.");
            }
        }
        if (!modeString.equals(Mode.EXPERT.toString())) throw new InternalErrorException("Cannot set mode to " + modeString + ".");
        try {
            boolean repeat = ((BooleanToken)this.repeatUntilFixpoint.getToken()).booleanValue();
            if (repeat) {
                return;
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        try {
            if (this.modified != null) {
                this.modified.setContainer(null);
                this.modified = null;
            }
            if (this.matchInput == null) {
                this.matchInput = new TypedIOPort(this, "matchInput", true, false);
                this.matchInput.setTypeEquals(BaseType.OBJECT);
                this.matchInput.setPersistent(false);
            }
            if (this.matchOutput == null) {
                this.matchOutput = new TypedIOPort(this, "matchOutput", false, true);
                this.matchOutput.setTypeEquals(BaseType.OBJECT);
                this.matchOutput.setPersistent(false);
            }
            if (this.trigger == null) {
                this.trigger = new TypedIOPort(this, "trigger", true, false);
                this.trigger.setTypeEquals(BaseType.BOOLEAN);
                this.trigger.setPersistent(false);
                new StringAttribute(this.trigger, "_cardinal").setExpression("SOUTH");
            }
            if (this.remaining != null) return;
            this.remaining = new TypedIOPort(this, "remaining", false, true);
            this.remaining.setTypeEquals(BaseType.INT);
            this.remaining.setPersistent(false);
            new StringAttribute(this.remaining, "_cardinal").setExpression("SOUTH");
            return;
        }
        catch (KernelException e) {
            throw new InternalErrorException(this, (Throwable)e, "Cannot create port.");
        }
    }

    protected void _init() throws IllegalActionException, NameDuplicationException {
        this.setClassName("ptolemy.actor.gt.TransformationRule");
        new Pattern(this, "Pattern");
        new Replacement(this, "Replacement");
        this.modelInput = new TypedIOPort(this, "modelInput", true, false);
        this.modelInput.setTypeEquals(ActorToken.TYPE);
        this.modelOutput = new TypedIOPort(this, "modelOutput", false, true);
        this.modelOutput.setTypeEquals(ActorToken.TYPE);
        this.mode = new StringParameter(this, "mode");
        for (int i = Mode.values().length - 1; i >= 0; --i) {
            this.mode.addChoice(Mode.values()[i].toString());
        }
        this.mode.addValueListener(this);
        this.mode.setExpression(Mode.REPLACE_FIRST.toString());
        this.repeatUntilFixpoint = new Parameter(this, "repeatUntilFixpoint");
        this.repeatUntilFixpoint.setTypeEquals(BaseType.BOOLEAN);
        this.repeatUntilFixpoint.setToken(BooleanToken.FALSE);
        new TransformationDirector(this, "GTDirector");
    }

    private Mode _getMode() throws IllegalActionException {
        String modeString = this.mode.getExpression();
        if (modeString.equals(Mode.REPLACE_FIRST.toString())) {
            return Mode.REPLACE_FIRST;
        }
        if (modeString.equals(Mode.REPLACE_ANY.toString())) {
            return Mode.REPLACE_ANY;
        }
        if (modeString.equals(Mode.REPLACE_ALL.toString())) {
            return Mode.REPLACE_ALL;
        }
        if (modeString.equals(Mode.EXPERT.toString())) {
            return Mode.EXPERT;
        }
        throw new IllegalActionException("Unexpected mode: " + modeString);
    }

    private static enum LastResultsOperation {
        CLEAR,
        NONE,
        REMOVE_FIRST;

    }

    public static enum Mode {
        EXPERT{

            public String toString() {
                return "full control";
            }
        }
        ,
        REPLACE_ALL{

            public String toString() {
                return "replace all";
            }
        }
        ,
        REPLACE_ANY{

            public String toString() {
                return "replace any";
            }
        }
        ,
        REPLACE_FIRST{

            public String toString() {
                return "replace first";
            }
        };

    }

    public static class TransformationDirector
    extends Director {
        public TransformationDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.setClassName("ptolemy.actor.gt.TransformationRule$GTDirector");
        }

        @Override
        public void initialize() throws IllegalActionException {
        }

        @Override
        public void wrapup() throws IllegalActionException {
        }
    }
}

