/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.gt.RelationCollapsingAttribute;
import ptolemy.actor.gt.TransformationAttribute;
import ptolemy.actor.gt.data.FastLinkedList;
import ptolemy.actor.gt.data.Pair;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public abstract class GraphAnalyzer {
    public NamedObj findFirstChild(CompositeEntity top, IndexedLists indexedLists, Collection<Object> excludedObjects) {
        boolean collapsing;
        LinkedList children = new LinkedList(top.entityList(ComponentEntity.class));
        Token collapsingToken = this._getAttribute(top, "RelationCollapsing", RelationCollapsingAttribute.class);
        boolean bl = collapsing = collapsingToken == null ? false : ((BooleanToken)collapsingToken).booleanValue();
        if (!collapsing) {
            for (Object relationObject : top.relationList()) {
                children.add(relationObject);
            }
        }
        if (!children.isEmpty()) {
            int i = 0;
            IndexedList currentList = new IndexedList(children, 0);
            indexedLists.add(currentList);
            FastLinkedList.Entry currentListEntry = indexedLists.getTail();
            for (Object child : children) {
                currentList.setSecond(i);
                if (!(child instanceof CompositeEntity) || this._isOpaque((CompositeEntity)child)) {
                    if (!excludedObjects.contains(child)) {
                        return (NamedObj)child;
                    }
                } else {
                    CompositeEntity compositeEntity = (CompositeEntity)child;
                    NamedObj childObject = this.findFirstChild(compositeEntity, indexedLists, excludedObjects);
                    if (childObject != null && !excludedObjects.contains(childObject)) {
                        return childObject;
                    }
                }
                ++i;
            }
            currentListEntry.remove();
        }
        return null;
    }

    public boolean findFirstPath(Port startPort, Path path, Set<? super Relation> visitedRelations, Set<? super Port> visitedPorts) {
        List relationList = startPort.linkedRelationList();
        if (startPort instanceof ComponentPort) {
            relationList.addAll(((ComponentPort)startPort).insideRelationList());
        }
        int i = 0;
        IndexedList currentList = new IndexedList(relationList, 0);
        path.add(currentList);
        FastLinkedList.Entry currentListEntry = path.getTail();
        for (Object relationObject : relationList) {
            Relation relation = (Relation)relationObject;
            if (visitedRelations.contains(relation) || this._ignoreRelation(relation)) {
                ++i;
                continue;
            }
            currentList.setSecond(i);
            visitedRelations.add(relation);
            List portList = relation.linkedPortList();
            int j = 0;
            IndexedList currentList2 = new IndexedList(portList, 0);
            path.add(currentList2);
            FastLinkedList.Entry currentListEntry2 = path.getTail();
            for (Object portObject : portList) {
                Port port = (Port)portObject;
                if (visitedPorts.contains(port)) {
                    ++j;
                    continue;
                }
                currentList2.setSecond(j);
                visitedPorts.add(port);
                NamedObj container = port.getContainer();
                boolean reachEnd = true;
                if (container instanceof CompositeEntity && !this._isOpaque((CompositeEntity)container)) {
                    if (this.findFirstPath(port, path, visitedRelations, visitedPorts)) {
                        return true;
                    }
                    reachEnd = false;
                }
                if (reachEnd) {
                    return true;
                }
                visitedPorts.remove(port);
                ++j;
            }
            currentListEntry2.remove();
            visitedRelations.remove(relation);
            ++i;
        }
        currentListEntry.remove();
        return false;
    }

    public NamedObj findNextChild(CompositeEntity top, IndexedLists indexedLists, Collection<Object> excludedObjects) {
        if (indexedLists.isEmpty()) {
            return this.findFirstChild(top, indexedLists, excludedObjects);
        }
        for (FastLinkedList.Entry entry = indexedLists.getTail(); entry != null; entry = entry.getPrevious()) {
            IndexedList indexedList = (IndexedList)entry.getValue();
            List objectList = (List)indexedList.getFirst();
            for (int index = (Integer)indexedList.getSecond() + 1; index < objectList.size(); ++index) {
                indexedList.setSecond(index);
                NamedObj child = (NamedObj)objectList.get(index);
                indexedLists.removeAllAfter(entry);
                if (!(child instanceof CompositeEntity) || this._isOpaque((CompositeEntity)child)) {
                    if (excludedObjects.contains(child)) continue;
                    return child;
                }
                CompositeEntity compositeEntity = (CompositeEntity)child;
                NamedObj childObject = this.findFirstChild(compositeEntity, indexedLists, excludedObjects);
                if (childObject == null) continue;
                return childObject;
            }
        }
        indexedLists.clear();
        return null;
    }

    public boolean findNextPath(Path path, Set<Relation> visitedRelations, Set<Port> visitedPorts) {
        for (FastLinkedList.Entry entry = path.getTail(); entry != null; entry = entry.getPrevious()) {
            IndexedList markedEntityList = (IndexedList)entry.getValue();
            List entityList = (List)markedEntityList.getFirst();
            for (int index = (Integer)markedEntityList.getSecond() + 1; index < entityList.size(); ++index) {
                markedEntityList.setSecond(index);
                path.removeAllAfter(entry);
                Object nextObject = entityList.get(index);
                if (nextObject instanceof Port) {
                    Port port = (Port)nextObject;
                    if (visitedPorts.contains(port)) continue;
                    visitedPorts.add(port);
                    NamedObj container = port.getContainer();
                    if (!(container instanceof CompositeEntity) || this._isOpaque((CompositeEntity)container)) {
                        return true;
                    }
                    if (this.findFirstPath(port, path, visitedRelations, visitedPorts)) {
                        return true;
                    }
                    visitedPorts.remove(port);
                } else {
                    Relation relation = (Relation)nextObject;
                    if (visitedRelations.contains(relation) || this._ignoreRelation(relation)) continue;
                    visitedRelations.add(relation);
                    List portList = relation.linkedPortList();
                    int i = 0;
                    for (Object portObject : portList) {
                        Port port = (Port)portObject;
                        if (visitedPorts.contains(port)) {
                            ++i;
                            continue;
                        }
                        path.add(new IndexedList(portList, i));
                        visitedPorts.add(port);
                        NamedObj container = port.getContainer();
                        if (!(container instanceof CompositeEntity) || this._isOpaque((CompositeEntity)container)) {
                            return true;
                        }
                        if (this.findFirstPath(port, path, visitedRelations, visitedPorts)) {
                            return true;
                        }
                        visitedPorts.remove(port);
                    }
                    visitedRelations.remove(relation);
                }
                if (!this.findNextPath(path, visitedRelations, visitedPorts)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract Token _getAttribute(NamedObj var1, String var2, Class<? extends TransformationAttribute> var3);

    protected boolean _ignoreRelation(Relation relation) {
        Attribute hideAttribute = relation.getAttribute("_hide");
        if (hideAttribute != null) {
            try {
                BooleanToken token = (BooleanToken)((Parameter)hideAttribute).getToken();
                boolean hide = token.booleanValue();
                return hide;
            }
            catch (IllegalActionException illegalActionException) {
                // empty catch block
            }
        }
        return false;
    }

    protected abstract boolean _isOpaque(CompositeEntity var1);

    public static class Path
    extends IndexedLists
    implements Cloneable {
        private Port _startPort;

        public Object clone() {
            Path path = new Path(this._startPort);
            for (FastLinkedList.Entry entry = this.getHead(); entry != null; entry = entry.getNext()) {
                path.add((IndexedList)((IndexedList)entry.getValue()).clone());
            }
            return path;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this._startPort == ((Path)object)._startPort;
        }

        public Port getEndPort() {
            IndexedList list = (IndexedList)this.getTail().getValue();
            return (Port)((List)list.getFirst()).get((Integer)list.getSecond());
        }

        public Port getStartPort() {
            return this._startPort;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(new int[]{this._startPort.hashCode(), super.hashCode()});
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this._startPort.getFullName());
            buffer.append(":[");
            int i = 0;
            for (FastLinkedList.Entry entry = this.getHead(); entry != null; entry = entry.getNext()) {
                IndexedList markedList = (IndexedList)entry.getValue();
                List list = (List)markedList.getFirst();
                NamedObj object = (NamedObj)list.get((Integer)markedList.getSecond());
                if (i++ > 0) {
                    buffer.append(", ");
                }
                buffer.append(object.getFullName());
            }
            buffer.append("]");
            return buffer.toString();
        }

        Path(Port startPort) {
            this._startPort = startPort;
        }
    }

    public static class IndexedLists
    extends FastLinkedList<IndexedList> {
    }

    public static class IndexedList
    extends Pair<List<?>, Integer> {
        @Override
        public boolean equals(Object object) {
            if (object instanceof IndexedList) {
                IndexedList list = (IndexedList)object;
                return ((List)this.getFirst()).get((Integer)this.getSecond()) == ((List)list.getFirst()).get((Integer)list.getSecond());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((List)this.getFirst()).get((Integer)this.getSecond()).hashCode();
        }

        IndexedList(List<?> list, Integer mark) {
            super(list, mark);
        }
    }
}

