/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Collection;
import ptolemy.actor.gt.CompositeActorMatcher;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.PatternObjectAttribute;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.TransformationRule;
import ptolemy.actor.gt.data.CombinedCollection;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;

public class GTTools {
    public static NamedObj getChild(NamedObj object, String name, boolean allowAttribute, boolean allowPort, boolean allowEntity, boolean allowRelation) {
        NamedObj child = null;
        if (allowAttribute) {
            child = object.getAttribute(name);
        }
        if (child == null && allowPort && object instanceof Entity) {
            child = ((Entity)object).getPort(name);
        }
        if (object instanceof CompositeEntity) {
            if (child == null && allowEntity) {
                child = ((CompositeEntity)object).getEntity(name);
            }
            if (child == null && allowRelation) {
                child = ((CompositeEntity)object).getRelation(name);
            }
        }
        return child;
    }

    public static Collection<?> getChildren(NamedObj object, boolean includeAttributes, boolean includePorts, boolean includeEntities, boolean includeRelations) {
        Entity entity;
        CombinedCollection collection = new CombinedCollection();
        if (includeAttributes) {
            collection.addAll(object.attributeList());
        }
        if (includePorts && object instanceof Entity) {
            entity = (Entity)object;
            collection.addAll(entity.portList());
        }
        if (object instanceof CompositeEntity) {
            entity = (CompositeEntity)object;
            if (includeEntities) {
                collection.addAll(((CompositeEntity)entity).entityList());
            }
            if (includeRelations) {
                collection.addAll(((CompositeEntity)entity).relationList());
            }
        }
        return collection;
    }

    public static String getCodeFromObject(NamedObj object, NamedObj topContainer) {
        String replacementAbbrev = GTTools.getObjectTypeAbbreviation(object);
        String name = topContainer == null ? object.getName() : object.getName(topContainer);
        return replacementAbbrev + name;
    }

    public static CompositeActorMatcher getContainingPatternOrReplacement(NamedObj entity) {
        NamedObj parent;
        for (parent = entity.getContainer(); parent != null && !(parent instanceof Pattern) && !(parent instanceof Replacement); parent = parent.getContainer()) {
        }
        return (CompositeActorMatcher)parent;
    }

    public static NamedObj getCorrespondingPatternObject(NamedObj replacementObject) {
        PatternObjectAttribute attribute = GTTools.getPatternObjectAttribute(replacementObject);
        if (attribute == null) {
            return null;
        }
        CompositeActorMatcher container = GTTools.getContainingPatternOrReplacement(replacementObject);
        if (container == null) {
            return null;
        }
        String patternObjectName = attribute.getExpression();
        if (patternObjectName.equals("")) {
            return null;
        }
        TransformationRule transformer = (TransformationRule)container.getContainer();
        Pattern pattern = transformer.getPattern();
        if (replacementObject instanceof Entity) {
            return pattern.getEntity(patternObjectName);
        }
        if (replacementObject instanceof Relation) {
            return pattern.getRelation(patternObjectName);
        }
        return null;
    }

    public static MoMLChangeRequest getDeletionChangeRequest(Object originator, NamedObj object) {
        String moml;
        if (object instanceof Attribute) {
            moml = "<deleteProperty name=\"" + object.getName() + "\"/>";
        } else if (object instanceof Entity) {
            moml = "<deleteEntity name=\"" + object.getName() + "\"/>";
        } else if (object instanceof Port) {
            moml = "<deletePort name=\"" + object.getName() + "\"/>";
        } else if (object instanceof Relation) {
            moml = "<deleteRelation name=\"" + object.getName() + "\"/>";
        } else {
            return null;
        }
        return new MoMLChangeRequest(originator, object.getContainer(), moml);
    }

    public static NamedObj getObjectFromCode(String code, NamedObj topContainer) {
        String abbreviation = code.substring(0, 2);
        String name = code.substring(2);
        if (abbreviation.equals("A:")) {
            return topContainer.getAttribute(name);
        }
        if (abbreviation.equals("E:") && topContainer instanceof CompositeEntity) {
            return ((CompositeEntity)topContainer).getEntity(name);
        }
        if (abbreviation.equals("P:") && topContainer instanceof Entity) {
            return ((Entity)topContainer).getPort(name);
        }
        if (abbreviation.equals("R:") && topContainer instanceof CompositeEntity) {
            return ((CompositeEntity)topContainer).getRelation(name);
        }
        return null;
    }

    public static String getObjectTypeAbbreviation(NamedObj object) {
        if (object instanceof Attribute) {
            return "A:";
        }
        if (object instanceof Entity) {
            return "E:";
        }
        if (object instanceof Port) {
            return "P:";
        }
        if (object instanceof Relation) {
            return "R:";
        }
        return null;
    }

    public static PatternObjectAttribute getPatternObjectAttribute(NamedObj object) {
        Attribute attribute = object.getAttribute("patternObject");
        if (attribute != null && attribute instanceof PatternObjectAttribute) {
            return (PatternObjectAttribute)attribute;
        }
        return null;
    }

    public static boolean isInPattern(NamedObj entity) {
        CompositeActorMatcher container = GTTools.getContainingPatternOrReplacement(entity);
        return container != null && container instanceof Pattern;
    }

    public static boolean isInReplacement(NamedObj entity) {
        CompositeActorMatcher container = GTTools.getContainingPatternOrReplacement(entity);
        return container != null && container instanceof Replacement;
    }
}

