/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientsAttribute;
import ptolemy.actor.gt.MalformedStringException;
import ptolemy.actor.gt.ValidationException;

public class GTIngredientList
extends LinkedList<GTIngredient> {
    private GTIngredientsAttribute _owner;

    public GTIngredientList(GTIngredientsAttribute owner) {
        this._owner = owner;
    }

    public GTIngredientList(GTIngredientsAttribute owner, GTIngredient ... rules) {
        for (GTIngredient rule : rules) {
            this.add(rule);
        }
        this._owner = owner;
    }

    public GTIngredientList(GTIngredientsAttribute owner, GTIngredientList initRules) {
        super(initRules);
        this._owner = owner;
    }

    public GTIngredientsAttribute getOwner() {
        return this._owner;
    }

    public static GTIngredientList parse(GTIngredientsAttribute owner, String expression) throws MalformedStringException {
        GTIngredientList list = new GTIngredientList(owner);
        int startPos = 0;
        while (startPos < expression.length()) {
            int endPos = GTIngredient._findMatchingParen(expression, startPos);
            if (endPos < 0) {
                throw new MalformedStringException(expression);
            }
            String ruleString = expression.substring(startPos + 1, endPos);
            GTIngredient rule = list._parseRule(ruleString);
            list.add(rule);
            startPos = endPos + 1;
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (GTIngredient rule : this) {
            buffer.append('(');
            buffer.append(rule.getClass().getName());
            buffer.append("/");
            buffer.append(rule.getValues());
            buffer.append(')');
        }
        return buffer.toString();
    }

    public void validate() throws ValidationException {
        int i = 0;
        for (GTIngredient rule : this) {
            ++i;
            try {
                rule.validate();
            }
            catch (ValidationException e) {
                throw new ValidationException("Rule " + i + ": " + e.getMessage());
            }
        }
    }

    private GTIngredient _parseRule(String ruleString) {
        int separator = ruleString.indexOf("/");
        if (separator < 0) {
            return null;
        }
        String ruleClassName = ruleString.substring(0, separator);
        try {
            Class<?> namedClass = Class.forName(ruleClassName);
            Class<GTIngredient> ruleClass = namedClass.asSubclass(GTIngredient.class);
            String values = ruleString.substring(separator + 1);
            return ruleClass.getConstructor(GTIngredientList.class, String.class).newInstance(this, values);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }
}

