/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.IOPort;
import ptolemy.data.Token;

public class TokenSentEvent {
    private int _channel;
    private IOPort _port;
    private Token _token;
    private Token[] _tokenArray;
    private int _vectorLength;

    public TokenSentEvent(IOPort source, int channel, Token[] tokens, int vectorLength) {
        this._port = source;
        this._channel = channel;
        this._tokenArray = tokens;
        this._token = null;
        this._vectorLength = vectorLength;
    }

    public TokenSentEvent(IOPort source, int channel, Token token) {
        this._port = source;
        this._channel = channel;
        this._tokenArray = null;
        this._token = token;
        this._vectorLength = -1;
    }

    public TokenSentEvent(IOPort source, Token token) {
        this._port = source;
        this._channel = -1;
        this._tokenArray = null;
        this._token = token;
        this._vectorLength = -1;
    }

    public TokenSentEvent(IOPort source, Token[] tokens, int vectorLength) {
        this._port = source;
        this._channel = -1;
        this._tokenArray = tokens;
        this._token = null;
        this._vectorLength = vectorLength;
    }

    public int getChannel() {
        return this._channel;
    }

    public IOPort getPort() {
        return this._port;
    }

    public Token getToken() {
        return this._token;
    }

    public Token[] getTokenArray() {
        return this._tokenArray;
    }

    public int getVectorLength() {
        return this._vectorLength;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The port " + this._port + " sent ");
        if (this._vectorLength != -1) {
            buffer.append(this._vectorLength);
            buffer.append(" tokens ");
        } else {
            buffer.append(this._token.toString());
        }
        if (this._channel != -1) {
            buffer.append(" to channel " + this._channel + ".");
        } else {
            buffer.append(" to all channels");
        }
        return buffer.toString();
    }
}

