/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.IOPort;
import ptolemy.data.Token;

public class TokenGotEvent {
    private int _channel;
    private IOPort _port;
    private Token _token;
    private Token[] _tokenArray;
    private int _vectorLength;
    private boolean _outside;

    public TokenGotEvent(IOPort sink, int channel, Token[] tokens, int vectorLength, boolean outside) {
        this._port = sink;
        this._channel = channel;
        this._tokenArray = tokens;
        this._token = null;
        this._vectorLength = vectorLength;
        this._outside = outside;
    }

    public TokenGotEvent(IOPort sink, int channel, Token token, boolean outside) {
        this._port = sink;
        this._channel = channel;
        this._tokenArray = null;
        this._token = token;
        this._vectorLength = -1;
        this._outside = outside;
    }

    public int getChannel() {
        return this._channel;
    }

    public IOPort getPort() {
        return this._port;
    }

    public Token getToken() {
        return this._token;
    }

    public Token[] getTokenArray() {
        return this._tokenArray;
    }

    public int getVectorLength() {
        return this._vectorLength;
    }

    public boolean getOutsideFlag() {
        return this._outside;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The port " + this._port + " took ");
        if (this._vectorLength != -1) {
            buffer.append(this._vectorLength);
            buffer.append(" tokens ");
        } else {
            buffer.append(this._token.toString());
        }
        buffer.append(" on channel " + this._channel + ".");
        return buffer.toString();
    }
}

