/*
 * Decompiled with CFR 0.152.
 */
package JSci.mathml;

import JSci.mathml.MathMLDocumentImpl;
import JSci.mathml.MathMLElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLContentElement;
import org.w3c.dom.mathml.MathMLVectorElement;

public class MathMLVectorElementImpl
extends MathMLElementImpl
implements MathMLVectorElement {
    public MathMLVectorElementImpl(MathMLDocumentImpl mathMLDocumentImpl, String string) {
        super(mathMLDocumentImpl, string);
    }

    public int getNcomponents() {
        return this.getComponentsGetLength();
    }

    public MathMLContentElement getComponent(int n) throws DOMException {
        Node node = this.getComponentsItem(n - 1);
        if (node == null) {
            throw new DOMException(1, "Index out of bounds");
        }
        return (MathMLContentElement)node;
    }

    public MathMLContentElement setComponent(MathMLContentElement mathMLContentElement, int n) throws DOMException {
        int n2 = this.getComponentsGetLength();
        if (n < 1 || n > n2 + 1) {
            throw new DOMException(1, "Index out of bounds");
        }
        if (n == n2 + 1) {
            return (MathMLContentElement)this.appendChild((Node)mathMLContentElement);
        }
        return (MathMLContentElement)this.replaceChild((Node)mathMLContentElement, this.getComponentsItem(n - 1));
    }

    public MathMLContentElement insertComponent(MathMLContentElement mathMLContentElement, int n) throws DOMException {
        int n2 = this.getComponentsGetLength();
        if (n < 0 || n > n2 + 1) {
            throw new DOMException(1, "Index out of bounds");
        }
        if (n == 0 || n == n2 + 1) {
            return (MathMLContentElement)this.appendChild((Node)mathMLContentElement);
        }
        return (MathMLContentElement)this.insertBefore((Node)mathMLContentElement, this.getComponentsItem(n - 1));
    }

    public MathMLContentElement removeComponent(int n) throws DOMException {
        Node node = this.getComponentsItem(n - 1);
        if (node == null) {
            throw new DOMException(1, "Index out of bounds");
        }
        return (MathMLContentElement)this.removeChild(node);
    }

    public void deleteComponent(int n) throws DOMException {
        this.removeComponent(n);
    }

    private int getComponentsGetLength() {
        int n = this.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(this.item(i) instanceof MathMLContentElement)) continue;
            ++n2;
        }
        return n2;
    }

    private Node getComponentsItem(int n) {
        int n2 = this.getComponentsGetLength();
        if (n < 0 || n >= n2) {
            return null;
        }
        Node node = null;
        int n3 = -1;
        int n4 = 0;
        while (n3 < n) {
            node = this.item(n4);
            if (node instanceof MathMLContentElement) {
                ++n3;
            }
            ++n4;
        }
        return node;
    }
}

