/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies8;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies8.Scaling8;
import JSci.maths.wavelet.daubechies8.Wavelet8;

public final class Daubechies8
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 14;
    protected static final int minlength = 28;
    static final double[] vg = new double[]{0.00267279339281, -4.28394300246E-4, -0.0211456865284, 0.00538638875377, 0.0694904659113, -0.0384935212634, -0.0734625087609, 0.515398670374, 1.09910663054, 0.68074534719, -0.0866536154058, -0.202648655286, 0.0107586117505, 0.0448236230437, -7.66690896228E-4, -0.0047834585115};
    static final double[] v0temp = new double[]{0.814531364, -0.5801195196};
    static final double[] v1temp = new double[]{0.2546778816, 0.3575868684, 0.3176080089, -0.8404736527};
    static final double[] v2temp = new double[]{-0.211874065, -0.2974870959, -0.5809146479, -0.4102927684, 0.5953490052, -0.07980217044};
    static final double[] v3temp = new double[]{0.07371113089, 0.1034959624, 0.3790561153, 0.2096111511, 0.5261835609, -0.4930256875, 0.06765214691, -0.5212625063};
    static final double[] v4temp = new double[]{-0.01657029358, -0.02326593637, 0.02835607555, -0.004204253027, 0.05232892196, 0.3363143855, 0.2707791658, -0.2181631699, 0.1282592034, -0.8632205676};
    static final double[] v5temp = new double[]{0.04725307654, 0.06634686747, -0.1768605708, -0.02428779496, -0.1728053705, -0.2496491113, -0.1026485332, -0.07015597057, 0.4504320556, -0.06366908518, -0.1272105456, -0.7941822291};
    static final double[] v6temp = new double[]{-0.3150600071, -0.4423679063, 0.4664265832, -0.107419133, 0.0459153625, -0.01495306795, 0.3948485068, 0.2753380149, -0.2521499192, 0.04757966099, 0.04479299855, -0.3909345922, -0.02305781603, -0.1438599401};
    static final double[] v7temp = new double[]{-0.162837404, -0.2286359419, 0.1439556412, -0.09221803771, -0.155963871, -0.4526846422, 0.07680278703, 0.2798722613, 0.6073428962, -0.1277567678, 0.007075076739, 0.437131413, 0.01227511608, 0.04457322339, -0.001100591484, -0.006866696512};
    static final double[] v8temp = new double[]{0.0142234391, 0.01997077647, -0.05755686815, -0.008943575462, -0.05113148256, -0.02870337098, -0.05044680204, -0.07048754871, 0.07802410165, -0.003357971353, 0.957478882, -0.06034410649, -0.08780892537, -0.2208827842, 0.01042138073, 0.04380269399, -7.294541741E-4, -0.004551135007};
    static final double[] v9temp = new double[]{-0.02847286228, -0.03997803654, 0.01712399543, -0.01916575373, -0.02592997362, 0.005065243826, 0.04279291071, -0.03263024185, -0.03163483356, 0.01965128227, 0.1870478101, -0.05633846528, 0.8568892098, 0.4372612498, -0.0670305999, -0.1500716835, 0.008519695716, 0.03506433161, -6.219669046E-4, -0.003880511557};
    static final double[] v10temp = new double[]{-0.01332967539, -0.01871586512, 0.02153245326, -0.003865012867, 0.004740812821, 0.003654642397, 0.01552794626, 0.01184719866, -0.0168335152, 0.002573274217, 0.05123819976, -0.03022844964, -0.04903142965, 0.3621831839, 0.7774835776, 0.4809708581, -0.06128478594, -0.1432550194, 0.007610815937, 0.03170366925, -5.425512917E-4, -0.003385029882};
    static final double[] v11temp = new double[]{1.198029623E-4, 1.682123545E-4, -4.574159978E-4, -6.498394141E-5, -5.03760011E-4, -0.001039508974, 1.793350305E-4, 1.895383041E-4, 0.001581295871, -2.137732665E-4, -0.01495199763, 0.003830464294, 0.04910595228, -0.02718959315, -0.05195946631, 0.3644408152, 0.7771868548, 0.48136115, -0.06127351228, -0.1432947954, 0.007607500914, 0.03169516934, -5.421324438E-4, -0.00338241665};
    static final double[] v12temp = new double[]{-1.467161418E-5, -2.060004793E-5, 1.949164967E-5, -5.84448803E-6, 7.48555411E-7, 9.49098318E-6, -5.287598342E-5, -9.424653819E-6, 1.650150426E-7, -8.931253371E-6, 0.001889628005, -3.041026881E-4, -0.01495041138, 0.003806880495, 0.04913803765, -0.02721895815, -0.05194591141, 0.3644417925, 0.7771857621, 0.4813596873, -0.06127335999, -0.1432942437, 0.007607487339, 0.03169508789, -5.421323322E-4, -0.003382415953};
    static final double[] v13temp = new double[]{-1.287522004E-8, -1.807777568E-8, 1.467373756E-8, -6.047676057E-9, -2.557954799E-9, 6.767773484E-9, -4.138623196E-8, -1.152590396E-8, -7.816962231E-10, -6.457861266E-9, -1.973430468E-9, -1.721336728E-10, 0.00188995208, -3.029230007E-4, -0.0149522572, 0.003808752194, 0.04913717957, -0.02721903007, -0.05194583809, 0.3644418949, 0.7771857517, 0.4813596513, -0.06127335907, -0.1432942384, 0.007607487325, 0.03169508781, -5.421323318E-4, -0.003382415951};
    static final double[] vd0temp = new double[]{0.8154844606, 0.5787789687};
    static final double[] vd1temp = new double[]{-0.1247831717, 0.1758162321, -0.3656686728, 0.9054304139};
    static final double[] vd2temp = new double[]{0.002997291603, -0.004223105639, 0.01242773642, 0.006252204333, -0.9904302529, 0.1372135453};
    static final double[] vd3temp = new double[]{0.01966225161, -0.02770359932, -0.7546094737, -0.296668612, 0.0349943732, 0.3331775846, -0.2987492141, 0.3740523778};
    static final double[] vd4temp = new double[]{0.004323222764, -0.006091308037, 0.07954572256, 0.03390409091, 0.09217898627, 0.6563318928, 0.3523462443, -0.1251353548, 0.404222967, 0.4999957374};
    static final double[] vd5temp = new double[]{-0.02660208461, 0.03748164289, -9.461286592E-4, -0.01132648426, -0.009275963658, -0.06461897138, 0.01372894292, 0.0626729702, 0.2202320256, -0.08389760645, -0.1403041536, 0.9561140215};
    static final double[] vd6temp = new double[]{0.2524537323, -0.3557007197, 0.01516837508, 0.1099880629, 0.01862464672, 0.1115880939, 0.02254220157, -0.004913049824, -0.5563920979, 0.2664015938, 0.3095222627, 0.2269636732, -0.08010927222, 0.4998095408};
    static final double[] vd7temp = new double[]{0.2456578749, -0.346125534, 0.009925065785, 0.1050746034, -0.04318903116, -0.333451409, 0.2290161361, 0.5487762846, 0.5044722993, -0.001254772285, 0.1029941228, -0.1417543694, -0.02283734323, 0.236467448, -0.003231151084, 0.02015946352};
    static final double[] vd8temp = new double[]{-0.2349913172, 0.3310966326, -0.05311446508, -0.1181288132, -0.009603473986, -0.04380266939, 0.2600141912, 0.08361504832, 0.0251063911, -0.1008073945, 0.8418631631, 0.07567187201, -0.05157252055, -0.1011324247, 0.01353427731, -0.05842857844, -8.94333733E-4, 0.005579834492};
    static final double[] vd9temp = new double[]{0.1175808867, -0.1656684005, 0.02116820474, 0.0569230484, -3.212417295E-4, -0.01449706939, 0.00760843323, 0.08842036371, -0.1106702915, 0.1150658911, 0.1320221928, 0.05853544071, 0.8673441259, -0.3405381015, -0.07026544508, 0.1612247059, 0.008814953584, -0.03651364229, -6.354725161E-4, 0.003964774371};
    static final double[] vd10temp = new double[]{-0.1869200178, 0.2633654264, -0.01715897751, -0.08383072732, -5.454552299E-5, 0.0171690365, -0.02459571155, -0.1067048762, 0.1392253947, -0.131218202, -0.06903207429, -0.06174129657, 0.4567820059, 0.665967777, 0.4075238681, -0.08959489682, -0.03070551742, 0.05834412826, 0.004209662663, -0.01666652373, -3.299795784E-4, 0.002058774443};
    static final double[] vd11temp = new double[]{-5.983387981E-5, 8.430437497E-5, -7.367030616E-4, -3.221424476E-4, 2.377031466E-4, 0.001801086072, 0.006525360795, 0.001852858079, -0.01304362553, 0.004142993226, 0.0287786899, 0.00749049, -0.1429947491, -0.06137476013, 0.4811678727, 0.7773035028, 0.3644701648, -0.0520000392, -0.02722180405, 0.0491475464, 0.0038089818, -0.0149534627, -3.029283977E-4, 0.001889999515};
    static final double[] vd12temp = new double[]{2.133198342E-4, -3.005620786E-4, 1.154368505E-4, 1.343825608E-4, 1.922522728E-5, 1.082819743E-4, -9.178438545E-4, -5.253253664E-4, 5.862560755E-4, -1.372988867E-4, -0.003162915788, -5.366827388E-4, 0.03167918922, 0.007662389238, -0.1433799225, -0.06122357795, 0.4813668294, 0.7771700444, 0.3644410683, -0.05194231988, -0.02721896821, 0.04913678918, 0.003808752164, -0.01495225825, -3.029205498E-4, 0.001889950551};
    static final double[] vd13temp = new double[]{-2.204602645E-7, 3.106227586E-7, -2.497015754E-7, -1.915445903E-7, -3.628131005E-8, -2.16164733E-7, 1.096077744E-6, 4.502869954E-7, -6.259648891E-7, 1.952007624E-7, -5.855423375E-7, -5.654617843E-9, -0.003382391093, -5.42177224E-4, 0.03169514253, 0.007607457819, -0.1432942434, -0.06127334917, 0.4813596518, 0.7771857494, 0.3644418948, -0.05194583784, -0.02721902992, 0.04913717967, 0.003808752014, -0.01495225834, -3.029205147E-4, 0.001889950333};
    static final double[] v0 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v3temp);
    static final double[] v4 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v4temp);
    static final double[] v5 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v5temp);
    static final double[] v6 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v6temp);
    static final double[] v7 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v7temp);
    static final double[] v8 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v8temp);
    static final double[] v9 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v9temp);
    static final double[] v10 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v10temp);
    static final double[] v11 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v11temp);
    static final double[] v12 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v12temp);
    static final double[] v13 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v13temp);
    static final double[] vd0 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd0temp));
    static final double[] vd1 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd1temp));
    static final double[] vd2 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd2temp));
    static final double[] vd3 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd3temp));
    static final double[] vd4 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd4temp));
    static final double[] vd5 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd5temp));
    static final double[] vd6 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd6temp));
    static final double[] vd7 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd7temp));
    static final double[] vd8 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd8temp));
    static final double[] vd9 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd9temp));
    static final double[] vd10 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd10temp));
    static final double[] vd11 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd11temp));
    static final double[] vd12 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd12temp));
    static final double[] vd13 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd13temp));
    static final double[] vgtemp = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])vg);
    static final double[] phvg = WaveletMath.lowToHigh((double[])vgtemp);
    static final double[] phv0 = new double[]{-0.2620979145, -0.3680051517, 0.3007938848, -0.1223236495, -0.0381541148, 0.2223806092, -0.7414398574, -0.2856615192, 0.07435240137, -0.0395812997, -0.03312367172, 5.296663936E-4, -2.698631364E-5, 4.8278454E-8, -2.405836391E-9, -1.119370789E-8};
    static final double[] phv1 = new double[]{-0.01530044792, -0.02148297772, -0.1411089928, -0.06710033379, -0.2754652268, -0.5621677849, -0.2521929541, 0.08489402134, -0.575611971, -0.4252477763, -0.001717046011, 4.224061134E-4, -2.349772977E-4, -4.160927634E-4, 3.225252044E-5, 1.266155053E-4, -2.565139468E-6, -1.600415263E-5};
    static final double[] phv2 = new double[]{0.1495099502, 0.2099231961, 0.1776433332, 0.2017476699, 0.4784490465, 0.05947478107, -0.3620530588, 0.6528531425, 0.05286410695, -0.222212146, 0.05727745934, -0.1143513897, 0.05375754041, 0.008506084034, -0.004048226504, -0.007458590086, 5.621800279E-4, 0.002220046324, -4.426269435E-5, -2.761592227E-4};
    static final double[] phv3 = new double[]{0.02437646831, 0.03422639182, -0.0400321495, 0.006820587728, -0.009838965803, -0.009366231848, -0.02696011202, -0.02069757161, 0.03436761211, -0.005103853901, -0.1475095258, 0.06694319985, 0.4773719174, -0.7755787502, 0.3636972524, 0.05218600648, -0.02717665152, -0.04912168611, 0.00380108165, 0.01492736485, -3.021310554E-4, -0.00188502482};
    static final double[] phv4 = new double[]{-2.526109188E-4, -3.546846973E-4, 8.694036319E-4, 1.010912744E-4, 9.035494282E-4, 0.001885121065, -4.586723661E-4, -3.637255134E-4, -0.002829586692, 3.593205922E-4, 0.03169382593, -0.00764943816, -0.1432336703, 0.06121586703, 0.4813866596, -0.7771843511, 0.3644396836, 0.05194280857, -0.0272187235, -0.04913606047, 0.003808725019, 0.01495209647, -3.029202893E-4, -0.001889948926};
    static final double[] phv5 = new double[]{2.622395072E-5, 3.682039585E-5, -3.484560037E-5, 1.0444002E-5, -1.346357753E-6, -1.696820074E-5, 9.452329486E-5, 1.683706766E-5, -2.973670447E-7, 1.596726796E-5, -0.003381844248, 5.442476019E-4, 0.03169178699, -0.007604144409, -0.1432957713, 0.06127323127, 0.4813597833, -0.777185571, 0.3644418761, 0.05194577328, -0.02721902826, -0.04913717014, 0.003808751988, 0.01495225819, -3.029205141E-4, -0.001889950329};
    static final double[] phv6 = new double[]{2.30418041E-8, 3.235242306E-8, -2.626045803E-8, 1.082307302E-8, 4.577834066E-9, -1.211150005E-8, 7.406609086E-8, 2.062688911E-8, 1.399229053E-9, 1.155742488E-8, 3.531713891E-9, 3.080661641E-10, -0.003382419079, 5.421367809E-4, 0.03169508577, -0.007607487647, -0.1432942382, 0.06127335935, 0.4813596512, -0.7771857518, 0.3644418948, 0.05194583812, -0.02721902992, -0.04913717967, 0.003808752014, 0.01495225834, -3.029205147E-4, -0.001889950333};
    static final double[] phvd0temp = new double[]{0.2423397898, -0.3414504387, -0.1594658038, 0.0352990223, 0.001178925154, 0.005541735135, -0.3397784131, -0.6081576576, 0.3969712638, -0.2244673049, 0.3235661995, 0.001864123221, -3.711413269E-4, 1.409795475E-7, 1.765799666E-8, -1.432302065E-8};
    static final double[] phvd1temp = new double[]{0.04513529643, -0.06359445463, 0.4156183867, 0.1864214898, 0.08260455402, 0.5471723539, -0.2060895161, 0.3195284622, -0.01900505437, -0.5728513561, 0.08401643267, -0.007395446869, -5.473278975E-4, 9.194626204E-4, 4.88043722E-5, -2.033336993E-4, -3.477949227E-6, 2.169926352E-5};
    static final double[] phvd2temp = new double[]{0.1250013206, -0.1761235982, -0.296940178, -0.0684959011, 0.01052599951, 0.09784281131, 0.7121369985, -0.1923488214, -0.1670869235, -0.4966168654, -0.1731874885, -0.01213007854, 0.03720006761, -0.02322200303, -0.002923066799, 0.006878894624, 3.616735843E-4, -0.001510315965, -2.565448314E-5, 1.600607975E-4};
    static final double[] phvd3temp = new double[]{0.1176229912, -0.1657277246, 0.01156398803, 0.05306159526, -1.350101618E-4, -0.0121097401, 0.008506023466, 0.06454872425, -0.07545099201, 0.07860638961, 0.01423462206, 0.03160238725, -0.06318521633, -0.3456069087, 0.7552228032, -0.4695151924, -0.05958716642, 0.1395811538, 0.007391464073, -0.03081345978, -5.261056159E-4, 0.003282423723};
    static final double[] phvd4temp = new double[]{-1.40814825E-4, 1.984044131E-4, 3.17162995E-4, 7.015727951E-5, -1.485516761E-4, -0.00109501131, -0.002896265919, -6.063657602E-4, 0.006809567802, -0.002202777079, -0.0135030665, -0.003747971165, 0.04898531345, 0.02723198199, -0.05177607522, -0.3645627219, 0.7771651866, -0.4813205851, -0.06127118296, 0.1432859367, 0.007607311222, -0.03169412534, -5.421276476E-4, 0.003382386726};
    static final double[] phvd5temp = new double[]{-1.190143232E-4, 1.676880751E-4, -6.429765381E-5, -7.493111227E-5, -1.071266241E-5, -6.032714131E-5, 5.119585945E-4, 2.931623842E-4, -3.270646712E-4, 7.655763607E-5, 0.00176778064, 2.998801694E-4, -0.01494339773, -0.003839392904, 0.04918502279, 0.02719124334, -0.05194987783, -0.3644331897, 0.7771862176, -0.4813616291, -0.06127339397, 0.1432944583, 0.00760748727, -0.03169508804, -5.421323123E-4, 0.003382415829};
    static final double[] phvd6temp = new double[]{1.231735693E-7, -1.735483443E-7, 1.395294094E-7, 1.070254954E-7, 2.027240624E-8, 1.207834424E-7, -6.124273534E-7, -2.515754905E-7, 3.497458016E-7, -1.090603783E-7, 3.271625017E-7, 3.159481233E-9, 0.001889936443, 3.029455986E-4, -0.01495228891, -0.003808735528, 0.0491371825, 0.02721902439, -0.05194583841, -0.3644418935, 0.7771857517, -0.4813596514, -0.06127335907, 0.1432942384, 0.007607487325, -0.03169508781, -5.421323318E-4, 0.003382415951};
    static final double[] phvd0 = ArrayMath.invert((double[])phvd0temp);
    static final double[] phvd1 = ArrayMath.invert((double[])phvd1temp);
    static final double[] phvd2 = ArrayMath.invert((double[])phvd2temp);
    static final double[] phvd3 = ArrayMath.invert((double[])phvd3temp);
    static final double[] phvd4 = ArrayMath.invert((double[])phvd4temp);
    static final double[] phvd5 = ArrayMath.invert((double[])phvd5temp);
    static final double[] phvd6 = ArrayMath.invert((double[])phvd6temp);

    public int getFilterType() {
        return 14;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling8(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling8(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet8(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet8(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(14, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 28) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < " + 28);
        }
        double[] dArray2 = new double[2 * dArray.length - 14];
        int n3 = dArray.length - 1;
        for (n2 = 14; n2 <= n3 - 14; ++n2) {
            for (n = -8; n < 8; ++n) {
                int n4 = 2 * n2 + n - 6;
                dArray2[n4] = dArray2[n4] + vg[n + 8] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])v2, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])v3, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])v4, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[5], (double[])v5, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[6], (double[])v6, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[7], (double[])v7, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[8], (double[])v8, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[9], (double[])v9, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[10], (double[])v10, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[11], (double[])v11, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[12], (double[])v12, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[13], (double[])v13, (int)0);
        n2 = dArray2.length - vd0.length;
        n = dArray2.length - vd1.length;
        int n5 = dArray2.length - vd2.length;
        int n6 = dArray2.length - vd3.length;
        int n7 = dArray2.length - vd4.length;
        int n8 = dArray2.length - vd5.length;
        int n9 = dArray2.length - vd6.length;
        int n10 = dArray2.length - vd7.length;
        int n11 = dArray2.length - vd8.length;
        int n12 = dArray2.length - vd9.length;
        int n13 = dArray2.length - vd10.length;
        int n14 = dArray2.length - vd11.length;
        int n15 = dArray2.length - vd12.length;
        int n16 = dArray2.length - vd13.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3], (double[])vd0, (int)n2);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 1], (double[])vd1, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 2], (double[])vd2, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 3], (double[])vd3, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 4], (double[])vd4, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 5], (double[])vd5, (int)n8);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 6], (double[])vd6, (int)n9);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 7], (double[])vd7, (int)n10);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 8], (double[])vd8, (int)n11);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 9], (double[])vd9, (int)n12);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 10], (double[])vd10, (int)n13);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 11], (double[])vd11, (int)n14);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 12], (double[])vd12, (int)n15);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 13], (double[])vd13, (int)n16);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 14) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 14");
        }
        double[] dArray2 = new double[2 * dArray.length + 14];
        int n3 = dArray.length - 1;
        for (n2 = 7; n2 <= n3 - 7; ++n2) {
            for (n = -8; n < 8; ++n) {
                int n4 = 2 * n2 + n + 8;
                dArray2[n4] = dArray2[n4] + phvg[n + 8] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])phv0, (int)0);
        n2 = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3], (double[])phvd0, (int)n2);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])phv1, (int)0);
        n = dArray2.length - phvd1.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 1], (double[])phvd1, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])phv2, (int)0);
        int n5 = dArray2.length - phvd2.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 2], (double[])phvd2, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])phv3, (int)0);
        int n6 = dArray2.length - phvd3.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 3], (double[])phvd3, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])phv4, (int)0);
        int n7 = dArray2.length - phvd4.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 4], (double[])phvd4, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[5], (double[])phv5, (int)0);
        int n8 = dArray2.length - phvd5.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 5], (double[])phvd5, (int)n8);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[6], (double[])phv6, (int)0);
        int n9 = dArray2.length - phvd6.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 6], (double[])phvd5, (int)n9);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 14, n, n3, n2);
    }
}

