/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies6;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies6.Daubechies6;

public final class Wavelet6
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies6 cdf = new Daubechies6();

    public Wavelet6(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet6() {
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet6) {
            Wavelet6 wavelet6 = (Wavelet6)object;
            return this.dimension(0) == wavelet6.dimension(0) && this.position() == wavelet6.position();
        }
        return false;
    }

    public int getFilterType() {
        return 10;
    }

    public void setParameters(int n, int n2) {
        if (n < 20) {
            throw new IllegalScalingException(n, 20);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet6 wavelet6 = (Wavelet6)super.clone();
        wavelet6.n0 = this.n0;
        wavelet6.k = this.k;
        return wavelet6;
    }

    public double[] evaluate(int n) {
        return cdf.evalWavelet(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 10);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

