/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies2;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies2.Daubechies2;

public final class Wavelet2
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies2 cdf = new Daubechies2();

    public Wavelet2(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet2() {
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet2) {
            Wavelet2 wavelet2 = (Wavelet2)object;
            return this.dimension(0) == wavelet2.dimension(0) && this.position() == wavelet2.position();
        }
        return false;
    }

    public int getFilterType() {
        return 2;
    }

    public void setParameters(int n, int n2) {
        if (n < 4) {
            throw new IllegalScalingException(n, 4);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet2 wavelet2 = (Wavelet2)super.clone();
        wavelet2.n0 = this.n0;
        wavelet2.k = this.k;
        return wavelet2;
    }

    public double[] evaluate(int n) {
        return cdf.evalWavelet(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 2);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

