/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.GlobalSettings;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.EngineerMath;
import JSci.maths.FourierMath;
import JSci.maths.MappingND;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.FWTCoef;
import JSci.maths.wavelet.FWTPacketCoef;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.LinearSpline;
import java.util.Arrays;

public class Signal
extends LinearSpline
implements NumericalConstants,
Cloneable {
    private Filter filterdual;
    static final double normalisation = 0.7071067811865475;
    private double[] param;

    public Object clone() {
        Signal signal = (Signal)super.clone();
        if (this.filterdual != null) {
            signal.filterdual = this.filterdual;
        }
        if (this.param != null) {
            signal.param = new double[this.param.length];
            System.arraycopy(signal.param, 0, this.param, 0, this.param.length);
        }
        return signal;
    }

    private Signal copy(double[] dArray) {
        if (this.filterdual != null) {
            if (this.param != null) {
                double[] dArray2 = new double[this.param.length];
                System.arraycopy(this.param, 0, dArray2, 0, dArray2.length);
                return new Signal(this.filterdual, dArray, dArray2);
            }
            return new Signal(this.filterdual, dArray);
        }
        return new Signal(dArray);
    }

    public Signal() {
    }

    public Signal(double[] dArray) {
        super(dArray);
    }

    public Signal(Filter filter, double[] dArray, double[] dArray2) {
        super(dArray);
        this.filterdual = filter;
        System.arraycopy(dArray2, 0, this.param, 0, this.param.length);
    }

    public Signal(Filter filter) {
        this.filterdual = filter;
    }

    public Signal(Filter filter, double[] dArray) {
        super(dArray);
        this.filterdual = filter;
    }

    public double[] getValues() {
        return this.interpolate(0);
    }

    public void setFilter(Filter filter) {
        this.filterdual = filter;
    }

    public void setParameters(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.param[i] = dArray[i];
        }
    }

    public void setParameters(Double[] doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            this.param[i] = doubleArray[i];
        }
    }

    public void removeParameters() {
        this.param = null;
    }

    public void setLengthFromEnd(int n) {
        double[] dArray = ArrayMath.setLengthFromEnd((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void resample(int n) {
        double[] dArray = EngineerMath.resample((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void setLengthFromBeginning(int n) {
        double[] dArray = ArrayMath.setLengthFromBeginning((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void setData(double[] dArray) {
        this.setValues(dArray);
    }

    public FWTCoef fwt(int n) {
        if (n > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] dArray = this.interpolate(0);
        double[][] dArrayArray = new double[n + 1][];
        for (int i = 1; i <= n; ++i) {
            dArrayArray[i] = this.highpassProject(dArray);
            dArray = this.lowpassProject(dArray);
        }
        dArrayArray[0] = dArray;
        FWTCoef fWTCoef = new FWTCoef(dArrayArray);
        return fWTCoef;
    }

    public FWTPacketCoef fwtPacket(int n, MappingND mappingND) {
        if (n > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] dArray = this.interpolate(0);
        double[][] dArrayArray = new double[n + 1][];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.highpassProject(dArray);
            double[] dArray3 = this.lowpassProject(dArray);
            if (mappingND.map(dArray2)[0] < mappingND.map(dArray3)[0]) {
                dArrayArray[i] = dArray2;
                dArray = dArray3;
                blArray[i] = true;
                continue;
            }
            dArray = dArray2;
            dArrayArray[i] = dArray3;
            blArray[i] = false;
        }
        dArrayArray[n] = dArray;
        FWTPacketCoef fWTPacketCoef = new FWTPacketCoef(dArrayArray, blArray);
        return fWTPacketCoef;
    }

    private double[] lowpassProject(double[] dArray) {
        int n = this.filterdual.previousDimension(dArray.length);
        double[] dArray2 = new double[n];
        if (this.param != null) {
            for (int i = 0; i < n; ++i) {
                double[] dArray3 = new double[this.param.length];
                System.arraycopy(this.param, 0, dArray3, 0, dArray3.length);
                double[] dArray4 = this.filterdual.lowpass(this.delta(i, n, 0.7071067811865475), dArray3);
                dArray2[i] = Signal.scalarProduct(dArray, dArray4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double[] dArray5 = this.filterdual.lowpass(this.delta(i, n, 0.7071067811865475));
                dArray2[i] = Signal.scalarProduct(dArray, dArray5);
            }
        }
        return dArray2;
    }

    private static double scalarProduct(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public double[] lowpassProject() {
        double[] dArray = this.interpolate(0);
        return this.lowpassProject(dArray);
    }

    private double[] highpassProject(double[] dArray) {
        int n = this.filterdual.previousDimension(dArray.length);
        int n2 = dArray.length - n;
        double[] dArray2 = new double[n2];
        if (this.param != null) {
            for (int i = 0; i < n2; ++i) {
                double[] dArray3 = new double[this.param.length];
                System.arraycopy(this.param, 0, dArray3, 0, dArray3.length);
                double[] dArray4 = this.filterdual.highpass(this.delta(i, n2, 1.0), dArray3);
                dArray2[i] = Signal.scalarProduct(dArray, dArray4);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                double[] dArray5 = this.filterdual.highpass(this.delta(i, n2, 1.0));
                dArray2[i] = Signal.scalarProduct(dArray, dArray5);
            }
        }
        return dArray2;
    }

    public double[] highpassProject() {
        double[] dArray = this.interpolate(0);
        return this.highpassProject(dArray);
    }

    private double[] delta(int n, int n2, double d) {
        if (n < 0 || n > n2 || n2 < 0) {
            throw new IllegalArgumentException("This Kronecker doesn't exist.");
        }
        double[] dArray = new double[n2];
        dArray[n] = d;
        return dArray;
    }

    public double norm() {
        double[] dArray = this.interpolate(0);
        return ArrayMath.norm((double[])dArray);
    }

    public Complex[] fft() {
        double[] dArray = this.interpolate(0);
        return Signal.fft(dArray);
    }

    public static Complex[] fft(double[] dArray) {
        return FourierMath.transform((double[])dArray);
    }

    public static Complex[] fft(Complex[] complexArray) {
        return FourierMath.transform((Complex[])complexArray);
    }

    public double[] absFFT() {
        Complex[] complexArray = this.fft();
        double[] dArray = new double[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            dArray[i] = complexArray[i].mod();
        }
        return dArray;
    }

    public static double[] absFFT(double[] dArray) {
        Complex[] complexArray = Signal.fft(dArray);
        double[] dArray2 = new double[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            dArray2[i] = complexArray[i].mod();
        }
        return dArray2;
    }

    public static Complex[] fftInverse(Complex[] complexArray) {
        return FourierMath.inverseTransform((Complex[])complexArray);
    }

    public boolean equals(Signal signal) {
        return Arrays.equals(this.getValues(), signal.getValues());
    }

    public void setDimensionFromEnd(int n) {
        double[] dArray = this.interpolate(0);
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        for (int i = n2; i < dArray.length; ++i) {
            dArray2[i + n - dArray.length] = dArray[i];
        }
        super.setValues(dArray2);
    }

    public void setDimensionFromBeginning(int n) {
        double[] dArray = this.interpolate(0);
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        for (int i = 0; i < dArray.length - n2; ++i) {
            dArray2[i] = dArray[i];
        }
        super.setValues(dArray2);
    }

    public void denoiseByFFT(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be 1 or more : " + n);
        }
        double[] dArray = this.interpolate(0);
        if (n > dArray.length - 2) {
            if (dArray.length < 4) {
                throw new IllegalArgumentException("Your signal is too short to be denoised : " + dArray.length + " < 4");
            }
            throw new IllegalArgumentException("Since you signal has dimension " + dArray.length + ", the parameter must be at most : " + (dArray.length - 2));
        }
        Complex[] complexArray = Signal.fft(dArray);
        complexArray[n + 1] = Complex.ZERO;
        complexArray[dArray.length - 1 - n] = Complex.ZERO;
        Complex[] complexArray2 = Signal.fftInverse(complexArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = complexArray2[i].real();
            if (!(Math.abs(complexArray2[i].imag()) > GlobalSettings.ZERO_TOL)) continue;
            throw new IllegalArgumentException("Complex values detected during synthesis. Please get in touch with Daniel Lemire at Daniel.Lemire@Tintin.net to report this error.");
        }
        super.setValues(dArray);
    }

    public double entropy() {
        return EngineerMath.entropy((double[])this.evaluate(0));
    }

    public Signal filter(double[] dArray) {
        double[] dArray2 = this.interpolate(0);
        if (dArray2.length - (dArray.length - 1) <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + dArray2.length + ", " + dArray.length);
        }
        double[] dArray3 = new double[dArray2.length - (dArray.length - 1)];
        for (int i = 0; i < dArray2.length - (dArray.length - 1); ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[j] * dArray2[i + j];
            }
        }
        return this.copy(dArray3);
    }

    public Signal medianFilter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive: " + n + " < 0");
        }
        double[] dArray = super.interpolate(0);
        if (dArray.length - 2 * n <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + dArray.length + " - " + 2 * n + " = " + (dArray.length - 2 * n));
        }
        double[] dArray2 = new double[dArray.length - 2 * n];
        double[] dArray3 = new double[2 * n + 1];
        for (int i = 0; i < dArray.length - 2 * n; ++i) {
            for (int j = 0; j < 2 * n + 1; ++j) {
                dArray3[j] = dArray[i + j];
            }
            dArray2[i] = ArrayMath.median((double[])dArray3);
        }
        return this.copy(dArray2);
    }

    public Signal denoiseShortPeaks(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The parameter p must be between 0 and 1: " + d);
        }
        double[] dArray = this.interpolate(0);
        double d2 = ArrayMath.max((double[])dArray) - ArrayMath.min((double[])dArray);
        double d3 = d2 * d;
        double[] dArray2 = this.medianFilter(n).interpolate(0);
        for (int i = n; i < dArray.length - n; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i - n]) > d3)) continue;
            dArray[i] = dArray2[i - n];
        }
        return this.copy(dArray);
    }
}

