/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

class Matrix3D {
    float xx = 1.0f;
    float xy;
    float xz;
    float xo;
    float yx;
    float yy = 1.0f;
    float yz;
    float yo;
    float zx;
    float zy;
    float zz = 1.0f;
    float zo;

    Matrix3D() {
    }

    void scale(float f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.yo *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
        this.zo *= f;
    }

    void scale(float f, float f2, float f3) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f2;
        this.yy *= f2;
        this.yz *= f2;
        this.yo *= f2;
        this.zx *= f3;
        this.zy *= f3;
        this.zz *= f3;
        this.zo *= f3;
    }

    void translate(float f, float f2, float f3) {
        this.xo += f;
        this.yo += f2;
        this.zo += f3;
    }

    void yRotate(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        float f = (float)((double)this.xx * d2 + (double)this.zx * d3);
        float f2 = (float)((double)this.xy * d2 + (double)this.zy * d3);
        float f3 = (float)((double)this.xz * d2 + (double)this.zz * d3);
        float f4 = (float)((double)this.xo * d2 + (double)this.zo * d3);
        float f5 = (float)((double)this.zx * d2 - (double)this.xx * d3);
        float f6 = (float)((double)this.zy * d2 - (double)this.xy * d3);
        float f7 = (float)((double)this.zz * d2 - (double)this.xz * d3);
        float f8 = (float)((double)this.zo * d2 - (double)this.xo * d3);
        this.xo = f4;
        this.xx = f;
        this.xy = f2;
        this.xz = f3;
        this.zo = f8;
        this.zx = f5;
        this.zy = f6;
        this.zz = f7;
    }

    void xRotate(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        float f = (float)((double)this.yx * d2 + (double)this.zx * d3);
        float f2 = (float)((double)this.yy * d2 + (double)this.zy * d3);
        float f3 = (float)((double)this.yz * d2 + (double)this.zz * d3);
        float f4 = (float)((double)this.yo * d2 + (double)this.zo * d3);
        float f5 = (float)((double)this.zx * d2 - (double)this.yx * d3);
        float f6 = (float)((double)this.zy * d2 - (double)this.yy * d3);
        float f7 = (float)((double)this.zz * d2 - (double)this.yz * d3);
        float f8 = (float)((double)this.zo * d2 - (double)this.yo * d3);
        this.yo = f4;
        this.yx = f;
        this.yy = f2;
        this.yz = f3;
        this.zo = f8;
        this.zx = f5;
        this.zy = f6;
        this.zz = f7;
    }

    void zRotate(double d) {
        double d2 = Math.cos(d *= Math.PI / 180);
        double d3 = Math.sin(d);
        float f = (float)((double)this.yx * d2 + (double)this.xx * d3);
        float f2 = (float)((double)this.yy * d2 + (double)this.xy * d3);
        float f3 = (float)((double)this.yz * d2 + (double)this.xz * d3);
        float f4 = (float)((double)this.yo * d2 + (double)this.xo * d3);
        float f5 = (float)((double)this.xx * d2 - (double)this.yx * d3);
        float f6 = (float)((double)this.xy * d2 - (double)this.yy * d3);
        float f7 = (float)((double)this.xz * d2 - (double)this.yz * d3);
        float f8 = (float)((double)this.xo * d2 - (double)this.yo * d3);
        this.yo = f4;
        this.yx = f;
        this.yy = f2;
        this.yz = f3;
        this.xo = f8;
        this.xx = f5;
        this.xy = f6;
        this.xz = f7;
    }

    void multiply(Matrix3D matrix3D) {
        float f = this.xx * matrix3D.xx + this.yx * matrix3D.xy + this.zx * matrix3D.xz;
        float f2 = this.xy * matrix3D.xx + this.yy * matrix3D.xy + this.zy * matrix3D.xz;
        float f3 = this.xz * matrix3D.xx + this.yz * matrix3D.xy + this.zz * matrix3D.xz;
        float f4 = this.xo * matrix3D.xx + this.yo * matrix3D.xy + this.zo * matrix3D.xz + matrix3D.xo;
        float f5 = this.xx * matrix3D.yx + this.yx * matrix3D.yy + this.zx * matrix3D.yz;
        float f6 = this.xy * matrix3D.yx + this.yy * matrix3D.yy + this.zy * matrix3D.yz;
        float f7 = this.xz * matrix3D.yx + this.yz * matrix3D.yy + this.zz * matrix3D.yz;
        float f8 = this.xo * matrix3D.yx + this.yo * matrix3D.yy + this.zo * matrix3D.yz + matrix3D.yo;
        float f9 = this.xx * matrix3D.zx + this.yx * matrix3D.zy + this.zx * matrix3D.zz;
        float f10 = this.xy * matrix3D.zx + this.yy * matrix3D.zy + this.zy * matrix3D.zz;
        float f11 = this.xz * matrix3D.zx + this.yz * matrix3D.zy + this.zz * matrix3D.zz;
        float f12 = this.xo * matrix3D.zx + this.yo * matrix3D.zy + this.zo * matrix3D.zz + matrix3D.zo;
        this.xx = f;
        this.xy = f2;
        this.xz = f3;
        this.xo = f4;
        this.yx = f5;
        this.yy = f6;
        this.yz = f7;
        this.yo = f8;
        this.zx = f9;
        this.zy = f10;
        this.zz = f11;
        this.zo = f12;
    }

    void identity() {
        this.xo = 0.0f;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.zo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
    }

    void transform(float[] fArray, int[] nArray, int n) {
        float f = this.xx;
        float f2 = this.xy;
        float f3 = this.xz;
        float f4 = this.xo;
        float f5 = this.yx;
        float f6 = this.yy;
        float f7 = this.yz;
        float f8 = this.yo;
        float f9 = this.zx;
        float f10 = this.zy;
        float f11 = this.zz;
        float f12 = this.zo;
        int n2 = n * 3;
        while ((n2 -= 3) >= 0) {
            float f13 = fArray[n2];
            float f14 = fArray[n2 + 1];
            float f15 = fArray[n2 + 2];
            nArray[n2] = (int)(f13 * f + f14 * f2 + f15 * f3 + f4);
            nArray[n2 + 1] = (int)(f13 * f5 + f14 * f6 + f15 * f7 + f8);
            nArray[n2 + 2] = (int)(f13 * f9 + f14 * f10 + f15 * f11 + f12);
        }
    }

    public String toString() {
        return "[" + this.xo + "," + this.xx + "," + this.xy + "," + this.xz + ";" + this.yo + "," + this.yx + "," + this.yy + "," + this.yz + ";" + this.zo + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }
}

