/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.Graph2DModel;
import JSci.awt.Point2DListModel;
import JSci.maths.ExtraMath;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JLineTrace
extends JDoubleBufferedComponent {
    private final List dataPoints = new ArrayList();
    private float samplingInterval;
    private boolean numbering = true;
    private NumberFormat xNumberFormat = new DecimalFormat("##0.0");
    private NumberFormat yNumberFormat = new DecimalFormat("##0.0");
    private Point origin = new Point();
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float xScale;
    private float yScale;
    private final float xIncPixels = 40.0f;
    private final float yIncPixels = 40.0f;
    private final int scalePad = 5;
    private final int axisPad = 25;
    private int leftAxisPad;

    public JLineTrace(float f, float f2, float f3, float f4) {
        this.addMouseMotionListener(new MouseLineAdapter());
        this.setXExtrema(f, f2);
        this.setYExtrema(f3, f4);
        this.setSamplingInterval(0.2f);
    }

    public Graph2DModel getModel() {
        Point2DListModel point2DListModel = new Point2DListModel();
        point2DListModel.setData(this.dataPoints);
        return point2DListModel;
    }

    public final void setNumbering(boolean bl) {
        this.numbering = bl;
        this.leftAxisPad = 25;
        if (this.numbering && this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.yNumberFormat.format(this.maxY));
            int n2 = fontMetrics.stringWidth(this.yNumberFormat.format(this.minY));
            int n3 = Math.max(n2, n);
            if (this.minX < 0.0f) {
                int n4 = (int)((float)(Math.max(this.getSize().width, this.getMinimumSize().width) - 60) * this.minX / (this.minX - this.maxX));
                n3 = Math.max(n3 - n4, 0);
            }
            this.leftAxisPad += n3;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.numbering);
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setXNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setYNumberFormat(NumberFormat numberFormat) {
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public void setXExtrema(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
        }
        this.minX = f;
        this.maxX = f2;
        this.rescale();
    }

    public void setYExtrema(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
        }
        this.minY = f;
        this.maxY = f2;
        this.rescale();
    }

    public void setSamplingInterval(float f) {
        this.samplingInterval = f;
    }

    public void clear() {
        this.dataPoints.clear();
        this.redraw();
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        this.xScale = (float)((double)(n - (this.leftAxisPad + 25)) / (double)(this.maxX - this.minX));
        this.yScale = (float)((double)(n2 - 50) / (double)(this.maxY - this.minY));
        this.origin.x = this.leftAxisPad - Math.round(this.minX * this.xScale);
        this.origin.y = n2 - 25 + Math.round(this.minY * this.yScale);
        this.redraw();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    private Point2D.Float screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / (double)this.xScale;
        double d2 = (double)(this.origin.y - point.y) / (double)this.yScale;
        return new Point2D.Float((float)d, (float)d2);
    }

    private Point dataToScreen(Point2D.Float float_) {
        return new Point(this.origin.x + Math.round(this.xScale * float_.x), this.origin.y - Math.round(this.yScale * float_.y));
    }

    private Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected void offscreenPaint(Graphics graphics) {
        this.drawAxes(graphics);
        Iterator iterator = this.dataPoints.iterator();
        if (iterator.hasNext()) {
            Point point = this.dataToScreen((Point2D.Float)iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.dataToScreen((Point2D.Float)iterator.next());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                point = point2;
            }
        }
    }

    private void drawAxes(Graphics graphics) {
        graphics.setColor(this.getForeground());
        if (this.minY > 0.0f) {
            graphics.drawLine(this.leftAxisPad - 5, this.getHeight() - 25, this.getWidth() - 20, this.getHeight() - 25);
        } else {
            graphics.drawLine(this.leftAxisPad - 5, this.origin.y, this.getWidth() - 20, this.origin.y);
        }
        if (this.minX > 0.0f) {
            graphics.drawLine(this.leftAxisPad, 20, this.leftAxisPad, this.getHeight() - 20);
        } else {
            graphics.drawLine(this.origin.x, 20, this.origin.x, this.getHeight() - 20);
        }
        if (this.numbering) {
            Point point;
            double d;
            Point point2;
            int n;
            String string;
            double d2;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            float f = (float)ExtraMath.round((double)(40.0 / (double)this.xScale), (int)1);
            if (f == 0.0f) {
                f = Float.MIN_VALUE;
            }
            double d3 = d2 = this.minX > 0.0f ? (double)this.minX : (double)f;
            while (d2 <= (double)this.maxX) {
                string = this.xNumberFormat.format((float)d2);
                n = fontMetrics.stringWidth('+' + string);
                point2 = this.dataToScreen((float)d2, this.minY > 0.0f ? this.minY : 0.0f);
                graphics.drawLine(point2.x, point2.y, point2.x, point2.y + 5);
                graphics.drawString(string, point2.x - n / 2, point2.y + 5 + n2);
                d2 += (double)f;
            }
            for (d2 = (double)(-f); d2 >= (double)this.minX; d2 -= (double)f) {
                string = this.xNumberFormat.format((float)d2);
                n = fontMetrics.stringWidth(string);
                point2 = this.dataToScreen((float)d2, this.minY > 0.0f ? this.minY : 0.0f);
                graphics.drawLine(point2.x, point2.y, point2.x, point2.y + 5);
                graphics.drawString(string, point2.x - n / 2, point2.y + 5 + n2);
            }
            float f2 = (float)ExtraMath.round((double)(40.0 / (double)this.yScale), (int)1);
            if (f2 == 0.0f) {
                f2 = Float.MIN_VALUE;
            }
            double d4 = d = this.minY > 0.0f ? (double)this.minY : (double)f2;
            while (d <= (double)this.maxY) {
                String string2 = this.yNumberFormat.format((float)d);
                int n3 = fontMetrics.stringWidth(string2);
                point = this.dataToScreen(this.minX > 0.0f ? this.minX : 0.0f, (float)d);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string2, point.x - 8 - n3, point.y + n2 / 4);
                d += (double)f2;
            }
            for (d = (double)(-f2); d >= (double)this.minY; d -= (double)f2) {
                String string3 = this.yNumberFormat.format((float)d);
                int n4 = fontMetrics.stringWidth(string3);
                point = this.dataToScreen(this.minX > 0.0f ? this.minX : 0.0f, (float)d);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string3, point.x - 8 - n4, point.y + n2 / 4);
            }
        }
    }

    class MouseLineAdapter
    extends MouseMotionAdapter {
        MouseLineAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point2D.Float float_ = JLineTrace.this.screenToData(mouseEvent.getPoint());
            int n = JLineTrace.this.dataPoints.size() - 1;
            if (float_.x >= (float)n * JLineTrace.this.samplingInterval + JLineTrace.this.minX && float_.x <= JLineTrace.this.maxX) {
                JLineTrace.this.dataPoints.add(float_);
            }
            JLineTrace.this.redraw();
        }
    }
}

