/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.scheme;

import opale.mathtools.DVect;
import opale.mathtools.FixPoint;
import opale.mathtools.IFnn;
import opale.ode.Equation;
import opale.ode.TimeScheme;
import opale.tools.Debug;
import opale.tools.Stdio;

public final class ImplicitEuler
extends TimeScheme {
    private DVect sol;
    private func f = new func();

    public void init() {
        super.init();
        this.sol = new DVect(this.getPb().dim());
        this.f.tmp = new DVect(this.getPb().dim());
    }

    public void forward(Equation equation) {
        boolean bl = false;
        boolean bl2 = false;
        this.sol.set(this.present());
        this.f.eq = equation;
        boolean bl3 = FixPoint.solve(this.f, this.present().size(), this.present(), this.sol);
        Debug.print("Pt fixe cvg = " + bl3);
        if (!bl3) {
            Stdio.printerrln("WARNING!! The fix point method doesn't converge for the fully implicit Euler scheme");
        }
        this.present().set(this.sol);
    }

    public void advance() {
        boolean bl = false;
        boolean bl2 = false;
        this.sol.set(this.past());
        this.f.eq = this.getEquation();
        boolean bl3 = FixPoint.solve(this.f, this.present().size(), this.past(), this.sol);
        Debug.print("Pt fixe cvg = " + bl3);
        if (!bl3) {
            Stdio.printerrln("WARNING!! The fix point method doesn't converge for the fully implicit Euler scheme");
        }
        this.present().set(this.sol);
    }

    public String toString() {
        return "Implicit Euler";
    }

    private class func
    implements IFnn {
        DVect tmp;
        Equation eq;

        private func() {
        }

        public DVect val(DVect dVect) {
            this.tmp.set(ImplicitEuler.this.past());
            this.tmp.acc(ImplicitEuler.this.dt(), this.eq.derivs(ImplicitEuler.this.time(), dVect));
            return this.tmp;
        }
    }
}

