/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import opale.mathtools.parser.Abs;
import opale.mathtools.parser.Acos;
import opale.mathtools.parser.Asin;
import opale.mathtools.parser.Atan;
import opale.mathtools.parser.Cos;
import opale.mathtools.parser.Cst;
import opale.mathtools.parser.Deg;
import opale.mathtools.parser.Exp;
import opale.mathtools.parser.Log;
import opale.mathtools.parser.Log10;
import opale.mathtools.parser.Operator;
import opale.mathtools.parser.PNode;
import opale.mathtools.parser.ParseFunctionException;
import opale.mathtools.parser.Rad;
import opale.mathtools.parser.Rnd;
import opale.mathtools.parser.SUnaryFunction;
import opale.mathtools.parser.Sin;
import opale.mathtools.parser.Sqrt;
import opale.mathtools.parser.Tan;
import opale.mathtools.parser.TypeOp;
import opale.mathtools.parser.UnaryFunction;
import opale.mathtools.parser.Variable;

public class Parser {
    private static final boolean DEBUG = true;
    private Hashtable les_func = new Hashtable(20);
    private Hashtable les_var;
    private Hashtable les_cst;
    private int state = 0;
    private int flag_deg_rad = 1;
    private static final int ADD = 43;
    private static final int SUBTRACT = 45;
    private static final int DIVIDE = 47;
    private static final int MULTIPLY = 42;
    private static final int POWER = 94;
    private static final int GRP = 40;
    private static final int ENDGRP = 41;
    private static final Operator OP_ADD = new Operator(Parser.precedence(43), 43);
    private static final Operator OP_MUL = new Operator(Parser.precedence(42), 42);
    private static final Operator OP_DIV = new Operator(Parser.precedence(47), 47);
    private static final Operator OP_SUB = new Operator(Parser.precedence(45), 45);
    private static final Operator OP_GRP = new Operator(0, 40);
    private static final Operator OP_ENDGRP = new Operator(0, 41);
    private static final Operator OP_POW = new Operator(Parser.precedence(94), 94);
    private PNode root = null;
    private String str;

    public Parser() {
        this.init_func();
        this.les_var = new Hashtable(5);
        this.les_cst = new Hashtable(5);
        this.init_cst();
        this.str = "0";
    }

    public Parser(String string) {
        this.init_func();
        this.les_var = new Hashtable(5);
        this.les_cst = new Hashtable(5);
        this.init_cst();
        this.str = !string.equals("") ? new String(string) : "0";
    }

    public void parseString(String string) {
        this.str = !string.equals("") ? new String(string) : "0";
        this.parseString();
    }

    public void parseString() {
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        StringReader stringReader = new StringReader(this.str);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.parseNumbers();
        streamTokenizer.lowerCaseMode(true);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(94);
        try {
            int n;
            this.state = 0;
            while ((n = streamTokenizer.nextToken()) != -1) {
                switch (this.state) {
                    case 0: {
                        this.parserState0(streamTokenizer, stack, stack2);
                        break;
                    }
                    case 1: {
                        this.parserState1(streamTokenizer, stack, stack2);
                        break;
                    }
                    case 2: {
                        this.parserState2(streamTokenizer, stack, stack2);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                System.out.println("op = " + stack2);
                int n2 = 0;
                while (n2 < stack.size()) {
                    ((PNode)stack.get(n2)).print(0);
                    ++n2;
                }
            }
            this.parserState2(streamTokenizer, stack, stack2);
            System.out.println("op = " + stack2);
            ((PNode)stack.get(0)).print(0);
            this.root = (PNode)stack.get(0);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public double eval() {
        return this.eval(this.root);
    }

    public void addFunc(UnaryFunction unaryFunction) {
        unaryFunction.setParser(this);
        this.les_func.put(unaryFunction.keyword().toLowerCase(), unaryFunction);
    }

    public void addVar(String string) {
        this.les_var.put(string.toLowerCase(), new Variable());
    }

    public void setVar(String string, double d) {
        Variable variable = (Variable)this.les_var.get(string.toLowerCase());
        if (variable == null) {
            throw new ParseFunctionException("method setVar : Unknown variable " + string + " !!!");
        }
        variable.setValue(d);
    }

    public void setVar(String string, String string2) {
        Variable variable = (Variable)this.les_var.get(string.toLowerCase());
        if (variable == null) {
            throw new ParseFunctionException("method setVar : Unknown variable " + string + " !!!");
        }
        variable.setValue(string2);
    }

    public double getVar(String string) {
        Variable variable = (Variable)this.les_var.get(string.toLowerCase());
        if (variable == null) {
            throw new ParseFunctionException("method getVar : Unknown variable " + string + " !!!");
        }
        return variable.getValue();
    }

    public void addCst(String string, double d) {
        this.les_cst.put(string.toLowerCase(), new Cst(d));
    }

    private static Operator getOp(int n) {
        switch (n) {
            case 43: {
                return OP_ADD;
            }
            case 45: {
                return OP_SUB;
            }
            case 42: {
                return OP_MUL;
            }
            case 47: {
                return OP_DIV;
            }
            case 94: {
                return OP_POW;
            }
            case 40: {
                return OP_GRP;
            }
            case 41: {
                return OP_ENDGRP;
            }
        }
        return null;
    }

    private double eval(PNode pNode) {
        double d = 0.0;
        if (pNode == null) {
            throw new ParseFunctionException("method eval : null node !!!");
        }
        switch (pNode.type) {
            case 0: {
                d = this.evalOp(pNode);
                break;
            }
            case 1: {
                d = pNode.value;
                break;
            }
            case 2: {
                d = this.evalFunc(pNode);
                break;
            }
            case 3: {
                d = this.evalVar(pNode);
                break;
            }
            default: {
                throw new ParseFunctionException("method eval : Unknown type for this node !!!");
            }
        }
        return d;
    }

    private double evalOp(PNode pNode) {
        double d = 0.0;
        switch (pNode.op) {
            case 43: {
                if (pNode.left != null) {
                    d = this.eval(pNode.left);
                }
                d += this.eval(pNode.right);
                break;
            }
            case 45: {
                if (pNode.right != null) {
                    d = this.eval(pNode.right);
                }
                d = this.eval(pNode.left) - d;
                break;
            }
            case 47: {
                d = this.eval(pNode.left);
                d /= this.eval(pNode.right);
                break;
            }
            case 42: {
                d = this.eval(pNode.left);
                d *= this.eval(pNode.right);
                break;
            }
            case 94: {
                d = Math.pow(this.eval(pNode.left), this.eval(pNode.right));
                break;
            }
            default: {
                throw new ParseFunctionException("method evalOp : Unknown operator !!!");
            }
        }
        return d;
    }

    private double evalFunc(PNode pNode) {
        double d = 0.0;
        UnaryFunction unaryFunction = (UnaryFunction)this.les_func.get(pNode.svalue.toLowerCase());
        if (unaryFunction == null) {
            throw new ParseFunctionException("method evalFunc : Unknown function !!!");
        }
        d = unaryFunction.eval(this.eval(pNode.left));
        return d;
    }

    private double evalVar(PNode pNode) {
        double d = 0.0;
        Variable variable = (Variable)this.les_var.get(pNode.svalue);
        if (variable == null) {
            throw new ParseFunctionException("method evalVar : Unknown variable " + pNode.svalue + " !!!");
        }
        d = variable.getValue();
        return d;
    }

    private static int precedence(int n) {
        switch (n) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 47: {
                return 3;
            }
            case 94: {
                return 5;
            }
        }
        return -1;
    }

    private void parserState0(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        try {
            switch (streamTokenizer.ttype) {
                case -3: {
                    System.out.println(streamTokenizer.sval);
                    Variable variable = (Variable)this.les_var.get(streamTokenizer.sval);
                    if (variable != null) {
                        PNode pNode = new PNode();
                        pNode.type = 3;
                        pNode.svalue = streamTokenizer.sval;
                        stack.push(pNode);
                        this.state = 2;
                        break;
                    }
                    UnaryFunction unaryFunction = (UnaryFunction)this.les_func.get(streamTokenizer.sval);
                    if (unaryFunction != null) {
                        stack2.push(unaryFunction);
                        this.state = 0;
                        break;
                    }
                    Cst cst = (Cst)this.les_cst.get(streamTokenizer.sval);
                    if (cst != null) {
                        PNode pNode = new PNode();
                        pNode.type = 1;
                        pNode.value = cst.getValue();
                        stack.push(pNode);
                        this.state = 2;
                        break;
                    }
                    throw new ParseFunctionException("Unknown keyword " + streamTokenizer.sval + " !!");
                }
                case -2: {
                    System.out.println(streamTokenizer.nval);
                    PNode pNode = new PNode();
                    pNode.type = 1;
                    pNode.value = streamTokenizer.nval;
                    stack.push(pNode);
                    this.state = 2;
                    break;
                }
                case 43: {
                    System.out.println("plus unaire");
                    stack2.push(Parser.getOp(43));
                    PNode pNode = new PNode();
                    pNode.type = 1;
                    pNode.value = 0.0;
                    stack.push(pNode);
                    this.state = 1;
                    break;
                }
                case 45: {
                    System.out.println("moins unaire");
                    stack2.push(Parser.getOp(45));
                    PNode pNode = new PNode();
                    pNode.type = 1;
                    pNode.value = 0.0;
                    stack.push(pNode);
                    this.state = 1;
                    break;
                }
                case 40: {
                    System.out.println("(");
                    stack2.push(Parser.getOp(40));
                    this.state = 0;
                    break;
                }
                default: {
                    System.out.println(streamTokenizer.ttype);
                    throw new ParseFunctionException("parsing this string fails !!");
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParseFunctionException("Missing arguments !!!");
        }
    }

    private void parserState1(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        try {
            switch (streamTokenizer.ttype) {
                case -3: {
                    System.out.println(streamTokenizer.sval);
                    Variable variable = (Variable)this.les_var.get(streamTokenizer.sval);
                    if (variable != null) {
                        PNode pNode = new PNode();
                        pNode.type = 3;
                        pNode.svalue = streamTokenizer.sval;
                        stack.push(pNode);
                        this.state = 2;
                        break;
                    }
                    UnaryFunction unaryFunction = (UnaryFunction)this.les_func.get(streamTokenizer.sval);
                    if (unaryFunction != null) {
                        stack2.push(unaryFunction);
                        this.state = 0;
                        break;
                    }
                    Cst cst = (Cst)this.les_cst.get(streamTokenizer.sval);
                    if (cst != null) {
                        PNode pNode = new PNode();
                        pNode.type = 1;
                        pNode.value = cst.getValue();
                        stack.push(pNode);
                        this.state = 2;
                        break;
                    }
                    throw new ParseFunctionException("Unknown keyword " + streamTokenizer.sval + " !!");
                }
                case -2: {
                    System.out.println(streamTokenizer.nval);
                    PNode pNode = new PNode();
                    pNode.type = 1;
                    pNode.value = streamTokenizer.nval;
                    stack.push(pNode);
                    this.state = 2;
                    break;
                }
                case 40: {
                    System.out.println("(");
                    stack2.push(Parser.getOp(40));
                    this.state = 0;
                    break;
                }
                default: {
                    System.out.println(streamTokenizer.ttype);
                    throw new ParseFunctionException("parsing this string fails !!");
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParseFunctionException("Missing arguments !!!");
        }
    }

    private void parserState2(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        try {
            switch (streamTokenizer.ttype) {
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 94: {
                    System.out.println((char)streamTokenizer.ttype);
                    Operator operator = Parser.getOp(streamTokenizer.ttype);
                    if (!stack2.empty()) {
                        TypeOp typeOp = (TypeOp)stack2.peek();
                        while (typeOp.precedence() >= operator.precedence()) {
                            PNode pNode;
                            PNode pNode2;
                            TypeOp typeOp2;
                            if (typeOp instanceof Operator) {
                                typeOp2 = (Operator)stack2.pop();
                                System.out.println("depile = " + typeOp2);
                                pNode2 = (PNode)stack.pop();
                                pNode = (PNode)stack.pop();
                                PNode pNode3 = new PNode();
                                pNode3.type = 0;
                                pNode3.op = ((Operator)typeOp2).op;
                                pNode3.left = pNode;
                                pNode3.right = pNode2;
                                stack.push(pNode3);
                            } else if (typeOp instanceof UnaryFunction) {
                                typeOp2 = (UnaryFunction)stack2.pop();
                                System.out.println("depile = " + typeOp2);
                                pNode2 = (PNode)stack.pop();
                                pNode = new PNode();
                                pNode.type = 2;
                                pNode.svalue = typeOp2.keyword();
                                pNode.left = pNode2;
                                pNode.right = null;
                                stack.push(pNode);
                            }
                            if (stack2.empty()) break;
                            typeOp = (TypeOp)stack2.peek();
                        }
                    }
                    stack2.push(operator);
                    this.state = 1;
                    break;
                }
                case 41: {
                    System.out.println(")");
                    Operator operator = Parser.getOp(streamTokenizer.ttype);
                    if (!stack2.empty()) {
                        TypeOp typeOp = (TypeOp)stack2.pop();
                        while (!typeOp.keyword().equals("(")) {
                            PNode pNode;
                            PNode pNode4;
                            TypeOp typeOp3;
                            if (typeOp instanceof Operator) {
                                typeOp3 = (Operator)typeOp;
                                System.out.println("depile = " + typeOp3);
                                pNode4 = (PNode)stack.pop();
                                pNode = (PNode)stack.pop();
                                PNode pNode5 = new PNode();
                                pNode5.type = 0;
                                pNode5.op = ((Operator)typeOp3).op;
                                pNode5.left = pNode;
                                pNode5.right = pNode4;
                                stack.push(pNode5);
                            } else if (typeOp instanceof UnaryFunction) {
                                typeOp3 = (UnaryFunction)typeOp;
                                System.out.println("depile = " + typeOp3);
                                pNode4 = (PNode)stack.pop();
                                pNode = new PNode();
                                pNode.type = 2;
                                pNode.svalue = typeOp3.keyword();
                                pNode.left = pNode4;
                                pNode.right = null;
                                stack.push(pNode);
                            }
                            if (stack2.empty()) break;
                            typeOp = (TypeOp)stack2.pop();
                        }
                    }
                    this.state = 2;
                    break;
                }
                case -1: {
                    System.out.println("EOF");
                    while (!stack2.empty()) {
                        PNode pNode;
                        PNode pNode6;
                        TypeOp typeOp;
                        TypeOp typeOp4 = (TypeOp)stack2.pop();
                        if (typeOp4 instanceof Operator) {
                            typeOp = (Operator)typeOp4;
                            System.out.println("depile = " + typeOp);
                            pNode6 = (PNode)stack.pop();
                            pNode = (PNode)stack.pop();
                            PNode pNode7 = new PNode();
                            pNode7.type = 0;
                            pNode7.op = ((Operator)typeOp).op;
                            pNode7.left = pNode;
                            pNode7.right = pNode6;
                            stack.push(pNode7);
                            continue;
                        }
                        if (!(typeOp4 instanceof UnaryFunction)) continue;
                        typeOp = (UnaryFunction)typeOp4;
                        pNode6 = (PNode)stack.pop();
                        pNode = new PNode();
                        pNode.type = 2;
                        pNode.svalue = typeOp.keyword();
                        pNode.left = pNode6;
                        pNode.right = null;
                        stack.push(pNode);
                    }
                    this.state = 0;
                    break;
                }
                default: {
                    System.out.println(streamTokenizer.ttype);
                    System.out.println(streamTokenizer.sval);
                    throw new ParseFunctionException("parsing this string fails !!");
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParseFunctionException("Missing arguments !!!");
        }
    }

    private void init_cst() {
        this.addCst("pi", Math.PI);
        this.addCst("e", Math.E);
    }

    private void init_func() {
        this.addFunc(new Sin());
        this.addFunc(new Cos());
        this.addFunc(new Tan());
        this.addFunc(new Log());
        this.addFunc(new Log10());
        this.addFunc(new Exp());
        this.addFunc(new Sqrt());
        this.addFunc(new Abs());
        this.addFunc(new Acos());
        this.addFunc(new Asin());
        this.addFunc(new Atan());
        this.addFunc(new Rnd());
        this.addFunc(new Rad());
        this.addFunc(new Deg());
    }

    public void setRad() {
        this.flag_deg_rad = 1;
    }

    public void setDeg() {
        this.flag_deg_rad = 0;
    }

    public boolean isDeg() {
        return this.flag_deg_rad == 0;
    }

    public static void main(String[] stringArray) {
        Parser parser = new Parser("cos(myFunc(x)^2-2*myFunc(2))");
        parser.addVar("X");
        parser.addVar("y");
        parser.setVar("x", 1.0);
        parser.setVar("y", "acos(0.5)");
        SUnaryFunction sUnaryFunction = new SUnaryFunction("MYfunc", "x", "3*x");
        parser.addFunc(sUnaryFunction);
        parser.parseString();
        System.out.println(parser.eval());
    }
}

