/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import opale.m2d.CoordSystem;
import opale.m2d.OIJ;
import opale.m2d.OIJException;

public class LinLinCS
extends CoordSystem {
    private double stepX;
    private double stepY;
    private double originX;
    private double originY;

    public LinLinCS(int n, int n2, int n3, int n4) {
        this.setSize(n, n2, n3, n4);
        try {
            this.oij = new OIJ(0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
            this.autoadjust();
        }
        catch (OIJException oIJException) {
            // empty catch block
        }
    }

    public LinLinCS(OIJ oIJ, int n, int n2, int n3, int n4) {
        this.setSize(n, n2, n3, n4);
        this.setOIJ(oIJ);
        this.autoadjust();
    }

    public void autoadjust() {
        double d = Math.sqrt(this.oij.normSqI());
        double d2 = Math.sqrt(this.oij.normSqJ());
        this.stepX = (double)this.width / (this.xmax - this.xmin) / d;
        this.stepY = (double)this.height / (this.ymax - this.ymin) / d2;
        this.originX = (int)((double)this.borderX - this.xmin * this.stepX * d);
        this.originY = (int)((double)this.borderY + this.ymax * this.stepY * d2);
    }

    public void normadjust() {
        double d = Math.sqrt(this.oij.normSqI());
        double d2 = Math.sqrt(this.oij.normSqJ());
        this.stepX = this.stepY = Math.min((double)this.width / (this.xmax - this.xmin) / d, (double)this.height / (this.ymax - this.ymin) / d2);
        this.width = (int)((this.xmax - this.xmin) * this.stepX * d);
        this.height = (int)((this.ymax - this.ymin) * this.stepX * d2);
        this.originX = (int)((double)this.borderX - this.xmin * this.stepX * d);
        this.originY = (int)((double)this.borderY + this.ymax * this.stepY * d2);
    }

    public final int X(double d, double d2) {
        return (int)(this.originX + d * this.stepX * this.oij.getIx() + d2 * this.stepY * this.oij.getJx());
    }

    public final int Y(double d, double d2) {
        return (int)(this.originY - d * this.stepX * this.oij.getIy() - d2 * this.stepY * this.oij.getJy());
    }

    public final double xfromXY(int n, int n2) {
        return this.oij.getOriginX() + (((double)n - this.originX) * this.oij.getJy() - ((double)n2 - this.originY) * this.oij.getJx()) / (this.stepX * (this.oij.getIx() * this.oij.getJy() - this.oij.getIy() * this.oij.getJx()));
    }

    public final double yfromXY(int n, int n2) {
        return this.oij.getOriginY() + (((double)n2 - this.originY) * this.oij.getIx() - ((double)n - this.originX) * this.oij.getIy()) / (this.stepY * (-this.oij.getIx() * this.oij.getJy() + this.oij.getIy() * this.oij.getJx()));
    }

    public final double normSq(double d, double d2) {
        return this.oij.normSq(d, d2);
    }
}

