/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperSymmPackMatrix
extends AbstractSymmPackMatrix {
    public UpperSymmPackMatrix(int n) {
        super(n, UpLo.Upper);
    }

    public UpperSymmPackMatrix(Matrix A) {
        this(A, true);
    }

    public UpperSymmPackMatrix(Matrix A, boolean deep) {
        super(A, deep, UpLo.Upper);
    }

    public void add(int row, int column, double value) {
        if (row <= column) {
            int n = this.getIndex(row, column);
            this.data[n] = this.data[n] + value;
        }
    }

    public void set(int row, int column, double value) {
        if (row <= column) {
            this.data[this.getIndex((int)row, (int)column)] = value;
        }
    }

    public double get(int row, int column) {
        if (row <= column) {
            return this.data[this.getIndex(row, column)];
        }
        return this.data[this.getIndex(column, row)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (column + 1) * column / 2;
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UpperSymmPackMatrix copy() {
        return new UpperSymmPackMatrix(this);
    }
}

