/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class UnitUpperTriangDenseMatrix
extends UpperTriangDenseMatrix {
    public UnitUpperTriangDenseMatrix(int n) {
        super(n, Diag.Unit);
    }

    public UnitUpperTriangDenseMatrix(Matrix A) {
        this(A, true);
    }

    public UnitUpperTriangDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, Diag.Unit);
    }

    public void add(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() >= e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UnitUpperTriangDenseMatrix copy() {
        return new UnitUpperTriangDenseMatrix(this);
    }

    public Matrix zero() {
        throw new UnsupportedOperationException();
    }
}

