/** automatically generated by AFNI program quotize **/
static char *readme_env[] = {
   "Unix Environment Variables Used by AFNI\n" ,
   "=======================================\n" ,
   "The AFNI program allows you to use several Unix environment variables\n" ,
   "to influence its behavior.  The mechanics of setting an environment\n" ,
   "variable depend on which shell you are using.  To set an environment\n" ,
   "variable named \"FRED\" to the string \"Elvis\":\n" ,
   "\n" ,
   "   csh or tcsh:  setenv FRED Elvis\n" ,
   "   bash or ksh:  FRED=Elvis ; export FRED\n" ,
   "\n" ,
   "Normally, these commands would go in your .cshrc or .profile files,\n" ,
   "so that they would be invoked when you login.  If in doubt, consult\n" ,
   "your local Unix guru.  If you don't have one, well....\n" ,
   "\n" ,
   "You don't NEED to set any of these variables -- AFNI will still work\n" ,
   "correctly.  But they are an easy way to set up certain defaults to\n" ,
   "make AFNI a little easier on your neocortex and hippocampus.\n" ,
   "\n" ,
   "N.B.: Changes to environment variables AFTER you start a program will\n" ,
   "      not be seen by that program, since each running program gets\n" ,
   "      a private copy of the entire set of environment variables when\n" ,
   "      it starts.  This is a standard Unix feature, and is not specific\n" ,
   "      to AFNI.  Some variables can be set internally in AFNI using\n" ,
   "      the \"Edit Environment\" control from the \"Datamode->Misc\" menu\n" ,
   "      or from the image window Button-3 popup menu.  Such variables\n" ,
   "      are marked with \"(editable)\" in the descriptions below.\n" ,
   "\n" ,
   "N.B.: Some variables below are described as being of \"YES/NO\" type.\n" ,
   "      This means that they should either be set to the value \"YES\"\n" ,
   "      or to the value \"NO\".\n" ,
   "\n" ,
   "N.B.: You can now set environment variables on the 'afni' command\n" ,
   "      line; for example:\n" ,
   "        afni -DAFNI_EDGIZE_OVERLAY=YES -DAFNI_SESSTRAIL=3\n" ,
   "      This may be useful for a 'one time' situation, or as an alias.\n" ,
   "      You can also use this '-Dname=val' option in 1dplot and 3dDeconvolve.\n" ,
   "      -- RWCox - 22 Mar 2005\n" ,
   "      And now you can use this feature on most program command lines.\n" ,
   "      -- RWCox - 13 Dec 2007\n" ,
   "\n" ,
   "N.B.: At the end of this file is a list of several environment variables\n" ,
   "      that affect the program 3dDeconvolve, rather than the interactive\n" ,
   "      AFNI program itself.\n" ,
   "\n" ,
   "N.B.: If you set an AFNI environment variable on the command line, or\n" ,
   "      in a shell startup file (e.g., ~/.cshrc), and also have that\n" ,
   "      variable in your ~/.afnirc file, you will get a warning telling\n" ,
   "      you that the value in the ~/.afnirc file is being ignored.\n" ,
   "      To turn off these warnings, set environment variable\n" ,
   "      AFNI_ENVIRON_WARNINGS to NO.\n" ,
   "\n" ,
   "N.B.: You can allow the .afnirc file to re-set existing environment\n" ,
   "      variables by setting environment variable AFNI_ENVIRON_RESET to YES.\n" ,
   "\n" ,
   "********************************************************\n" ,
   "June 1999: Setting environment variables in file .afnirc\n" ,
   "********************************************************\n" ,
   "You can now set environment variables for an interactive AFNI run in the\n" ,
   "setup (.afnirc) file.  This is provided as a convenience.  An example:\n" ,
   "\n" ,
   "***ENVIRONMENT\n" ,
   "  AFNI_HINTS = YES\n" ,
   "  AFNI_SESSTRAIL = 3\n" ,
   "\n" ,
   "Note that the spaces around the \"=\" sign are required.  See README.setup\n" ,
   "for more information about the possible contents of .afnirc besides the\n" ,
   "environment variables.\n" ,
   "\n" ,
   "A few other programs in the AFNI package also read the ***ENVIRONMENT\n" ,
   "section of the .afnirc file.  This is needed so that environment settings\n" ,
   "that affect those programs (e.g., AFNI_COMPRESSOR for auto-compression of\n" ,
   "output datasets) can be properly initialized in .afnirc.\n" ,
   "\n" ,
   "At the same time, the routine in AFNI that initializes certain internal\n" ,
   "constants from X11 resources (usually in your .Xdefaults or .Xresources\n" ,
   "file, and described in file AFNI.Xdefaults) has been modified to also\n" ,
   "allow the same constants to be set from Unix environment variables.\n" ,
   "For example, the gap (in pixels) between sub-graphs is set by the\n" ,
   "X11 resource \"AFNI*graph_ggap\", and can now be set by the environment\n" ,
   "variables \"AFNI_graph_ggap\" or \"AFNI_GRAPH_GGAP\", as in\n" ,
   "\n" ,
   "  AFNI_graph_ggap = 6   // this is a comment\n" ,
   "\n" ,
   "If an X11 resource is actually set, it will take priority over the\n" ,
   "environment variable.  Some of the variables that can be set in this\n" ,
   "way are:\n" ,
   "\n" ,
   " AFNI_ncolors             = number of gray levels to use\n" ,
   " AFNI_gamma               = gamma correction for image intensities\n" ,
   " AFNI_graph_boxes_thick   = 0=thin lines, 1=thick lines, for graph boxes\n" ,
   " AFNI_graph_grid_thick    = ditto for the graph vertical grid lines\n" ,
   " AFNI_graph_data_thick    = ditto for the data graphs\n" ,
   " AFNI_graph_ideal_thick   = ditto for the ideal graphs\n" ,
   " AFNI_graph_ort_thick     = ditto for the ort graphs\n" ,
   " AFNI_graph_dplot_thick   = ditto for the dplot graphs\n" ,
   " AFNI_graph_ggap          = initial spacing between graph boxes\n" ,
   " AFNI_graph_matrix        = initial number of sub-graphs\n" ,
   " AFNI_fim_polort          = polynomial detrending order for FIM\n" ,
   " AFNI_fim_ignore          = how many pts to ignore at start when doing FIM\n" ,
   " AFNI_montage_periodic    = True allows periodic montage wraparound\n" ,
   " AFNI_purge               = True allows automatic dataset memory purge\n" ,
   " AFNI_resam_vox           = dimension of voxel (mm) for resampled datasets\n" ,
   " AFNI_resam_anat          = One of NN, Li, Cu, Bk for Anat resampling mode\n" ,
   " AFNI_resam_func          = ditto for Func resampling mode\n" ,
   " AFNI_resam_thr           = ditto for Threshold resampling mode\n" ,
   " AFNI_pbar_posfunc        = True will start color pbar as all positive\n" ,
   " AFNI_pbar_sgn_pane_count = # of panes to start signed color pbar with\n" ,
   " AFNI_pbar_pos_pane_count = # of panes to start positive color pbar with\n" ,
   "\n" ,
   "Some other such variables are described in file AFNI.Xdefaults.  Note that\n" ,
   "values that actually affect the way the X11/Motif interface appears, such as\n" ,
   "AFNI*troughColor, must be set via the X11 mechanism and cannot be set using\n" ,
   "Unix environment variables.  This is because they are interpreted by the\n" ,
   "Motif graphics library when it starts and not by any actual AFNI code.\n" ,
   "\n" ,
   "The following example is from my own .afnirc file on the Linux system on\n" ,
   "which I do most of the AFNI development.  The first ones (in lower case)\n" ,
   "are described in AFNI.Xdefaults.  The later ones (all upper case) are\n" ,
   "documented in this file.  (You can tell from this file that I like to\n" ,
   "have things line up.  You would never be able to tell this from the\n" ,
   "piles of paper in my office, though.)\n" ,
   "\n" ,
   " ***ENVIRONMENT\n" ,
   "\n" ,
   " AFNI_ncolors             = 60      // number of gray levels\n" ,
   " AFNI_gamma               = 1.5     // adjust for proper display\n" ,
   " AFNI_purge               = True    // purge datasets from memory when not used\n" ,
   " AFNI_chooser_doubleclick = Apply   // like Apply button; could also be Set\n" ,
   " AFNI_chooser_listmax     = 25      // max nonscrolling items in chooser lists\n" ,
   " AFNI_graph_width         = 512     // initial width of graph window (pixels)\n" ,
   " AFNI_graph_height        = 384     // initial height of graph window\n" ,
   " AFNI_graph_data_thick    = 1       // graph time series with thick lines\n" ,
   " AFNI_fim_ignore          = 2       // default value for FIM ignore\n" ,
   " AFNI_graph_ggap          = 7       // gap between sub-graphs (pixels)\n" ,
   " AFNI_pbar_hide           = True    // hide color pbar when it changes size\n" ,
   " AFNI_hotcolor            = Violet  // color to use on Done and Set buttons\n" ,
   " AFNI_SESSTRAIL           = 2       // see below for these ...\n" ,
   " AFNI_RENDER_ANGLE_DELTA  = 4.0     //                       |\n" ,
   " AFNI_RENDER_CUTOUT_DELTA = 4.0     //                       |\n" ,
   " AFNI_FIM_BKTHR           = 25.0    //                       |\n" ,
   " AFNI_SPLASHTIME          = 3.0     //                       v\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MESSAGE_PREFIX\n" ,
   "-----------------------------\n" ,
   "Most AFNI programs output various messages prefixed by '++', '**', and\n" ,
   "divers variations.  If you are running several programs at once, you can\n" ,
   "pre-pend a string to these prefixes to distinguish them in the output\n" ,
   "terminal stream.  For example, a csh script might look like so:\n" ,
   "  foreach fred ( 1 2 3 4 )\n" ,
   "    setenv AFNI_MESSAGE_PREFIX case$fred\n" ,
   "    run_some_program -option $fred ... |& tee out${fred}.txt &\n" ,
   "  end\n" ,
   "  wait\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_MESSAGE_COLORIZE   [22 Feb 2016]\n" ,
   "-------------------------------\n" ,
   "When AFNI programs print WARNING or ERROR messages, they normally print the\n" ,
   "'WARNING' or 'ERROR' label using inverted colors, to aid in picking out these\n" ,
   "messages from other text on the screen.  To turn this feature off, set this\n" ,
   "environment variable to 'NO'.\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable: AFNI_DONT_SORT_ENVIRONMENT\n" ,
   "------------------------------------\n" ,
   "If this YES/NO variable is YES, then the Edit Environment controls will\n" ,
   "NOT be sorted alphabetically.  The default action is to sort them\n" ,
   "alphabetically.  If they are unsorted, the editable environment variables\n" ,
   "will appear in the control panel in the order in which they were added to\n" ,
   "the code (that is, in an order that makes no real sense).\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_ORIENT (editable)\n" ,
   "---------------------\n" ,
   "This is a string used to control the display of coordinates in the AFNI\n" ,
   "main control window.  The string must be 3 letters, one each from the\n" ,
   "pairs {R,L} {A,P} {I,S}.  The first letter in the string gives the\n" ,
   "orientation of the x-axis, the second the orientation of the y-axis,\n" ,
   "the third the z-axis:\n" ,
   "\n" ,
   "   R = right-to-left           L = left-to-right\n" ,
   "   A = anterior-to-posterior   P = posterior-to-anterior\n" ,
   "   I = inferior-to-superior    S = superior-to-inferior\n" ,
   "\n" ,
   "If AFNI_ORIENT is undefined, the default is RAI.  This is the order\n" ,
   "used by DICOM, and means\n" ,
   "\n" ,
   "   the -x axis is Right,    the +x axis is Left,\n" ,
   "   the -y axis is Anterior, the +y axis is Posterior,\n" ,
   "   the -z axis is Inferior, the +z axis is Superior.\n" ,
   "\n" ,
   "As a special case, using the code 'flipped' is equivalent to 'LPI',\n" ,
   "which is the orientation used in many neuroscience journals.\n" ,
   "\n" ,
   "This variable is also recognized by program 3dclust, which will report\n" ,
   "the cluster coordinates in the (x,y,z) order given by AFNI_ORIENT.\n" ,
   "Both AFNI and 3dclust also recognize the command line switch\n" ,
   "\"-orient string\", where string is a 3 letter code that can be used\n" ,
   "to override the value of AFNI_ORIENT.\n" ,
   "\n" ,
   "The plugin \"Coord Order\" (plug_coord.c) allows you to interactively\n" ,
   "change the orientation of the variable display within AFNI.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PLUGINPATH\n" ,
   "-------------------------\n" ,
   "This variable should be the directory in which AFNI should search\n" ,
   "for plugins, executable files, atlases, templates and atlas definition files.\n" ,
   "See the atlas environment variable section below for more details.\n" ,
   "If there is more than one appropriate directory, they can be separated\n" ,
   "by colons, as in\n" ,
   "\n" ,
   "   setenv AFNI_PLUGINPATH /directory/one:/directory/two\n" ,
   "\n" ,
   "If this variable is not set, then AFNI will use the PATH variable\n" ,
   "instead.  This will waste time, since most directories in the PATH\n" ,
   "will not have plugins.  On some systems, using the PATH has been\n" ,
   "known to cause problems when AFNI starts.  I believe this is due to\n" ,
   "bugs in the system library routines (e.g., dlopen) used to manage\n" ,
   "dynamically loaded shared objects. Take care to remove any slow or\n" ,
   "non-existent directories from the PATH because these problems will cause\n" ,
   "searches to fail or become excessively slow.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_NOPLUGINS\n" ,
   "------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will not try to\n" ,
   "read plugins when it starts up.  The command line switch \"-noplugins\"\n" ,
   "will have the same effect.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_YESPLUGOUTS\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will try to listen\n" ,
   "for plugouts when it starts.  The command line switch \"-yesplugouts\"\n" ,
   "will have the same effect.  (Plugouts are an experimental feature\n" ,
   "that allow external programs to exchange data with AFNI.)  It is now\n" ,
   "also possible to start plugout listening from the Datamode->Misc menu.\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_TSPATH\n" ,
   "---------------------\n" ,
   "This variable should be set to any directory which you want to have\n" ,
   "AFNI scan for timeseries files (*.1D -- see the AFNI manual).  If\n" ,
   "more than one directory is desired, then colons can be used to\n" ,
   "separate them, as in AFNI_PLUGINPATH.  Note that timeseries files\n" ,
   "are read from all session directories, so directories provided by\n" ,
   "AFNI_TSPATH are designed to contain extra timeseries files that\n" ,
   "you want loaded no matter what AFNI sessions and datasets are being\n" ,
   "viewed.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_MODELPATH\n" ,
   "------------------------\n" ,
   "This variable should be set to the directory from which you want AFNI\n" ,
   "timeseries models to be loaded.  These models are similar to plugins,\n" ,
   "and are used by programs 3dNLfim, 3dTSgen, and the plugin plug_nlfit\n" ,
   "(menu label \"NLfit & NLerr\") -- see documentation file 3dNLfim.ps.\n" ,
   "If AFNI_MODELPATH is not given, then AFNI_PLUGINPATH will be used\n" ,
   "instead.\n" ,
   "\n" ,
   "-----------------------------------------\n" ,
   "Variable: AFNI_IMSIZE_* (or MCW_IMSIZE_*)\n" ,
   "-----------------------------------------\n" ,
   "These variables (named AFNI_IMSIZE_1 to AFNI_IMSIZE_99) allow you\n" ,
   "to control how the AFNI programs read binary image files.  The use of\n" ,
   "these is somewhat complicated, and is explained in detail at the end\n" ,
   "of the auxiliary programs manual (afni_aux.ps), in the section on \"3D:\"\n" ,
   "file specifications, and is also explained in the AFNI FAQ list.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_SESSTRAIL (editable)\n" ,
   "------------------------\n" ,
   "This variable controls the number of directory levels shown when\n" ,
   "choosing between session directories with the \"Switch Session\"\n" ,
   "button.  This variable should be set to a nonnegative integer.\n" ,
   "If a session directory name were\n" ,
   "   this/is/a/directory/name/\n" ,
   "then the \"Switch Session\" chooser would display the following:\n" ,
   "\n" ,
   "   AFNI_SESSTRAIL    Display\n" ,
   "   --------------    -------\n" ,
   "            0        name/\n" ,
   "            1        directory/name/\n" ,
   "            2        a/directory/name/\n" ,
   "            3        is/a/directory/name/\n" ,
   "            4        this/is/a/directory/name/\n" ,
   "\n" ,
   "That is, AFNI_SESSTRAIL determines how many trailing levels of\n" ,
   "the directory name are used for the display.  If AFNI_SESSTRAIL\n" ,
   "is not set, then it is equivalent to setting it to 0 (which\n" ,
   "was the old method).\n" ,
   "\n" ,
   "--------------------\n" ,
   "Variable: AFNI_HINTS\n" ,
   "--------------------\n" ,
   "This is a string controlling whether or not the popup \"hints\" are\n" ,
   "displayed when AFNI starts.  If the string is \"NO\", then the hints\n" ,
   "are disabled when AFNI starts, otherwise they are enabled.  In\n" ,
   "either case, they can be turned off and on interactively from the\n" ,
   "Define Datamode->Misc menu.\n" ,
   "\n" ,
   "Hints can be permanently disabled by setting the C macro\n" ,
   "DONT_USE_HINTS in machdep.h and recompiling AFNI.  They can also\n" ,
   "be disabled at runtime by setting AFNI_HINTS to \"KILL\".\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_COMPRESSOR (cf. AFNI_AUTOGZIP) (editable)\n" ,
   "-------------------------\n" ,
   "This variable is used to control automatic compression of .BRIK files on\n" ,
   "output.  The legal values are \"COMPRESS\", \"GZIP\", \"BZIP2\", \"PIGZ\", which\n" ,
   "respectively invoke programs \"compress\", \"gzip\",\"bzip2\" and \"pigz\" (these\n" ,
   "must be in your path for compression to work).  If AFNI_COMPRESSOR is\n" ,
   "equal to one of these, then all AFNI programs will automatically pass\n" ,
   ".BRIK data through the appropriate compression program as it is written\n" ,
   "to disk.  Note that this will slow down dataset write operations.  Note\n" ,
   "also that compressed datasets cannot be mapped directly from disk into\n" ,
   "memory ('mmap'), but must occupy actual memory (RAM) and swap space.  For\n" ,
   "more details, see file README.compression.\n" ,
   "\n" ,
   "Note that compressed (.BRIK.Z, .BRIK.gz, and .BRIK.bz2) datasets will\n" ,
   "automatically be uncompressed on input, no matter what the setting of\n" ,
   "this variable.  AFNI_COMPRESSOR only controls how the datasets are\n" ,
   "written.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_BYTEORDER\n" ,
   "------------------------\n" ,
   "This variable is used to control the byte order for output files.\n" ,
   "If you use it, the two legal values are \"LSB_FIRST\" and \"MSB_FIRST\".\n" ,
   "If you don't use it, the default order on your CPU will be used.\n" ,
   "The main purpose of this would be if you were using a mixture of\n" ,
   "CPU types reading shared disks (i.e., using NFS).  If the majority\n" ,
   "of the systems were MSB_FIRST (e.g., SGI, HP, Sun), but there were\n" ,
   "a few LSB_FIRST systems (e.g., Intel, DEC Alpha), then you might\n" ,
   "want to do 'setenv AFNI_BYTEORDER MSB_FIRST' on all of the MSB_FIRST\n" ,
   "systems to make sure that the datasets that they write out are\n" ,
   "readable by the other computers.\n" ,
   "\n" ,
   "Note that AFNI programs can now check the .HEAD file for the byte\n" ,
   "order of a dataset, and will swap the bytes on input, if needed.\n" ,
   "If you wish to mark all of the datasets on a given system as\n" ,
   "being in a particular order, the following command should work:\n" ,
   "\n" ,
   " find /top/dir -name \\*.HEAD -exec 3drefit -byteorder NATIVE_ORDER {} \\;\n" ,
   "\n" ,
   "Here, '/top/dir' is the name of the top level directory under\n" ,
   "which you wish to search for AFNI datasets.  The string NATIVE_ORDER\n" ,
   "means to set all datasets to the CPU default order, which is probably\n" ,
   "what you are using now.  (You can use the program 'byteorder' to\n" ,
   "find out the native byte ordering of your CPU.)\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_BYTEORDER_INPUT\n" ,
   "------------------------------\n" ,
   "This variable is used to control the byte order for input files.\n" ,
   "If you use it, the two legal values are \"LSB_FIRST\" and \"MSB_FIRST\".\n" ,
   "The value of this variable is only used for old datasets that do\n" ,
   "not have the byte order encoded in their headers.  If this variable\n" ,
   "is not present, then the CPU native byte order is used.  If this\n" ,
   "variable is present, and its value differs from the native byte\n" ,
   "order, then 2 byte dataset BRIKs (short) are 2-swapped (as in\n" ,
   "\"ab\" -> \"ba\") when they are read from disk, and 4 byte datasets\n" ,
   "(float, complex) are 4-swapped (\"abcd\" -> \"dcba\").\n" ,
   "\n" ,
   "[per the request of John Koger]\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_NOMMAP\n" ,
   "---------------------\n" ,
   "This YES/NO variable can be used to turn off the mmap feature by which\n" ,
   "AFNI can load datasets into memory using the map-file-to-memory\n" ,
   "functionality of Unix.  (Dataset .BRIK files will only be mmap-ed if\n" ,
   "they are not compressed and are in the native byte order of the CPU.)\n" ,
   "On some systems, mmap doesn't seem to work very well (e.g., Linux kernel\n" ,
   "version 1.2.13).  You can disable mmap by 'setenv AFNI_NOMMAP YES'.\n" ,
   "\n" ,
   "The penalty for disabling mmap is that all datasets must be loaded\n" ,
   "into actual RAM.  AFNI does not have the ability to load a dataset\n" ,
   "only partially, so if a 20 Megabyte .BRIK file is accessed, all of\n" ,
   "it will be loaded into RAM.  With mmap, the Unix operating system will\n" ,
   "decide how much of the file to load.  In this way, it is possible to\n" ,
   "deal with more files than you have swap space on your computer\n" ,
   "(since .BRIK files are mmap-ed in readonly mode, so they don't\n" ,
   "take up swap space, which is for saving modified memory pages).\n" ,
   "\n" ,
   "The moral of the story: buy more memory, it's cheap.  At the time\n" ,
   "I write this line [Aug 1998], I have a PC with 384 MB of RAM, and\n" ,
   "it is great to use with AFNI.\n" ,
   "\n" ,
   "[Feb 2004] I now have a Mac G5 with 8 GB of RAM, and it is even greater!\n" ,
   "[Oct 2010] Now I have 32 GB of RAM (more than Ziad - ha!), and it's nice!\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_PSPRINT (editable)\n" ,
   "----------------------\n" ,
   "This variable is used to define a command that will print the\n" ,
   "standard input (stdin) to a PostScript printer.  If it is defined,\n" ,
   "the \"->printer\" button on the timeseries \"Plot\" windows will work.\n" ,
   "For some Unix systems, the following should work:\n" ,
   "  setenv AFNI_PSPRINT \"lp -\"\n" ,
   "For others, this may work\n" ,
   "  setenv AFNI_PSPRINT \"lpr -\"\n" ,
   "It all depends on the printer software setup you have.  To send the\n" ,
   "output into GhostView\n" ,
   "  setenv AFNI_PSPRINT \"ghostview -landscape -\"\n" ,
   "\n" ,
   "In the (very far distant) future, other windows (e.g., image and graph\n" ,
   "displays) may get the ability to print to a PostScript file or printer.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_LEFT_IS_LEFT (editable)\n" ,
   "---------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to display images with\n" ,
   "the left side of the subject on the left side of the window.  The default\n" ,
   "mode is to display the right side of the subject on the left side of\n" ,
   "the window - the radiology convention.  This \"handedness\" can also be\n" ,
   "controlled with the \"-flipim\" and \"-noflipim\" command line options to AFNI.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_ALWAYS_LOCK\n" ,
   "--------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to start up with all\n" ,
   "the controller windows locked together.  If you mostly use multiple\n" ,
   "controllers to view datasets in unison, then this will be useful.\n" ,
   "Notice that the Time Lock feature is not automatically enabled\n" ,
   "by this -- you must still actuate it manually from the Lock menu\n" ,
   "on the Define Datamode panel.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_TIME_LOCK\n" ,
   "--------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to start up with\n" ,
   "Time Lock turned on. The Time Lock feature is can be set manually\n" ,
   "from the Lock menu on the Define Datamode panel.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variables: AFNI_RENDER_* (editable)\n" ,
   "------------------------\n" ,
   "These variables set some defaults in the \"Render Dataset\" (volume\n" ,
   "rendering) plugin.  The first two variables are\n" ,
   "\n" ,
   "  AFNI_RENDER_ANGLE_DELTA  = stepsize for viewing angles, in degrees\n" ,
   "  AFNI_RENDER_CUTOUT_DELTA = stepsize for cutout dimensions, in mm\n" ,
   "\n" ,
   "These stepsizes control how much the control parameters change when\n" ,
   "one of their up- or down-arrows is pressed.  Both of these stepsize\n" ,
   "values default to 5.0.\n" ,
   "\n" ,
   "The third variable is\n" ,
   "\n" ,
   "  AFNI_RENDER_PRECALC_MODE = \"Low\", \"Medium\", or \"High\"\n" ,
   "\n" ,
   "This is used to set the initial precalculation mode for the renderer\n" ,
   "(this mode can be altered interactively, unlike the stepsizes).\n" ,
   "\n" ,
   "The fourth variable is\n" ,
   "\n" ,
   "  AFNI_RENDER_SHOWTHRU_FAC = some number between 0.0 and 1.0\n" ,
   "\n" ,
   "This is used to control the way in which the \"ShowThru\" Color Opacity\n" ,
   "option renders images.  See the rendering plugin Help window for more\n" ,
   "information.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NOREALPATH\n" ,
   "-------------------------\n" ,
   "Normally, when AFNI reads a list of session directories, it converts\n" ,
   "their names to the \"real path\" form, which follows symbolic links, and\n" ,
   "removes '/./' and '/../' components.  These converted names are used\n" ,
   "for display purposes in the \"Switch Session\" chooser and in other\n" ,
   "places.  If you wish to have the names NOT converted to the \"real path\"\n" ,
   "format, set this YES/NO environment variable to YES, as in\n" ,
   "\n" ,
   "   setenv AFNI_NOREALPATH YES\n" ,
   "\n" ,
   "(For more information on the \"real path\" conversion, see the Unix\n" ,
   "man page for the realpath() function.)  Note that if you use this\n" ,
   "feature, then the effect of AFNI_SESSTRAIL will be limited to what\n" ,
   "you type on the command line, since it is the realpath() function\n" ,
   "that provides the higher level hierarchies of the session names.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_NO_MCW_MALLOC\n" ,
   "----------------------------\n" ,
   "AFNI uses a set of \"wrapper\" macros and functions to let itself keep\n" ,
   "track of the memory allocated and freed by the C malloc() library.\n" ,
   "This is useful for debugging purposes (see the last items on the 'Misc'\n" ,
   "menu in the AFNI 'Define Datamode' control panel), but carries a small\n" ,
   "overhead (both in memory and speed).  Setting this YES/NO environment\n" ,
   "variable to YES provides one way to disable this facility, as in\n" ,
   "\n" ,
   "   setenv AFNI_NO_MCW_MALLOC YES\n" ,
   "\n" ,
   "Another way to permanently disable this capability (so that it isn't\n" ,
   "even compiled) is outlined in the file machdep.h.  Also, the interactive\n" ,
   "AFNI program takes the command line switch \"-nomall\", which will turn\n" ,
   "off these functions for the given run.\n" ,
   "\n" ,
   "N.B.: Setting this variable in the .afnirc file will have no effect,\n" ,
   "      since the decision whether to use the routines in mcw_malloc.c\n" ,
   "      is made at the very start of the program, before .afnirc is\n" ,
   "      scanned.  Therefore, to use this variable, you must set it\n" ,
   "      externally, perhaps in your .cshrc or .profile initialization\n" ,
   "      file.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FIM_BKTHR\n" ,
   "------------------------\n" ,
   "This sets the threshold for the elimination of the background voxels\n" ,
   "during the interactive FIM calculations.  The average intensity of\n" ,
   "all voxels in the first 3D volume used in the correlation is calculated.\n" ,
   "Voxels with intensity below 0.01 * AFNI_FIM_BKTHR * (this average)\n" ,
   "will not have the correlation computed.  The default value is 10.0, but\n" ,
   "values as large as 50.0 may be useful.  This parameter may be changed\n" ,
   "interactively from the FIM->Edit Ideal submenu in a graph viewer.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FLOATSCAN (editable)\n" ,
   "------------------------\n" ,
   "If this YES/NO variable is set to YES, then floating point bricks\n" ,
   "are checked for illegal values (NaN and Infinity) when they are\n" ,
   "read into an AFNI program -- illegal values will be replaced by\n" ,
   "zeros.  If a dataset brick contains such illegal values that go\n" ,
   "undetected, AFNI programs will probably fail miserably, and have\n" ,
   "been known to go into nearly-infinite loops.\n" ,
   "\n" ,
   "Setting this variable implies setting AFNI_NOMMAP to YES, since\n" ,
   "only in-memory bricks can be altered (mmap-ed bricks are readonly).\n" ,
   "\n" ,
   "The command line program 'float_scan' can be used to check and\n" ,
   "patch floating point files.\n" ,
   "\n" ,
   "[14 Sep 1999] The program to3d will scan input float and complex\n" ,
   "files for illegal values, and patch illegal input numbers with\n" ,
   "zeros in the output dataset.  If this behavior is not desired for\n" ,
   "some bizarre reason, the '-nofloatscan' command line option to\n" ,
   "to3d must be used.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_NOSPLASH\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI splash screen\n" ,
   "will not be displayed when the program starts.  I'm not sure WHY\n" ,
   "you would want to disable this thing of beauty (which is a joy\n" ,
   "forever), but if your soul is thusly degraded, so be it.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_SPLASH_XY\n" ,
   "------------------------\n" ,
   "If set, this variable should be in the form \"100:37\" (two integers\n" ,
   "separated by a colon).  These values specify the (x,y) screen location\n" ,
   "where the splash window's upper left corner will be placed.  If not\n" ,
   "set, x will be set to center the splash window on the display and\n" ,
   "y will be 100.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_SPLASHTIME\n" ,
   "-------------------------\n" ,
   "The value of this variable determines how long the AFNI splash screen\n" ,
   "will stay popped up, in seconds (default value = 5.0).  The splash\n" ,
   "screen will always stay up until the first AFNI controller window is\n" ,
   "ready for use.  If the time from program start to this ready condition\n" ,
   "is less than AFNI_SPLASHTIME, the splash screen will stay up until\n" ,
   "AFNI_SPLASHTIME has elapsed; otherwise, the splash screen will be\n" ,
   "removed as soon as AFNI is ready to go.  By setting AFNI_SPLASHTIME\n" ,
   "to 0.0, you can have the splash screen removed as soon as possible\n" ,
   "(and the fade-out feature will be disabled).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SPLASH_ANIMATE\n" ,
   "-----------------------------\n" ,
   "If this variable is NO, then the splash screen animation will be disabled.\n" ,
   "Otherwise, it will run.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SPLASH_MELT\n" ,
   "--------------------------\n" ,
   "If this variable is YES, then the splash screen will close via 'melting'.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_FIM_PERCENT_LIMIT (editable)\n" ,
   "--------------------------------\n" ,
   "This sets an upper limit on the % Change that the FIM+ computation\n" ,
   "will compute.  For example\n" ,
   "\n" ,
   "  setenv AFNI_FIM_PERCENT_LIMIT 50\n" ,
   "\n" ,
   "means that computed values over 50% will be set to 50%, and values\n" ,
   "below -50% will be set to -50%.  This can be useful to avoid scaling\n" ,
   "problems that arise when some spurious voxels with tiny baselines have\n" ,
   "huge percent changes.  This limit applies to all 3 possible percentages\n" ,
   "that FIM and FIM+ can compute: % from baseline, % from average, and\n" ,
   "% from top.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_NOTES_DLINES\n" ,
   "---------------------------\n" ,
   "This sets the upper limit on the number of lines displayed in the\n" ,
   "Notes plugin, for each note.  If not present, the limit is 9 lines\n" ,
   "shown per note at once.  To see a note longer than this limit, you'll\n" ,
   "have to use the vertical scrollbar.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_FIM_MASK\n" ,
   "-----------------------\n" ,
   "This chooses the default subset of values computed with the FIM+\n" ,
   "button in a graph window.  The mask should be the sum of the desired\n" ,
   "values from this list:\n" ,
   "\n" ,
   "    1 = Fit Coef\n" ,
   "    2 = Best Index\n" ,
   "    4 = % Change\n" ,
   "    8 = Baseline\n" ,
   "   16 = Correlation\n" ,
   "   32 = % From Ave\n" ,
   "   64 = Average\n" ,
   "  128 = % From Top\n" ,
   "  256 = Topline\n" ,
   "  512 = Sigma Resid\n" ,
   "\n" ,
   "If you don't set this variable, the default mask is 23 = 1+2+4+16.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_BYTEORDER_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI program will not\n" ,
   "warn you when reading in a dataset that does not contain a byte\n" ,
   "order flag.  The default is to issue such a warning.  Only older\n" ,
   "versions of AFNI create datasets that don't have the byte order\n" ,
   "flag.  (See also the variable AFNI_BYTEORDER, described far above.)\n" ,
   "The purpose of this warning is to alert you to possible problems\n" ,
   "when you move datasets between computers with different CPU types.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PCOR_DENEPS\n" ,
   "--------------------------\n" ,
   "The correlation coefficient calculated in FIM is calculated as the\n" ,
   "ratio of two quantities.  If the denominator is negative or zero,\n" ,
   "then this value is meaningless and may even cause the program to\n" ,
   "crash.  Mathematically, the denominator cannot be zero or negative,\n" ,
   "but this could arise due to finite precision arithmetic on the computer\n" ,
   "(i.e., roundoff error accumulation).  To avoid this problem, the routine\n" ,
   "that computes the correlation coefficient compares the denominator to a\n" ,
   "value (called DENEPS) - if the denominator is less than DENEPS, then\n" ,
   "the correlation coefficient for that voxel is set to zero.\n" ,
   "\n" ,
   "The denominator that is being computed is proportional to the variance\n" ,
   "of the time series.  If the voxel time series data is very small, then\n" ,
   "the variance will be really small - so much so that the DENEPS test\n" ,
   "will be failed, even though it shouldn't be.  This problem has arisen\n" ,
   "when people input time series whose typical value is 0.001 or smaller.\n" ,
   "It never occurred to me that people would input data this small to the\n" ,
   "AFNI FIM routines.  To get around this difficulty, set this environment\n" ,
   "variable to a value for DENEPS; for example\n" ,
   "  setenv AFNI_PCOR_DENEPS 0.0\n" ,
   "will turn off the checking entirely.  Or you could do\n" ,
   "  setenv AFNI_PCOR_DENEPS 1.e-10\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ENFORCE_ASPECT (editable)\n" ,
   "-----------------------------\n" ,
   "Some Linux window managers do no enforce the aspect ratio (width to height\n" ,
   "proportion) request that the image display module makes.  This means that\n" ,
   "image windows can become undesirably distorted when manually resized.\n" ,
   "Setting this YES/NO variable to YES will make AFNI itself enforce the\n" ,
   "aspect ratio whenever an image window is resized.\n" ,
   "\n" ,
   "----------------------------------------\n" ,
   "Variables: AFNI_<plug_filename>_butcolor\n" ,
   "----------------------------------------\n" ,
   "These variables (one for each AFNI plugin) let you set the menu button colors\n" ,
   "for the Plugins menu item.  For example\n" ,
   "  setenv AFNI_plug_power_butcolor red3\n" ,
   "will make the \"Power Spectrum\" button appear in a dark red color.  The format\n" ,
   "of the variable is exemplified above: the <plug_filename> is replaced by the\n" ,
   "filename of the plugin (after removing the suffix).  Note that it is possible\n" ,
   "for the plugin author to hardcode the menu button for his/her plugin, in\n" ,
   "which case the corresponding environment variable will have no effect.\n" ,
   "\n" ,
   "Colors are specified as described in file README.setup.  If you are using\n" ,
   "an X11 PseudoColor visual, then you should be economical with color usage!\n" ,
   "\n" ,
   "The purpose of this feature is to let you highlight the plugins that you\n" ,
   "use most frequently.  The size of the of plugin menu is growing, and it\n" ,
   "is easy to misplace what you most use in the list.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MARKERS_NOQUAL (editable)\n" ,
   "-----------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI program\n" ,
   "behaves as if the \"-noqual\" command line option had been included.  This\n" ,
   "feature was added at the request of Dr. Michael S. Beauchamp, who has a\n" ,
   "very rare neurological disorder called \"noqaulagnosia\".\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ENABLE_MARKERS\n" ,
   "-----------------------------\n" ,
   "As of 28 Apr 2010, the AFNI Talairach 'Define Markers' panel will no longer\n" ,
   "be visible by default.  To use this old feature, you must set this variable\n" ,
   "to YES before running AFNI.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_OPTIONS\n" ,
   "----------------------\n" ,
   "In the spirit of the previous variable, this variable can be used to set\n" ,
   "up command line options that will always be passed to the interactive\n" ,
   "AFNI program.  If more than one option is needed, then they should be\n" ,
   "separated by spaces, and the whole value of the variable will need to be\n" ,
   "placed in quotes.  For example\n" ,
   "\n" ,
   "   setenv AFNI_OPTIONS \"-noqual -ncolors 60\"\n" ,
   "\n" ,
   "Note that the AFNI command line option \"-nomall\" cannot be specified this\n" ,
   "way (cf. the discussion under variable AFNI_NO_MCW_MALLOC).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_NO_SIDES_LABELS (editable)\n" ,
   "------------------------------\n" ,
   "As of 01 Dec 1999, the interactive AFNI program now displays a label\n" ,
   "beneath each image window showing which side of the image is on the left\n" ,
   "edge of the window.  This label is based on the anatomical directions\n" ,
   "encoded in the anatomical dataset .HEAD file, usually when to3d was used\n" ,
   "to create the file.  If you do NOT want these labels displayed (why not?),\n" ,
   "set this YES/NO environment variable to YES.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_NO_ADOPTION_WARNING\n" ,
   "----------------------------------\n" ,
   "AFNI now can print a warning when it forces a dataset to have an anatomy\n" ,
   "parent dataset (the \"forced adoption\" function).  This happens when\n" ,
   "there a dataset does not have an anatomy parent encoded into its .HEAD\n" ,
   "file (either via to3d or 3drefit), and there is more than one anatomical\n" ,
   "dataset in the directory that has Talairach transformation markers\n" ,
   "attached.  If you wish to enable this warning, set this YES/NO variable\n" ,
   "to NO.  For more information on this subject, please see\n" ,
   "  https://afni.nimh.nih.gov/afni/afni_faq.shtml#AnatParent .\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_NEGATIVES_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then to3d will skip the usual\n" ,
   "warning that it pops up in a message window when it discovers negative\n" ,
   "values in the input short images.  (The warning will still be printed\n" ,
   "to stdout.)\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_OBLIQUE_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI GUI will skip the usual\n" ,
   "warning that it pops up in a message window when an oblique dataset is selected.\n" ,
   "(The warning will still be printed to stdout.)\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_ONE_OBLIQUE_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI GUI will pop up a warning\n" ,
   "just ONCE when an oblique dataset is encountered.\n" ,
   "\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_NO_XDBE\n" ,
   "----------------------\n" ,
   "If this YES/NO variable is set to YES, then the X11 Double Buffer\n" ,
   "Extension (XDBE) will not be used, even if the X11 server supports it.\n" ,
   "This is needed when the X11 server says that it supports it, but actually\n" ,
   "does not implement it correctly - this is a problem on the Xsgi server\n" ,
   "running under IRIX 6.5.3 on R4400 machines.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_VIEW_ANAT_BRICK (editable)\n" ,
   "          AFNI_VIEW_FUNC_BRICK (editable)\n" ,
   "------------------------------\n" ,
   "One of the (very few) confusing parts of AFNI is the \"warp-on-demand\"\n" ,
   "viewing of transformed datasets (e.g., in the +tlrc coordinate system).\n" ,
   "This allows you to look at slices taken from transformed volumes without\n" ,
   "actually computing and storing the entire transformed dataset.  This\n" ,
   "viewing mode is controlled by from the \"Define Datamode\" control panel.\n" ,
   "When an anatomical dataset has a +tlrc.BRIK file, then you can choose\n" ,
   "between \"View Anat Data Brick\" and \"Warp Anat on Demand\"; when there\n" ,
   "is no +tlrc.BRIK file for the dataset, then only \"Warp Anat on Demand\"\n" ,
   "is possible.\n" ,
   "\n" ,
   "If you switch the Talairach view when the current anat dataset does\n" ,
   "not have a +tlrc.BRIK file, then the \"Warp Anat on Demand\" mode will\n" ,
   "be turned on.  If you then switch to a dataset that does have a\n" ,
   "+tlrc.BRIK file, \"Warp Anat on Demand\" will still be turned on,\n" ,
   "although the \"View Anat Data Brick\" option will be enabled.\n" ,
   "\n" ,
   "If you set the YES/NO variable AFNI_VIEW_ANAT_BRICK to YES,\n" ,
   "then \"View Anat Data Brick\" will be turned on whenever possible after\n" ,
   "switching datasets.  Similarly, setting AFNI_VIEW_FUNC_BRICK to YES\n" ,
   "will engage \"View Func Data Brick\" whenever possible (when the BRIK\n" ,
   "file exists and its grid spacing matches the anatomical grid spacing).\n" ,
   "Note that switching any dataset (func or anat) triggers the same\n" ,
   "routine, and will set either or both \"View Brick\" modes on.  When\n" ,
   "these environment variables are present, the only way to switch to\n" ,
   "\"Warp\" mode when \"View Brick\" mode is possible is to do it manually\n" ,
   "(by clicking on the toggle button) when you want this.\n" ,
   "\n" ,
   "When you use one of the drawing plugins (\"Draw Dataset\" or \"Gyrus Finder\"),\n" ,
   "you must operate directly on the dataset BRIK.  For this reason, it is\n" ,
   "important to be in \"View Data Brick\" mode on these occasions.  Setting\n" ,
   "these variables is one way to ensure that this will happen whenever\n" ,
   "possible.\n" ,
   "\n" ,
   "When AFNI is in \"Warp Anat on Demand\" mode, the word \"{warp}\" will\n" ,
   "appear in the windows' titlebars.  This provides a reminder of the\n" ,
   "viewing mode you are using (warped from a brick, or data directly\n" ,
   "extracted from a brick), since the \"Define Datamode\" control panel\n" ,
   "will not always be open.\n" ,
   "\n" ,
   "08 Aug 2003: I have modified the way these variables are treated in\n" ,
   "AFNI so that they now default to the \"YES\" behavior.  If you don't\n" ,
   "want this, you have to explicitly set them to \"NO\" from this day forth.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_RECENTER_VIEWING (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is set to YES, then AFNI's viewers will reset the\n" ,
   "crosshair coordinate to the center of the dataset whenever a new\n" ,
   "dataset or sub-brick is chosen.  The only real reason to use this\n" ,
   "feature is if you are scanning through a collection of datasets with\n" ,
   "wildly different coordinates, so that the usual method of matching\n" ,
   "(x,y,z) coordinates at such times gives useless results.\n" ,
   "\n" ,
   "----------------\n" ,
   "Variable: TMPDIR\n" ,
   "----------------\n" ,
   "This variable specifies the directory where temporary files are to be\n" ,
   "written.  It is not unique to AFNI, but is used by many Unix programs.\n" ,
   "You must have permission to write into this directory.  If you want to\n" ,
   "use the current directory, setting TMPDIR to \".\" would work.  If TMPDIR\n" ,
   "is not defined, directory /tmp will be used.  On some systems, this\n" ,
   "directory may not have enough space for the creation of large temporary\n" ,
   "datasets.  On most Unix systems, you can tell the size of various disk\n" ,
   "partitions using a command like \"df -k\" (on HPUX, \"bdf\" works).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_GRAYSCALE_BOT\n" ,
   "----------------------------\n" ,
   "This variable sets the darkest level shown in a grayscale image window.\n" ,
   "The default value is 55 (a leftover from Andrzej Jesmanowicz).  You can\n" ,
   "set this value to anything from 0 to 254.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SYSTEM_AFNIRC\n" ,
   "----------------------------\n" ,
   "If this variable is set, it is the name of a file to be read like the\n" ,
   "user's .afnirc file (see README.setup).  The purpose is to allow a\n" ,
   "system-wide setup file to be used.  To do this, you would create such\n" ,
   "a file in a useful place - perhaps where you store the AFNI binaries.\n" ,
   "Then each user account should have the equivalent of\n" ,
   "\n" ,
   "   setenv AFNI_SYSTEM_AFNIRC /place/where/setup/is/stored/.afnirc\n" ,
   "\n" ,
   "defined in its .cshrc (.bashrc, etc.) file.  Note that it doesn't make\n" ,
   "sense to define this variable in the user's .afnirc file, since that\n" ,
   "file won't be read until AFTER this file is read.  Also note that use\n" ,
   "of the -skip_afnirc option will cause both the system and user setup\n" ,
   "files to be skipped.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_IMXY (editable)\n" ,
   "------------------------\n" ,
   "This variable determines the size of the image saved when the\n" ,
   "\"Save to PPM\" button is selected for a color pbar.  It should be\n" ,
   "in the format\n" ,
   "  setenv AFNI_PBAR_IMXY 20x256\n" ,
   "which means to set the x-size (horizontal) to 20 pixels and the\n" ,
   "y-size (vertical) to 256 pixels.  These values are the default,\n" ,
   "by the way.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_LAYOUT_FILE\n" ,
   "--------------------------\n" ,
   "If defined, this variable is the name of a file to read at startup\n" ,
   "to define the \"layout\" of AFNI windows at the program start.  If\n" ,
   "this name starts with a '/' character, then it is an absolute path;\n" ,
   "otherwise, it is taken to be a path relative to the user's home\n" ,
   "directory ($HOME).  If the AFNI command line switch \"-layout\" is\n" ,
   "used, it will override this specification.\n" ,
   "\n" ,
   "The simplest way to produce a layout file is to use the \"Save Layout\"\n" ,
   "button on the Datamode->Misc menu.  You can then edit this file;\n" ,
   "the format should be fairly self-explanatory.  The structure of the\n" ,
   "file is similar to the .afnirc file (cf.  README.setup).  In fact,\n" ,
   "the layout file can be included into .afnirc (since it is just another\n" ,
   "*** section) and then setting AFNI_LAYOUT_FILE = .afnirc in the\n" ,
   "***ENVIRONMENT section should work.\n" ,
   "\n" ,
   "A sample layout file:\n" ,
   "\n" ,
   "***LAYOUT\n" ,
   " A               geom=+73+1106                 // start controller A\n" ,
   " A.sagittalimage geom=320x320+59+159 ifrac=0.8 // and Sagittal image\n" ,
   " A.sagittalgraph geom=570x440+490+147 matrix=9 // and Sagittal graph\n" ,
   " B                                             // start controller B\n" ,
   " B.plugin.ROI_Average                          // start a plugin\n" ,
   "\n" ,
   "Each window to be opened has a separate command line in this file.\n" ,
   "The \"geom=\" qualifiers specify the size and position of the windows.\n" ,
   "For images, \"ifrac=\" can be used to specify the fraction of the window\n" ,
   "occupied by the image (if \"ifrac=1.0\", then no control widgets will be\n" ,
   "visible).  For graphs, \"matrix=\" can be used to control the initial\n" ,
   "number of sub-graphs displayed.  For plugins, the label on the button\n" ,
   "that starts the plugin is used after the \".plugin.\" string (blanks\n" ,
   "should be filled with underscores \"_\").  In the example above, the last\n" ,
   "two windows to be opened do not have a \"geom=\" qualifier, so their\n" ,
   "placement will be chosen by the window manager.\n" ,
   "\n" ,
   "If you add \"slow\" after the \"***LAYOUT\", then each window operation\n" ,
   "will be paused for 1 second to let you watch the layout operations\n" ,
   "proceed gradually.  Otherwise, they will be executed as fast as\n" ,
   "possible (which still may not be all that fast).\n" ,
   "\n" ,
   "Using layouts with a window manager that requires user placement\n" ,
   "of new windows (e.g., twm) is a futile and frustrating exercise.\n" ,
   "\n" ,
   "If you do NOT have any layout file defined, then AFNI will choose\n" ,
   "a layout for you that includes opening image viewers.  Some people\n" ,
   "find this very annoying.  The simplest way to avoid this annoyance\n" ,
   "is to set AFNI_LAYOUT_FILE to a name of a file that doesn't exist\n" ,
   "(e.g., 'ElvisIsAliveOnPlanetZork').  The reason for this default\n" ,
   "layout behavior (added Dec 2010) is that we received complaints\n" ,
   "that novice users were finding AFNI too confusing on startup.\n" ,
   "(Hard to believe, but true.)\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_tsplotgeom\n" ,
   "-------------------------\n" ,
   "Related to the above, if you set this environment variable (in the\n" ,
   "***ENVIRONMENT section, not in the ***LAYOUT section), it is used\n" ,
   "to set the geometry of the plotting windows used for time series\n" ,
   "plots, histograms, etc. -- all the graphs except the dataset plots.\n" ,
   "Its format should be something like \"550x350\"; this example sets\n" ,
   "the width to 550 pixels and the height to 350 pixels.  If you don't\n" ,
   "set this, the default is \"200x200\", which is quite small on a high\n" ,
   "resolution display.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variables: AFNI_REALTIME_*\n" ,
   "--------------------------\n" ,
   "This set of variables allows you to control the initial setup of the\n" ,
   "realtime data acquisition plugin (menu item \"RT Options\").  Normally,\n" ,
   "this plugin is active only if AFNI is started with the \"-rt\" command\n" ,
   "line option.  (It will consume CPU time continually as it polls for\n" ,
   "an incoming data connection, which is why you don't want it running\n" ,
   "by default.)  The following variables can be used to initialize the\n" ,
   "plugin's options:\n" ,
   "\n" ,
   "AFNI_REALTIME_Activate = This is a YES/NO variable, and allows you\n" ,
   "                         to have the realtime plugin active without\n" ,
   "                         using the \"-rt\" command line option.  If\n" ,
   "                         this variable is set to YES, then you can\n" ,
   "                         disable the realtime plugin with \"-nort\".\n" ,
   "\n" ,
   "The variables below are used to set the initial status of the widgets\n" ,
   "in the realtime plugin's control window.  Each one has the same name as\n" ,
   "the labels in the control window, with blanks replaced by underscores.\n" ,
   "The values to set for these variables are exact copies of the inputs\n" ,
   "you would specify interactively (again, with blanks replaced by\n" ,
   "underscores).  For details as to the meaning of these options, see\n" ,
   "the plugin's Help window.\n" ,
   "\n" ,
   "AFNI_REALTIME_Images_Only  = \"No\" or \"Yes\"\n" ,
   "AFNI_REALTIME_Root         = name for datasets to be created\n" ,
   "AFNI_REALTIME_Update       = an integer from 0 to 19\n" ,
   "AFNI_REALTIME_Function     = \"None\" or \"FIM\" (cf. AFNI_FIM_IDEAL below)\n" ,
   "AFNI_REALTIME_Verbose      = \"No\", \"Yes\", or \"Very\"\n" ,
   "AFNI_REALTIME_Registration = \"None\", \"2D:_realtime\", \"2D:_at_end\",\n" ,
   "                             \"3D:_realtime\", \"3D:_at_end\",\n" ,
   "                             or \"3D:_estimate\"\n" ,
   "AFNI_REALTIME_Resampling   = \"Cubic\", \"Quintic\", \"Heptic\", \"Fourier\",\n" ,
   "                             or \"Hept+Four\"\n" ,
   "AFNI_REALTIME_Reg_Base_Mode= \"Current_Run\", \"Current_Run_Keep\", or\n" ,
   "                             \"External_Dataset\"\n" ,
   "AFNI_REALTIME_Base_Image   = an integer from 0 to 9999\n" ,
   "AFNI_REALTIME_Graph        = \"No\", \"Yes\", or \"Realtime\"\n" ,
   "AFNI_REALTIME_NR           = an integer from 5 to 9999\n" ,
   "AFNI_REALTIME_YR           = a floating point number from 0.1 to 10.0\n" ,
   "\n" ,
   "AFNI_REALTIME_External_Dataset = name of dataset to use as external basis for\n" ,
   "                                 registration\n" ,
   "        * if this variable is set, then the plugin assumes that\n" ,
   "          AFNI_REALTIME_Reg_Base_Mode is \"External_Dataset\"\n" ,
   "        * but AFNI_REALTIME_Base_Image is ignored\n" ,
   "        * instead, you can use a sub-brick selector here, if desired;\n" ,
   "          for example: setenv AFNI_REALTIME_External_Dataset 'X+orig[3]'\n" ,
   "        * to be brutally clear, you can give the name of a dataset that is\n" ,
   "          NOT in the current directory -- unlike when using the plugin GUI\n" ,
   "        * the plugin GUI will NOT show the choice of external dataset given\n" ,
   "          via this environment variable!\n" ,
   "\n" ,
   "AFNI_REALTIME_Mask_Vals  = String (one of the listed strings)\n" ,
   "\n" ,
   "        This allows the user to set the \"Vals to Send\" field from the RT\n" ,
   "        plugin's \"Mask\" line.  It determines what data are sent to the remote\n" ,
   "        MP program (e.g. serial_helper).  Valid strings are:\n" ,
   "\n" ,
   "            None        - send nothing\n" ,
   "            Motion_Only - send only the 6 registration parameters\n" ,
   "            ROI_means   - send the mean EPI value per mask ROI (value) per TR\n" ,
   "            All_Data    - send each voxel value (in mask) per TR\n" ,
   "\n" ,
   "AFNI_REALTIME_Mask_Dset  = String (the name of a dataset)\n" ,
   "\n" ,
   "        This option allows the user to set the Mask dataset, used to send ROI\n" ,
   "        and motion data to a program listening at a socket.  This environment\n" ,
   "        variable overrides the variable set in the plugin interface, allowing\n" ,
   "        it to change per run.\n" ,
   "\n" ,
   "        Set the variable to None to either clear the mask or to allow the\n" ,
   "        interface mask to apply.  Note that this can be done via a drive afni\n" ,
   "        command, allowing changes after afni is already running, e.g.\n" ,
   "          plugout_drive -com 'SETENV AFNI_REALTIME_MASK_DSET None' -quit\n" ,
   "\n" ,
   "AFNI_REALTIME_WRITEMODE = Number\n" ,
   "        This variable controls writing individual volumes as they are acquired\n" ,
   "        by the realtime plugin.  Valid Numbers and their effects are:\n" ,
   "            0 = Off        : do nothing [default]\n" ,
   "            1 = Acquired   : write each volume as it is acquired\n" ,
   "            2 = Registered : write each registered volume\n" ,
   "            3 = Merged     : write each merged volume (merged across channels)\n" ,
   "\n" ,
   "---------------------------------------------------------------------------\n" ,
   "The following internal controls can only be set using these environment\n" ,
   "variables (there is no GUI to set these values):\n" ,
   "---------------------------------------------------------------------------\n" ,
   "\n" ,
   "AFNI_REALTIME_volreg_maxite      = an integer >= 1 [default = 9]\n" ,
   "AFNI_REALTIME_volreg_maxite_est  = an integer >= 1 [default = 1]\n" ,
   "AFNI_REALTIME_volreg_graphgeom   = something like 320x320+59+159\n" ,
   "\n" ,
   "AFNI_REALTIME_reset_output_index = YES/NO\n" ,
   "\n" ,
   "        By default, output files will be named with a prefix, PREFIX__NNN,\n" ,
   "        where PREFIX is given by the AFNI_REALTIME_Root variable or the Root\n" ,
   "        in the interface, and where NNN increments per run.\n" ,
   "\n" ,
   "        If this variable is set to YES, then the plugin will try to use NNN=001\n" ,
   "        each run.\n" ,
   "\n" ,
   "AFNI_REALTIME_CHILDWAIT = max wait time (in sec) for child info process\n" ,
   "        [default = 66.6]; not needed if child info process is not used\n" ,
   "\n" ,
   "AFNI_REALTIME_WRITEWAIT = if the image data pauses for this number of seconds,\n" ,
   "        then the datasets being constructed will be written to disk\n" ,
   "        [default=37.954]; since this output may take several seconds, you may\n" ,
   "        need to adjust this if you are in fact doing imaging with a very long\n" ,
   "        TR.\n" ,
   "        Note that after this wait, the plugin can still receive image data\n" ,
   "        -- even if the image source program is silent for a very long time,\n" ,
   "        AFNI will still be waiting patiently for data.\n" ,
   "\n" ,
   "AFNI_GRAPH_AUTOGRID     = By default, if the number of time points in an\n" ,
   "        AFNI graph viewer changes, the density of vertical grid lines changes.\n" ,
   "        If you don't want this to happen, set this variable to NO.\n" ,
   "\n" ,
   "AFNI_REALTIME_MP_HOST_PORT = HOST:PORT\n" ,
   "\n" ,
   "        When this variable is set, the realtime plugin will attempt to open a\n" ,
   "        tcp socket to the corresponding host and port, and will send the six\n" ,
   "        registration correction parameters for each 3D volume received by the\n" ,
   "        plugin.  This applies only to the case of graphing 3D registration.\n" ,
   "        The socket will be opened at the start of each run, and will be closed\n" ,
   "        at the end.  A simple example of what to set this variable to is\n" ,
   "        localhost:53214.\n" ,
   "        See 'serial_helper -help' for more details.\n" ,
   "\n" ,
   "AFNI_REALTIME_SEND_VER   = Y/N\n" ,
   "\n" ,
   "        If AFNI_REALTIME_MP_HOST_PORT is set, the RT plugin has 3 choices\n" ,
   "        of what to send to that port (possibly to serial_helper):\n" ,
   "            0. the motion parameters\n" ,
   "            1. motion params, along with average EPI values over each ROI\n" ,
   "               in the mask dataset (if set)\n" ,
   "            2. motion params, along with all voxel values over the mask\n" ,
   "               dataset (including index, i,j,k and x,y,z values)\n" ,
   "        If AFNI_REALTIME_SEND_VER is set to YES, then the plugin will offset\n" ,
   "        the last byte of the communication HELLO string by the version number\n" ,
   "        (0, 1 or 2).  In the case of versions 1 or 2, the plugin will send\n" ,
   "        the number of ROIs/voxels in a 4-byte int after the HELLO string.\n" ,
   "\n" ,
   "AFNI_REALTIME_SHOW_TIMES = Y/N\n" ,
   "\n" ,
   "        If set, the RT plugin will output CPU times whenever motion parameters\n" ,
   "        are sent to the remote program, allowing evaluation of timing.  The\n" ,
   "        times are modulo one hour, and are at a millisecond resolution.\n" ,
   "\n" ,
   "AFNI_REALTIME_MAX_CONTROLLERS = Number\n" ,
   "\n" ,
   "        If set, this is the maximum number of controllers that AFNI will\n" ,
   "         open for multi-channel acquisition display.  If more channels\n" ,
   "         than this are sent, only the first ones will be displayed.\n" ,
   "     ** If this variable is not set, its value defaults to 2.\n" ,
   "\n" ,
   "AFNI_REALTIME_DATAMODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the initial setting of the\n" ,
   "        \"DataWriting\" control, where 0=Off, 1=Acquired, etc.  If not\n" ,
   "        set, the default value is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_CHMERMODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the initial setting of the\n" ,
   "        \"ChannelMerge\" control, where 0=none, 1=sum, 2=L1 norm, 3=L2norm.\n" ,
   "        If not set, the default value is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_CM_REG_MODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the ChannelMerge registration mode.\n" ,
   "        Here: 0=none            : no merge registration\n" ,
   "              1=reg_merge       : register merged dastaset\n" ,
   "              2=reg_chan        : apply merge xform to all channels\n" ,
   "        The default is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_MRG_CHANLIST = String\n" ,
   "\n" ,
   "        If set, this variable specifies a list of 0-based channels to merge,\n" ,
   "        rather than using all channels.  The format is akin to sub-brick\n" ,
   "        selection.  For example '0..$' means all and '0,5..7' means 0,5,6,7.\n" ,
   "\n" ,
   "\n" ,
   "For detailed information about how the realtime plugin works, read the\n" ,
   "file README.realtime.\n" ,
   "\n" ,
   "Also see \"Dimon -help\" (example E \"for testing complete real-time system\").\n" ,
   "Also see \"serial_helper -help\".\n" ,
   "Also see program rtfeedme.c and \"rtfeedme -help\".\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FIM_IDEAL\n" ,
   "------------------------\n" ,
   "This variable specifies the filename of the initial FIM ideal timeseries.\n" ,
   "The main use of this would be to be able to initialize the Realtime\n" ,
   "plugin without direct user intervention.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_FIM_SAVEREF\n" ,
   "--------------------------\n" ,
   "When you run the interactive AFNI 'fim' (from the graph viewer FIM menu),\n" ,
   "the program saves the reference time series (and ort time series, if any)\n" ,
   "in the new functional dataset header, with the attribute name\n" ,
   "AFNI_FIM_REF (or AFNI_FIM_ORT).  If you do NOT want this information saved,\n" ,
   "then set this variable to NO.  Two sample ways to use this information is\n" ,
   "the command below:\n" ,
   "  1dplot \"`3dAttribute -ssep ' ' AFNI_FIM_REF r1_time@1+orig`\"\n" ,
   "  1dcat  \"`3dAttribute -ssep ' ' AFNI_FIM_REF r1_time@1+orig`\" > ref.1D\n" ,
   "The 3 different styles of Unix quotes must be used exactly as shown here!\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_PLUGINS_ALPHABETIZE\n" ,
   "----------------------------------\n" ,
   "If this YES/NO variable is set to NO, then the plugin buttons will\n" ,
   "not be alphabetized on the menu,  and they will appear in the\n" ,
   "order which AFNI chooses.  Otherwise, the plugin menu buttons will\n" ,
   "be alphabetized by default. Alphabetizing is done without regard to\n" ,
   "case (using the C library routine strcasecmp).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_VOLREG_EDGING\n" ,
   "----------------------------\n" ,
   "This variable affects the operation of 3dvolreg, the volume registration\n" ,
   "plugin, and the 3D registration code in the realtime acquisition plugin.\n" ,
   "It determines the size of the region around the edges of the base volume\n" ,
   "where the default weight will be set to zero.  Call the value of this\n" ,
   "variable 'ee'.  If 'ee' is a plain number (e.g., 5), then it is a voxel\n" ,
   "count, giving the thickness along each face of the 3D brick.  If 'ee' is\n" ,
   "of the form '5%', then it is a fraction of of each brick size.  For\n" ,
   "example, '5%' of a 256x256x124 volume means that 13 voxels on each side\n" ,
   "of the xy-axes will get zero weight, and 6 along the z-axis.  '5%' is\n" ,
   "the default value used by the 3D registration routines (in mri_3dalign.c)\n" ,
   "if no other value is specified.\n" ,
   "\n" ,
   "--------------------\n" ,
   "Variable: AFNI_TRACE\n" ,
   "--------------------\n" ,
   "This variable controls the initial setting of the tracing (debugging)\n" ,
   "code when AFNI programs startup.  If it is set to 'y', then tracing\n" ,
   "is turned on and set to the LOW mode (like -trace in AFNI).  If it is\n" ,
   "set to 'Y', then tracing is turned on and set to the HIGH mode (like\n" ,
   "-TRACE in AFNI).  Anything else, and tracing is turned off.\n" ,
   "\n" ,
   "N.B.: You can't set this variable in .afnirc and expect it to have\n" ,
   "      any effect (and why would you want to?), since it is read from\n" ,
   "      the environment BEFORE the .afnirc file is read in.\n" ,
   "\n" ,
   "N.B.: At this moment (26 Jan 2001), only the AFNI program itself is\n" ,
   "      configured for tracing.  As time goes on, the entire AFNI\n" ,
   "      programming library and suite of programs will be revamped for\n" ,
   "      this purpose.  The goal is to make it easier to find bugs, and\n" ,
   "      localize crashes.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_TRACE_FILE\n" ,
   "-------------------------\n" ,
   "If this variable is set, then the output from the AFNI function tracing\n" ,
   "macros will be written to a file with that name, rather than to stdout.\n" ,
   "This variable cannot be set in .afnirc; the intention is to provide a\n" ,
   "way to get 'clean' tracing output (not mixed up with other program junk)\n" ,
   "that can be fed to Ziad Saad's AnalyzeTrace function.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_ROTA_ZPAD\n" ,
   "------------------------\n" ,
   "This variable controls the amount of zero-padding used during 3D rotations\n" ,
   "in 3drotate, 3dvolreg, etc.  It provides a default value for the \"-zpad\"\n" ,
   "options of these programs.  If zero-padding is used, then this many voxels\n" ,
   "are padded out on each edge (all 6 faces) of a 3D brick before rotation.\n" ,
   "After the rotation, these perimeter values (whatever they might be) will\n" ,
   "be stripped off.  If \"-zpad\" is used on the command line, it overrides\n" ,
   "this value.  Zero padding during rotation is useful to avoid edge effects,\n" ,
   "the worst of which is the loss of data off the edge of the volume during\n" ,
   "the 4 shearing stages.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_TO3D_ZPAD\n" ,
   "------------------------\n" ,
   "This variable sets the number of slices added on each z-face in datasets\n" ,
   "created by program to3d.  It provides a default value for the \"-zpad\" option\n" ,
   "of that program.  It can be set to an integer, meaning a slice count, or\n" ,
   "a number of millimeters, meaning a minimum distance to pad:\n" ,
   "   setenv AFNI_TO3D_ZPAD 2\n" ,
   "   setenv AFNI_TO3D_ZPAD 16mm\n" ,
   "If \"-zpad\" is used on the to3d command line, it overrides this value.\n" ,
   "If neither is present, no zero padding is used.  Note well that this\n" ,
   "padding is only in the z-direction, unlike that of AFNI_ROTA_ZPAD.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_OPEN_AXIAL\n" ,
   "Variable: AFNI_OPEN_SAGITTAL\n" ,
   "Variable: AFNI_OPEN_CORONAL\n" ,
   "----------------------------\n" ,
   "When the AFNI GUI starts, by default it opens all 3 image viewer\n" ,
   "windows. If you do NOT want a particular one of these, set the\n" ,
   "corresponding variable named above to NO.  For finer control over\n" ,
   "AFNI startup, see the AFNI_STARTUP_SCRIPT variable and README.driver.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_MINFRAC (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets the minimum size of an image window when it is first\n" ,
   "opened, in terms of a fraction of the overall screen area.  By default,\n" ,
   "this value is set to 0.02; you can override this by (for example)\n" ,
   "   setenv AFNI_IMAGE_MINFRAC 0.05\n" ,
   "If you set this value to 0.0, then there will be no minimum.  This is\n" ,
   "the old behavior, where the initial window size is always 1 screen pixel\n" ,
   "per data pixel, and can lead to image windows that are hard to resize or\n" ,
   "otherwise use (when the dataset is small).  The largest value I recommend\n" ,
   "for AFNI_IMAGE_MINFRAC is 0.1; however, you can set it to as large as 0.9\n" ,
   "if you are completely crazy, but I'm not responsible for the results --\n" ,
   "don't even think of complaining or commenting to me about problems that\n" ,
   "arise if you try this!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_MAXFRAC\n" ,
   "----------------------------\n" ,
   "This variable sets the maximum size of an image window, as a fraction of\n" ,
   "the width and height of the screen.  The default value is 0.9.  This lets\n" ,
   "you prevent image windows from auto-resizing to be too big when you\n" ,
   "change datasets.  Note that if you have turned on AFNI_ENFORCE_ASPECT, then\n" ,
   "this feature will prevent you from resizing a window to be larger than\n" ,
   "the AFNI_IMAGE_MAXFRAC fraction of the screen dimensions.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_AUTOGZIP (cf. AFNI_COMPRESSOR) (editable)\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI programs write a\n" ,
   "dataset .BRIK file to disk, they will test to see if the data is easily\n" ,
   "compressible (at least 80%).  If so, then the GZIP compression will be\n" ,
   "used.  (For this to work, the gzip program must be in your path.) This\n" ,
   "can be useful if you are dealing with mask datasets, which are usually\n" ,
   "highly compressible, but don't want the overhead of trying to compress\n" ,
   "and decompress arbitrary MRI datasets.\n" ,
   "\n" ,
   "A command line method to carry out compression of datasets that will\n" ,
   "compress well is to use a csh script like the following:\n" ,
   "\n" ,
   "  #!/bin/csh\n" ,
   "  foreach fred ( `find . -name \\*.BRIK -print` )\n" ,
   "    ent16 -%50 < $fred\n" ,
   "    if( $status == 1 ) gzip -1v $fred\n" ,
   "  end\n" ,
   "\n" ,
   "This will only gzip .BRIK files that the program ent16 estimates will\n" ,
   "compress by at least 50%.  Note that ent16's estimate of compression\n" ,
   "may be high or low relative to what gzip actually does.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DONT_MOVE_MENUS (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the functions that try\n" ,
   "to move popup menus to \"good\" locations on screens will be skipped.\n" ,
   "This seems to be necessary on some Solaris systems, where the menus\n" ,
   "can end up being moved to bizarre locations.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MINC_DATASETS\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is not set to NO, then MINC-format files\n" ,
   "with name suffix .mnc will be read into the interactive AFNI\n" ,
   "program at startup, along with standard .HEAD/.BRIK datasets.\n" ,
   "That is, you have to set this variable explicitly to NO if you\n" ,
   "don't want MINC-format files to be automatically recognized by\n" ,
   "the interactive AFNI program.  This variable does not affect\n" ,
   "the ability of command line programs (3dSomething) to read\n" ,
   ".mnc input files.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MINC_FLOATIZE\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to YES, then when MINC-format files\n" ,
   "are read in as datasets, their values will be scaled to floats.\n" ,
   "Otherwise, their values will be scaled to the same data type as\n" ,
   "stored in the file.  In some cases, the latter behavior is not\n" ,
   "good; for example, if a byte-valued file (intrinsic range 0..255)\n" ,
   "is scaled to the range 0..0.5 in the MINC header, then after\n" ,
   "conversion back to bytes, the resulting AFNI dataset values will\n" ,
   "all be zero.  Setting AFNI_MINC_FLOATIZE to YES will cause the\n" ,
   "scaled values to be stored as floats.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_MINC_SLICESCALE\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to NO, then AFNI will not use the\n" ,
   "image-min and image-max scaling when reading data from MINC files.\n" ,
   "Normally, you want this scaling, since MINC files are scaled separately\n" ,
   "in each slice.  However, if the image-min and image-max values in the\n" ,
   "MINC file are damaged, then you can turn off the scaling this way.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ANALYZE_SCALE\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to NO, then the \"funused1\" entry\n" ,
   "in the Mayo Analyze .hdr file will not be used as a scale factor\n" ,
   "for the images contained in the corresponding .img file.  Otherwise,\n" ,
   "if funused1 is positive and not equal to 1.0, all the image data\n" ,
   "in the .img file will be scaled by this value.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ANALYZE_FLOATIZE\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then Mayo Analyze files\n" ,
   "will be scaled to floats on input.  Otherwise, they will be read\n" ,
   "in the format in which they are stored in the .img file.  Conversion\n" ,
   "to floats can be useful if the scaling factor is such that the image\n" ,
   "native format can't hold the scaled values; for example, if short\n" ,
   "values in the image range from -1000..1000 and the scale factor\n" ,
   "is 0.0001, then the scaled values range from -0.1..0.1, which would\n" ,
   "be truncated to 0 in the scaled image if it is not \"floatized\".\n" ,
   "(Conversion to floats will only be done to byte, short, and int\n" ,
   "image types.)\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ANALYZE_ORIGINATOR\n" ,
   "---------------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will attempt\n" ,
   "to read and use the ORIGINATOR field in a Mayo Analyze file\n" ,
   "to set the origin of the pixel space in AFNI.  This origin\n" ,
   "can be used directly by several programs--the main AFNI viewer,\n" ,
   "and all of the 3dxxxx programs, including especially 3dcopy,\n" ,
   "which is the preferred way to convert an Analyze format file\n" ,
   "to an AFNI native file.\n" ,
   "This variable will also force 3dAFNItoANALYZE to write the\n" ,
   "ORIGINATOR field into the output Analyze file based on the\n" ,
   "input AFNI file's origin information.\n" ,
   "The ORIGINATOR field should be compatible with SPM in most\n" ,
   "cases, but please verify this.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_START_SMALL\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI starts, it will\n" ,
   "look for the smallest dataset in the first session, and choose this\n" ,
   "as its starting point.  This can be useful if you also use the layout\n" ,
   "feature to pop open an image window on startup; in that case, if the\n" ,
   "default starting dataset (the first alphabetical) is huge, you won't\n" ,
   "see anything while the program reads all of into memory before displaying\n" ,
   "the first image.\n" ,
   "\n" ,
   "The old behavior of this variable was to set the smallest dataset\n" ,
   "marked as 'Anatomical' to be the underlay, and the smallest dataset\n" ,
   "marked as 'Functional' to be the overlay.  The new behavior just\n" ,
   "sets both the underlay and overlay to be the smallest dataset.\n" ,
   "If you want the old behavior, set this variable to the string 'OLD'.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_MENU_COLSIZE\n" ,
   "---------------------------\n" ,
   "This numerical variable sets the maximum number of entries in a popup\n" ,
   "menu column (e.g., like the sub-brick menus for bucket datasets).  The\n" ,
   "default value is 20, but you may want to make this larger (say 40).  When\n" ,
   "you have a menu with a huge number of entries, the menu can become so\n" ,
   "wide that it doesn't fit on the screen.  Letting the columns be longer\n" ,
   "will make the menus be narrower across the screen.\n" ,
   "\n" ,
   "Another way to get a handle on such huge menus is to Button-3 (right)\n" ,
   "click on the label to the left of the menu.  This will popup a one-\n" ,
   "column scrollable list chooser that is equivalent to the menu.  In this\n" ,
   "way, it is still possible to use menus that have hundreds of entries.\n" ,
   "The maximum number of entries shown at one time in a scrollable list\n" ,
   "chooser is given by variable AFNI_chooser_listmax if it exists, otherwise\n" ,
   "by AFNI_MENU_COLSIZE.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GLOBAL_SESSION\n" ,
   "-----------------------------\n" ,
   "This variable, if it exists, is the name of a directory that contains\n" ,
   "\"global\" datasets - ones that you want to be visible in each \"Switch Underlay\"\n" ,
   "or \"Switch Overlay\" menu.  Pointers to the datasets read from this directory\n" ,
   "will be appended to the dataset list for each directory read from the\n" ,
   "command line.  In the \"Switch\" choosers, these datasets are marked with\n" ,
   "the character 'G' at the right, and they appear last in the list.\n" ,
   "\n" ,
   "It really only makes sense to put +tlrc datasets in the global session\n" ,
   "directory, since only they can be presumed to be aligned with other datasets.\n" ,
   "Also, it is probably best if you make sure each global anatomical dataset\n" ,
   "has itself as the anatomy parent; this can be enforced by issuing the command\n" ,
   "  3drefit -apar SELF *.HEAD\n" ,
   "in the global session directory.\n" ,
   "\n" ,
   "When you Switch Sessions and are viewing a global dataset, it is likely that\n" ,
   "you will NOT be viewing the same dataset after the Switch Session.  You will\n" ,
   "have to then Switch Underlay and/or Switch Overlay to get back to the same\n" ,
   "global dataset(s).\n" ,
   "\n" ,
   "If you start AFNI and there are no datasets in the sessions given on the\n" ,
   "command line, then the directory specified by this variable becomes the\n" ,
   "default session.  If there are no datasets there, either, then AFNI makes\n" ,
   "up a dummy dataset (AFNI cannot operate without at least one dataset).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISP_SCROLLBARS (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the 'Disp' control window\n" ,
   "(on the image viewers) will have scrollbars attached.  This window has\n" ,
   "grown larger over the years, and for some people with pitifully small\n" ,
   "displays (e.g., laptops), it is now taller than their screens.  If\n" ,
   "activated, this option will prevent the Disp window from being so tall\n" ,
   "and will attach scrollbars so you can access all of its contents.\n" ,
   "\n" ,
   "Note: If you change this value interactively, via Edit Environment, the\n" ,
   "change will only affect Disp windows opened after you 'Set' the variable.\n" ,
   "That is, already opened Disp windows won't suddenly get scrollbars if\n" ,
   "you change this to YES.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_GRAPH_TEXTLIMIT (editable)\n" ,
   "------------------------------\n" ,
   "This numerical variable sets the upper limit on the number of rows shown\n" ,
   "in the Button-3 popup in a sub-graph.  If the number of rows in the popup\n" ,
   "would be more than this value, a text window with scrollbars is used\n" ,
   "instead of a \"spring-loaded\" menu pane.  If you set this value to 1, then\n" ,
   "the text window will always be used.  Note that a text window does not\n" ,
   "automatically popdown, but must be explicitly dismissed by the user\n" ,
   "pressing the \"Quit\" button.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GRAPH_BASELINE\n" ,
   "-----------------------------\n" ,
   "This variable should be set to one of the strings \"Individual\", \"Common\",\n" ,
   "or \"Global\", corresponding to the choices on the Opt->Baseline menu in\n" ,
   "a graph window.  (Actually, only the first letter of the string will be\n" ,
   "used.)  This variable will determine the initial setting of the Baseline\n" ,
   "menu when a graph window opens.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_GRAPH_GLOBALBASE\n" ,
   "-------------------------------\n" ,
   "Normally, the global baseline for a graph window is set to the smallest\n" ,
   "value found in the entire 3D+time dataset.  This variable lets you specify\n" ,
   "a numerical value to be used for this purpose instead.  Probably the most\n" ,
   "common setting (for those who want to use this feature at all, which means\n" ,
   "Mike Beauchamp) would be\n" ,
   "  setenv AFNI_GRAPH_GLOBALBASE 0\n" ,
   "Of course, you can always change the global baseline from the Opt->Baseline\n" ,
   "menu.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_CX2R (editable)\n" ,
   "-------------------------\n" ,
   "This variable determines how the AFNI time series graphing window displays\n" ,
   "complex-valued datasets.  The possible values are ABS, PHASE, REAL, and IMAG.\n" ,
   "(Actually, only the first letter matters to the program.)  The default\n" ,
   "method is ABS.  (If you edit this method interactively, the graph won't\n" ,
   "automatically be redrawn -- you'll have to force a graph window redraw\n" ,
   "to see the effects.)\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_GRAPH_BOXLAB (editable)\n" ,
   "---------------------------\n" ,
   "This variable determines if and how the AFNI grapher displays sub-brick\n" ,
   "labels on top of the Box graphs (from the 'Colors, Etc.' menu, or via\n" ,
   "the 'B' keypress).  If Box graphs are turned on, and if the graph matrix\n" ,
   "has only 1 graph, and if this environment variable is set properly, then\n" ,
   "sub-brick labels will be drawn on top of the graph boxes.  The settings\n" ,
   "for this variable are\n" ,
   "  ATOP (or A) = labels go on top of their boxes\n" ,
   "  MAX  (or M) = labels go at the level of the tallest box\n" ,
   "  ZERO (or Z) = labels go at the bottom of the graph\n" ,
   "Labels are drawn vertically, upwards from their starting point.  Play\n" ,
   "with this feature to see how it works and looks, and recall that beauty\n" ,
   "is in the eye of the beholder.  (If you edit this method interactively,\n" ,
   "the graph won't automatically be redrawn -- you'll have to force a graph\n" ,
   "window redraw to see the effects.)  You can control the font for this\n" ,
   "text with AFNI_GRAPH_FONT (next).  Note that if you use the Dataset#N\n" ,
   "plugin with this feature, the labels will come from the underlay dataset\n" ,
   "rather than the Dataset#N datasets.  This bug is so recondite and intractable\n" ,
   "that I hope it will not cause too many problems for the adoring AFNI public.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_FONT\n" ,
   "-------------------------\n" ,
   "This variable is the name of a font to use for text overlays in the\n" ,
   "AFNI time series graph viewers.  If this variable is not set, the\n" ,
   "program has a list of fonts to try to load.  If none of those can\n" ,
   "be loaded (something I've never seen happen), text may not display.\n" ,
   "For best results, this should be a fixed width font.  To see a full\n" ,
   "list of all X11 fonts available, use the system command 'xlsfonts'\n" ,
   "(you probably want to pipe this output through 'more').  The first\n" ,
   "default font is currently [Apr 2011] set to\n" ,
   "  -adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1\n" ,
   "For a font that is larger than the default, try 9x15bold or even\n" ,
   "10x20, as in the command\n" ,
   "  afni -DAFNI_GRAPH_FONT=9x15bold\n" ,
   "The entire list of fonts that will be tried can be found in the\n" ,
   "source code file display.h, in the string array tfont_hopefuls[].\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_FADE\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the 'threshold fade' feature\n" ,
   "of the AFNI graph window is turned on for all graph viewers when\n" ,
   "they open.  Otherwise, you have to turn this feature on via the\n" ,
   "'F' key or the toggle control in the Opt menu.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_VALUE_LABEL (editable)\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the data value label on the\n" ,
   "Define Overlay control panel will be turned on when only 1 or 2 image\n" ,
   "viewer windows are open.  This will consume more CPU time and redrawing\n" ,
   "time than the default, which is that this label is only turned on when\n" ,
   "all 3 image viewer windows are open.  If you are operating X11 remotely\n" ,
   "over a slow connection, this option should not be turned on.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SUMA_BOXCOLOR (editable)\n" ,
   "----------------------------\n" ,
   "This string defines the color used for overlaying surface nodes transmitted\n" ,
   "from SUMA to AFNI.  The default is an orangish-yellow.  If you like yellow,\n" ,
   "then do\n" ,
   "   setenv AFNI_SUMA_COLOR yellow\n" ,
   "If this is set to \"none\", then these lines won't be plotted.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SUMA_LINECOLOR (editable)\n" ,
   "-----------------------------\n" ,
   "This string defines the color used for overlaying the intersection of SUMA\n" ,
   "surface triangles with image slice planes.  The default is white.  If this\n" ,
   "is set to \"none\", then these lines won't be plotted.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_SUMA_BOXSIZE (editable)\n" ,
   "---------------------------\n" ,
   "This variable defines the size of the boxes drawn at each surface node\n" ,
   "transmitted from SUMA.  The default is 0.25, which means that each box is\n" ,
   "plus and minus 1/4 of a voxel size about the node location. If you want a\n" ,
   "larger box, you could try\n" ,
   "   setenv AFNI_SUMA_BOXSIZE 0.5\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SUMA_LINESIZE (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets the thickness of the lines used when drawing a surface\n" ,
   "intersection overlay.  The units are the width of the entire image;\n" ,
   "reasonable values are in the range 0..0.01; 0 means to draw the thinnest\n" ,
   "line possible.  Since this is editable, you can experiment with it to\n" ,
   "see what looks good.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NIML_START\n" ,
   "-------------------------\n" ,
   "If this YES/NO variable is set to YES, then NIML listening will be engaged\n" ,
   "from when AFNI starts.  You can also enable NIML from the command line with\n" ,
   "the option \"-niml\", and from the Datamode->Misc menu item \"Start NIML\".\n" ,
   "\n" ,
   "NIML is the mechanism by which AFNI talks to other programs - it is the\n" ,
   "successor to plugouts.  At this moment (Mar 2002), the only external NIML\n" ,
   "program is SUMA - the surface mapper.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_KEEP_PANNING (editable)\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then when the Zoom pan gets turned\n" ,
   "on in the AFNI image viewer, it will stay on until it is explicitly turned\n" ,
   "off.  (The default behavior is to turn panning off after the user releases\n" ,
   "the mouse button.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_MODE\n" ,
   "-------------------------------\n" ,
   "This integer determines the placement of the image coordinate labels drawn\n" ,
   "in the AFNI image viewer windows.  The possible values are\n" ,
   "   0  =  Labels are off\n" ,
   "   1  =  Labels in upper left\n" ,
   "   2  =  Labels in upper right\n" ,
   "   3  =  Labels in lower left\n" ,
   "   4  =  Labels in lower right\n" ,
   "   5  =  Labels in upper middle\n" ,
   "   6  =  Labels in lower middle\n" ,
   "You can also control the placement and size of the labels from the Button-3\n" ,
   "(right-click) popup menu attached to the intensity bar to the right of the\n" ,
   "image sub-window.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_SIZE\n" ,
   "-------------------------------\n" ,
   "This integer determines the size of the image coordinate labels:\n" ,
   "   0  =  Small\n" ,
   "   1  =  Medium\n" ,
   "   2  =  Large\n" ,
   "   3  =  Huge\n" ,
   "   4  =  Enormous\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_COLOR (editable)\n" ,
   "--------------------------------\n" ,
   "This variable controls the color of the image coordinate labels.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_SETBACK (editable)\n" ,
   "----------------------------------\n" ,
   "This variable, a floating point value between 0 and 0.1, determines how\n" ,
   "far from the edge an image coordinate label will be drawn.  The units are\n" ,
   "fractions of the image width/height.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_STRING (editable)\n" ,
   "---------------------------------\n" ,
   "This value of this variable is a string that is appended to the automatically\n" ,
   "generated image slice viewer overlay label -- the viewing of this label is\n" ,
   "controlled from the right-click popup menu attached to the intensity bar to\n" ,
   "the right of the image itself.  This variable applies to any slice image\n" ,
   "viewer window into which the user has not specifically set a string for\n" ,
   "this purpose from the GUI menu item 'Label Append String'.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CROSSHAIR_LINES (editable) -- THIS VARIABLE IS NOW UNUSED\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the image crosshairs will be\n" ,
   "drawn using lines rather than pixels.  By default (this is the original\n" ,
   "AFNI way), crosshair lines are drawn the same way as functional overlays:\n" ,
   "by putting color pixels on top of the image.  The new way draws lines on\n" ,
   "top of the image instead.  The difference is quite visible when the image\n" ,
   "is zoomed; overlay by pixels shows the crosshair lines as fat blobs, but\n" ,
   "the lines are drawn as thin as possible, no matter what the image window\n" ,
   "size and zoom factor.\n" ,
   "\n" ,
   "Good points about crosshairs drawn with lines:\n" ,
   " - They are less obtrusive than pixel overlay, especially if you zoom\n" ,
   "     or enlarge the image a lot\n" ,
   " - When doing a montage with Spacing=1, they'll look better in the\n" ,
   "     orthogonal slices.\n" ,
   "Good points about crosshairs drawn with pixel overlay:\n" ,
   " - Pixel overlays can be rendered as translucent (on X11 TrueColor displays);\n" ,
   "     geometrical overlays are always solid color.\n" ,
   "So you have to decide what you need most.  You can change this item using\n" ,
   "the \"Edit Environment\" pseudo-plugin on the Datamode->Misc menu, so you\n" ,
   "can play with it interactively to get the features you want.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_CROSSHAIR_THICKNESS\n" ,
   "----------------------------------\n" ,
   "This numeric variable lets you set the thickness of the lines used to draw\n" ,
   "the image viewer crosshairs.  The default value is 0, which means thin lines.\n" ,
   "The units are fractions of the image size, and the legal range is 0 .. 0.05\n" ,
   "(which will be very thick lines, I assure you).  This variable was introduced\n" ,
   "in March 2015 for Corianne (if there is such a person).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_CROP_ZOOMSAVE (editable)\n" ,
   "----------------------------\n" ,
   "When saving a zoomed image, the default is to save the entire zoomed image,\n" ,
   "not just the part you see.  If this YES/NO variable is set to YES, then only\n" ,
   "the visible part will be saved.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CROP_AUTOCENTER\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the image viewer windows will\n" ,
   "automatically re-center the cropping sub-window (if cropping is active)\n" ,
   "around the crosshair position -- as far as possible.  You can also set\n" ,
   "this crop autocenter capability individually for each image viewer\n" ,
   "window from the intensity bar right-click popup menu.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variables: AFNI_TLRC_BBOX_*\n" ,
   "---------------------------\n" ,
   "These variables let you choose the size of the \"Talairach Box\", into which\n" ,
   "+tlrc datasets are transformed.  If defined, they should be positive values,\n" ,
   "in mm.  The 5 variables (any or all of which may be used) are:\n" ,
   "\n" ,
   "  AFNI_TLRC_BBOX_LAT = distance from midline to maximum left/right position\n" ,
   "                        [default=80]\n" ,
   "  AFNI_TLRC_BBOX_ANT = distance from AC to most anterior point in box\n" ,
   "                        [default=80]\n" ,
   "  AFNI_TLRC_BBOX_POS = distance from AC to most posterior point in box\n" ,
   "                        [default=110]\n" ,
   "  AFNI_TLRC_BBOX_INF = distance from AC-PC line to most inferior point in box\n" ,
   "                        [default=55 for small box, 65 for big box]\n" ,
   "  AFNI_TLRC_BBOX_SUP = distance from AC-PC line to most superior point in box\n" ,
   "                        [default=85]\n" ,
   "\n" ,
   "For example, \"setenv AFNI_TLRC_BBOX_INF 100\" lets you define the +tlrc box\n" ,
   "to extend 100 mm below the AC-PC line.  Please note that virtually all the\n" ,
   "3d* analysis programs (3dANOVA, etc.) do voxel-by-voxel analyses.  This fact\n" ,
   "means that you will be unable to compare datasets created in +tlrc coordinates\n" ,
   "with different box sizes.  Also, you will be unable to overlay regions from\n" ,
   "the Talairach Daemon database onto odd-sized +tlrc datasets.  Therefore, I\n" ,
   "recommend that these variables be used only when strictly needed, and with\n" ,
   "caution.\n" ,
   "\n" ,
   "Lastly, try hard not to mix TLRC datasets created with various box sizes in\n" ,
   "the same session. Strange things may happen.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variables: AFNI_ACPC_BBOX_*\n" ,
   "---------------------------\n" ,
   "The variables let you choose the size of the \"ACPC Box\", into which\n" ,
   "+acpc datasets are transformed. If defined, they should be positive values,\n" ,
   "in mm.  The 6 variables (any or all of which may be used) are:\n" ,
   "\n" ,
   "  AFNI_ACPC_BBOX_LAT = distance from midline to maximum left/right position\n" ,
   "                        [default=95]\n" ,
   "  AFNI_ACPC_BBOX_ANT = distance from AC to most anterior point in box\n" ,
   "                        [default=95]\n" ,
   "  AFNI_ACPC_BBOX_POS = distance from AC to most posterior point in box\n" ,
   "                        [default=140]\n" ,
   "  AFNI_ACPC_BBOX_INF = distance from AC-PC line to most inferior point in box\n" ,
   "                        [default=70]\n" ,
   "  AFNI_ACPC_BBOX_SUP = distance from AC-PC line to most superior point in box\n" ,
   "                        [default=100]\n" ,
   "\n" ,
   "Check example and heed ALL warnings for variables AFNI_TLRC_BBOX_* above.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_TTRR_SETUP\n" ,
   "-------------------------\n" ,
   "Name of a file to be loaded to define Talairach Atlas Colors, when the Atlas\n" ,
   "Colors control panel is first created.  Format is the same as a file created\n" ,
   "from this control panel's \"Save\" button.  This filename should be an absolute\n" ,
   "path (e.g., /home/yourname/.afni_ttcolors), since otherwise it will be read\n" ,
   "relative to the directory in which you start AFNI.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_LOAD_PRINTSIZE\n" ,
   "-----------------------------\n" ,
   "AFNI will print (to stderr) a warning that it is loading a large dataset from\n" ,
   "disk.  This value determines the meaning of \"large\".  For example, setting\n" ,
   "this variable to \"40M\" means that loading a dataset larger than 40 Megabytes\n" ,
   "will trigger the warning.  If not given, the default value is 100 Megabytes.\n" ,
   "The purpose of the warning is just to let the user know that it may be several\n" ,
   "seconds before the dataset is loaded (e.g., before the images appear).  If you\n" ,
   "don't want this warning at all, set this variable to the string \"0\".\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ANALYZE_DATASETS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is not set to NO, then ANALYZE-format files with name\n" ,
   "suffix .hdr will be read into the interactive AFNI program at startup, along\n" ,
   "with standard .HEAD/.BRIK datasets.  That is, you have to set this variable\n" ,
   "explicitly to NO if you don't want ANALYZE-format files to be automatically\n" ,
   "recognized by the interactive AFNI program.  This variable does not affect\n" ,
   "the ability of command line programs (3dSomething) to read .hdr input files.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ANALYZE_ORIENT\n" ,
   "-----------------------------\n" ,
   "ANALYZE .hdr files do not contain reliable information about the orientation\n" ,
   "of the data volumes.  By default, AFNI assumes that these datasets are\n" ,
   "oriented in LPI order.  You can set this variable to a different default\n" ,
   "order.  See AFNI_ORIENT for details on the 3 letter format for this.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ANALYZE_AUTOCENTER\n" ,
   "---------------------------------\n" ,
   "ANALYZE .hdr files do not contain information about the origin of coordinates.\n" ,
   "The default AFNI approach mirrors that of FSL - the outermost corner of the\n" ,
   "first voxel in the dataset is set to (0,0,0).  If you set this variable\n" ,
   "(AFNI_ANALYZE_AUTOCENTER) to YES, then instead (0,0,0) will be set to the\n" ,
   "center of the 3D ANALYZE array.  This is the default that would be applied\n" ,
   "if you read the ANALYZE array into program to3d.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_VERSION_CHECK\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to NO, then AFNI will not try to check if its\n" ,
   "version is up-to-date when it starts.  Otherwise, it will try to check the\n" ,
   "program version with the AFNI web server.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_MOTD_CHECK\n" ,
   "-------------------------\n" ,
   "Similarly, if this YES/NO variable is set to NO, then AFNI will not display\n" ,
   "and fetch the AFNI \"Message of the Day\" at startup.  You can always check\n" ,
   "the MOTD by using the Datamode->Misc menu.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_SLICE_SPACING_IS_GAP\n" ,
   "-----------------------------------\n" ,
   "This YES/NO variable is designed to patch a flaw in some DICOM files, where\n" ,
   "the \"Spacing Between Slices\" attribute is erroneously set to the gap between\n" ,
   "the slices, rather than the center-to-center slice distance specified in\n" ,
   "the DICOM standard.  If this variable is set to YES, then the \"Slice Thickness\"\n" ,
   "attribute will always be added to \"Spacing Between Slices\" to get the z voxel\n" ,
   "size (assuming both attributes are present in the DICOM file).\n" ,
   "\n" ,
   "To check if a DICOM file has this problem, you can read it into to3d with\n" ,
   "the command \"to3d suspect_file_name\".  A warning will be printed to the\n" ,
   "terminal window if attribute \"Spacing Between Slices\" is less than\n" ,
   "attribute \"Slice Thickness\".  Another way to check is with a command like so\n" ,
   "\n" ,
   "  dicom_hdr suspect_file_name | grep \"Slice\"\n" ,
   "\n" ,
   "then check if the \"Spacing Between Slices\" and \"Slice Thickness\" values are\n" ,
   "correct for the given acquisition.  We have only seen this problem in GE\n" ,
   "generated DICOM files, but that doesn't mean it won't occur elsewhere.\n" ,
   "\n" ,
   "If this variable is set to NO, then this patchup will never be made.\n" ,
   "The z voxel size will be set to \"Spacing Between Slices\" if present,\n" ,
   "otherwise to \"Slice Thickness\".  This may be needed for some Phillips pulse\n" ,
   "sequences, which can report \"Spacing Between Slices\" < \"Slice Thickness\".\n" ,
   "In such a case, if this variable is not set, the wrong z voxel size will\n" ,
   "be assigned!\n" ,
   "\n" ,
   "If this variable is not set at all, AND if \"Spacing Between Slices\" is less\n" ,
   "less than 0.99 times \"Slice Thickness\", it will be treated as a gap;\n" ,
   "that is, the z voxel size will again be set to \"Spacing Between Slices\" +\n" ,
   "\"Slice Thickness\" if \"Spacing Between Slices\" < 0.99*\"Slice Thickness\".\n" ,
   "Otherwise, the z voxel size will be set to the larger of\n" ,
   "\"Spacing Between Slices\" and \"Slice Thickness\".\n" ,
   "\n" ,
   "N.B.: \"YES\", \"NO\", and \"not set\" have 3 different sets of behavior!\n" ,
   "      In the summary below, if a variable isn't set, treat it as zero:\n" ,
   "\n" ,
   "  YES     => dz = Thickness + Spacing\n" ,
   "  NO      => dz = Spacing if present, otherwise Thickness\n" ,
   "  not set => if( Spacing > 0 && Spacing < 0.99*Thickness )\n" ,
   "               dz = Thickness + Spacing\n" ,
   "             else\n" ,
   "               dz = MAX( Thickness , Spacing )\n" ,
   "\n" ,
   "If neither variable is set, then dz=1 mm, which is probably wrong.\n" ,
   "\n" ,
   "Sorry about this complexity, but the situation with various manufacturers\n" ,
   "is complicated, murky, and confusingly maddening.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variables: AFNI_DICOM_RESCALE and AFNI_DICOM_WINDOW\n" ,
   "---------------------------------------------------\n" ,
   "DICOM image files can contain rescaling and windowing \"tags\".  If present,\n" ,
   "these values indicate to affinely modify the values stored in the file.\n" ,
   "As far as I can tell, \"rescale\" means that the values should always be\n" ,
   "modified, whereas \"window\" means the values should be modified for display\n" ,
   "purposes.  If both are present, the rescale comes before window.  These\n" ,
   "two YES/NO environment variables control whether the AFNI image input\n" ,
   "functions (used in to3d) should apply the rescale and window tags.\n" ,
   "\n" ,
   "It is my impression from the laconic, terse, and opaque DICOM manual that\n" ,
   "window tags are intended for display purposes only, and that they aren't\n" ,
   "needed for signal processing.  But you'll have to examine your own data to\n" ,
   "decide whether to use these options -- manufacturers seem to differ.\n" ,
   "Plus, I don't have that much experience with DICOM data from many different\n" ,
   "sources.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variable: AFNI_DICOM_VERBOSE\n" ,
   "---------------------------------------------------\n" ,
   "Set this YES/NO variable to YES to output extra details when reading\n" ,
   "DICOM images.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variable: AFNI_DICOM_USE_LAST_ELEMENT\n" ,
   "---------------------------------------------------\n" ,
   "Set this YES/NO variable to YES to force the DICOM reading routines to set\n" ,
   "each DICOM element based on the last occurrence, not necessarily the first.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: IDCODE_PREFIX\n" ,
   "-----------------------\n" ,
   "AFNI stores with each dataset a unique string, called an \"idcode\".  An example\n" ,
   "is \"XYZ_MoNLqdNOwMNEYmKSBytfJg\".  You can alter the first three characters of\n" ,
   "the idcode with this variable.  For example,\n" ,
   "  setenv IDCODE_PREFIX RWC\n" ,
   "sets the first 3 characters of newly generated idcodes to be the initials of\n" ,
   "AFNI's author.  I find this a handy way to \"brand\" my datasets.  Of course,\n" ,
   "there are only 17576 possible 3 letter combinations (140608 if you allow for\n" ,
   "case), so you should claim your prefix soon!!!\n" ,
   "\n" ,
   "Idcodes are used to store links between datasets.  For example, when SUMA\n" ,
   "sends a surface to AFNI, it identifies the dataset to which the surface is\n" ,
   "to be associated with the dataset's idcode.  Similarly, when AFNI sends a\n" ,
   "color overlay to SUMA, it uses the surface idcode to indicate which surface\n" ,
   "family the overlay is to be mapped onto.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_AGIF_DELAY\n" ,
   "-------------------------\n" ,
   "This is the time delay between frames when writing an animated GIF file from\n" ,
   "an image viewer window.  The units are 100ths of seconds (centi-seconds!);\n" ,
   "the default value is 20 (= 5 frames per second).  Note that this value\n" ,
   "is NOT editable in the Edit Environment control panel, so you have to\n" ,
   "set it up prior to starting AFNI (e.g., by using an option like\n" ,
   "'-DAFNI_AGIF_DELAY=10' on the command line when starting AFNI).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MPEG_FRAMERATE\n" ,
   "-----------------------------\n" ,
   "This value sets the frame rate (per second) of the MPEG-1 output animation\n" ,
   "from the image viewer window.  The legal values allowed by MPEG-1 are\n" ,
   "24, 25, 30, 50, and 60; 24 (the slowest) is the default.  Note that the\n" ,
   "MPEG-1 standard does NOT allow arbitrary framerates, only these listed.\n" ,
   "To further slow down an MPEG-1 animation in AFNI, use the AFNI_ANIM_DUP\n" ,
   "variable, described below.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_ANIM_DUP (editable)\n" ,
   "-----------------------\n" ,
   "This value sets the frame duplication factor for AGIF or MPEG animation\n" ,
   "output.  If this value 'd' is between 1 and 99, then each frame (image)\n" ,
   "will be written out 'd' times before being incorporated into the\n" ,
   "movie file.  Note that AFNI_AGIF_DELAY can be used to slow down an\n" ,
   "AGIF file more efficiently, but that there is no other way (within AFNI)\n" ,
   "to slow down an MPEG file.  (Some MPEG movie players will let you slow\n" ,
   "down the animation, but that's outside of AFNI's control.)\n" ,
   "\n" ,
   "You can control this variable directly from the Edit Environment control\n" ,
   "panel, or set its internal value in AFNI (or other image viewers) from\n" ,
   "the right-click popup menu attached to the intensity grayscale bar just\n" ,
   "to the right of the image sub-window in the viewer.  Note that the\n" ,
   "duplication factor must be greater than 1 for any slowdown to occur.\n" ,
   "For example, if you want 6 frames per second in an MPEG file, then a\n" ,
   "duplication factor of 4 would work (24 fps / 4 = 6 fps).\n" ,
   "\n" ,
   "For MPEG-1 files, AFNI will set up the frame temporal encoding pattern so\n" ,
   "that there is very little .mpg file size overhead for this frame\n" ,
   "duplication.  The same is NOT true for animated GIF files, since these\n" ,
   "files do not have any compression along the time axis.  Therefore, you\n" ,
   "should use AFNI_AGIF_DELAY to control the frame rate of animated GIF\n" ,
   "files, and not this frame duplication factor.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_STARTUP_SCRIPT\n" ,
   "-----------------------------\n" ,
   "If this is set, this is the name of an AFNI Script to run when AFNI first\n" ,
   "starts.  (See the file README.driver for information about AFNI Scripts.)\n" ,
   "If this is not set, it defaults to \".afni.startup_script\".  The program first\n" ,
   "tries to read this filename from the current working directory; if that fails,\n" ,
   "then it tries to read from your home directory.  No error message is given\n" ,
   "if neither file can be read.\n" ,
   "\n" ,
   "You can save a file \".afni.startup_script\" that will recreate the window\n" ,
   "layout you currently have.  Use the \"Datamode->Misc->Save Layout\" button\n" ,
   "and press \"Set\" on the popup control without entering any filename.  Instead\n" ,
   "of a Layout file (cf. AFNI_LAYOUT_FILE above), you'll get a Script file\n" ,
   "if you leave the filename blank or enter any filename with the string\n" ,
   "\"script\" included (e.g., \"coolstuff.script\").\n" ,
   "\n" ,
   "The capabilities of Script files are expanded from time to time.  Not all\n" ,
   "features of the AFNI window setup are currently save-able this way.\n" ,
   "\n" ,
   "You can load a Script file interactively during an AFNI run by using the\n" ,
   "button \"Datamode->Misc->Run Script\".  As a 'secret' option, if you enter\n" ,
   "a line containing a blank in the the filename dialog, that line will be\n" ,
   "executed as a single command, rather than be used as a script filename.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DEFAULT_OPACITY\n" ,
   "------------------------------\n" ,
   "This should be set to an integer from 1..9, and controls the default opacity\n" ,
   "setting for the color overlay in image viewer windows.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_DEFAULT_IMSAVE\n" ,
   "-----------------------------\n" ,
   "This should be set to the suffix of the image format to which you want to save\n" ,
   "from an image viewer.  The suffixes AFNI knows about (as of 23 Jan 2003) are\n" ,
   " ppm = Portable PixMap format                            = cat\n" ,
   " jpg = Joint Photographics Experts Group (JPEG) format   = cjpeg\n" ,
   " gif = Compuserve Graphics Interchange File (GIF) format = ppmtogif\n" ,
   " tif = Tagged Image File Format (TIFF)                   = ppm2tiff or pnmtotiff\n" ,
   " bmp = Windows Bitmap (BMP) format                       = ppmtobmp\n" ,
   " eps = Encapsulated PostScript format                    = pnmtops\n" ,
   " pdf = Portable Document Format                          = epstopdf\n" ,
   " png = Portable Network Graphics format                  = pnmtopng\n" ,
   "The third column is the name of the external filter program that AFNI uses to\n" ,
   "write the format.  If a filter is not present on your system, then that option\n" ,
   "is not available.  Most of these filters are part of the netpbm package.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variables: AFNI_COLORSCALE_xx  for xx=01, 02, ..., 99\n" ,
   "-----------------------------\n" ,
   "These variables let you name files to be read it at AFNI startup to define\n" ,
   "\"continuous\" colorscales for the \"**\" mode of the color pbar.  These files\n" ,
   "will be looked for in the current directory when you start AFNI, or in your\n" ,
   "home directory (if they aren't in the current directory).  A sample file:\n" ,
   "\n" ,
   "  Yellow-Red-Blue\n" ,
   "  1.0 #ffff00\n" ,
   "  0.7 #ffaa00\n" ,
   "  0.5 #ff0000\n" ,
   "  0.3 #aa00aa\n" ,
   "  0.0 #0000ff\n" ,
   "\n" ,
   "The first line is the name of this colorscale, to go in the colorscale popup\n" ,
   "chooser.  The succeeding lines each have a number and a color definition.\n" ,
   "The numbers should be decreasing, and indicate the location on the colorscale.\n" ,
   "The largest number corresponds to the top of the colorscale and the smallest\n" ,
   "to the bottom - intermediate numbers denote intermediate locations.  The colors\n" ,
   "at each location are specified using X11 notation (cf. \"man XParseColor\").\n" ,
   "In this example, I'm using hexadecimal colors, in the form #rrggbb, where each\n" ,
   "hex pair ranges from 00 to ff.  Another color format is \"rgbi:rf/gf/bf\",\n" ,
   "where each value rf,gf,bf is a number between 0.0 and 1.0 (inclusive); for\n" ,
   "example, yellow would be \"rgbi:1.0/1.0/0.0\".\n" ,
   "\n" ,
   "Colors are interpolated (linearly in RGB space) between the break locations\n" ,
   "given in the file.  There are actually 128 color locations on a colorscale.\n" ,
   "\n" ,
   "An alternative format for the file is to omit the numbers indicating the\n" ,
   "break locations.  In this case, the break locations will be taken to be\n" ,
   "equally spaced.  For example:\n" ,
   "\n" ,
   "  Yellow-Red-Blue\n" ,
   "   #ffff00\n" ,
   "   #ffaa00\n" ,
   "   #ff0000\n" ,
   "   #aa00aa\n" ,
   "   #0000ff\n" ,
   "\n" ,
   "This example is not exactly the same as the other one, since the breakpoints\n" ,
   "are evenly spaced now (as if they had been given as 1.0, 0.75, 0.5, 0.25,\n" ,
   "and 0.0).  With this format, if you want to manually specify all 128 colors,\n" ,
   "you can do so, 1 color per line, remembering that the first line of the file\n" ,
   "is taken to be the colorscale title (no blanks allowed in the title!).\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_COLORSCALE_DEFAULT\n" ,
   "---------------------------------\n" ,
   "If set, this is the name of the default colorscale to use in setup.  As a\n" ,
   "special case, if you DO NOT want a colorscale to be setup by default at all,\n" ,
   "then set this variable to the string \"NO\".\n" ,
   "N.B.: This variable only applies if you are using AFNI with a TrueColor X11\n" ,
   "visual.  If you are using a PseudoColor visual, then this variable is ignored!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_RESCAN_METHOD\n" ,
   "----------------------------\n" ,
   "On 28 Dec 2002, I modified the way that the \"Rescan\" operation in AFNI works\n" ,
   "when re-reading datasets from sessions.  The old way would purge and replace\n" ,
   "all datasets; the new way just adds datasets that didn't exist before.\n" ,
   "There are some differences between these methods:\n" ,
   "  \"Replace\" will detect changes to a dataset, so if you add a brick using\n" ,
   "    3dTcat -glueto (for example), this will be reflected in AFNI.\n" ,
   "  \"Replace\" will cause troubles if you are using a dataset in a plugin;\n" ,
   "    the two main examples are volume rendering and the drawing plugin.\n" ,
   "    This problem will occur even if you didn't do anything to the dataset\n" ,
   "    on disk, since the internal pointer to the dataset will have been\n" ,
   "    changed by the rescan, but the plugins won't know that.\n" ,
   "  \"Add\" will not detect changes to a dataset on disk, but it also won't\n" ,
   "    affect the pointers to the existing datasets.\n" ,
   "You can choose to use the \"Replace\" method (the old style) by setting\n" ,
   "this environment variable to the string \"REPLACE\".\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_OLD_PPMTOBMP\n" ,
   "---------------------------\n" ,
   "The old (before 21 Feb 2003) usage of netpbm program \"ppmtobmp\" was to\n" ,
   "write a color image quantized to 255 colors.  The new usage is to write\n" ,
   "a 24-bit image, which is thus not color-quantized.  If you want the old\n" ,
   "behavior, set this environment variable to YES.  This setting (YES) will\n" ,
   "be necessary if you have an older version of ppmtobmp in your path, which\n" ,
   "doesn't support the \"-bpp\" option.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_1DPLOT_COLOR_xx\n" ,
   "------------------------------\n" ,
   "This variable lets you set the colors used in the 1dplot program (and other\n" ,
   "similar graphs).  Here, \"xx\" is a number from \"01\" to \"19\".  The value of\n" ,
   "the environment variable must be in the form \"rgbi:rf/gf/bf\", where each\n" ,
   "color intensity (rf, gf, bf) is a number between 0.0 and 1.0.  For example,\n" ,
   "\"rgbi:1.0/1.0/0.0\" is yellow.  By default, the first 4 colors are defined\n" ,
   "as the equivalents of\n" ,
   "  setenv AFNI_1DPLOT_COLOR_01 rgbi:0.0/0.0/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_02 rgbi:0.9/0.0/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_03 rgbi:0.0/0.7/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_04 rgbi:0.0/0.0/0.9\n" ,
   "which are black, red, green, and blue, respectively.  You can alter these\n" ,
   "colors, or leave them unchanged and start defining colors at 05.  The largest\n" ,
   "color number you define will be the last color index used; if more line colors\n" ,
   "are needed, they will cycle back to color 01.  If you leave a gap in the\n" ,
   "numbering (e.g., you define color 07 but not 05 or 06), then the undefined\n" ,
   "colors will be fuliginous.\n" ,
   "\n" ,
   "[Dec 2007] You can now specify the colors by using the special names 'green',\n" ,
   "'red', 'blue', 'gold', 'pink', and 'purple'.  Also, by using 3 or 6 digit\n" ,
   "hexadecimal notation as in '#8888aa' for a blueish-gray color (6 digits) or\n" ,
   "'#0ac' for a cyanish color (3 digits).  These are intended to make life a\n" ,
   "little simpler.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_1DPLOT_THIK (editable)\n" ,
   "--------------------------\n" ,
   "This numeric variable lets you control the thickness of lines drawn in the\n" ,
   "1dplot-style windows.  The units are in terms of the width of the entire\n" ,
   "plot, so that a value of 0.005 is 'reasonable'; 0.01 will be fairly thick\n" ,
   "lines, and 0.02 will be too thick for most purposes.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_1DPLOT_IMSIZE\n" ,
   "----------------------------\n" ,
   "This numeric variable sets the image size (in pixels across the screen) of\n" ,
   "images saved via the '-png' or '-jpg' options of 1dplot, or images saved\n" ,
   "when giving the '.png' or '.jpg' from 1dplot-style graphs.  The default\n" ,
   "value is 1024.  Values over 2048 may give odd looking results, and will\n" ,
   "be palpably slower to render.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_1DPLOT_BOXSIZE\n" ,
   "-----------------------------\n" ,
   "This variable sets the size of the boxes that are plotted with the 1dplot\n" ,
   "'-box' option.  The units are in terms of the width of the entire plot;\n" ,
   "a value of 0.006 is the default.  The largest allowed value is 0.02 and\n" ,
   "the smallest is 0.001.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_1DPLOT_RENDEROLD\n" ,
   "-------------------------------\n" ,
   "On 30 Apr 2012, a new method of rendering the 1dplot graph into an X11\n" ,
   "window was introduced -- this method uses 'anti-aliasing' to produce\n" ,
   "smoother lines and characters.  If you want the old coarser-looking\n" ,
   "rendering method, set this variable to YES.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_1DPLOT_RANBOX\n" ,
   "----------------------------\n" ,
   "When using '-noline' in 1dplot (to get a cloud of points without\n" ,
   "lines), and when there are multiple time series being plotted with\n" ,
   "option '-one', the normal state of affairs is that later time series\n" ,
   "boxes get plotted on top of earlier boxes.  If there are a lot of\n" ,
   "points, then the earlier boxes get completely obscured.  Setting\n" ,
   "this variable to YES means that the boxes will be plotted in a\n" ,
   "pseudo-random order, so that each color/shape of box has a chance\n" ,
   "to be seen in the cloud of data.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_SIEMENS_INTERLEAVE\n" ,
   "---------------------------------\n" ,
   "The old (pre-DICOM) Siemens .ima image mosaic format sometimes stores the\n" ,
   "multi-slice EPI data in correct spatial order and sometimes in correct\n" ,
   "time acquisition order.  In the latter case, the images are stored in\n" ,
   "a spatially-interleaved fashion.  As far as I know, there is no way to\n" ,
   "tell this from the .ima file header itself.  Therefore, if you have a\n" ,
   "problem with such files, set this variable to YES to un-interleave the\n" ,
   "images when to3d reads them.  One way to tell if the images need to be\n" ,
   "un-interleaved is to do\n" ,
   "  afni -im fred.ima\n" ,
   "then look at the images in an Axial image viewer.  If the slices make up\n" ,
   "a single coherent volume, then they are NOT interleaved.  If the slices\n" ,
   "look like they make up 2 separate brain volumes, then they need to be\n" ,
   "un-interleaved, and you need to set this variable to YES.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_TRY_DICOM_LAST\n" ,
   "-----------------------------\n" ,
   "When to3d tries to read an image file, it guesses the format from the\n" ,
   "filename.  However, this doesn't always work.  In particular, DICOM files\n" ,
   "don't have any fixed filename suffix or prefix.  If all else fails, to3d\n" ,
   "normally tries to read a file as a DICOM file, and as a last resort, as\n" ,
   "a flat binary file.  However, if a file is NOT a DICOM file, the DICOM\n" ,
   "reading function will print out a lot of error messages, since there is\n" ,
   "also no standard internal marker in all DICOM files that identify them.\n" ,
   "Most people don't like all these messages (perhaps hundreds per file),\n" ,
   "even if the program then successfully reads their flat binary files.\n" ,
   "\n" ,
   "If this YES/NO variable is set to YES, then the normal last-resort order\n" ,
   "of reading described above is reversed.  If to3d can't read the file any\n" ,
   "other way, it will try it as a flat binary file.  If that fails, then\n" ,
   "DICOM will be the ultimate resort, instead of being the penultimate\n" ,
   "resort that it is by default.  This may help elide some error messages.\n" ,
   "However, if you have a DICOM file that is exactly 131072 bytes long\n" ,
   "(for example), then it will be interpreted as a headerless 256x256 image\n" ,
   "of shorts, instead of whatever it really is.  So only set this variable\n" ,
   "to YES if necessary!\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_THRESH_BIGSTEP\n" ,
   "-----------------------------\n" ,
   "The AFNI threshold sliders (in the Define Overlay control panels and the\n" ,
   "Render Dataset plugins) are divided into 10000 steps from bottom to top.\n" ,
   "If you click in the trough or use the PageUp/PageDown keys, the default\n" ,
   "action is to move the slider 10 of the steps at once.  (The up and down\n" ,
   "arrow keys move 1 step at a time.)  You can change this big step from the\n" ,
   "default of 10 to any value between 1 and 1000 by setting this environment\n" ,
   "variable; for example\n" ,
   "  setenv AFNI_THRESH_BIGSTEP 100\n" ,
   "will move the slider 1% of its height per PageUp/PageDown key or mouse click.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_THRESH_AUTO (editable)\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then whenever you switch overlay datasets,\n" ,
   "the function threshold slider will automatically change to some value that may\n" ,
   "be appropriate for the values in the new dataset.  [This is for Ziad!]\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_THRESH_TOP_EXPON\n" ,
   "-------------------------------\n" ,
   "This variable defines the top value for the '**' setting underneath the Overlay\n" ,
   "threshold slider.  By default, this value is 4, but you can change that to 5\n" ,
   "or 6 with this variable.  [This is for Phil Kohn]\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_SNAPFILE_PREFIX\n" ,
   "------------------------------\n" ,
   "Image files saved with the \"snapfile\" (or \"record to file\") by default have\n" ,
   "filenames of the form \"S_000001.ppm\".  The prefix \"S\" can be altered by\n" ,
   "setting this environment variable; for example,\n" ,
   "  setenv AFNI_SNAPFILE_PREFIX Elvis\n" ,
   "will save snapfiles with names like \"Elvis_000666.ppm\".  You can view snapfiles\n" ,
   "with the \"aiv\" (\"AFNI Image Viewer\") utility, the \"xv\" program, or many other\n" ,
   "Unix utilities.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STARTUP_WARNINGS\n" ,
   "-------------------------------\n" ,
   "When the interactive AFNI program starts, it may pop up warnings about the\n" ,
   "programming environment for which it was compiled.  At this time, there are\n" ,
   "two such warning messages possible:\n" ,
   "  LessTiff: AFNI will work with LessTif, but works better with Motif.\n" ,
   "  Button-3: On Solaris 2.8, Button-3 popup menus don't work quite properly.\n" ,
   "If you are tired of seeing these messages, set AFNI_STARTUP_WARNINGS to NO.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_1D_TIME\n" ,
   "----------------------\n" ,
   "If this YES/NO variable is set to YES, then when a multicolumn .1D file is\n" ,
   "read in as an AFNI dataset, the column variable is taken to be time, and\n" ,
   "a time-dependent dataset is created.  The default is to create a bucket\n" ,
   "dataset.  Note that each row is taken to be a separate 'voxel'.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_1D_TRANOUT\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, it affects the way 1D datasets are\n" ,
   "written out from 3d* programs that are being used to process 1D files\n" ,
   "as AFNI dataset.  If this variable is YES, AND if the output dataset\n" ,
   "prefix ends in '.1D' or is the string '-' (meaning standard output),\n" ,
   "then the output 1D file will be transposed and written so that the\n" ,
   "time axis goes down the columns instead of across them.  If this\n" ,
   "variable is NO, then the standard AFNI 1D-to-3D dataset convention is\n" ,
   "followed: each row is a single voxel time series.  Example:\n" ,
   "  3dDetrend -polort 1 -prefix - 1D:'3 4 5 4 3'\\'\n" ,
   "will write to the screen\n" ,
   "           -0.8\n" ,
   "            0.2\n" ,
   "            1.2\n" ,
   "            0.2\n" ,
   "           -0.8\n" ,
   "if AFNI_1D_TRANOUT is YES, but will write\n" ,
   " -0.8 0.2 1.2 0.2 -0.8\n" ,
   "to stdout if AFNI_1D_TRANOUT is NO.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_1D_TIME_TR\n" ,
   "-------------------------\n" ,
   "If this is set, and AFNI_1D_TIME is YES, then this determines the TR (in\n" ,
   "seconds) of a .1D file read in as an AFNI dataset.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_1D_ZERO_TEXT\n" ,
   "---------------------------\n" ,
   "If this is set to 'YES', then non-commented text gets set to 0\n" ,
   "instead of causing a read failure. The default setting is 'No'\n" ,
   "\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_3D_BINARY\n" ,
   "------------------------\n" ,
   "If this is set to YES, then .3D files are written by AFNI programs in\n" ,
   "binary, rather than the default text mode.  Binary files will be more\n" ,
   "compact (usually) and faster to read in.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_MAX_OPTMENU (editable)\n" ,
   "--------------------------\n" ,
   "This variable (default=255) sets the maximum number of entries allowed\n" ,
   "in an AFNI \"option menu\" -- these are the buttons that popup a menu\n" ,
   "of values from which to choose, and which also let you popup a text\n" ,
   "list chooser by right-clicking in the menu's label.  (Example: the\n" ,
   "sub-brick option menus \"Anat\", \"Func\", \"Thr\" on the \"Define Overlay\"\n" ,
   "control panel.)\n" ,
   "\n" ,
   "Some computer systems may crash when an option menu gets too big.\n" ,
   "That's why there is a default limit in AFNI of 255 entries.  However,\n" ,
   "if you have a bucket dataset with more than 255 sub-bricks, this makes\n" ,
   "it impossible to view the later data volumes.  If this problem arises,\n" ,
   "you can try setting this environment variable to a larger limit (e.g.,\n" ,
   "99999 would take care of all currently imaginable cases).\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_VALUE_LABEL_DTABLE\n" ,
   "---------------------------------\n" ,
   "This variable sets a filename that holds a default value-label table\n" ,
   "for the Draw Dataset plugin.  A sample file is shown below:\n" ,
   "\n" ,
   "   <VALUE_LABEL_DTABLE\n" ,
   "     ni_type=\"2*String\"\n" ,
   "     ni_dimen=\"3\" >\n" ,
   "    \"1\" \"elvis\"\n" ,
   "    \"2\" \"presley\"\n" ,
   "    \"3\" \"memphis\"\n" ,
   "   </VALUE_LABEL_DTABLE>\n" ,
   "\n" ,
   "The 'ni_dimen' attribute is the number of value-label pairs; in the\n" ,
   "  above example it is 3.\n" ,
   "Each value-label pair is shown on a separate line.  The values and\n" ,
   "  labels are strings, enclosed in quote characters.  There should be\n" ,
   "  exactly as many value-label pairs as specified in 'ni_dimen'.\n" ,
   "If you really want to put a double quote character \" in a label,\n" ,
   "  you can enclose the label in single forward quotes ' instead.\n" ,
   "When you 'Save' a drawn dataset from the Draw Dataset plugin, the\n" ,
   "  .HEAD file attribute VALUE_LABEL_DTABLE will contain a table in\n" ,
   "  exactly this XML-based format.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STROKE_THRESHOLD (editable)\n" ,
   "-------------------------------\n" ,
   "If you press Button-1 in an image window, and then move it left or\n" ,
   "right (\"stroke it\") before releasing the button, the grayscale mapping\n" ,
   "changes in the same way as if you pressed the 'c' button up and the 'b'\n" ,
   "button down.  This variable sets the threshold for the stroking movement\n" ,
   "size in pixels; a movement of this number of pixels rightwards corresponds\n" ,
   "to one press of 'c' up and 'b' down, while a leftwards movement is like\n" ,
   "one press of 'c' down and 'b' up.  Larger movements make larger adjustments.\n" ,
   "\n" ,
   "A larger threshold makes the stroking less sensitive; a smaller threshold\n" ,
   "makes it more sensitive.  The value you choose will depend on your personal\n" ,
   "taste.  The default is 32 pixels, which is the flavor I prefer.  If you set\n" ,
   "this variable to 0, then the stroking function is disabled.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STROKE_AUTOPLOT (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is set to YES, then the graymap-versus-data value plot\n" ,
   "(manually controlled by \"Display Graymap Plot\") is automatically popped\n" ,
   "up when the grayscale mapping is altered by using the stroking feature\n" ,
   "described above.  When the stroke is finished, the plot will pop down.\n" ,
   "N.B.: when the 'Draw Dataset' plugin is active, this option is disabled\n" ,
   "temporarily.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_IMAGE_MINTOMAX (editable)\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will be set\n" ,
   "to the \"Min-to-Max\" state rather than the default \"2%-to-98%\" state\n" ,
   "when they are opened.  If you set this in the \"Edit Environment\"\n" ,
   "control, it only affects image viewer windows opened after that point.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_CLIPPED (editable)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will be set\n" ,
   "to the \"Clipped\" state rather than the default \"2%-to-98%\" state\n" ,
   "when they are opened.  If you set this in the \"Edit Environment\"\n" ,
   "control, it only affects image viewer windows opened after that point.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_CLIPBOT (editable)\n" ,
   "----------------------------\n" ,
   "In the \"Clipped\" mode, the top level of the grayscale image is computed\n" ,
   "as 3.11 times the 'cliplevel' as computed by the 3dClipLevel algorithm.\n" ,
   "The bottom level is then a fraction of this top level -- by default, the\n" ,
   "fraction is 0.25, but you can change this default by setting this variable\n" ,
   "to a value between 0.0 and 0.5 (inclusive).  You can also use variable\n" ,
   "AFNI_IMAGE_CLIPTOP to scale the default top level -- this variable can take\n" ,
   "values between 0.6 and 1.9 (inclusive) -- the default is 1.0.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_IMAGE_GLOBALRANGE (editable)\n" ,
   "--------------------------------\n" ,
   "AFNI_IMAGE_GLOBALRANGE can be set to SLICE (default), VOLUME (SUBBRICK),\n" ,
   "or DSET. The GUI applies the lookup table to color the underlay with the\n" ,
   "range determined from the slice, sub-brick or the whole multi-sub-brick\n" ,
   "dataset,respectively, depending on this variable. Besides the .afnirc file,\n" ,
   "the GUI allows changes from the environment plugin menu, the right-click\n" ,
   "menu on the image viewer colorbar or by typing Control-m in an image viewer.\n" ,
   "The Control-m cycles among the global range types.\n" ,
   "\n" ,
   "Previous YES/NO definitions for this variable correspond to VOLUME and\n" ,
   "SLICE respectively and will continue to work as before. The lower right\n" ,
   "corner of the image viewer shows the current range setting:\n" ,
   "(2%-98%/Min2Max, Vol, Dset)\n" ,
   "\n" ,
   "If this variable is set to YES/VOLUME/SUBBRICK, then the image\n" ,
   "viewer windows will be set to scale the bottom gray level to the\n" ,
   "minimum value in the 3D volume and the top gray level to the maximum\n" ,
   "value in the 3D volume. Setting the variable to DSET similarly sets\n" ,
   "the minimum and maximum based on the range of the whole dataset.\n" ,
   "\n" ,
   "This setting overrides the \"Min-to-Max\" and \"2%-to-98%\" settings in\n" ,
   "the \"Disp\" control panel.  This setting also applies to all image\n" ,
   "viewers.  If you set this in the \"Edit Environment\" control, it will\n" ,
   "apply to all open image viewers immediately, as well as to any image\n" ,
   "viewers opened later.\n" ,
   "  It is important to realize that if you use the 'Display Range'\n" ,
   "popup to set the bot-top range for the grayscale, these settings\n" ,
   "will override the global range UNTIL you switch datasets or switch\n" ,
   "sub-bricks within a dataset.  At that point, the global range for\n" ,
   "the new volume will be enforced.  This change can be confusing.\n" ,
   "Therefore, the info label beneath the slider shows the source of\n" ,
   "the bot-top grayscale values:\n" ,
   "  [2%-98%]  = from the 2% to 98% points on the slice histogram\n" ,
   "  [Min2Max] = from the 0% to 100% points on the slice histogram\n" ,
   "  [Vol]     = set from the entire volume min and max values\n" ,
   "  [Dset]    = set from the min and max across all subbricks of a dataset\n" ,
   "  [User]    = set by the user from 'Display Range'\n" ,
   "  absent    = not applicable (e.g., underlay image is RGB)\n" ,
   "The popup 'hint' for the grayscale bar shows the current values\n" ,
   "of the bot-top range, if you want to know what numbers correspond\n" ,
   "to the image at which you are gazing so fondly.\n" ,
   "  Finally, note that when a montage is built, the number-to-grayscale\n" ,
   "algorithm is applied to each slice separately, and then the montage\n" ,
   "is assembled.  For [2%-98%] and [Min2Max], this fact means that each\n" ,
   "slice will (probably) have a separate grayscale conversion range.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DRAW_UNDOSIZE (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets the size (in units of Megabytes) of the Undo/Redo\n" ,
   "buffer in the Draw Dataset plugin.  The default value is 6.  If you\n" ,
   "are short on memory, you could set this to 1.  If you are running out\n" ,
   "of undo levels, you could set this to a larger value; however, this\n" ,
   "would only be needed if you are drawing huge 3D swaths of data at a\n" ,
   "time (e.g., using the 3D sphere option with a large radius).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DRAW_THRESH\n" ,
   "----------------------------\n" ,
   "This variable controls the clipping threshold for converting atlas\n" ,
   "regions into ROIs in the Draw Dataset plugin. The default value is 49\n" ,
   "percent unless set by this variable as a percentage greater than 0.0\n" ,
   "and at most 100.0 percent\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_SPEECH (editable)\n" ,
   "---------------------\n" ,
   "If this YES/NO variable is set to NO, then the AFNI speech synthesis\n" ,
   "is disabled.  At the current time (Nov 2003), only the Mac OS X 10.3\n" ,
   "version of AFNI uses speech synthesis in any way.  And that's just\n" ,
   "for fun.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_IMAGE_ZEROCOLOR\n" ,
   "------------------------------\n" ,
   "This variable, if set to the string name of one of the colors in the\n" ,
   "color chooser menus (e.g., \"Black\"), will result in voxels whose value\n" ,
   "is 0 being set to this color in the slice viewing windows (except when\n" ,
   "viewing RGB images).  The main function is to avoid having to use the\n" ,
   "\"Choose Zero Color\" menu all the time, especially when you use the \"Swap\"\n" ,
   "feature to invert the grayscale map (e.g., to make a T2 weighted image\n" ,
   "look sort of like a T1 weighted image).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MPEG_DATASETS\n" ,
   "----------------------------\n" ,
   "This variable can be used to allow MPEG files to be read in as AFNI datasets.\n" ,
   "Such datasets are inherently 3 dimensional.  How they will be organized inside\n" ,
   "AFNI depends on the setting of this variable.  The options are:\n" ,
   "  SPACE = the frame sequence number will be the z-axis\n" ,
   "  TIME  = the frame sequence number will be the time axis\n" ,
   "  NO    = MPEG files won't be read as AFNI datasets\n" ,
   "          (they can still be read as images into to3d, aiv, etc.)\n" ,
   "If this variable is NOT set to anything, then it is the same as SPACE.\n" ,
   "\n" ,
   "MPEG filenames input to AFNI programs (as sources of images or as datasets)\n" ,
   "must end in \".mpg\", \".MPG\", \".mpeg\", or \".MPEG\".  MPEG datasets will be read\n" ,
   "so that the individal images are displayed in an Axial image window.\n" ,
   "\n" ,
   "Note that decoding a long .mpg file that happens to be in your directory\n" ,
   "can slow down the AFNI startup considerably!\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_MPEG_GRAYIZE\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then MPEG files read into AFNI,\n" ,
   "to3d, or aiv will be converted to grayscale, even if the images in\n" ,
   "the movie are in color.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_VIDEO_DELAY (editable)\n" ,
   "--------------------------\n" ,
   "This is the number of milliseconds the AFNI waits between drawing new\n" ,
   "images when the 'V' or 'v' keys are pressed in an image (or graph)\n" ,
   "window.  The default value is 1, which is faster than video can be\n" ,
   "displayed anyway.  Set this to a larger value (e.g, 100) to slow down\n" ,
   "the image redraw rate.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_ENTROPY (editable)\n" ,
   "----------------------------\n" ,
   "If this numeric variable is set, this is the entropy of an image below\n" ,
   "which the 2%-98% image scaling will be disabled, and min-to-max will\n" ,
   "be used instead.  The units are bits/byte; a useful threshold seems to\n" ,
   "be in the range (0.2,0.5).  For images that only have a few values\n" ,
   "different from 0, the 2%-98% scaling can produce weird artifacts.  Such\n" ,
   "images will also have a very low entropy.  Since this variable can be\n" ,
   "changed interactively from the Edit Environment controls, you can play\n" ,
   "with it to see how it affects your images.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_LOGO16 (etc.)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then the 'AFNI' background logo used in\n" ,
   "the controller and image windows will be enabled.  By default, it is off.\n" ,
   "You can control the colors of this logo by the following variables:\n" ,
   "  AFNI_LOGO16_FOREGROUND_x\n" ,
   "  AFNI_LOGO16_BACKGROUND_x\n" ,
   "where 'x' is 'A', 'B', 'C', etc., for the various controller labels.\n" ,
   "If AFNI_LOGO16_BACKGROUND_x isn't set, then AFNI_LOGO16_BACKGROUND\n" ,
   "(with no suffix) is checked as an alternate.  The values of these\n" ,
   "variables should be the names of one of the labels on the color chooser\n" ,
   "menus (e.g., the \"Xhairs Color\" menu).  You can use these variables to\n" ,
   "make the windows for the various controllers somewhat distinct in\n" ,
   "appearance.  If these color variables are not set at all, then AFNI\n" ,
   "uses some colors of my choosing for this purpose.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_COLORIZE_CONTROLLER\n" ,
   "----------------------------------\n" ,
   "If this variable is set to YES, then the background of the AFNI controllers\n" ,
   "and image viewers will be colorized.  The default state is that they are not\n" ,
   "colorized.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_THRESH_LOCK (editable)\n" ,
   "--------------------------\n" ,
   "This variable can be used to lock the Define Overlay threshold sliders\n" ,
   "together.  There are three possibilities:\n" ,
   "  NO (the default) => each controller's slider is independent\n" ,
   "  VALUE            => the numerical value on each slider will be the same\n" ,
   "  P-VALUE          => the p-value for each slider will be the same\n" ,
   "This locking only applies to AFNI controllers that are Lock-ed together\n" ,
   "(cf. AFNI_ALWAYS_LOCK and the Define Datamode->Lock menu).  If p-values\n" ,
   "are locked, this lock will also only apply to controllers whose current\n" ,
   "Threshold sub-brick has a known statistical distribution.\n" ,
   "\n" ,
   "When you drag a locked threshold slider, the other one will only change\n" ,
   "when you release the mouse button -- they won't slide in tandem, but will\n" ,
   "just jump to the final value.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_LOCK (editable)\n" ,
   "------------------------\n" ,
   "If this variable is set to YES, then the Define Overlay color bars\n" ,
   "(the \"pbars\") of AFNI controllers that are Lock-ed together will be\n" ,
   "coordinated.  Changes to one locked pbar will be reflected in the\n" ,
   "others immediately.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_AUTO  (or AFNI_CMAP_AUTO)\n" ,
   "------------------------\n" ,
   "If this variable is set to NO, then the automatic color bar switching\n" ,
   "(that was introduced by Ziad Saad) will be turned off.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PBAR_THREE\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the 'continuous' colorscale\n" ,
   "color bar in the AFNI GUI will have 3 panes rather than 1.  The\n" ,
   "middle pane will have the continuously variable colorscale loaded.\n" ,
   "The upper and lower panes will have the upper and lower colors loaded,\n" ,
   "OR they can be turned off.  The sashes that controls the position and\n" ,
   "size of the middle pane can be moved to separately set the top and bottom\n" ,
   "of the color-ization scale (rather than make bottom = -top or bottom = 0,\n" ,
   "as with the 1 pane color bar).\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_TICK (editable)\n" ,
   "------------------------\n" ,
   "If this variable is set to NO, then the tick marks in the continuous\n" ,
   "colorscale bar in the AFNI GUI will not have tick marks added on the\n" ,
   "left and right edges. You can also set the number of tick marks this\n" ,
   "way, if you don't want the default number (9).  The maximum number\n" ,
   "of tick marks allowed is 63, which should be enough.\n" ,
   "* If this variable is NOT set to NO (or 0), then 9 tick marks will\n" ,
   "  be drawn in the image window intensity bar as well (dividing it\n" ,
   "  into 10 intervals).  For this bar, the number of tick marks is\n" ,
   "  fixed: it is either 0 or 9.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_PBAR_FULLRANGE  [03 Jun 2014]\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then the color pbar in Define Overlay\n" ,
   "will reflect the range set by the user for the colorization process.  At\n" ,
   "some point, this feature will become the default, and then you'll have\n" ,
   "to set this variable to NO to get the old behavior -- where the range\n" ,
   "set by the user is shown only at the bottom right of the Define Overlay\n" ,
   "panel, and it then multiplies the independently set top value of the\n" ,
   "pbar to get the colorization scale.  In the new method, the top value of\n" ,
   "the pbar cannot be set by the user independently of the range (or\n" ,
   "autorange) parameter.  The intention of this change is to make the\n" ,
   "number -> colors process somewhat more blatant.  This variable's value\n" ,
   "must be set at startup (e.g., in .afnirc), and changing it later will\n" ,
   "have no effect. Also note that if this variable is YES, then setting\n" ,
   "AFNI_PBAR_LOCK to YES will imply AFNI_RANGE_LOCK is YES as well.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_RANGE_LOCK (editable)\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the OLay range values of\n" ,
   "different AFNI controllers that are Lock-ed together will be\n" ,
   "coordinated.  Changes in one controller will be reflected in\n" ,
   "the others immediately.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_ZOOM_NN (editable)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will use\n" ,
   "nearest neighbor interpolation for zooming.  The default is linear\n" ,
   "interpolation, which produces smoother-looking images.  However, some\n" ,
   "people want to see the actual data values represented in the window,\n" ,
   "not some fancy-schmancy interpolated values designed to look good but\n" ,
   "in fact making a mockery of a sham of a mockery of a travesty of two\n" ,
   "mockeries of a sham of reality.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISABLE_CURSORS\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then AFNI will not try to change the X11\n" ,
   "cursor shape.  This feature is available because it seems that sometimes\n" ,
   "particular X11 installations choices of cursor and AFNI's choices don't\n" ,
   "work together well.  If you have unpleasant cursors in AFNI (e.g., an X),\n" ,
   "try setting this variable to YES.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SLAVE_FUNCTIME (editable)\n" ,
   "-----------------------------\n" ,
   "When the underlay and overlay datasets both are time-dependent, switching\n" ,
   "the time index will change both the underlay and overlay sub-bricks.  If\n" ,
   "you want the time index control to change ONLY the underlay sub-brick,\n" ,
   "then set this variable to NO.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SLAVE_THROLAY\n" ,
   "----------------------------\n" ,
   "This variable allows you to control the INITIAL setting of the widgets\n" ,
   "that slave (or not) the threshold index to the overlay index.  (These\n" ,
   "widgets are on the 'Index' right-click popup chooser and on the threshold\n" ,
   "slider right-click popup menu.)  The values you can set for this variable,\n" ,
   "and their effects, are listed below (not case sensitive):\n" ,
   "   'OLay'    *or*  '=='  *or*  '0'  ==> threshold index = overlay index\n" ,
   "   'OLay+1'  *or*  '+1'  *or*  '1'  ==> threshold index = overlay index + 1\n" ,
   "   ANYTHING ELSE                    ==> threshold index is free and wild\n" ,
   "This variable replaces the 2 variables listed below.  Again, this only\n" ,
   "controls the INITIAL setting of the widgets -- you can change them in the\n" ,
   "AFNI GUI later at any time.  Setting this variable after AFNI starts\n" ,
   "(e.g., from plugout_drive) will have little discernable effect.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_FUNC_ALPHA\n" ,
   "-------------------------\n" ,
   "You can set this variable to the string 'Linear' or 'Quadratic', which\n" ,
   "will set the initial state of the functional overlay Alpha control\n" ,
   "(which by default will start in the 'Off' mode). If you are naive to the\n" ,
   "hidden ways of the AFNI, this control is on the right-click popup menu\n" ,
   "attached to the label just above the 'Define Overlay' threshold slider.\n" ,
   "\n" ,
   "If Alpha is turned on, then the opacity of the overlay ranges from 1 for\n" ,
   "above-threshold pixels down to the 'Floor' value (default is 0) -- however,\n" ,
   "pixels with the threshold variable exactly equal to zero will not get\n" ,
   "the Floor value of opacity, but will get alpha=0. Note that the alpha\n" ,
   "(opacity) level at the pixel-wise level is scaled by the global opacity\n" ,
   "'1-9' control on the right side of the image viewer, where '9' means that\n" ,
   "above-threshold pixels will be 100% opaque, and '6' means they will be\n" ,
   "6/9=67% opaque -- and lower opacity pixels will be have their opacity scaled\n" ,
   "down by the same factor.\n" ,
   "\n" ,
   "The variable-opacity overlay usually looks better (less blocky) if you open\n" ,
   "'Define Datamode' and set the resampling modes for the OLay and Stat to 'Li'\n" ,
   "(linear) rather than the default 'NN' (you can also do this via variables\n" ,
   "AFNI_resam_func and AFNI_resam_thr).  Also when Alpha is turned on, the\n" ,
   "above-threshold pixel regions are outlined in black, unless you set the\n" ,
   "AFNI_EDGIZE_OVERLAY environment variable to NO -- this variable can be set\n" ,
   "interactively via the 'EditEnv' pseudo-plugin.  You can alter the color\n" ,
   "used for the outline by setting the AFNI_EDGIZE_COLOR variable; for example,\n" ,
   "  afni -DAFNI_EDGIZE_COLOR=hotpink -DAFNI_FUNC_ALPHA=Linear\n" ,
   "\n" ,
   "The outline is done over the pixels immediately OUTSIDE the above-threshold\n" ,
   "regions, in the overlay image as interpolated to the underlay resolution.\n" ,
   "If the underlay is on a coarse matrix (e.g., native EPI), these outlines\n" ,
   "will look terrible -- you can alter the underlay display grid dimension in\n" ,
   "'Define Datamode' using the control 'Warp ULay on Demand'.\n" ,
   "\n" ,
   "Please note that the ALpha features described above only apply if the\n" ,
   "color scale is in the 'continuous' mode ('**'), not in the discrete\n" ,
   "panes mode. Sorry about this, but that's the situation for the nonce.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SLAVE_THRTIME       *** THIS VARIABLE IS NO LONGER USED ***\n" ,
   "----------------------------\n" ,
   "When the underlay and overlay datasets both are time-dependent, switching\n" ,
   "the time index will change both the underlay and overlay sub-bricks, but\n" ,
   "NOT the threshold sub-brick.  If you want the time index control to change\n" ,
   "the threshold sub-brick, then set this variable to YES.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_SLAVE_BUCKETS_TOO   *** THIS VARIABLE IS NO LONGER USED ***\n" ,
   "--------------------------------\n" ,
   "Set this to YES if you want to make changing the time index in the underlay\n" ,
   "dataset change the sub-brick index in the overlay dataset even when the\n" ,
   "overlay is a 'bucket' dataset without a time axis.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_CLICK_MESSAGE\n" ,
   "----------------------------\n" ,
   "If this veriable is set to NO, then the string\n" ,
   "  [---------------]\n" ,
   "  [ Click in Text ]\n" ,
   "  [ to Pop Down!! ]\n" ,
   "will NOT be appended to the very first popup message window that AFNI\n" ,
   "creates.  This message was added because some people do not realize\n" ,
   "that the way to get rid of these popups (before they vanish on their\n" ,
   "own after 30 seconds) is to click in them.  You know who you are.\n" ,
   "However, if you are advanced enough to read this file, then you probably\n" ,
   "aren't one of THEM.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_X11_REDECORATE (editable)\n" ,
   "-----------------------------\n" ,
   "By default, AFNI tries to change some of the \"decorations\" (control buttons)\n" ,
   "on some of the windows it creates (e.g., removing resize handles).  If you\n" ,
   "don't want this to happen, set this variable to NO.  This variable only\n" ,
   "has an effect on windows created AFTER it is set, so if you change this\n" ,
   "interactively in the Edit Environment plugin, it will not affect existing\n" ,
   "windows.  Normally, you would want to set this in your .afnirc file.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_SAVESQUARE\n" ,
   "-------------------------------\n" ,
   "YES/NO: Forces images (from the image view \"Save\" button) to be saved with\n" ,
   "square pixels, even if they are stored with nonsquare pixels.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_BUCKET_LABELSIZE\n" ,
   "-------------------------------\n" ,
   "THIS VARIABLE HAS BEEN REMOVED FROM AFNI.\n" ,
   "\n" ,
   "Formerly, it was used to set the width of the \"ULay\", \"OLay\", and \"Thr\" menu\n" ,
   "choosers on the \"Define Overlay\" control panel.  As of 03 May 2005, AFNI now\n" ,
   "calculates the default width based on the longest sub-brick label input\n" ,
   "for each dataset.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_MAX_1DSIZE\n" ,
   "-------------------------\n" ,
   "Sets the maximum size (in bytes) of each 1D file that will be automatically\n" ,
   "loaded when AFNI starts.  The default is 123 Kbytes.  The intention is to\n" ,
   "prevent loading of very large files that are not intended to be used for\n" ,
   "graphing/FIMming purposes.  If you set this to 0, you get the default size.\n" ,
   "If you set this to 1, no 1D files will be read at the AFNI GUI startup.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_TITLE_LABEL2 (editable)\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is YES, then the AFNI window titlebars will show\n" ,
   "the 'label2' field from the AFNI dataset .HEAD file, rather than the\n" ,
   "dataset filename.  If the label2 field is set to a nontrivial value,\n" ,
   "that is.  You can set the label2 field with the 3drefit command.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_SKIP_ONETIME_POPUPS\n" ,
   "----------------------------------\n" ,
   "Some AFNI popup messages are 'onetime' -- that is, they show up only\n" ,
   "once for each user.  This capability is there to announce changes that\n" ,
   "should be noticed.  Each onetime message is logged into a file named\n" ,
   ".afni.recordings in the user's home directory, and if a record of such\n" ,
   "a message is found therein, it will not be shown again.  To skip\n" ,
   "showing these messages at all, even once, set this variable to YES.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_SHOW_SURF_POPUPS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI receives surface\n" ,
   "nodes, triangles or normals from suma, a popup message will be displayed.\n" ,
   "Otherwise, the message will be send to stderr (on the terminal window).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_KILL_SURF_POPUPS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI receives surface\n" ,
   "nodes, triangles or normals from suma, no messages will be displayed,\n" ,
   "either in a popup or stderr.  Note that if errors occur, popups will\n" ,
   "still be shown; this just turns off the normal information messages.\n" ,
   "N.B.: If AFNI_SHOW_SURF_POPUPS is YES, then it wins over\n" ,
   "      AFNI_KILL_SURF_POPUPS being YES.  If neither is set, then\n" ,
   "      messages are displayed to stderr.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_EDGIZE_OVERLAY (editable)\n" ,
   "-----------------------------\n" ,
   "If set to YES, then the color overlays in the image windows will only\n" ,
   "have their edge pixels displayed.  Edge-izing takes place in 2 slightly\n" ,
   "different ways, depending on the Alpha setting in the AFNI interface\n" ,
   "(cf. variable AFNI_FUNC_ALPHA, above):\n" ,
   " * If Alpha is off, then edges shown comprise the outermost above-threshold\n" ,
   "   voxels. The edge color is just the color that these voxels normally\n" ,
   "   get from the overlay sub-brick values. In this mode, the 'blobs' are\n" ,
   "   hollowed out, leaving only the edges.\n" ,
   " * If the Alpha is on, the edges shown comprise the voxels just OUTSIDE the\n" ,
   "   outermost above-threshold voxels -- so that all the above-threshold\n" ,
   "   voxels are visible. Also, the edge color is solid black (or can be set\n" ,
   "   via variable AFNI_EDGIZE_COLOR). The 'blobs' are NOT hollowed out.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_EDGIZE_COLOR (editable)\n" ,
   "---------------------------\n" ,
   "Defines the color used for the edge outline of above threshold regions,\n" ,
   "when Alpha is turned on.  See AFNI_FUNC_ALPHA for more information.\n" ,
   "This variable has no effect if Alpha is turned off.  Colors can be\n" ,
   "set via X11 names (e.g., \"yellow\", \"hotpink\", \"#1188ff\" ).\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_NIFTI_DEBUG (editable)\n" ,
   "--------------------------\n" ,
   "This integral variable determines the debug level used by the nifti_io\n" ,
   "library functions.  If set to 0, only errors are reported by the library.\n" ,
   "The maximum debug level used is currently 4.  Note that if this is changed\n" ,
   "from within AFNI, a 'Rescan: This' operation should probably be performed,\n" ,
   "which will force a re-reading of the datasets and so force an elicitation\n" ,
   "of the NIfTI debug messages (for .nii files, that is).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_NIFTI_TYPE_WARN\n" ,
   "------------------------------\n" ,
   "AFNI converts 'byte' NIFTI data types to 'short', and 'int' to 'float'.\n" ,
   "Programs that do so will issue a warning each time such a conversion is\n" ,
   "carried out. When this variable is set to NO, as it is now by default,\n" ,
   "each program would issue just one warning at the first occurrence of a type conversion.\n" ,
   "Set this variable to YES if you want to see all conversion warnings.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_DEBUG_PLUG_VOL2SURF\n" ,
   "--------------------------\n" ,
   "Use this interger variable to initialize the debug level in plug_vol2surf.\n" ,
   "The current set of acceptable values is {0..5}.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_NIFTI_NOEXT\n" ,
   "--------------------------\n" ,
   "When writing a '.nii' (or '.nii.gz') file from an AFNI program, normally\n" ,
   "a NIfTI-1.1 extension field with some extra AFNI header information is\n" ,
   "written into the output file.  If you set this variable to YES, then\n" ,
   "this extension is not written, which will make the output be a 'pure'\n" ,
   "NIfTI-1.1 file.  Only use this if absolutely necessary.  You can also\n" ,
   "use the 'nifti_tool' program to strip extension data from a NIfTI-1.1\n" ,
   "dataset file.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_OVERLAY_ZERO (editable)\n" ,
   "---------------------------\n" ,
   "If set to YES, this variable indicates that voxels in the overlay dataset\n" ,
   "that have the numerical value of 0 will get colored when the Inten color\n" ,
   "scale on the Define Datamode panel indicates that 0 has a color that isn't\n" ,
   "\"none\".  The default way that AFNI works is NOT to colorize voxels that\n" ,
   "are 0, even if they should otherwise get a color.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: NIML_TRUSTHOST_xx\n" ,
   "---------------------------\n" ,
   "These environment variables ('xx' = '01', '02', ..., '99') set the names\n" ,
   "and/or addresses of external computer hosts to trust with NIML TCP/IP\n" ,
   "connections, which are how AFNI and SUMA communicate.  Should only be\n" ,
   "necessary to use these if you are using AFNI and SUMA on different\n" ,
   "machines.  Connections from machines not on the trusted list will be\n" ,
   "rejected, for the sake of security.  The 'localhost' or 127.0.0.1 address\n" ,
   "and local class B network 192.168.0.* addresses are always trusted.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_DONT_LOGFILE\n" ,
   "---------------------------\n" ,
   "Most AFNI programs write a copy of their command line to a file in your\n" ,
   "home directory named \".afni.log\".  If you do NOT want the log to be\n" ,
   "kept, set this environment variable to YES.  The purpose of the log\n" ,
   "is for you to be able to look back and see what AFNI commands you used\n" ,
   "in the past.  However, if you are doing a vast number of commands inside\n" ,
   "a script, the log file might eventually become gigantic (the Kevin Murphy\n" ,
   "effect).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ECHO_COMMANDLINE\n" ,
   "-------------------------------\n" ,
   "If this is YES, then the command line logger will also echo the command\n" ,
   "line of each AFNI program to stderr, as it starts up.  This feature\n" ,
   "is explicitly for Daniel Handwerker, and may well eventually be considered\n" ,
   "his ultimate claim to fame in the Macrocosmic All.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WRITE_NIML\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then AFNI .HEAD files will be written in\n" ,
   "the new NIML (XML subset) format, rather than the 'classic' format.  The\n" ,
   "volumetric image data is still in the pure binary .BRIK file, not XML-ified\n" ,
   "in any way.  At present (Jun 2005) this format is experimental, but will\n" ,
   "someday soon become the default.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ALLOW_MILLISECONDS\n" ,
   "---------------------------------\n" ,
   "The TR value (time step) in 3D+time datasets created with to3d can be flagged\n" ,
   "as being in units of milliseconds (ms) or seconds (s).  This situation is\n" ,
   "unfortunate, as some AFNI programs assume that the units are always s, which\n" ,
   "doesn't work well when the TR is actually in ms.  On 15 Aug 2005, AFNI dataset\n" ,
   "I/O was modified to only write out TR in s units, and to convert ms units\n" ,
   "to s units on input.  If you absolutely need to store TR in ms, then you\n" ,
   "must set this environment variable to YES.  I strongly recommend against\n" ,
   "such a setting, but recall the AFNI philosophy: \"provide mechanism, not\n" ,
   "policy\" -- in other words, if you want to shoot yourself in the foot, go\n" ,
   "right ahead.  This variable is just the safety on the revolver.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_AUTO_RESCAN\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI program\n" ,
   "will rescan all session directories every 15 seconds for new datasets.\n" ,
   "Basically, this is just a way for you to avoid pressing the 'Rescan'\n" ,
   "buttons.  Note that if AFNI_AUTO_RESCAN is enabled, then the rescan\n" ,
   "method will be 'Add', not 'Replace', no matter what you set variable\n" ,
   "AFNI_RESCAN_METHOD to.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_RESCAN_AT_SWITCH\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI program\n" ,
   "will rescan all session directories everytime you click on either of the\n" ,
   "'Overlay' or 'Underlay' buttons. Basically, this is just another way for\n" ,
   "you to avoid pressing the 'Rescan' buttons.  (Unlike with AFNI_AUTO_RESCAN,\n" ,
   "the AFNI_RESCAN_METHOD settings are respected.)\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_ALL_DATASETS  [02 Jun 2016]\n" ,
   "---------------------------\n" ,
   "By default, AFNI creates a session (internal the the program) that\n" ,
   "contains all the input datasets -- if you input more than one session\n" ,
   "directory, that is.  This session is called 'All_Datasets' in the\n" ,
   "'DataDir Switch' popup chooser, and should be the last session listed\n" ,
   "in that list.  If you do NOT want this session created, then set\n" ,
   "AFNI_ALL_DATASETS to NO.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_WEB_BROWSER\n" ,
   "--------------------------\n" ,
   "This variable should be set to the full executable path to a Web browser,\n" ,
   "as in\n" ,
   "  setenv AFNI_WEB_BROWSER /usr/bin/mozilla\n" ,
   "If it is not set, AFNI will scan your path to see if it can find a browser,\n" ,
   "looking for \"firefox\", \"mozilla\", \"netscape\", and \"opera\" (in that order).\n" ,
   "If a browser is found, or set, then the 'hidden' popup menu (in the blank\n" ,
   "square to the right of the 'done' button) will have a menu item to open it.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SELENIUM\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the Selenium webdriver will be\n" ,
   "used to open a browser window in the places where AFNI uses webpages\n" ,
   "(whereami, help,...) The AFNI_WEB_BROWSER should be set to the browser of\n" ,
   "choice (Chrome,Firefox,Safari). The default browser will be chrome if the\n" ,
   "AFNI_WEB_BROWSER variable is not set. If AFNI_SELENIUM is not set or set\n" ,
   "to NO, AFNI will open the standard browser using a system command. Selenium\n" ,
   "may be installed with \"pip install -U selenium\" on a Mac or \"sudo yum install\n" ,
   "selenium\" on Linux. If you need to get pip, it is available from\n" ,
   "https://pypi.python.org/pypi/pip .\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_WEB_DOWNLOADER\n" ,
   "-----------------------------\n" ,
   "This variable should be set to the full executable path to a Web downloader,\n" ,
   "as in\n" ,
   "  setenv AFNI_WEB_DOWNLOADER /usr/bin/curl\n" ,
   "If it is not set, AFNI will scan your path to see if it can find a downloader,\n" ,
   "looking for \"curl\" and \"wget\" (in that order).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_JPEG_COMPRESS\n" ,
   "----------------------------\n" ,
   "This variable determines the compression quality of JPEG files saved in\n" ,
   "the AFNI GUI and 3dDeconvolve. Its value can be set to an integer from\n" ,
   "1 to 100. If not set, the default value is 95%.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_NLFIM_METHOD\n" ,
   "---------------------------\n" ,
   "Can be used to set the optimization method using in the NLfit plugin\n" ,
   "(not in 3dNLfim).  The methods available are\n" ,
   "  SIMPLEX (the default)\n" ,
   "  POWELL  (the NEWUOA method)\n" ,
   "  BOTH    (use both methods, choose the 'best' result)\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_OVERLAY_ONTOP\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then the 'Overlay' button will be above\n" ,
   "the 'Underlay' button on the AFNI control panel.  The default, from the\n" ,
   "olden days, is to have the 'Underlay' button above the 'Overlay' button,\n" ,
   "which some people find confusing.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_DATASET_BROWSE (editable)\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then when you 'browse' through a dataset\n" ,
   "chooser ('Overlay' or 'Underlay' list) with the mouse or arrow keys, then\n" ,
   "as a dataset is selected in the list, AFNI will immediately switch to\n" ,
   "viewing that dataset.  This can be convenient for scrolling through datasets,\n" ,
   "but can also consume memory and CPU time very quickly.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISABLE_TEAROFF\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the AFNI GUI will not allow popup or\n" ,
   "popdown menus to be 'torn off'.  The default is to enable tear off for most\n" ,
   "menus, but this may cause bad things on some platforms (like program death).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_PLUGOUT_TCP_BASE (BETTER USE AFNI_PORT_OFFSET)\n" ,
   "-------------------------------\n" ,
   "This integer will override the base TCP port used by afni to listen for\n" ,
   "plugouts.  This allows multiple instances of afni on one machine, where\n" ,
   "each can listen for plugouts.  Valid port numbers are 1024..65535.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PORT_OFFSET\n" ,
   "--------------------------\n" ,
   "This integer provides an offset for the range of port numbers used by\n" ,
   "AFNI and its ilk. This allows multiple instances of communicating\n" ,
   "programs on one machine.  Valid port offset numbers are 1024..65000.\n" ,
   "See related options -np in afni -help. See also AFNI_PORT_BLOC.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PORT_BLOC\n" ,
   "--------------------------\n" ,
   "This integer selects a bloc of port numbers to be used by\n" ,
   "AFNI and its ilk. Much like AFNI_PORT_OFFSET, it allows multiple instances\n" ,
   "of communicating programs on one machine.  However it is easier to use.\n" ,
   "Acceptable integer values range from 0 to a couple of thousands.\n" ,
   "See related option -npb, -max_port_bloc in afni -help.\n" ,
   "This environment variable takes precedence over AFNI_PORT_OFFSET.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_IMAGE_TICK_DIV_IN_MM (editable)\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the Tick Div. value in an\n" ,
   "image window will be interpreted as a separation distance, in mm, as\n" ,
   "opposed to the number of tick divisions along each edge.  In the YES case,\n" ,
   "a larger value would produce fewer ticks, as they would be farther apart.\n" ,
   "In the NO case, a larger value will produce more tick marks.  Tick marks\n" ,
   "are controlled from the Button 3 popup menu attached to the grayscale\n" ,
   "intensity bar in an image viewer.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGRA_CLOSER\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to YES, then when you click in an 'Image'\n" ,
   "or 'Graph' button for a viewer window that is already open (so the button\n" ,
   "is displayed in inverted colors), then the corresponding viewer window\n" ,
   "will close.  The default action is to try to raise the viewer window to\n" ,
   "the front, but some window managers (I'm looking at you, FC5) don't allow\n" ,
   "this action.  So this provides a way to kill the window, at least, if you've\n" ,
   "lost it in desktop hell somewhere.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_DECONFLICT\n" ,
   "-------------------------\n" ,
   "When AFNI programs write datasets to disk, they will check whether the\n" ,
   "output filename already exists.  If it does, the AFNI programs will act\n" ,
   "based on the possible values of AFNI_DECONFLICT as follows:\n" ,
   "    NO/<none>   : do not modify the name or overwrite the file, but\n" ,
   "                  inform the user of the conflict, and exit\n" ,
   "    YES         : modify the filename, as stated below\n" ,
   "    OVERWRITE   : do not modify the filename, overwrite the dataset\n" ,
   "If AFNI_DECONFLICT is YES, then the filename will be changed to one that\n" ,
   "does not conflict with any existing file.  For example 'fred+orig' could\n" ,
   "be changed to 'fred_AA1+orig'.\n" ,
   "\n" ,
   "The default behavior is as 'NO', not to deconflict, but to exit.\n" ,
   "Some programs supply their own default.\n" ,
   "\n" ,
   "---------------------------------------\n" ,
   "Variable:  AFNI_GUI_WRITE_AS_DECONFLICT\n" ,
   "---------------------------------------\n" ,
   "When you use the 'Write' buttons under 'Define Datamode' Panel, the default\n" ,
   "is to overwrite existing datasets. However, if AFNI_GUI_WRITE_AS_DECONFLICT\n" ,
   "is set to YES, then the decision follows the value of AFNI_DECONFLICT\n" ,
   "\n" ,
   "The default value for this variable is NO, which means interactive 'Write'\n" ,
   "operates in overwrite mode.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SEE_OVERLAY\n" ,
   "--------------------------\n" ,
   "If this variable is set to YES, then the 'See Overlay' button will be turned\n" ,
   "on when a new AFNI controller is opened.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_INDEX_SCROLLREV\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the default direction of image slice\n" ,
   "and time index scrolling will be reversed in the image and graph viewers,\n" ,
   "respectively.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_PREFIX\n" ,
   "-----------------------------\n" ,
   "This variable sets the prefix for 'Save' timeseries 1D files from the\n" ,
   "'Clusterize' report panel.  The default string is \"Clust\".  The value\n" ,
   "of this variable will be loaded into the cluster Rpt window text entry\n" ,
   "field, and the prefix can be edited there by the users when it comes\n" ,
   "time to save files.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_SCROLL\n" ,
   "-----------------------------\n" ,
   "If this variable is NO, then the 'Clusterize' report will not be given\n" ,
   "scrollbars.  The default is to give it scroll bars (i.e., YES).\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_CLUSTER_EBAR\n" ,
   "---------------------------\n" ,
   "If this variable is YES, then the Clusterize 'Mean' and 'Medn' Plot\n" ,
   "graphs will have error bars plotted.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_REPMAX  (editable)\n" ,
   "-----------------------------\n" ,
   "This numeric variable (between 10 and 9999, inclusive) sets the maximum\n" ,
   "number of clusters that will be reported in a 'Clusterize' report panel,\n" ,
   "if scroll bars are turned off by AFNI_CLUSTER_SCROLL. The default value\n" ,
   "is 15.  If scroll bars are turned on, then the maximum number of clusters\n" ,
   "shown defaults to 999, but can be increased to 9999 if you are completely\n" ,
   "mad, or are named Shruti.  If scroll bars are turned off, then you probably\n" ,
   "don't want to make this very big, since the report window would become\n" ,
   "taller than your monitor, and that would be hard to deal with.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CLUSTER_WAMIMAX (editable)\n" ,
   "------------------------------\n" ,
   "This variable should be set to a number indicating the maximum number\n" ,
   "of clusters to get a 'whereami' report when the 'WamI' button is\n" ,
   "pressed.  Since the querying the diverse atlas datasets is slow,\n" ,
   "increasing this value much past its default value of 20 is not usually\n" ,
   "a good plan.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_STRLIST_INDEX\n" ,
   "----------------------------\n" ,
   "If this variable is set to NO, then the new [12 Oct 2007] 'Index' selector\n" ,
   "at the bottom of a string-list chooser (e.g., the 'Overlay' button popup\n" ,
   "window) will NOT be shown.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_HISTOG_MAXDSET\n" ,
   "-----------------------------\n" ,
   "If this variable is set to a numeric value between 4 and 9 (inclusive),\n" ,
   "then the number of Source datasets in the 'Histogram: Multi' plugin\n" ,
   "will be set to this value.  The default number of Source datasets is 3 --\n" ,
   "this variable allows you to increase that setting.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_HISTOG_CUMULATIVE (editable)\n" ,
   "--------------------------------\n" ,
   "This YES/NO variable lets you control if the 'Histogram: Multi' plugin\n" ,
   "plots the cumulative distribution as well as the density histogram.\n" ,
   "Mostly this was added to subserve the nefarious conspiracies of the\n" ,
   "dreaded Dr Cox, but if you find it useful ....\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SIGQUIT_DELAY\n" ,
   "----------------------------\n" ,
   "This numeric variable (between 1 and 30) sets the number of seconds AFNI\n" ,
   "will delay before exiting after a SIGQUIT signal is delivered to the process.\n" ,
   "The default delay is 5 seconds.  If you deliver a SIGALRM signal, AFNI will\n" ,
   "exit immediately.  If you don't know what Unix signals are, then don't pay\n" ,
   "any attention to this subject!\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NEVER_SAY_GOODBYE\n" ,
   "--------------------------------\n" ,
   "If this variable is set to YES, then the AFNI 'goodbye' messages won't\n" ,
   "be printed when the program exits.  For the grumpy people out there\n" ,
   "(you know who I'm talking about, don't you, Daniel?).\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NEWSESSION_SWITCH\n" ,
   "--------------------------------\n" ,
   "If this variable is set to NO, then AFNI will not automatically switch\n" ,
   "to a new session after that session is read in using the 'Read Sess'\n" ,
   "button on the Datamode control panel.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_FLASH_VIEWSWITCH\n" ,
   "-------------------------------\n" ,
   "If you switch sessions, underlay, or overlay, it can happen that the\n" ,
   "coordinate system might be forced to switch from +orig to +tlrc\n" ,
   "(for example) because there is no dataset to view in the +orig system.\n" ,
   "If you set this variable to YES, AFNI flashes the view switch buttons\n" ,
   "on and off a few times to let you know this is happening\n" ,
   "(this is the Adam Thomas feature).\n" ,
   "  ** Formerly, this feature was on by default, but now you have **\n" ,
   "  ** to explicitly turn it on (this is the Ziad Saad fixup).    **\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_SHELL_GLOB\n" ,
   "-------------------------\n" ,
   "'Globbing' is the Unix jargon for filename wildcard expansion.  AFNI programs\n" ,
   "do globbing at various points, using an adaptation of a function from the\n" ,
   "csh shell.  This function has been reported to fail on Mac OS X Server 10.5\n" ,
   "on network mounted directories.  If you set this variable to YES, then globbing\n" ,
   "will instead be done using the shell directly (via popen and ls).  You should\n" ,
   "only set this variable if you really need it, and understand the issue!\n" ,
   "[For Graham Wideman]\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GLOB_SELECTORS\n" ,
   "-----------------------------\n" ,
   "If this variable is 'YES', then internal wildcard expansion (in AFNI programs\n" ,
   "that support this capability) will NOT use the '[]' , '{}' , or '<>' selectors.\n" ,
   "Note that '[]' is a standard shell wildcard, so using this variable will\n" ,
   "restrict your wildcard-ing.  On the other hand, it lets you do something like\n" ,
   "  3dTcat -prefix ALL_rest0.nii -relabel -verb 'rest_*.nii[0]'\n" ,
   "which will create a dataset from the #0 sub-brick of every dataset that matches\n" ,
   "the wildcard 'rest_*.nii'.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_IGNORE_BRICK_FLTFAC\n" ,
   "----------------------------------\n" ,
   "Under some very rare circumstances, you might want to ignore the brick scaling\n" ,
   "factors.  Set this variable to YES to do so.  WARNING: this is dangerous, so\n" ,
   "be sure to unset this variable when you are done.  Sample usage:\n" ,
   "  3dBrickStat -DAFNI_IGNORE_BRICK_FLTFAC=YES -max fred+orig\n" ,
   "\n" ,
   "----------------------------------------\n" ,
   "Variable: AFNI_ALLOW_ARBITRARY_FILENAMES\n" ,
   "----------------------------------------\n" ,
   "Normally, AFNI checks output filenames for 'bad' characters, which are\n" ,
   "defined as control characters and ASCII characters that will cause\n" ,
   "trouble on the Unix command line ('*', '$', etc.).  'Bad' filenames\n" ,
   "will not be allowed by most AFNI programs.  If, for some reason, you\n" ,
   "want to use such filenames, set this variable to YES.  Don't blame\n" ,
   "me if you get into trouble with such filenames!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_INSTACORR_FDR (editable)\n" ,
   "----------------------------\n" ,
   "If you want AFNI's InstaCorr feature to compute the FDR curve for the\n" ,
   "on-the-fly correlation coefficient sub-brick created interactively, then set\n" ,
   "this variable to YES.  Since the FDR computations are the slowest part of the\n" ,
   "operation, the default (if this variable is not YES) is that FDR curves are\n" ,
   "NOT computed.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_INSTACORR_SEEDBLUR\n" ,
   "---------------------------------\n" ,
   "The InstaCorr controls let you use extra spatial smoothing when selecting\n" ,
   "the seed voxel time series.  By default, this extra smoothing is a flat\n" ,
   "average over a sphere of the chosen radius: \"SeedRad\".  However, if this\n" ,
   "environment variable is set to YES, then the extra smoothing is done\n" ,
   "by Gaussian blurring with the chosen FWHM: \"SeedBlur\".  This variable\n" ,
   "cannot be set interactively, but can be set on the AFNI command line\n" ,
   "with the usual -DAFNI_INSTACORR_SEEDBLUR=YES method.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_INSTACORR_XYZ_LPI\n" ,
   "--------------------------------\n" ,
   "In 3dGroupInCorr's batch mode, the XYZ method of operation sets the\n" ,
   "seed coordinates using AFNI's standard RAI (DICOM) order.  If you\n" ,
   "set this variable to YES, then the coordinates given will be\n" ,
   "interpreted as being in LPI (AKA 'neurological') order; that is,\n" ,
   "the given x and y values will be negated before being used inside\n" ,
   "3dGroupInCorr to pick the seed voxel.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_BLUR_INTS_AS_OLD\n" ,
   "----------------------------------\n" ,
   "As of 15 June 2009, the FIR (finite implulse response) method is applid to\n" ,
   "byte and short data.  Previously, 3dmerge had used FIR only on float data,\n" ,
   "meaning shorts and floats would be applied via Fourier interpolation.\n" ,
   "Setting AFNI_BLUR_INTS_AS_OLD to YES will revert to the Fourier method for\n" ,
   "such data.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_IMAGE_CROPSTEP (editable)\n" ,
   "-----------------------------\n" ,
   "Numeric value sets the size of the panning step using in the image viewer,\n" ,
   "when you are adjusting the cropping region using the Shift+Arrow keys\n" ,
   "on the keyboard.  Defaults to 1.  Legal values are -9..9 (inclusive).\n" ,
   "Positive values means pressing Shift+LeftArrow causes the image in the\n" ,
   "crop window to appear to move to the left; negative values cause the\n" ,
   "crop window to move in the opposite direction, so the visible part of\n" ,
   "the image appears to move to the right.  (Mutatis mutandum for the\n" ,
   "other directions, of course.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_COLORANGLE (editable)\n" ,
   "-------------------------------\n" ,
   "This value, a number between 90 and 360 (inclusive) describes the\n" ,
   "amount of the AJJ color circle used by the 'Colr' button in an\n" ,
   "AFNI image viewer.  If no value is given, the default is 240.\n" ,
   "Changing this number to 360 means the color circle is continuous\n" ,
   "from top to bottom -- an effect that is obvious if you use the 'r'\n" ,
   "arrow buttons (on the right of the image viewer) to rotate the\n" ,
   "color circle.  The default value of 240 is purely for historical\n" ,
   "reasons, dating back to the old FD program from Medieval Times.\n" ,
   "\n" ,
   "--------------------------------------\n" ,
   "Variable: AFNI_IMAGE_SCROLLWHEEL_TMASK\n" ,
   "--------------------------------------\n" ,
   "This variable lets you control which keyboard modifier keys are\n" ,
   "checked when the mouse scroll wheel is used inside the image.\n" ,
   "If one (or more) of the selected keys is pressed while the\n" ,
   "scroll wheel is moved, then the AFNI controller 'Define Overlay'\n" ,
   "threshold slider moves -- otherwise (the normal case), the image\n" ,
   "slice slider moves.  The value of this variable should be contain\n" ,
   "one or more of these strings (NOT case sensitive):\n" ,
   "  Shift           = Shift key pressed\n" ,
   "  Ctrl or Control = Control key pressed\n" ,
   "  Mod1            = Alt key pressed (Linux)\n" ,
   "  Mod2            = Command key pressed (Mac)\n" ,
   "If you do NOT set this variable, it is like setting it to the\n" ,
   "value 'Mod1+Mod2' (so that Alt and Command work on Linux and\n" ,
   "Mac OS X, respectively).  However, some Linux systems seem to\n" ,
   "always have the Mod2 mask set for the scroll wheel, and so\n" ,
   "the wheel ALWAYS change the threshold slider and not the slice.\n" ,
   "To prevent this sad thing from happening, set this variable to\n" ,
   "just 'Mod1'.  Furthermore, if you include the string 'Debug'\n" ,
   "in this variable, when the scroll wheel is used over the image\n" ,
   "sub-window, some information will be printed out about what the\n" ,
   "program detects, which might help you set things up correctly.\n" ,
   "On my Mac, I get the following output when using the scroll wheel\n" ,
   "twice -- once with no key pressed and once with the Command key:\n" ,
   "  ++ Scrollwheel (imag): button=5 ; state mask=0x\n" ,
   "   +   (mask: shift=1x ctrl=4x mod1=8x mod2=10x mod3=20x mod4=40x mod5=80x)\n" ,
   "   +   change slice\n" ,
   "  ++ Scrollwheel (imag): button=5 ; state mask=10x\n" ,
   "   +   (mask: shift=1x ctrl=4x mod1=8x mod2=10x mod3=20x mod4=40x mod5=80x)\n" ,
   "   +   change threshold\n" ,
   "The second use shows that the 'state mask' (which shows the modifier\n" ,
   "keys) was hexadecimal '10x', which corresponds to the 'mod2' value.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DUMMY_DATASET\n" ,
   "----------------------------\n" ,
   "The old 'frivolous' AFNI dummy dataset was replaced with a low-resolution\n" ,
   "edition of the N27 dataset on 12 Feb 2010.  If for some absurd reason you\n" ,
   "want the old dummy dataset back, then set this variable to OLD.  (Recall\n" ,
   "that the dummy dataset is only created if you start the AFNI GUI without\n" ,
   "any input datasets at all -- AFNI is so constructed that it needs SOME\n" ,
   "dataset present to be able to operate: hence, the dummy dataset concept.)\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DONT_COMMAIZE\n" ,
   "----------------------------\n" ,
   "When AFNI programs print out informative (and fun) messages about the\n" ,
   "size of files, memory space, etc., by default commas are inserted,\n" ,
   "as in \"8,765,432\".  If you want these numbers printed as \"8765432\"\n" ,
   "(for whatever hideous and twisted reason), set this variable to YES.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_FILE_COORDS_x\n" ,
   "----------------------------\n" ,
   "If this variable is set (where 'x' is A, B, C, ...), then for AFNI\n" ,
   "controller 'x', whenever the crosshair viewpoint changes, the DICOM\n" ,
   "order (x,y,z) coordinates and the dataset 3D index (i,j,k) will be\n" ,
   "written to the file whose name is given by the value of this variable.\n" ,
   "As a special case, if the filename is 'stdout', then the coordinates\n" ,
   "are written to standard output.  A sample command\n" ,
   "\n" ,
   "  afni -DAFNI_FILE_COORDS_A=stdout\n" ,
   "\n" ,
   "If the file already exists when afni starts, it will be over-written;\n" ,
   "that is, it is opened in \"w\" mode.\n" ,
   "\n" ,
   "This feature may be referred to as the Jen Evans special.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_AUTORANGE_POWER\n" ,
   "------------------------------\n" ,
   "If this variable is set to a value between 0 and 1 (exclusive),\n" ,
   "then the functional overlay 'autoRange' value will be set to\n" ,
   "the largest value in the dataset raised to this power.  By default,\n" ,
   "the autoRange value is computed as if this power is 1.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_IDEAL_COLORS (editable)\n" ,
   "---------------------------\n" ,
   "This variable, if set, allows you to specify the set of colors used\n" ,
   "for the FIM Ideal overlay in the graph viewer window.  Separate color\n" ,
   "names by colons, as in \"red:green:blue\".  The first column in the Ideal\n" ,
   "1D file gets the first color; the second column gets the second color,\n" ,
   "and so on.  The variable AFNI_ORT_COLORS can similarly be used to specify\n" ,
   "the colors for the FIM Ort overlay.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_DONT_USE_HTMLWIN\n" ,
   "-------------------------------\n" ,
   "If this variable is set to NO, then the 'AFNI Tips' button will not\n" ,
   "use the HTML window to display the requested information -- a plain\n" ,
   "text window will be used.  You should only need to use this variable\n" ,
   "if the AFNI Tips window crashes on your system.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_UNFONTIZE_HTML\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then font-changing HTML tags will be\n" ,
   "deleted before opening the 'AFNI Tips' HTML window.  Try this first\n" ,
   "to avoid crashes, before using the previous variable to turn off the\n" ,
   "HTML tips entirely.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_USE_FGETS\n" ,
   "------------------------\n" ,
   "The function fgets() is the Unix standard for reading text lines from\n" ,
   "a file.  However, it assumes that the text file lines end in the Unix\n" ,
   "standard end-of-line character (ASCII 0xA).  Files created on Microsoft\n" ,
   "platforms use a different end-of-line character (ASCII 0xD).  The result\n" ,
   "is that Microsoft-ized text files don't work well with fgets().  AFNI\n" ,
   "uses its own function, cleverly called afni_fgets(), to read text lines,\n" ,
   "to avoid this problem.  However, this function is 4-5 times slower than\n" ,
   "the system fgets() function, so if speed if crucial -- as when reading\n" ,
   "a giant 1D file -- then set AFNI_USE_FGETS to YES to make AFNI programs\n" ,
   "use the system fgets() function.  The best way to do this would be on\n" ,
   "the command line, as in the simple example below:\n" ,
   "  1dcat -DAFNI_USE_FGETS=YES bigfileA.1D bigfileB.1D > bigfileAB.1D\n" ,
   "In such an example, you won't see a 4-5 times speedup, since actually\n" ,
   "most of the time is spent decoding the text in the file into numbers\n" ,
   "and then writing them back out -- you'll probably see a speedup of\n" ,
   "about 1.2-1.4 instead -- not trivial, but not exhilarating.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variables: AFNI_WSINC5_*\n" ,
   "------------------------\n" ,
   "These variables affect the way the '3dAllineate -final wsinc5' windowed\n" ,
   "since interpolation option works.  See the output of the command\n" ,
   "  3dAllineate -HELP\n" ,
   "for the details.  You can control the width of the sinc window, the\n" ,
   "tapering function, and a couple of other useless options.\n" ,
   "** N.B.: You can turn off the message that the wsinc5 code prints out\n" ,
   "detailing the parameter setup by setting AFNI_WSINC5_SILENT to YES.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_INDEX_STEP\n" ,
   "-------------------------\n" ,
   "This numeric variable (between 1 and 9, inclusive) sets the step size\n" ,
   "used when you press the up/down arrows on the 'Index' control in the\n" ,
   "left column of the main AFNI controller.  Setting this value to 2 (say)\n" ,
   "let's you scroll through an image time series seeing alternate time\n" ,
   "points.  This feature can be useful when looking at datasets where\n" ,
   "sub-bricks alternate in type -- for example, from 3dttest++, where the\n" ,
   "even-numbered volumes are effect size estimates, and the odd-numbered\n" ,
   "volumes are the corresponding t-statistics.  (This value can also be\n" ,
   "set interactively from a popup chooser activated by right-clicking\n" ,
   "on the 'Index' label to the left of the up/down arrows.)\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SCATPLOT_LINES\n" ,
   "-----------------------------\n" ,
   "The ScatterPlot plugin lets you graph the data in one sub-brick along\n" ,
   "the x-axis and the data in another sub-brick along the y-axis.  It also\n" ,
   "computes some straight line y=ax+b fits to the graph.  By default, it\n" ,
   "does 2 different fits, with least sum of squares (L2) and least sum\n" ,
   "of absolutes (L1) criteria.  The L2 line is plotted in red (and thus\n" ,
   "corresponds to the Pearson R also shown in red), and the L1 line is\n" ,
   "plotted in blue (and corresponds to the Spearman rho shown in blue).\n" ,
   "With this variable, you can turn off the plotting of either or both\n" ,
   "of these lines, which are often very nearly the same.  If the value\n" ,
   "of this variable contains the string 'NOL1', then the L1 line won't\n" ,
   "be shown, and if the value of this variable contains 'NOL2', then\n" ,
   "the L2 line won't be shown.  Thus, if the value of this variable is\n" ,
   "'NOL1+NOL2', neither line will be plotted.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SCATPLOT_FRAC\n" ,
   "----------------------------\n" ,
   "This variable lets you choose the size of the boxes plotted in the\n" ,
   "ScatterPlot plugin. The units are fractions of the plot width,\n" ,
   "so the reasonable range for this value is 0.0 to 0.01 (not inclusive).\n" ,
   "If this variable is not set, or the value is outside of this range,\n" ,
   "then the size of the boxes is set based on the number of points\n" ,
   "being plotted.  The only reason for using this variable is if you\n" ,
   "wish to create a sequence of scatterplots and ensure that the points\n" ,
   "plotted in different graphs have a uniform size of boxes.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_LINKRBRAIN\n" ,
   "-------------------------\n" ,
   "If you do NOT want to see the 'linkRbrain' button in the Clusterize\n" ,
   "GUI, then set this variable to NO.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_LINKRBRAIN_SITE\n" ,
   "------------------------------\n" ,
   "This variable sets the name of the linkRbrain server to use.  The default\n" ,
   "server is 'linkrbrain.eu'.\n" ,
   "\n" ,
   "----------------------------------------------------------------------\n" ,
   "--- variables specific to NIML I/O\n" ,
   "----------------------------------------------------------------------\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NIML_DEBUG\n" ,
   "-----------------------------------\n" ,
   "This integer sets the debugging level in some niml I/O routines, particularly\n" ,
   "those in thd_niml.c.  Currently used values range from 0 to 3.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NSD_ADD_NODES\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when a NI_SURF_DSET dataset\n" ,
   "is written to disk, if it has no node list attribute, a default list will\n" ,
   "be created.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NSD_TO_FLOAT\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to NO, then any necessary conversion of\n" ,
   "NI_SURF_DSET datasets to type float will be blocked.  Otherwise, all such\n" ,
   "datasets will be written as float.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NIML_TEXT_DATA\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then NI_SURF_DSET datasets will be\n" ,
   "written with data in text format.  Otherwise, data will be in binary.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SIMPLE_HISTORY\n" ,
   "-----------------------------\n" ,
   "A few programs (particularly 3dcalc) create a complicated history note\n" ,
   "in the output dataset header, by including the history of all inputs.\n" ,
   "This history can become inordinately long and pointless when 3calc is\n" ,
   "run in a long chain of calculations.  Setting this variable to YES will\n" ,
   "turn off this cumulation of all histories, and may make your dataset\n" ,
   "headers more manageable.\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_NIML_BUFSIZE or NIML_BUFSIZE\n" ,
   "-------------------------------------------\n" ,
   "This variable sets the number of bytes used as a memory buffer for\n" ,
   "NIML dataset input.  If you are inputting gigantic headers or gigantic\n" ,
   "String data components (I'm looking at YOU, Ziad), then you may want\n" ,
   "to increase this past its default size of 255*1024=261120.\n" ,
   "\n" ,
   "----------------------------------------------------------------------\n" ,
   "--- END: variables specific to NIML I/O\n" ,
   "----------------------------------------------------------------------\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GIFTI_VERB\n" ,
   "-------------------------\n" ,
   "This integer sets the verbose level in the gifti I/O library routines.\n" ,
   "Level 1 is the default, 0 is \"quiet\", and values go up to 7.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DATASETN_NMAX\n" ,
   "----------------------------\n" ,
   "This numeric variable, if set, lets you expand the number of dataset\n" ,
   "lines in the 'Dataset#N' plugin from the default of 9 up to a max of 49.\n" ,
   "(This one is for Shruti.)\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_WRITE_1D_AS_PREFIX\n" ,
   "---------------------------------\n" ,
   "If this variable is set to YES, then 1D formatted files will be written\n" ,
   "to the file based on the given prefix, rather than to an automatic 1D file.\n" ,
   "This allows writing surface files to NIfTI format, for example.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_PATH_SPACES_OK\n" ,
   "-----------------------------------\n" ,
   "If this variable is set to YES, dataset names with spaces in them will go\n" ,
   "through \"normal\" reading routines, rather than using THD_open_tcat() to try\n" ,
   "to combine multiple datasets.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_CREEPTO\n" ,
   "----------------------\n" ,
   "If set to YES, then the AFNI GUI 'Jump to (xyz)' behavior is altered to\n" ,
   "move the crosshairs to the chosen location incrementally, rather than\n" ,
   "in one big jump.  The reasons for using this feature are (a) to help\n" ,
   "get a feel for the transit, and (b) just plain fun.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_HISTORY_NAME\n" ,
   "---------------------------\n" ,
   "The value of this variable will alter the 'username@machine' listing\n" ,
   "in the history notes generated by AFNI programs.  If this variable\n" ,
   "is NOT set, then your user login name and machine ID are put in the\n" ,
   "header; otherwise, the value of this string is used.  You can set this\n" ,
   "string to the null string '' if you wish to hide your identity totally.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_INCLUDE_HISTORY\n" ,
   "---------------------------\n" ,
   "If this variable is set to YES, output datasets will have a HISTORY_NOTE which\n" ,
   "can be seen via 3dinfo, for example.  If set to NO, output datasets will not\n" ,
   "have any HISTORY.  This is one method for making datasets anonymous.\n" ,
   "\n" ,
   "\n" ,
   "=============================================\n" ,
   "| Robert W Cox, PhD                         |\n" ,
   "| Scientific and Statistical Computing Core |\n" ,
   "| National Institute of Mental Health       |\n" ,
   "| National Institutes of Health             |\n" ,
   "| Department of Health & Human Services     |\n" ,
   "| United States of America                  |\n" ,
   "| Earth, United Federation of Planets       |\n" ,
   "| Alpha Quadrant, Milky Way Galaxy          |\n" ,
   "| Local Group, Virgo Supercluster           |\n" ,
   "=============================================\n" ,
   "\n" ,
   "############################################################################\n" ,
   "##### Variables that Specifically Affect the Operation of 3dDeconvolve #####\n" ,
   "############################################################################\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_GOFORIT\n" ,
   "-----------------------------------\n" ,
   "If this variable is set to YES, then 3dDeconvolve behaves as if you used the\n" ,
   "'-GOFORIT' option on the command line -- that is, it will continue to run\n" ,
   "even if it detects serious non-fatal problems with the problem setup.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_NIML\n" ,
   "--------------------------------\n" ,
   "3dDeconvolve outputs the regression matrix 'X' into a file formatted in\n" ,
   "the 'NIML' .1D format -- with an XML-style header in '#' comments at the\n" ,
   "start of the file.  If you DON'T want this format, just plain numbers,\n" ,
   "set this variable to NO.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_extend\n" ,
   "----------------------------------\n" ,
   "If you input a stimulus time series (via the -stim_file option) to\n" ,
   "3dDeconvolve that is shorter than needed for the regression analysis, the\n" ,
   "program will normally print a warning message and extend the time series\n" ,
   "with zero values to the needed length.  If you would rather have the program\n" ,
   "stop if it detects this problem (the behavior before 22 Oct 2003), then set\n" ,
   "this environment variable to NO.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_nodup\n" ,
   "---------------------------------\n" ,
   "If this variable is set to YES, then if the 3dDeconvolve program detects\n" ,
   "duplicate input stimulus filenames or duplicate regressors, the program\n" ,
   "will fail (with an error message) rather than attempt to continue.\n" ,
   "\n" ,
   "-----------------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_nodata_extras\n" ,
   "-----------------------------------------\n" ,
   "When using the -nodata option in 3dDeconvolve, the default printout gives\n" ,
   "the 'normalized standard deviation' for each stimulus parameter.  If you\n" ,
   "set this variable to YES, then the printout will include the -polort\n" ,
   "baseline parameters as well, and also the L2 norm of each column in\n" ,
   "the regression matrix.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_oneline\n" ,
   "-----------------------------------\n" ,
   "3dDeconvolve outputs a command line for running the cognate 3dREMLfit\n" ,
   "program.  By default, this command line is line broken with '\\'\n" ,
   "characters for printing beauty.  If you want this command line\n" ,
   "to be all on one physical output line, for convenience in automatic\n" ,
   "extraction (e.g., via grep), then set this variable to YES before\n" ,
   "running the program.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_rawAM2\n" ,
   "----------------------------------\n" ,
   "Normally, when you use the -stim_times_AM2 option, the regression against\n" ,
   "the covariates is 'centered' around the mean of the values given.  If you\n" ,
   "want the regression to proceed directly with the covariate values as given,\n" ,
   "set this option to YES.  Please do NOT do this unless you understand what\n" ,
   "this means!!!\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_XJPEG_COLOR\n" ,
   "--------------------------\n" ,
   "Determines the color of the lines drawn between the column boxes in the\n" ,
   "output from the -xjpeg option to 3dDeconvolve.  The color format is\n" ,
   "\"rgbi:rf/gf/bf\", where each value rf,gf,bf is a number between 0.0 and 1.0\n" ,
   "(inclusive); for example, yellow would be \"rgbi:1.0/1.0/0.0\".  As a\n" ,
   "special case, if this value is the string \"none\" or \"NONE\", then these\n" ,
   "lines will not be drawn.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_XJPEG_IMXY\n" ,
   "-------------------------\n" ,
   "This variable determines the size of the image saved when via the -xjpeg\n" ,
   "option to 3dDeconvolve.  It should be in the format AxB, where 'A' is the\n" ,
   "number of pixels the image is to be wide (across the matrix rows) and 'B'\n" ,
   "is the number of pixels high (down the columns); for example:\n" ,
   "  setenv AFNI_XJPEG_IMXY 768x1024\n" ,
   "which means to set the x-size (horizontal) to 768 pixels and the y-size\n" ,
   "(vertical) to 1024 pixels.  These values are the default, by the way.\n" ,
   "\n" ,
   "If the first value 'A' is negative and less than -1, its absolute value\n" ,
   "is the number of pixels across PER ROW.  If the second value 'B' is\n" ,
   "negative, its absolute value is the number of pixels down PER ROW.\n" ,
   "(Usually there are many fewer columns than rows.)\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_XSAVE_TEXT\n" ,
   "-------------------------\n" ,
   "If this YES/NO variable is set to YES, then the .xsave file created by\n" ,
   "the \"-xsave\" option to 3dDeconvolve will be saved in text format.  The\n" ,
   "default is a binary format, which preserves the full accuracy of the\n" ,
   "matrices stored therein.  However, if you want to look at the .xsave\n" ,
   "file yourself, the binary format is hard to grok.  Note that the two\n" ,
   "forms are not quite equivalent, since the binary format stores the\n" ,
   "exact matrices used internally in the program, whereas the ASCII format\n" ,
   "stores only a decimal approximation of these matrices.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_GLTSYM_PRINT\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then the GLT matrices generated\n" ,
   "in 3dDeconvolve by the \"-gltsym\" option will be printed to the screen\n" ,
   "when the program starts up.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_FLOATIZE\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then 3dDeconvolve and 3dcalc\n" ,
   "will write their outputs in floating point format (unless they are\n" ,
   "forced to do otherwise with the '-datum short' type of option).  In\n" ,
   "the future, other programs may also be affected by this variable.\n" ,
   "Later [18 Nov 2008]: Now 3dANOVA, 3dANOVA2, and 3dANOVA3 will also\n" ,
   "use this flag to determine if their outputs should be written in\n" ,
   "float format.  For example:\n" ,
   "  3dANOVA -DAFNI_FLOATIZE=YES ... other options ...\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_AUTOMATIC_FDR\n" ,
   "----------------------------\n" ,
   "If this variable is set to NO, then the automatic computation of FDR\n" ,
   "curves into headers output by 3dDeconvolve, 3dANOVA, 3dttest, and\n" ,
   "3dNLfim will NOT be done.  Otherwise, the automatic FDR-ization of\n" ,
   "these datasets will performed when the datasets are written to disk.\n" ,
   "(You can always use '3drefit -addFDR' to add FDR curves to a dataset\n" ,
   "header, for those sub-bricks marked as statistical parameters.)\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DONT_ADJUST_FDR\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the adjustment of FDR q-values\n" ,
   "downwards by allowing for the estimate of the number of true\n" ,
   "negatives (e.g., as discussed by Storey, Benjamini, and others)\n" ,
   "will NOT be carried out.  As of 26 Mar 2009, this adjustment of\n" ,
   "q-values is the default in AFNI programs.  If you want the old\n" ,
   "behavior, set this variable to YES.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_NON_INDEPENDENT_FDR\n" ,
   "----------------------------------\n" ,
   "If this variable is set to YES, then the FDR calculation is made using\n" ,
   "the non-independent assumption, as in the '-cdep' option for program\n" ,
   "3dFDR.  This setting will affect the calculation of FDR curves via\n" ,
   "program 3drefit, et cetera.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SKIP_SATCHECK\n" ,
   "----------------------------\n" ,
   "If you want 3dDeconvolve to check the input dataset time series for\n" ,
   "initial saturation transients (a somewhat time consuming process),\n" ,
   "set this variable to NO.  You can also use program 3dSatCheck for\n" ,
   "this purpose.  Or just look at your data (please!).\n" ,
   "\n" ,
   "#####################################################\n" ,
   "##### ATLAS AND WHEREAMI ENVIRONMENT VARIABLES  #####\n" ,
   "#####################################################\n" ,
   "\n" ,
   "These variables control how AFNI and whereami make use of various atlases and\n" ,
   "template spaces. The variables may also affect how other AFNI programs use\n" ,
   "atlases as input datasets.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_ATLAS_LIST\n" ,
   "-------------------------\n" ,
   "This list contains the names of the atlases that should be queried when no\n" ,
   "specific atlas has been requested. For example, the afni GUI and whereami,\n" ,
   "by default, do not load all the atlases specified in the AFNI_atlas_spaces.niml\n" ,
   "file. If this variable is not set, the TT_Daemon atlas and the cytoarchitectonic\n" ,
   "Eickhoff-Zilles in MNI_ANAT space are loaded. If the variable is set to a list\n" ,
   "like \"TT_Daemon,DD_Desai_PM\", then only these two atlases are loaded. The list\n" ,
   "of atlas names may be separated by commas or semicolons. A special case of \"ALL\"\n" ,
   "may be set, and all the available atlases will be loaded.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_TEMPLATE_SPACE_LIST\n" ,
   "----------------------------------\n" ,
   "This list contains the names of the template spaces that are shown when whereami\n" ,
   "reports the coordinates among various spaces. By default, the list contains\n" ,
   "\"TLRC,MNI,MNI_ANAT\". As with AFNI_ATLAS_LIST, this list may also be set to\n" ,
   "\"ALL\".\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ATLAS_COLORS (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets which atlas to use in the AFNI GUI for \"Atlas Colors\",\n" ,
   "\"Go to Atlas location\", \"Draw Dataset\" and \"Renderer\" functions.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_JUMPTO_SPACE (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets which space to use in the AFNI GUI for \"Jump to (spacename)\"\n" ,
   "function where this would default to \"MNI\". Choose a valid spacename from the\n" ,
   "current list of spaces in \"whereami -show_spaces\". The jump function transforms\n" ,
   "the user input coordinates from that space to the space of the dataset.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ATLAS_PATH\n" ,
   "----------------------------\n" ,
   "This variable sets which directory or directories to search for AFNI\n" ,
   "atlas datasets that have been defined in the AFNI_atlas_spaces.niml\n" ,
   "or CustomAtlases.niml file. For all afni programs and scripts that use\n" ,
   "atlas and template datasets, the program will preferentially use (in order)\n" ,
   "the file path included in the dataset filename definition, the AFNI_ATLAS_PATH,\n" ,
   "the AFNI_PLUGINPATH or the standard PATH values.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PLUGINPATH\n" ,
   "-------------------------\n" ,
   "Described above, this variable is used for several purposes. For whereami,\n" ,
   "this variable sets the directory to load atlases and NIML files if not in the\n" ,
   "current directory. If this variable does not exist or the referred file does\n" ,
   "not exist, then the atlas is searched in the user's current PATH setting.\n" ,
   "If this is set, atlases will be found more quickly than searching all the\n" ,
   "directories of the entire PATH. Searches of the PATH variable for whereami\n" ,
   "usage stop at the first occurrence of the searched file, so placing the AFNI\n" ,
   "directory earlier in the PATH will dramatically increase the speed that the\n" ,
   "file is found.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_DEC_PLACES (editable)\n" ,
   "----------------------------------\n" ,
   "Sets precision for whereami output.  Higher field data and animal atlases\n" ,
   "require higher precision. The default value used for focus point among template\n" ,
   "spaces is still 0 decimal places (closest mm), but animal data requires three\n" ,
   "decimal places. Value may range from 0 to 10.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WAMI_DEBUG\n" ,
   "-------------------------\n" ,
   "This variable controls the output of detailed messages about various tasks\n" ,
   "involved in loading atlases, transformations and composing query results.\n" ,
   "By default, this information is not shown. This integer sets the debugging\n" ,
   "level in whereami routines. Currently used values range from 0 to 3.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_TTATLAS_DATASET\n" ,
   "------------------------------\n" ,
   "This variable may also specify the default location of AFNI atlases. This\n" ,
   "variable is maintained mostly for backward compatibility. By default, this\n" ,
   "is not set.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_NO_WARN\n" ,
   "-------------------------------\n" ,
   "Turns off warnings about various whereami features - like queries that have\n" ,
   "reached their limit of returned results. By default, warnings are displayed\n" ,
   "only the first time a particular message is encountered.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_MAX_FIND (editable)\n" ,
   "--------------------------------\n" ,
   "By default, only the first nine structures are displayed within a particular\n" ,
   "atlas. You may increase or decrease this to show more or fewer structures in\n" ,
   "the whereami results.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_MAX_SEARCH_RAD (editable)\n" ,
   "-------------------------------\n" ,
   "By default, whereami searches a radius of 7.5 mm. Set a radius up to 9.5 mm.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_PROB_MIN\n" ,
   "-------------------------------\n" ,
   "Minimum probability AFNI considers in probabilistic atlases\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_DEFAULT_STD_SPACE\n" ,
   "--------------------------------\n" ,
   "The default template space is assumed to be TLRC. This is used for coordinate\n" ,
   "input to whereami, the whereami GUI and for TLRC view datasets without a\n" ,
   "template space explicitly set in the dataset header.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NIFTI_VIEW\n" ,
   "--------------------------------\n" ,
   "The default view extension used for output when creating AFNI format datasets\n" ,
   "from NIFTI datasets.This variable is only applicable for sform and qform codes\n" ,
   "that do not have clearly defined views (sform/qform code = 2). Set to \"tlrc\"\n" ,
   "or \"orig\". See also AFNI_DEFAULT_STD_SPACE and AFNI_NIFTI_PRIORITY.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NIFTI_PRIORITY\n" ,
   "--------------------------------\n" ,
   "Sets preference for NIFTI files to use sform or qform codes and matrices to\n" ,
   "determine space, origin and orientation. Set to 'S' or 'Q' for sform or qform\n" ,
   "respectively. If not set, NIFTI files are read using the non-zero form code or\n" ,
   "the qform code if both are set.\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_SUPP_ATLAS, AFNI_LOCAL_ATLAS\n" ,
   "-------------------------------------------\n" ,
   "These variables allow the addition of more atlas definitions to the global list\n" ,
   "of atlases, templates, spaces and transformations. The variable should be set\n" ,
   "to the name of a NIML file with the same format of the AFNI_atlas_spaces.niml\n" ,
   "file. These can be customized by site (supplemental) or by subject (local) and\n" ,
   "follow the same search order as the AFNI_atlas_spaces.niml file. In order to\n" ,
   "be included in default searches, additional atlases or template spaces would\n" ,
   "also need to be added to AFNI_ATLAS_SPACE_LIST and the AFNI_TEMPLATE_SPACE_LIST,\n" ,
   "unless those are set to \"ALL\".\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_SUPP_ATLAS_DIR\n" ,
   "-------------------------------------------\n" ,
   "Allows the addition of atlas definitions to the global list of atlases,\n" ,
   "templates,spaces and transformations. The variable should be set to the name\n" ,
   "of a directory that contains a SessionAtlases.niml file with the same format\n" ,
   "as the AFNI_atlas_spaces.niml file. Also see AFNI_SUPP_ATLAS, AFNI_LOCAL_ATLAS,\n" ,
   "AFNI_ATLAS_SPACE_LIST, AFNI_TEMPLATE_SPACE_LIST.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_TTATLAS_CAUTION (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to NO, then the warning about the potential\n" ,
   "errors in the \"Where am I?\" popup will not appear.\n" ,
   "(This is purely for cosmetic purposes, Ziad.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_TTATLAS_FONTSIZE (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is not set, the default font size is used in the 'Where am I?'\n" ,
   "popup window.\n" ,
   "If this variable is set to 'BIG' or a positive number, then a larger font\n" ,
   "size is used.\n" ,
   "If this variable is set to 'SMALL' or a negative number, then a smaller font\n" ,
   "size is used.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WEBBY_WAMI\n" ,
   "-------------------------\n" ,
   "When set to YES, the Where Am I GUI becomes 'web-enabled', i.e. the report\n" ,
   "becomes clickable to open web pages from the output. Most features are\n" ,
   "still experimental. See AFNI_NEUROSYNTH and AFNI_SUMSDB below for examples.\n" ,
   "The default value is 'NO'.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NEUROSYNTH\n" ,
   "-------------------------\n" ,
   "When set to YES, provides link for MNI coordinate in Where Am I GUI to the\n" ,
   "Neurosynth site. Requires AFNI_WEBBY_WAMI to also be set to YES. The default\n" ,
   "value is 'NO'.\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_SUMSDB\n" ,
   "---------------------\n" ,
   "When set to YES, provides link for MNI coordinate in Where Am I GUI to the\n" ,
   "SumsDB site. Requires AFNI_WEBBY_WAMI to also be set to YES. The default\n" ,
   "value is 'NO'.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable:  AFNI_NO_OPTION_HINT\n" ,
   "-------------------------------\n" ,
   "If this variable is set, do NOT make suggestions if a program parsing error\n" ,
   "is encountered.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable:  AFNI_GUI_EDITOR\n" ,
   "--------------------------\n" ,
   "Set this variable to your favorite GUI text editor.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable:  AFNI_IMAGE_VIEWER\n" ,
   "----------------------------\n" ,
   "Set this variable to your favorite image viewer.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable:  AFNI_PDF_VIEWER\n" ,
   "----------------------------\n" ,
   "Set this variable to your favorite pdf viewer.\n" ,
   "\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_LOG_BEST_PROG_OPTION\n" ,
   "------------------------------------\n" ,
   "If set to YES, allow approximate searching functions to log their behavior in\n" ,
   "a file named ~/.afni/help/aps.log.txt\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_HISTDB_SCRIPT\n" ,
   "------------------------------------\n" ,
   "If set to a non-empty string, an attribute called HISTDB_SCRIPT is added to the\n" ,
   "header of AFNI datasets at write time. The value of the attribute is that of\n" ,
   "the variable AFNI_HISTDB_SCRIPT.\n" ,
   "At the moment, this variable is solely for Tom Ross's nefarious history\n" ,
   "databasing schemes.\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_ICORR_UBER_USER\n" ,
   "------------------------------------\n" ,
   "If set to YES, enable distance measures that are not ready for prime time in\n" ,
   "the instacorr interface.\n" ,
   NULL } ;
#define NUM_readme_env 4024
