#include "mrilib.h"

/*------- Inverse of a generic 4x4 matrix.  Code generated by Maple. -------*/

dmat44 generic_dmat44_inverse( dmat44 P )
{
   double p11,p12,p13,p14,p21,p22,p23,p24,p31,p32,p33,p34,p41,p42,p43,p44 ;
   dmat44 Q ;
   double t14 , t15 , t17 , t19 , t20 , t22 , t24 , t25 , t27 ,
          t29 , t32 , t33 , t35 , t37 , t38 , t40 , t42 , t43 ,
          t46 , t49 , t50 , t52 , t54 , t57 , t60 , t63 , t65 ,
          t71 , t73 , t75 , t77 , t81 , t83 , t85 , t87 , t101,
          t103, t105, t107, t109, t111, t115, t117, t119, t121,
          t123, t125, t129, t131, t133, t135 ;

   /* unload input matrix into scalar variables */

   p11=P.m[0][0] ; p12=P.m[0][1] ; p13=P.m[0][2] ; p14=P.m[0][3] ;
   p21=P.m[1][0] ; p22=P.m[1][1] ; p23=P.m[1][2] ; p24=P.m[1][3] ;
   p31=P.m[2][0] ; p32=P.m[2][1] ; p33=P.m[2][2] ; p34=P.m[2][3] ;
   p41=P.m[0][3] ; p42=P.m[1][3] ; p43=P.m[2][3] ; p44=P.m[3][3] ;

   /* Code below here is from Maple's codegen[C] function */

   t14 = p11*p22; t15 = p33*p44; t17 = p34*p43; t19 = p11*p32;
   t20 = p23*p44; t22 = p24*p43; t24 = p11*p42; t25 = p23*p34;
   t27 = p24*p33; t29 = p21*p12; t32 = p21*p32; t33 = p13*p44;
   t35 = p14*p43; t37 = p21*p42; t38 = p13*p34; t40 = p14*p33;

   t42 = t14*t15-t14*t17-t19*t20+t19*t22+t24*t25-t24*t27-t29*t15+t29*t17
        +t32*t33-t32*t35-t37*t38+t37*t40;

   t43 = p31*p12; t46 = p31*p22; t49 = p31*p42; t50 = p13*p24;
   t52 = p14*p23; t54 = p41*p12; t57 = p41*p22; t60 = p41*p32;

   t63 = t43*t20-t43*t22-t46*t33+t46*t35+t49*t50-t49*t52-t54*t25+t54*t27
        +t57*t38-t57*t40-t60*t50+t60*t52;
   t65 = t42+t63 ;    /* determinant */
   if( t65 == 0.0 ){ memset(&Q,0,sizeof(dmat44)); return Q; }
   t65 = 1.0/t65 ;

   t71  = p13*p32; t73  = p14*p32; t75  = p13*p42; t77  = p14*p42;
   t81  = p12*p23; t83  = p12*p24; t85  = p13*p22; t87  = p14*p22;
   t101 = p21*p33; t103 = p21*p34; t105 = p31*p23; t107 = p31*p24;
   t109 = p41*p23; t111 = p41*p24; t115 = p11*p33; t117 = p11*p34;
   t119 = p31*p13; t121 = p31*p14; t123 = p41*p13; t125 = p41*p14;
   t129 = p11*p23; t131 = p11*p24; t133 = p21*p13; t135 = p21*p14;

   Q.m[0][0] = -(-p22*p33*p44+p22*p34*p43+p32*p23*p44-p32*p24*p43
                 -p42*p23*p34+p42*p24*p33)*t65;
   Q.m[0][1] = (-p12*p33*p44+p12*p34*p43+t71*p44-t73*p43-t75*p34+t77*p33)*t65;
   Q.m[0][2] = -(-t81*p44+t83*p43+t85*p44-t87*p43-t75*p24+t77*p23)*t65;
   Q.m[0][3] = -(t81*p34-t83*p33-t85*p34+t87*p33+t71*p24-t73*p23)*t65;
   Q.m[1][0] = (-t101*p44+t103*p43+t105*p44-t107*p43-t109*p34+t111*p33)*t65;
   Q.m[1][1] = -(-t115*p44+t117*p43+t119*p44-t121*p43-t123*p34+t125*p33)*t65;
   Q.m[1][2] = -(t129*p44-t131*p43-t133*p44+t135*p43+t123*p24-t125*p23)*t65;
   Q.m[1][3] = (t129*p34-t131*p33-t133*p34+t135*p33+t119*p24-t121*p23)*t65;
   Q.m[2][0] = -(-t32*p44+t103*p42+t46*p44-t107*p42-t57*p34+t111*p32)*t65;
   Q.m[2][1] = -(t19*p44-t117*p42-t43*p44+t121*p42+t54*p34-t125*p32)*t65;
   Q.m[2][2] = (t14*p44-t131*p42-t29*p44+t135*p42+t54*p24-t125*p22)*t65;
   Q.m[2][3] = -(t14*p34-t131*p32-t29*p34+t135*p32+t43*p24-t121*p22)*t65;
   Q.m[3][0] = (-t32*p43+t101*p42+t46*p43-t105*p42-t57*p33+t109*p32)*t65;
   Q.m[3][1] = -(-t19*p43+t115*p42+t43*p43-t119*p42-t54*p33+t123*p32)*t65;
   Q.m[3][2] = -(t14*p43-t129*p42-t29*p43+t133*p42+t54*p23-t123*p22)*t65;
   Q.m[3][3] = -(-t14*p33+t129*p32+t29*p33-t133*p32-t43*p23+t119*p22)*t65;

   return Q ;
}

/*------- Determinant of a generic 4x4 matrix.  Code generated by Maple. -------*/

double generic_dmat44_determinant( dmat44 P )
{
   double p11,p12,p13,p14,p21,p22,p23,p24,p31,p32,p33,p34,p41,p42,p43,p44 ;
   double t14 , t15 , t17 , t19 , t20 , t22 , t24 , t25 , t27 ,
          t29 , t32 , t33 , t35 , t37 , t38 , t40 , t42 , t43 ,
          t46 , t49 , t50 , t52 , t54 , t57 , t60 , t63 , t65  ;

   /* unload input matrix into scalar variables */
                                                   /* [LPatrol] was here */
   p11=P.m[0][0] ; p12=P.m[0][1] ; p13=P.m[0][2] ; p14=P.m[0][3] ;
   p21=P.m[1][0] ; p22=P.m[1][1] ; p23=P.m[1][2] ; p24=P.m[1][3] ; 
   p31=P.m[2][0] ; p32=P.m[2][1] ; p33=P.m[2][2] ; p34=P.m[2][3] ;
   p41=P.m[0][3] ; p42=P.m[1][3] ; p43=P.m[2][3] ; p44=P.m[3][3] ;

   /* Code below here is from Maple's codegen[C] function */

   t14 = p11*p22; t15 = p33*p44; t17 = p34*p43; t19 = p11*p32;
   t20 = p23*p44; t22 = p24*p43; t24 = p11*p42; t25 = p23*p34;
   t27 = p24*p33; t29 = p21*p12; t32 = p21*p32; t33 = p13*p44;
   t35 = p14*p43; t37 = p21*p42; t38 = p13*p34; t40 = p14*p33;

   t42 = t14*t15-t14*t17-t19*t20+t19*t22+t24*t25-t24*t27-t29*t15+t29*t17
        +t32*t33-t32*t35-t37*t38+t37*t40;

   t43 = p31*p12; t46 = p31*p22; t49 = p31*p42; t50 = p13*p24;
   t52 = p14*p23; t54 = p41*p12; t57 = p41*p22; t60 = p41*p32;

   t63 = t43*t20-t43*t22-t46*t33+t46*t35+t49*t50-t49*t52-t54*t25+t54*t27
        +t57*t38-t57*t40-t60*t50+t60*t52;
   t65 = t42+t63 ;
   return t65 ;
}
