/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.run;

import com.nvidia.cuda.ide.util.NsightUtil;
import com.nvidia.viper.Activator;
import com.nvidia.viper.IViperJobListener;
import com.nvidia.viper.IViperWorkbench;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperJob;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.IViperRunnerListener;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class Runner {
    private ISessionPropertyChangeListener sessionListener = new ISessionPropertyChangeListener(){

        @Override
        public void propertyChange(IModel model, String propertyName) {
            if (propertyName.equals("session:progress:cancel") && Runner.this.job != null) {
                Runner.this.job.cancelJob();
            }
        }
    };
    private static final String API_RESULTS_LOG = "api.log";
    private static final String API_RESULTS_LOG_MULTI_PROCESS = "api_%p.log";
    private static final String API_RESULTS_LOG_MPI_PROCESS = "api_%h.%p.log";
    protected static final String PROFILE_RESULTS_PREFIX = "p_";
    protected static final String PROFILE_RESULTS_EXT = ".log";
    private static Set<Session> lockedSessions = new HashSet<Session>();
    private static Set<IViperRunnerListener> listeners = new HashSet<IViperRunnerListener>();
    protected ViperJob job;
    protected Session session;

    public Runner(Session session) {
        this.session = session;
        this.session.addPropertyChangeListener(this.sessionListener);
    }

    public abstract boolean runWithJob();

    public abstract IStatus runWithMonitor(IProgressMonitor var1);

    protected String getOutputFileName(Executable exe) {
        if (exe.isMultiProcess()) {
            if (exe.isMPI()) {
                return API_RESULTS_LOG_MPI_PROCESS;
            }
            return API_RESULTS_LOG_MULTI_PROCESS;
        }
        return API_RESULTS_LOG;
    }

    public static synchronized void addListener(IViperRunnerListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeListener(IViperRunnerListener listener) {
        listeners.remove(listener);
    }

    private static synchronized Set<IViperRunnerListener> getListenersCopy() {
        HashSet<IViperRunnerListener> rc = new HashSet<IViperRunnerListener>();
        rc.addAll(listeners);
        return rc;
    }

    private static void fireUnlockedEvent() {
        for (IViperRunnerListener listener : Runner.getListenersCopy()) {
            listener.sessionUnlocked();
        }
    }

    private static void fireLockedEvent() {
        for (IViperRunnerListener listener : Runner.getListenersCopy()) {
            listener.sessionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Session> getLockedSessions() {
        HashSet<Session> locked = new HashSet<Session>();
        Set<Session> set = lockedSessions;
        synchronized (set) {
            locked.addAll(lockedSessions);
        }
        return locked;
    }

    public static synchronized boolean isSessionLocked(Session session) {
        return lockedSessions.contains(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockSession(Session session, boolean raiseDialog) {
        boolean rc;
        Set<Session> set = lockedSessions;
        synchronized (set) {
            rc = lockedSessions.add(session);
        }
        if (rc) {
            Runner.fireLockedEvent();
        }
        if (!rc && raiseDialog) {
            final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViperMessageDialog.openInformation(shell, ViperMessages.Running_Exec_Title, ViperMessages.Running_Exec_Message);
                }
            });
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockSession(Session session) {
        Set<Session> set = lockedSessions;
        synchronized (set) {
            lockedSessions.remove(session);
        }
        Runner.fireUnlockedEvent();
    }

    protected boolean needProfilingDataDelete(Session session) {
        if (session.needProfilingDataDelete()) {
            return ViperMessageDialog.openQuestion(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.StaleProfilingData_Title, ViperMessages.StaleProfilingData_Message);
        }
        return Activator.getDefault().getViperWorkbench().needProfilingDataDelete(session);
    }

    public static boolean checkRunnable(Session session, boolean raiseDialog) {
        FileSystem fs;
        Executable exec = session.getExecutable();
        if (exec == null) {
            if (raiseDialog) {
                ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.NonRunnable_Exec_Title, ViperMessages.NonRunnable_Exec_Message);
            }
            return false;
        }
        if (exec.isProfileAllProcesses()) {
            return true;
        }
        try {
            fs = FileSystem.getFilesystem(exec.getConnectionName());
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            return false;
        }
        if (!fs.isCustomScript()) {
            if (exec.getFilename() == null) {
                if (raiseDialog) {
                    ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.NoRunnable_Exec_Title, ViperMessages.NoRunnable_Exec_Message);
                }
                return false;
            }
            try {
                if (!exec.isRunnable()) {
                    if (raiseDialog) {
                        ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.MissingRunnable_Exec_Title, ViperMessages.MissingRunnable_Exec_Message);
                    }
                    return false;
                }
            }
            catch (ConnectionNotFoundException e1) {
                ViperExceptionHandler.handle("Remote Profiling", "Unable to obtain remote connection", e1);
            }
        }
        try {
            if (NsightUtil.isCudaGdbRunning((boolean)true).booleanValue()) {
                if (raiseDialog) {
                    ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.Active_CudaGdb_Title, ViperMessages.Active_CudaGdb_Message);
                }
                return false;
            }
        }
        catch (CoreException e) {
            ViperExceptionHandler.logError("failed detecting cuda-gdb", e);
        }
        return true;
    }

    public void showConsole() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViperWorkbench viperWorkbench = Activator.getDefault().getViperWorkbench();
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viperWorkbench.getConsoleViewID());
                }
                catch (PartInitException partInitException) {
                    ViperExceptionHandler.logError("unable to show console view");
                }
            }
        });
    }

    protected String getNvprofBaseArgs(Executable exec) {
        String nvprofArgs = "";
        if (exec.getTimeOut() > 0) {
            nvprofArgs = String.valueOf(nvprofArgs) + " -t " + exec.getTimeOut();
        }
        nvprofArgs = String.valueOf(nvprofArgs) + " --concurrent-kernels " + (exec.isConcurrentKernel() ? "on" : "off");
        nvprofArgs = String.valueOf(nvprofArgs) + " --profile-api-trace " + (exec.isApiTrace() ? "all" : "none");
        nvprofArgs = String.valueOf(nvprofArgs) + " --profile-from-start " + (exec.isProfileOnStart() ? "on" : "off");
        nvprofArgs = String.valueOf(nvprofArgs) + " --system-profiling " + (exec.isEnvironmentProfiling() ? "on" : "off");
        nvprofArgs = String.valueOf(nvprofArgs) + " --unified-memory-profiling " + (exec.isUvmProfiling() ? "per-process-device" : "off");
        nvprofArgs = String.valueOf(nvprofArgs) + " --track-memory-allocations " + (exec.isAllocationsTracking() ? "on" : "off");
        if (!exec.isProfileCPU()) {
            nvprofArgs = String.valueOf(nvprofArgs) + " " + exec.getMultiProcessArg();
        }
        if (exec.isProfileCPU()) {
            nvprofArgs = String.valueOf(nvprofArgs) + " --cpu-profiling on";
        }
        nvprofArgs = String.valueOf(nvprofArgs) + " --device-buffer-size " + exec.getDeviceBuffersize();
        nvprofArgs = String.valueOf(nvprofArgs) + " --device-cdp-buffer-size " + exec.getCDPBuffersize();
        if (exec.isThreadTracking()) {
            nvprofArgs = String.valueOf(nvprofArgs) + " --cpu-thread-tracing on ";
        }
        if ("linux".equals(Platform.getOS()) && ("x86_64".equals(Platform.getOSArch()) || "ppc".equals(Platform.getOSArch()))) {
            nvprofArgs = String.valueOf(nvprofArgs) + " --openacc-profiling " + (exec.isOpenAccProfiling() ? "on" : "off");
            nvprofArgs = String.valueOf(nvprofArgs) + " --openmp-profiling " + (exec.isOpenMpProfiling() ? "on" : "off");
        }
        return nvprofArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IStatus waitForCompletion() {
        if (this.job == null) {
            return Status.OK_STATUS;
        }
        status = new Status[1];
        l = new IViperJobListener((IStatus[])status){
            private final /* synthetic */ IStatus[] val$status;
            {
                this.val$status = iStatusArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                this.val$status[0] = Runner.this.job.getResult();
                IStatus[] iStatusArray = this.val$status;
                synchronized (this.val$status) {
                    this.val$status.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        try {
            this.job.addJobListener(l);
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        var3_3 = status;
                        // MONITORENTER : status
                        status[0] = this.job.getResult();
                        if (status[0] != null) {
                            // MONITOREXIT : var3_3
                            return status[0];
                        }
                        status.wait();
                        // MONITOREXIT : var3_3
                        continue;
                        break;
                    }
                }
                catch (InterruptedException v1) {
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
        finally {
            this.job.removeJobListener(l);
        }
    }
}

