/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageMappingChangeEvent;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.language.LanguageVerifier;
import org.eclipse.cdt.internal.ui.language.ProjectLanguageMappingWidget;
import org.eclipse.cdt.internal.ui.language.WorkspaceLanguageMappingWidget;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectLanguageMappingPropertyPage
extends PropertyPage {
    private ProjectLanguageMappingWidget fMappingWidget = new ProjectLanguageMappingWidget();
    private WorkspaceLanguageMappingWidget fInheritedMappingWidget = new WorkspaceLanguageMappingWidget();
    private ProjectLanguageConfiguration fMappings;
    private ILanguageMappingChangeListener fInheritedMappingsChangeListener;

    public ProjectLanguageMappingPropertyPage() {
        this.fInheritedMappingWidget.setReadOnly(true);
        this.fMappingWidget.setChild(this.fInheritedMappingWidget);
    }

    protected Control createContents(Composite parent) {
        this.fMappingWidget.setElement((IAdaptable)this.getProject());
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        this.fetchMappings(this.getProject());
        Composite contentTypeMappings = this.fMappingWidget.createContents(contents, PreferencesMessages.ProjectLanguagesPropertyPage_description);
        contentTypeMappings.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(contents, 4);
        group.setText(PreferencesMessages.ProjectLanguagesPropertyPage_inheritedWorkspaceMappingsGroup);
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fetchWorkspaceMappings();
        this.fInheritedMappingWidget.createContents((Composite)group, null);
        this.fInheritedMappingsChangeListener = new ILanguageMappingChangeListener(){

            public void handleLanguageMappingChangeEvent(final ILanguageMappingChangeEvent event) {
                if (event.getType() == 0) {
                    if (ProjectLanguageMappingPropertyPage.this.isControlCreated()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ProjectLanguageMappingPropertyPage.this.getControl().isDisposed()) {
                                    ProjectLanguageMappingPropertyPage.this.fetchWorkspaceMappings();
                                    ProjectLanguageMappingPropertyPage.this.fInheritedMappingWidget.refreshMappings();
                                }
                            }
                        });
                    }
                } else if (event.getType() == 1 && ProjectLanguageMappingPropertyPage.this.isControlCreated()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ProjectLanguageMappingPropertyPage.this.getControl().isDisposed()) {
                                ProjectLanguageMappingPropertyPage.this.fetchMappings(event.getProject());
                                ProjectLanguageMappingPropertyPage.this.fMappingWidget.refreshMappings();
                            }
                        }
                    });
                }
            }
        };
        LanguageManager.getInstance().registerLanguageChangeListener(this.fInheritedMappingsChangeListener);
        return contents;
    }

    private void fetchMappings(IProject project) {
        try {
            LanguageManager manager = LanguageManager.getInstance();
            this.fMappings = manager.getLanguageConfiguration(project);
            ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project);
            Map<String, ILanguage> availableLanguages = LanguageVerifier.computeAvailableLanguages();
            Set<String> missingLanguages = LanguageVerifier.removeMissingLanguages(this.fMappings, description, availableLanguages);
            if (missingLanguages.size() > 0) {
                MessageBox messageBox = new MessageBox(this.getShell(), 40);
                messageBox.setText(PreferencesMessages.LanguageMappings_missingLanguageTitle);
                String affectedLanguages = LanguageVerifier.computeAffectedLanguages(missingLanguages);
                messageBox.setMessage(Messages.format(PreferencesMessages.ProjectLanguagesPropertyPage_missingLanguage, affectedLanguages));
                messageBox.open();
            }
            this.fMappingWidget.setMappings(this.fMappings.getContentTypeMappings());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    private void fetchWorkspaceMappings() {
        try {
            LanguageManager manager = LanguageManager.getInstance();
            WorkspaceLanguageConfiguration workspaceMappings = manager.getWorkspaceLanguageConfiguration();
            Map<String, ILanguage> availableLanguages = LanguageVerifier.computeAvailableLanguages();
            Set<String> missingLanguages = LanguageVerifier.removeMissingLanguages(workspaceMappings, availableLanguages);
            if (missingLanguages.size() > 0) {
                MessageBox messageBox = new MessageBox(this.getShell(), 40);
                messageBox.setText(PreferencesMessages.LanguageMappings_missingLanguageTitle);
                String affectedLanguages = LanguageVerifier.computeAffectedLanguages(missingLanguages);
                messageBox.setMessage(Messages.format(PreferencesMessages.WorkspaceLanguagesPreferencePage_missingLanguage, affectedLanguages));
                messageBox.open();
            }
            this.fInheritedMappingWidget.setMappings(workspaceMappings.getWorkspaceMappings());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fetchMappings(this.getProject());
        this.fMappingWidget.refreshMappings();
    }

    public boolean performOk() {
        block3: {
            try {
                if (this.fMappingWidget.isChanged()) break block3;
                return true;
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return false;
            }
        }
        this.fMappings.setContentTypeMappings(this.fMappingWidget.getContentTypeMappings());
        IContentType[] affectedContentTypes = this.fMappingWidget.getAffectedContentTypes();
        LanguageManager.getInstance().storeLanguageMappingConfiguration(this.getProject(), affectedContentTypes);
        this.fMappingWidget.setChanged(false);
        return true;
    }

    public void dispose() {
        super.dispose();
        LanguageManager.getInstance().unregisterLanguageChangeListener(this.fInheritedMappingsChangeListener);
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

