# flake8: noqa
# This file contains data for the test sg15_hydrogen.py.
pp_text = """<UPF version="2.0.1">
  <PP_INFO>

 This pseudopotential file has been produced using the code
 ONCVPSP  (Optimized Norm-Conservinng Vanderbilt PSeudopotential)
 scalar-relativistic version 2.1.1, 03/26/2014 by D. R. Hamann
 The code is available through a link at URL www.mat-simresearch.com.
 Documentation with the package provides a full discription of the
 input data below.


 While it is not required under the terms of the GNU GPL, it is
 suggested that you cite D. R. Hamann, Phys. Rev. B 88, 085117 (2013)
 in any publication using these pseudopotentials.


 Copyright 2015 The Regents of the University of California

 This work is licensed under the Creative Commons Attribution-ShareAlike
 4.0 International License. To view a copy of this license, visit
 http://creativecommons.org/licenses/by-sa/4.0/ or send a letter to
 Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

 This pseudopotential is part of the Schlipf-Gygi norm-conserving
 pseudopotential library. Its construction parameters were tuned to
 reproduce materials of a training set with very high accuracy and
 should be suitable as a general purpose pseudopotential to treat a
 variety of different compounds. For details of the construction and
 testing of the pseudopotential please refer to:

 [insert reference to paper here]

 We kindly ask that you include this reference in all publications
 associated to this pseudopotential.


    <PP_INPUTFILE>
# ATOM AND REFERENCE CONFIGURATION
# atsym  z    nc    nv    iexc   psfile
  H  1.00     0     1     4      upf
#
#   n    l    f        energy (Ha)
    1    0    1.00
#
# PSEUDOPOTENTIAL AND OPTIMIZATION
# lmax
    0
#
#   l,   rc,     ep,   ncon, nbas, qcut
    0   1.13748  -0.23860    5    8   9.72141
#
# LOCAL POTENTIAL
# lloc, lpopt,  rc(5),   dvloc0
    4    5   0.49352      0.00000
#
# VANDERBILT-KLEINMAN-BYLANDER PROJECTORs
# l, nproj, debl
    0    2   1.27464
#
# MODEL CORE CHARGE
# icmod, fcfact
    0   0.00000
#
# LOG DERIVATIVE ANALYSIS
# epsh1, epsh2, depsh
   -5.00    3.00    0.02
#
# OUTPUT GRID
# rlmax, drl
    6.00    0.01
#
# TEST CONFIGURATIONS
# ncnf
    0
# nvcnf
#   n    l    f
    </PP_INPUTFILE>
  </PP_INFO>
  <!--                               -->
  <!-- END OF HUMAN READABLE SECTION -->
  <!--                               -->
    <PP_HEADER
       generated="Generated using ONCVPSP code by D. R. Hamann"
       author="Martin Schlipf and Francois Gygi"
       date="150105"
       comment=""
       element="H "
       pseudo_type="NC"
       relativistic="scalar"
       is_ultrasoft="F"
       is_paw="F"
       is_coulomb="F"
       has_so="F"
       has_wfc="F"
       has_gipaw="F"
       core_correction="F"
       functional="PBE"
       z_valence="    1.00"
       total_psenergy="  -4.58772875004E-01"
       rho_cutoff="   6.01000000000E+00"
       l_max="0"
       l_local="-1"
       mesh_size="   602"
       number_of_wfc="0"
       number_of_proj="2"/>
 <PP_MESH>
   <PP_R type="real"  size=" 602" columns="8">
    0.0000    0.0100    0.0200    0.0300    0.0400    0.0500    0.0600    0.0700
    0.0800    0.0900    0.1000    0.1100    0.1200    0.1300    0.1400    0.1500
    0.1600    0.1700    0.1800    0.1900    0.2000    0.2100    0.2200    0.2300
    0.2400    0.2500    0.2600    0.2700    0.2800    0.2900    0.3000    0.3100
    0.3200    0.3300    0.3400    0.3500    0.3600    0.3700    0.3800    0.3900
    0.4000    0.4100    0.4200    0.4300    0.4400    0.4500    0.4600    0.4700
    0.4800    0.4900    0.5000    0.5100    0.5200    0.5300    0.5400    0.5500
    0.5600    0.5700    0.5800    0.5900    0.6000    0.6100    0.6200    0.6300
    0.6400    0.6500    0.6600    0.6700    0.6800    0.6900    0.7000    0.7100
    0.7200    0.7300    0.7400    0.7500    0.7600    0.7700    0.7800    0.7900
    0.8000    0.8100    0.8200    0.8300    0.8400    0.8500    0.8600    0.8700
    0.8800    0.8900    0.9000    0.9100    0.9200    0.9300    0.9400    0.9500
    0.9600    0.9700    0.9800    0.9900    1.0000    1.0100    1.0200    1.0300
    1.0400    1.0500    1.0600    1.0700    1.0800    1.0900    1.1000    1.1100
    1.1200    1.1300    1.1400    1.1500    1.1600    1.1700    1.1800    1.1900
    1.2000    1.2100    1.2200    1.2300    1.2400    1.2500    1.2600    1.2700
    1.2800    1.2900    1.3000    1.3100    1.3200    1.3300    1.3400    1.3500
    1.3600    1.3700    1.3800    1.3900    1.4000    1.4100    1.4200    1.4300
    1.4400    1.4500    1.4600    1.4700    1.4800    1.4900    1.5000    1.5100
    1.5200    1.5300    1.5400    1.5500    1.5600    1.5700    1.5800    1.5900
    1.6000    1.6100    1.6200    1.6300    1.6400    1.6500    1.6600    1.6700
    1.6800    1.6900    1.7000    1.7100    1.7200    1.7300    1.7400    1.7500
    1.7600    1.7700    1.7800    1.7900    1.8000    1.8100    1.8200    1.8300
    1.8400    1.8500    1.8600    1.8700    1.8800    1.8900    1.9000    1.9100
    1.9200    1.9300    1.9400    1.9500    1.9600    1.9700    1.9800    1.9900
    2.0000    2.0100    2.0200    2.0300    2.0400    2.0500    2.0600    2.0700
    2.0800    2.0900    2.1000    2.1100    2.1200    2.1300    2.1400    2.1500
    2.1600    2.1700    2.1800    2.1900    2.2000    2.2100    2.2200    2.2300
    2.2400    2.2500    2.2600    2.2700    2.2800    2.2900    2.3000    2.3100
    2.3200    2.3300    2.3400    2.3500    2.3600    2.3700    2.3800    2.3900
    2.4000    2.4100    2.4200    2.4300    2.4400    2.4500    2.4600    2.4700
    2.4800    2.4900    2.5000    2.5100    2.5200    2.5300    2.5400    2.5500
    2.5600    2.5700    2.5800    2.5900    2.6000    2.6100    2.6200    2.6300
    2.6400    2.6500    2.6600    2.6700    2.6800    2.6900    2.7000    2.7100
    2.7200    2.7300    2.7400    2.7500    2.7600    2.7700    2.7800    2.7900
    2.8000    2.8100    2.8200    2.8300    2.8400    2.8500    2.8600    2.8700
    2.8800    2.8900    2.9000    2.9100    2.9200    2.9300    2.9400    2.9500
    2.9600    2.9700    2.9800    2.9900    3.0000    3.0100    3.0200    3.0300
    3.0400    3.0500    3.0600    3.0700    3.0800    3.0900    3.1000    3.1100
    3.1200    3.1300    3.1400    3.1500    3.1600    3.1700    3.1800    3.1900
    3.2000    3.2100    3.2200    3.2300    3.2400    3.2500    3.2600    3.2700
    3.2800    3.2900    3.3000    3.3100    3.3200    3.3300    3.3400    3.3500
    3.3600    3.3700    3.3800    3.3900    3.4000    3.4100    3.4200    3.4300
    3.4400    3.4500    3.4600    3.4700    3.4800    3.4900    3.5000    3.5100
    3.5200    3.5300    3.5400    3.5500    3.5600    3.5700    3.5800    3.5900
    3.6000    3.6100    3.6200    3.6300    3.6400    3.6500    3.6600    3.6700
    3.6800    3.6900    3.7000    3.7100    3.7200    3.7300    3.7400    3.7500
    3.7600    3.7700    3.7800    3.7900    3.8000    3.8100    3.8200    3.8300
    3.8400    3.8500    3.8600    3.8700    3.8800    3.8900    3.9000    3.9100
    3.9200    3.9300    3.9400    3.9500    3.9600    3.9700    3.9800    3.9900
    4.0000    4.0100    4.0200    4.0300    4.0400    4.0500    4.0600    4.0700
    4.0800    4.0900    4.1000    4.1100    4.1200    4.1300    4.1400    4.1500
    4.1600    4.1700    4.1800    4.1900    4.2000    4.2100    4.2200    4.2300
    4.2400    4.2500    4.2600    4.2700    4.2800    4.2900    4.3000    4.3100
    4.3200    4.3300    4.3400    4.3500    4.3600    4.3700    4.3800    4.3900
    4.4000    4.4100    4.4200    4.4300    4.4400    4.4500    4.4600    4.4700
    4.4800    4.4900    4.5000    4.5100    4.5200    4.5300    4.5400    4.5500
    4.5600    4.5700    4.5800    4.5900    4.6000    4.6100    4.6200    4.6300
    4.6400    4.6500    4.6600    4.6700    4.6800    4.6900    4.7000    4.7100
    4.7200    4.7300    4.7400    4.7500    4.7600    4.7700    4.7800    4.7900
    4.8000    4.8100    4.8200    4.8300    4.8400    4.8500    4.8600    4.8700
    4.8800    4.8900    4.9000    4.9100    4.9200    4.9300    4.9400    4.9500
    4.9600    4.9700    4.9800    4.9900    5.0000    5.0100    5.0200    5.0300
    5.0400    5.0500    5.0600    5.0700    5.0800    5.0900    5.1000    5.1100
    5.1200    5.1300    5.1400    5.1500    5.1600    5.1700    5.1800    5.1900
    5.2000    5.2100    5.2200    5.2300    5.2400    5.2500    5.2600    5.2700
    5.2800    5.2900    5.3000    5.3100    5.3200    5.3300    5.3400    5.3500
    5.3600    5.3700    5.3800    5.3900    5.4000    5.4100    5.4200    5.4300
    5.4400    5.4500    5.4600    5.4700    5.4800    5.4900    5.5000    5.5100
    5.5200    5.5300    5.5400    5.5500    5.5600    5.5700    5.5800    5.5900
    5.6000    5.6100    5.6200    5.6300    5.6400    5.6500    5.6600    5.6700
    5.6800    5.6900    5.7000    5.7100    5.7200    5.7300    5.7400    5.7500
    5.7600    5.7700    5.7800    5.7900    5.8000    5.8100    5.8200    5.8300
    5.8400    5.8500    5.8600    5.8700    5.8800    5.8900    5.9000    5.9100
    5.9200    5.9300    5.9400    5.9500    5.9600    5.9700    5.9800    5.9900
    6.0000    6.0100
   </PP_R>
   <PP_RAB type="real"  size=" 602" columns="8">
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100    0.0100
    0.0100    0.0100
   </PP_RAB>
 </PP_MESH>
  <PP_LOCAL type="real"  size=" 602" columns="4">
   -9.0610437558E+00   -9.0568179440E+00   -9.0440368423E+00   -9.0228074240E+00
   -8.9932366622E+00   -8.9554713856E+00   -8.9096955089E+00   -8.8561267684E+00
   -8.7950131219E+00   -8.7266289853E+00   -8.6512714714E+00   -8.5692567717E+00
   -8.4809167973E+00   -8.3865961577E+00   -8.2866495257E+00   -8.1814394040E+00
   -8.0713342805E+00   -7.9567071423E+00   -7.8379342970E+00   -7.7153944473E+00
   -7.5894679553E+00   -7.4605362378E+00   -7.3289812341E+00   -7.1951848958E+00
   -7.0595286560E+00   -6.9223928378E+00   -6.7841559816E+00   -6.6451940571E+00
   -6.5058795596E+00   -6.3665804704E+00   -6.2276590796E+00   -6.0894706704E+00
   -5.9523620796E+00   -5.8166700798E+00   -5.6827196991E+00   -5.5508223633E+00
   -5.4212739530E+00   -5.2943527007E+00   -5.1703170897E+00   -5.0494035400E+00
   -4.9318240186E+00   -4.8177636487E+00   -4.7073781566E+00   -4.6007912591E+00
   -4.4980919767E+00   -4.3993318735E+00   -4.3045222275E+00   -4.2136312137E+00
   -4.1265808607E+00   -4.0432438377E+00   -3.9634411592E+00   -3.8869595066E+00
   -3.8135916025E+00   -3.7431452942E+00   -3.6754419749E+00   -3.6103158908E+00
   -3.5476125181E+00   -3.4871882092E+00   -3.4289088467E+00   -3.3726496295E+00
   -3.3182938607E+00   -3.2657329154E+00   -3.2148652694E+00   -3.1655961918E+00
   -3.1178374334E+00   -3.0715065944E+00   -3.0265268914E+00   -2.9828269546E+00
   -2.9403403441E+00   -2.8990053187E+00   -2.8587646530E+00   -2.8195654255E+00
   -2.7813586956E+00   -2.7440993328E+00   -2.7077458096E+00   -2.6722599695E+00
   -2.6376068987E+00   -2.6037546665E+00   -2.5706741108E+00   -2.5383386428E+00
   -2.5067240362E+00   -2.4758082142E+00   -2.4455710353E+00   -2.4159940785E+00
   -2.3870604303E+00   -2.3587544755E+00   -2.3310616932E+00   -2.3039684604E+00
   -2.2774618664E+00   -2.2515295388E+00   -2.2261594843E+00   -2.2013399461E+00
   -2.1770592791E+00   -2.1533058441E+00   -2.1300679226E+00   -2.1073336580E+00
   -2.0850909954E+00   -2.0633276674E+00   -2.0420311892E+00   -2.0211888715E+00
   -2.0007878496E+00   -1.9808151272E+00   -1.9612576275E+00   -1.9421022557E+00
   -1.9233359852E+00   -1.9049459279E+00   -1.8869194114E+00   -1.8692440280E+00
   -1.8519077546E+00   -1.8348990301E+00   -1.8182067760E+00   -1.8018204402E+00
   -1.7857300225E+00   -1.7699262307E+00   -1.7544003587E+00   -1.7391444068E+00
   -1.7241513910E+00   -1.7094149041E+00   -1.6949283914E+00   -1.6806851418E+00
   -1.6666793118E+00   -1.6529050288E+00   -1.6393565372E+00   -1.6260283354E+00
   -1.6129151224E+00   -1.6000117236E+00   -1.5873131231E+00   -1.5748145186E+00
   -1.5625112075E+00   -1.5503986290E+00   -1.5384724172E+00   -1.5267282808E+00
   -1.5151620774E+00   -1.5037698221E+00   -1.4925475838E+00   -1.4814916063E+00
   -1.4705982343E+00   -1.4598638619E+00   -1.4492850817E+00   -1.4388585096E+00
   -1.4285808834E+00   -1.4184490612E+00   -1.4084599113E+00   -1.3986104920E+00
   -1.3888978631E+00   -1.3793192008E+00   -1.3698717674E+00   -1.3605528496E+00
   -1.3513598874E+00   -1.3422902990E+00   -1.3333416549E+00   -1.3245115294E+00
   -1.3157975913E+00   -1.3071975681E+00   -1.2987092220E+00   -1.2903304217E+00
   -1.2820590200E+00   -1.2738930123E+00   -1.2658303454E+00   -1.2578691201E+00
   -1.2500073905E+00   -1.2422433402E+00   -1.2345751282E+00   -1.2270010179E+00
   -1.2195192646E+00   -1.2121282090E+00   -1.2048261947E+00   -1.1976116375E+00
   -1.1904829614E+00   -1.1834386556E+00   -1.1764772175E+00   -1.1695972076E+00
   -1.1627971899E+00   -1.1560757951E+00   -1.1494316470E+00   -1.1428634453E+00
   -1.1363698679E+00   -1.1299496816E+00   -1.1236016133E+00   -1.1173244954E+00
   -1.1111170992E+00   -1.1049783153E+00   -1.0989069715E+00   -1.0929019971E+00
   -1.0869622832E+00   -1.0810867896E+00   -1.0752744716E+00   -1.0695243151E+00
   -1.0638353388E+00   -1.0582065507E+00   -1.0526370315E+00   -1.0471258093E+00
   -1.0416720144E+00   -1.0362747227E+00   -1.0309330806E+00   -1.0256462248E+00
   -1.0204133106E+00   -1.0152335359E+00   -1.0101060634E+00   -1.0050301401E+00
   -1.0000049637E+00   -9.9502979509E-01   -9.9010388850E-01   -9.8522650356E-01
   -9.8039695184E-01   -9.7561449875E-01   -9.7087848953E-01   -9.6618823633E-01
   -9.6154307709E-01   -9.5694238357E-01   -9.5238548542E-01   -9.4787179443E-01
   -9.4340068216E-01   -9.3897154786E-01   -9.3458382085E-01   -9.3023689119E-01
   -9.2593022219E-01   -9.2166324612E-01   -9.1743540867E-01   -9.1324619440E-01
   -9.0909505086E-01   -9.0498147929E-01   -9.0090497409E-01   -8.9686501466E-01
   -8.9286113809E-01   -8.8889284780E-01   -8.8495967058E-01   -8.8106115837E-01
   -8.7719683072E-01   -8.7336625731E-01   -8.6956900186E-01   -8.6580460671E-01
   -8.6207267364E-01   -8.5837277569E-01   -8.5470449112E-01   -8.5106743638E-01
   -8.4746119942E-01   -8.4388539099E-01   -8.4033964140E-01   -8.3682355391E-01
   -8.3333676803E-01   -8.2987892766E-01   -8.2644965155E-01   -8.2304860442E-01
   -8.1967544372E-01   -8.1632980376E-01   -8.1301137110E-01   -8.0971981657E-01
   -8.0645479078E-01   -8.0321599828E-01   -8.0000312317E-01   -7.9681583368E-01
   -7.9365384812E-01   -7.9051686526E-01   -7.8740456836E-01   -7.8431668932E-01
   -7.8125294167E-01   -7.7821302127E-01   -7.7519667347E-01   -7.7220362543E-01
   -7.6923358691E-01   -7.6628631304E-01   -7.6336154485E-01   -7.6045900684E-01
   -7.5757846086E-01   -7.5471966218E-01   -7.5188235009E-01   -7.4906629106E-01
   -7.4627125457E-01   -7.4349699489E-01   -7.4074328111E-01   -7.3800989688E-01
   -7.3529661160E-01   -7.3260319525E-01   -7.2992944541E-01   -7.2727514676E-01
   -7.2464006883E-01   -7.2202402266E-01   -7.1942680330E-01   -7.1684819373E-01
   -7.1428800302E-01   -7.1174604062E-01   -7.0922210469E-01   -7.0671599945E-01
   -7.0422754882E-01   -7.0175656648E-01   -6.9930285090E-01   -6.9686623967E-01
   -6.9444655518E-01   -6.9204361057E-01   -6.8965723548E-01   -6.8728726731E-01
   -6.8493353479E-01   -6.8259585830E-01   -6.8027408946E-01   -6.7796806685E-01
   -6.7567761966E-01   -6.7340259451E-01   -6.7114284334E-01   -6.6889821110E-01
   -6.6666853234E-01   -6.6445367341E-01   -6.6225348756E-01   -6.6006782094E-01
   -6.5789652969E-01   -6.5573948134E-01   -6.5359653600E-01   -6.5146754198E-01
   -6.4935237457E-01   -6.4725090244E-01   -6.4516298961E-01   -6.4308849538E-01
   -6.4102730352E-01   -6.3897928686E-01   -6.3694431188E-01   -6.3492225321E-01
   -6.3291299679E-01   -6.3091642140E-01   -6.2893239660E-01   -6.2696081023E-01
   -6.2500155065E-01   -6.2305450228E-01   -6.2111953833E-01   -6.1919655775E-01
   -6.1728545168E-01   -6.1538610939E-01   -6.1349840980E-01   -6.1162225937E-01
   -6.0975755301E-01   -6.0790418385E-01   -6.0606203900E-01   -6.0423102850E-01
   -6.0241105218E-01   -6.0060200743E-01   -5.9880378789E-01   -5.9701630748E-01
   -5.9523947068E-01   -5.9347317955E-01   -5.9171733268E-01   -5.8997184815E-01
   -5.8823663490E-01   -5.8651159997E-01   -5.8479664543E-01   -5.8309169382E-01
   -5.8139665833E-01   -5.7971145131E-01   -5.7803597694E-01   -5.7637016247E-01
   -5.7471392514E-01   -5.7306718215E-01   -5.7142984084E-01   -5.6980183110E-01
   -5.6818307475E-01   -5.6657349289E-01   -5.6497299873E-01   -5.6338152110E-01
   -5.6179898754E-01   -5.6022532279E-01   -5.5866044633E-01   -5.5710428471E-01
   -5.5555677140E-01   -5.5401783464E-01   -5.5248740049E-01   -5.5096539222E-01
   -5.4945174929E-01   -5.4794640331E-01   -5.4644928588E-01   -5.4496032010E-01
   -5.4347944752E-01   -5.4200660421E-01   -5.4054172497E-01   -5.3908473990E-01
   -5.3763558480E-01   -5.3619420258E-01   -5.3476053107E-01   -5.3333450778E-01
   -5.3191606202E-01   -5.3050514339E-01   -5.2910169262E-01   -5.2770565043E-01
   -5.2631695259E-01   -5.2493554186E-01   -5.2356136607E-01   -5.2219436872E-01
   -5.2083449329E-01   -5.1948167463E-01   -5.1813586721E-01   -5.1679701734E-01
   -5.1546507114E-01   -5.1413997141E-01   -5.1282166293E-01   -5.1151009987E-01
   -5.1020523087E-01   -5.0890700456E-01   -5.0761536348E-01   -5.0633026144E-01
   -5.0505165203E-01   -5.0377948626E-01   -5.0251371517E-01   -5.0125428164E-01
   -5.0000114694E-01   -4.9875426449E-01   -4.9751358757E-01   -4.9627906774E-01
   -4.9505065408E-01   -4.9382830847E-01   -4.9261198641E-01   -4.9140164337E-01
   -4.9019723176E-01   -4.8899870589E-01   -4.8780602831E-01   -4.8661915658E-01
   -4.8543804824E-01   -4.8426265702E-01   -4.8309294118E-01   -4.8192886432E-01
   -4.8077038597E-01   -4.7961746566E-01   -4.7847005879E-01   -4.7732812642E-01
   -4.7619163356E-01   -4.7506054163E-01   -4.7393481203E-01   -4.7281440223E-01
   -4.7169927496E-01   -4.7058939701E-01   -4.6948473158E-01   -4.6838524190E-01
   -4.6729088781E-01   -4.6620163267E-01   -4.6511744539E-01   -4.6403829091E-01
   -4.6296413415E-01   -4.6189493768E-01   -4.6083066451E-01   -4.5977128600E-01
   -4.5871676870E-01   -4.5766707919E-01   -4.5662218308E-01   -4.5558204211E-01
   -4.5454663035E-01   -4.5351591594E-01   -4.5248986699E-01   -4.5146845163E-01
   -4.5045163204E-01   -4.4943938274E-01   -4.4843167416E-01   -4.4742847591E-01
   -4.4642975759E-01   -4.4543548505E-01   -4.4444562951E-01   -4.4346016491E-01
   -4.4247906228E-01   -4.4150229265E-01   -4.4052982584E-01   -4.3956162903E-01
   -4.3859767986E-01   -4.3763795070E-01   -4.3668241393E-01   -4.3573104192E-01
   -4.3478380238E-01   -4.3384067158E-01   -4.3290162488E-01   -4.3196663593E-01
   -4.3103567840E-01   -4.3010872454E-01   -4.2918574490E-01   -4.2826671914E-01
   -4.2735162215E-01   -4.2644042882E-01   -4.2553311405E-01   -4.2462964878E-01
   -4.2373001042E-01   -4.2283417718E-01   -4.2194212512E-01   -4.2105383031E-01
   -4.2016926876E-01   -4.1928841078E-01   -4.1841123932E-01   -4.1753773154E-01
   -4.1666786462E-01   -4.1580161574E-01   -4.1493896037E-01   -4.1407987359E-01
   -4.1322433773E-01   -4.1237233102E-01   -4.1152383170E-01   -4.1067881801E-01
   -4.0983726529E-01   -4.0899915239E-01   -4.0816446135E-01   -4.0733317141E-01
   -4.0650526184E-01   -4.0568071187E-01   -4.0485949712E-01   -4.0404159922E-01
   -4.0322700028E-01   -4.0241568050E-01   -4.0160762012E-01   -4.0080279935E-01
   -4.0000119443E-01   -3.9920278882E-01   -3.9840756506E-01   -3.9761550429E-01
   -3.9682658765E-01   -3.9604079630E-01   -3.9525810742E-01   -3.9447850542E-01
   -3.9370197363E-01   -3.9292849408E-01   -3.9215804879E-01   -3.9139061977E-01
   -3.9062618552E-01   -3.8986473052E-01   -3.8910623925E-01   -3.8835069457E-01
   -3.8759807933E-01   -3.8684837639E-01   -3.8610156584E-01   -3.8535763147E-01
   -3.8461655919E-01   -3.8387833266E-01   -3.8314293554E-01   -3.8241035148E-01
   -3.8168056246E-01   -3.8095355083E-01   -3.8022930425E-01   -3.7950780711E-01
   -3.7878904385E-01   -3.7807299889E-01   -3.7735965635E-01   -3.7664899651E-01
   -3.7594100897E-01   -3.7523567887E-01   -3.7453299135E-01   -3.7383293156E-01
   -3.7313548465E-01   -3.7244063248E-01   -3.7174836252E-01   -3.7105866202E-01
   -3.7037151682E-01   -3.6968691275E-01   -3.6900483566E-01   -3.6832527016E-01
   -3.6764820011E-01   -3.6697361536E-01   -3.6630150240E-01   -3.6563184773E-01
   -3.6496463784E-01   -3.6429985924E-01   -3.6363749507E-01   -3.6297753451E-01
   -3.6231996581E-01   -3.6166477608E-01   -3.6101195247E-01   -3.6036148208E-01
   -3.5971335135E-01   -3.5906754455E-01   -3.5842405304E-01   -3.5778286454E-01
   -3.5714396678E-01   -3.5650734748E-01   -3.5587299437E-01   -3.5524089309E-01
   -3.5461103153E-01   -3.5398340017E-01   -3.5335798731E-01   -3.5273478124E-01
   -3.5211377027E-01   -3.5149494269E-01   -3.5087828373E-01   -3.5026378405E-01
   -3.4965143359E-01   -3.4904122118E-01   -3.4843313568E-01   -3.4782716591E-01
   -3.4722330074E-01   -3.4662152533E-01   -3.4602183228E-01   -3.4542421132E-01
   -3.4482865181E-01   -3.4423514312E-01   -3.4364367460E-01   -3.4305423563E-01
   -3.4246681166E-01   -3.4188139641E-01   -3.4129797977E-01   -3.4071655158E-01
   -3.4013710172E-01   -3.3955962003E-01   -3.3898409638E-01   -3.3841051679E-01
   -3.3783887542E-01   -3.3726916258E-01   -3.3670136861E-01   -3.3613548384E-01
   -3.3557149861E-01   -3.3500940324E-01   -3.3444918462E-01   -3.3389083661E-01
   -3.3333435031E-01   -3.3277971650E-01
  </PP_LOCAL>
 <PP_NONLOCAL>
   <PP_BETA.1
       type="real"
       size=" 602"
       columns="4"
       index="1"
       angular_momentum="0"
       cutoff_radius_index=" 118"
       cutoff_radius="    1.1700000000E+00" >
    0.0000000000E+00   -2.6088547982E-01   -5.1833275472E-01   -7.6895641941E-01
   -1.0094757748E+00   -1.2367649640E+00   -1.4479004921E+00   -1.6402053307E+00
   -1.8112888675E+00   -1.9590820386E+00   -2.0818670611E+00   -2.1783012866E+00
   -2.2474347945E+00   -2.2887214604E+00   -2.3020233440E+00   -2.2876083718E+00
   -2.2461413919E+00   -2.1786688108E+00   -2.0865971283E+00   -1.9716657861E+00
   -1.8359148921E+00   -1.6816483354E+00   -1.5113931252E+00   -1.3278555788E+00
   -1.1338753152E+00   -9.3237750193E-01   -7.2632508798E-01   -5.1867053707E-01
   -3.1230935470E-01   -1.1003518382E-01    8.5502335005E-02    2.7183628053E-01
    4.4671684037E-01    6.0814212888E-01    7.5438240005E-01    8.8400019998E-01
    9.9586420814E-01    1.0891579569E+00    1.1633817902E+00    1.2183503968E+00
    1.2541845008E+00    1.2712971870E+00    1.2703761390E+00    1.2523616859E+00
    1.2184214326E+00    1.1699221627E+00    1.1083997635E+00    1.0355281365E+00
    9.5308744579E-01    8.6293235820E-01    7.6696227219E-01    6.6708583573E-01
    5.6517138232E-01    4.6301269339E-01    3.6230358110E-01    2.6460354791E-01
    1.7132725391E-01    8.3714876259E-02    2.8300950036E-03   -7.0461868736E-02
   -1.3548566127E-01   -1.9177104351E-01   -2.3903864371E-01   -2.7719764878E-01
   -3.0633813688E-01   -3.2671240755E-01   -3.3872209753E-01   -3.4290134301E-01
   -3.3989414704E-01   -3.3043492034E-01   -3.1532726713E-01   -2.9542143883E-01
   -2.7159339422E-01   -2.4472437166E-01   -2.1568159041E-01   -1.8530141020E-01
   -1.5437121547E-01   -1.2361699029E-01   -9.3692510618E-02   -6.5170103885E-02
   -3.8534327148E-02   -1.4178178357E-02    7.5982219585E-03    2.6586599843E-02
    4.2667321458E-02    5.5804230200E-02    6.6037784474E-02    7.3476782950E-02
    7.8288985480E-02    8.0690950459E-02    8.0937413388E-02    7.9310526716E-02
    7.6109267813E-02    7.1639300505E-02    6.6203546315E-02    6.0094670030E-02
    5.3585181276E-02    4.6922886516E-02    4.0325965406E-02    3.3979459512E-02
    2.8033278554E-02    2.2601546887E-02    1.7764693923E-02    1.3566271071E-02
    1.0019934924E-02    7.1127553803E-03    4.8089618584E-03    3.0547066732E-03
    1.7812642827E-03    9.1198278094E-04    3.6682674818E-04    6.5692263071E-05
   -6.8632527182E-05   -1.1027997757E-04   -8.4781932173E-05   -7.5466225625E-06
    5.5046813283E-06    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00
   </PP_BETA.1>
   <PP_BETA.2
       type="real"
       size=" 602"
       columns="4"
       index="2"
       angular_momentum="0"
       cutoff_radius_index=" 118"
       cutoff_radius="    1.1700000000E+00" >
    0.0000000000E+00   -6.6230384280E-02   -1.3227044522E-01   -1.9793408785E-01
   -2.6304354775E-01   -3.2743324392E-01   -3.9095326529E-01   -4.5347238282E-01
   -5.1488049086E-01   -5.7509039536E-01   -6.3403888294E-01   -6.9168702295E-01
   -7.4801967384E-01   -8.0304418574E-01   -8.5678831251E-01   -9.0929736637E-01
   -9.6063067143E-01   -1.0108573877E+00   -1.0600518025E+00   -1.1082881938E+00
   -1.1556354004E+00   -1.2021512134E+00   -1.2478767659E+00   -1.2928310462E+00
   -1.3370057140E+00   -1.3803603227E+00   -1.4228182118E+00   -1.4642630461E+00
   -1.5045363102E+00   -1.5434357567E+00   -1.5807149649E+00   -1.6160840886E+00
   -1.6492118605E+00   -1.6797288707E+00   -1.7072322005E+00   -1.7312913303E+00
   -1.7514553443E+00   -1.7672614056E+00   -1.7782442660E+00   -1.7839469588E+00
   -1.7839324513E+00   -1.7777959450E+00   -1.7651779669E+00   -1.7457779317E+00
   -1.7193680413E+00   -1.6858073499E+00   -1.6450558238E+00   -1.5971880652E+00
   -1.5424070527E+00   -1.4810575934E+00   -1.4136370872E+00   -1.3407629725E+00
   -1.2630862948E+00   -1.1812692944E+00   -1.0959852410E+00   -1.0079152517E+00
   -9.1774784801E-01   -8.2617381277E-01   -7.3388443997E-01   -6.4156480522E-01
   -5.4989159388E-01   -4.5952456379E-01   -3.7110347095E-01   -2.8524119151E-01
   -2.0251655480E-01   -1.2347058174E-01   -4.8599831493E-02    2.1650489647E-02
    8.6889253952E-02    1.4678399897E-01    2.0106542651E-01    2.4953062217E-01
    2.9204347185E-01    3.2853617819E-01    3.5900919836E-01    3.8352979134E-01
    4.0223095680E-01    4.1530746441E-01    4.2301167574E-01    4.2564876217E-01
    4.2357093422E-01    4.1717097424E-01    4.0687519421E-01    3.9313595295E-01
    3.7642387716E-01    3.5721993688E-01    3.3600752955E-01    3.1326472631E-01
    2.8945683082E-01    2.6502939400E-01    2.4040181789E-01    2.1596166863E-01
    1.9205980225E-01    1.6900638782E-01    1.4706789081E-01    1.2646640479E-01
    1.0737471459E-01    8.9919605583E-02    7.4182301027E-02    6.0200233461E-02
    4.7969874788E-02    3.7450322138E-02    2.8568294126E-02    2.1219868525E-02
    1.5278963151E-02    1.0602331228E-02    7.0348351713E-03    4.4142517848E-03
    2.5774088544E-03    1.3667064349E-03    6.3345563442E-04    2.4137577893E-04
    6.9281378302E-05    2.0772501814E-05    1.5017397331E-05    1.0881212294E-06
   -1.0503836267E-06    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00    0.0000000000E+00
    0.0000000000E+00    0.0000000000E+00
   </PP_BETA.2>
   <PP_DIJ type="real"  size="   4" columns="4">
   -2.4016441487E+01    0.0000000000E+00    0.0000000000E+00   -1.0336462913E+00
   </PP_DIJ>
 </PP_NONLOCAL>
 <PP_PSWFC>
 </PP_PSWFC>
 <PP_RHOATOM type="real"  size=" 602" columns="4">
    0.0000000000E+00    2.4794341471E-04    9.9091894057E-04    2.2263680628E-03
    3.9500456984E-03    6.1560486329E-03    8.8368548808E-03    1.1983373531E-02
    1.5585004525E-02    1.9629707710E-02    2.4104080427E-02    2.8993442803E-02
    3.4281929867E-02    3.9952589544E-02    4.5987485557E-02    5.2367804247E-02
    5.9073964300E-02    6.6085728409E-02    7.3382315882E-02    8.0942515274E-02
    8.8744796138E-02    9.6767419086E-02    1.0498854333E-01    1.1338633103E-01
    1.2193904783E-01    1.3062515893E-01    1.3942342031E-01    1.4831296458E-01
    1.5727338117E-01    1.6628479066E-01    1.7532791282E-01    1.8438412840E-01
    1.9343553473E-01    2.0246499428E-01    2.1145617765E-01    2.2039359948E-01
    2.2926264851E-01    2.3804961085E-01    2.4674168841E-01    2.5532701021E-01
    2.6379463827E-01    2.7213456885E-01    2.8033772768E-01    2.8839596035E-01
    2.9630201805E-01    3.0404953869E-01    3.1163302393E-01    3.1904781286E-01
    3.2629005077E-01    3.3335665407E-01    3.4024527527E-01    3.4695426557E-01
    3.5348262690E-01    3.5982997159E-01    3.6599648316E-01    3.7198285339E-01
    3.7779025613E-01    3.8342027746E-01    3.8887488964E-01    3.9415637933E-01
    3.9926732777E-01    4.0421053528E-01    4.0898900016E-01    4.1360586662E-01
    4.1806437563E-01    4.2236784139E-01    4.2651960765E-01    4.3052300623E-01
    4.3438133902E-01    4.3809784793E-01    4.4167568640E-01    4.4511789734E-01
    4.4842740211E-01    4.5160698378E-01    4.5465927654E-01    4.5758675943E-01
    4.6039174939E-01    4.6307640307E-01    4.6564271888E-01    4.6809254111E-01
    4.7042756695E-01    4.7264935579E-01    4.7475934017E-01    4.7675883847E-01
    4.7864906862E-01    4.8043116285E-01    4.8210618286E-01    4.8367513530E-01
    4.8513898716E-01    4.8649868075E-01    4.8775514807E-01    4.8890932424E-01
    4.8996215983E-01    4.9091463191E-01    4.9176775358E-01    4.9252257613E-01
    4.9318021185E-01    4.9374182540E-01    4.9420863911E-01    4.9458193531E-01
    4.9486305613E-01    4.9505340201E-01    4.9515442062E-01    4.9516762730E-01
    4.9509458085E-01    4.9493687901E-01    4.9469615451E-01    4.9437406196E-01
    4.9397228868E-01    4.9349254046E-01    4.9293652709E-01    4.9230595866E-01
    4.9160253929E-01    4.9082798382E-01    4.8998398626E-01    4.8907222166E-01
    4.8809434735E-01    4.8705202061E-01    4.8594687199E-01    4.8478050140E-01
    4.8355451132E-01    4.8227048421E-01    4.8092996944E-01    4.7953450212E-01
    4.7808561574E-01    4.7658480457E-01    4.7503353906E-01    4.7343329913E-01
    4.7178551873E-01    4.7009160857E-01    4.6835299066E-01    4.6657103314E-01
    4.6474709403E-01    4.6288253276E-01    4.6097864623E-01    4.5903674889E-01
    4.5705812988E-01    4.5504401645E-01    4.5299568348E-01    4.5091433129E-01
    4.4880115759E-01    4.4665736345E-01    4.4448406520E-01    4.4228244437E-01
    4.4005359528E-01    4.3779862199E-01    4.3551861800E-01    4.3321460984E-01
    4.3088768122E-01    4.2853880795E-01    4.2616903012E-01    4.2377930732E-01
    4.2137061147E-01    4.1894389471E-01    4.1650006236E-01    4.1404005773E-01
    4.1156472312E-01    4.0907498816E-01    4.0657164288E-01    4.0405558773E-01
    4.0152758537E-01    3.9898848719E-01    3.9643903481E-01    3.9388003353E-01
    3.9131220208E-01    3.8873630343E-01    3.8615303095E-01    3.8356310956E-01
    3.8096720441E-01    3.7836600704E-01    3.7576015114E-01    3.7315029989E-01
    3.7053705201E-01    3.6792104757E-01    3.6530284664E-01    3.6268307155E-01
    3.6006223998E-01    3.5744096187E-01    3.5481970890E-01    3.5219908368E-01
    3.4957950873E-01    3.4696157326E-01    3.4434567985E-01    3.4173237209E-01
    3.3912205408E-01    3.3651521191E-01    3.3391226115E-01    3.3131362397E-01
    3.2871973492E-01    3.2613094713E-01    3.2354771963E-01    3.2097033407E-01
    3.1839925340E-01    3.1583475732E-01    3.1327723928E-01    3.1072701520E-01
    3.0818439374E-01    3.0564973754E-01    3.0312326636E-01    3.0060536753E-01
    2.9809624731E-01    2.9559622996E-01    2.9310557269E-01    2.9062449750E-01
    2.8815332279E-01    2.8569218837E-01    2.8324141465E-01    2.8080118028E-01
    2.7837169267E-01    2.7595321500E-01    2.7354583751E-01    2.7114985674E-01
    2.6876540189E-01    2.6639264465E-01    2.6403181011E-01    2.6168295407E-01
    2.5934632864E-01    2.5702204381E-01    2.5471021239E-01    2.5241103884E-01
    2.5012456127E-01    2.4785096372E-01    2.4559036883E-01    2.4334280687E-01
    2.4110847696E-01    2.3888742000E-01    2.3667972467E-01    2.3448553732E-01
    2.3230484695E-01    2.3013779622E-01    2.2798447164E-01    2.2584484162E-01
    2.2371907224E-01    2.2160718423E-01    2.1950918491E-01    2.1742520274E-01
    2.1535521910E-01    2.1329927590E-01    2.1125746569E-01    2.0922973692E-01
    2.0721615973E-01    2.0521679417E-01    2.0323156191E-01    2.0126055392E-01
    1.9930380230E-01    1.9736120736E-01    1.9543287344E-01    1.9351880846E-01
    1.9161889992E-01    1.8973325450E-01    1.8786185993E-01    1.8600460254E-01
    1.8416157699E-01    1.8233276208E-01    1.8051803620E-01    1.7871748583E-01
    1.7693108606E-01    1.7515870043E-01    1.7340041110E-01    1.7165618863E-01
    1.6992589269E-01    1.6820958701E-01    1.6650724345E-01    1.6481872662E-01
    1.6314406985E-01    1.6148325248E-01    1.5983614921E-01    1.5820275480E-01
    1.5658306061E-01    1.5497695691E-01    1.5338439180E-01    1.5180537259E-01
    1.5023981072E-01    1.4868760030E-01    1.4714876754E-01    1.4562325032E-01
    1.4411088316E-01    1.4261171261E-01    1.4112567980E-01    1.3965263949E-01
    1.3819257554E-01    1.3674545831E-01    1.3531117665E-01    1.3388963650E-01
    1.3248084168E-01    1.3108472136E-01    1.2970109889E-01    1.2833001076E-01
    1.2697139008E-01    1.2562509939E-01    1.2429108335E-01    1.2296931894E-01
    1.2165971717E-01    1.2036212317E-01    1.1907655698E-01    1.1780294648E-01
    1.1654114810E-01    1.1529111045E-01    1.1405280258E-01    1.1282613765E-01
    1.1161095024E-01    1.1040725990E-01    1.0921499300E-01    1.0803401854E-01
    1.0686425527E-01    1.0570568262E-01    1.0455822148E-01    1.0342170539E-01
    1.0229612790E-01    1.0118143008E-01    1.0007751189E-01    9.8984230691E-02
    9.7901591614E-02    9.6829518883E-02    9.5767884597E-02    9.4716602554E-02
    9.3675651345E-02    9.2644952595E-02    9.1624357062E-02    9.0613825474E-02
    8.9613313452E-02    8.8622740963E-02    8.7641943554E-02    8.6670918562E-02
    8.5709603256E-02    8.4757913158E-02    8.3815684928E-02    8.2882931486E-02
    8.1959580376E-02    8.1045538566E-02    8.0140663081E-02    7.9244958367E-02
    7.8358352085E-02    7.7480747512E-02    7.6612013484E-02    7.5752149816E-02
    7.4901084880E-02    7.4058722878E-02    7.3224935982E-02    7.2399723308E-02
    7.1583014448E-02    7.0774718909E-02    6.9974704043E-02    6.9182972050E-02
    6.8399454182E-02    6.7624069401E-02    6.6856672591E-02    6.6097272493E-02
    6.5345802386E-02    6.4602189287E-02    6.3866284591E-02    6.3138090627E-02
    6.2417548303E-02    6.1704587356E-02    6.0999076474E-02    6.0300987164E-02
    5.9610277067E-02    5.8926878874E-02    5.8250682553E-02    5.7581621736E-02
    5.6919673704E-02    5.6264774278E-02    5.5616838504E-02    5.4975756187E-02
    5.4341526243E-02    5.3714087760E-02    5.3093374958E-02    5.2479257060E-02
    5.1871728058E-02    5.1270739451E-02    5.0676229134E-02    5.0088097362E-02
    4.9506279485E-02    4.8930756928E-02    4.8361471290E-02    4.7798357672E-02
    4.7241288817E-02    4.6690276084E-02    4.6145264773E-02    4.5606196203E-02
    4.5072972721E-02    4.4545541444E-02    4.4023881815E-02    4.3507939101E-02
    4.2997654834E-02    4.2492905991E-02    4.1993703269E-02    4.1499997132E-02
    4.1011733250E-02    4.0528830544E-02    4.0051217904E-02    3.9578886841E-02
    3.9111787057E-02    3.8649865000E-02    3.8193021326E-02    3.7741231625E-02
    3.7294467263E-02    3.6852678829E-02    3.6415813870E-02    3.5983760247E-02
    3.5556530198E-02    3.5134078994E-02    3.4716358396E-02    3.4303305080E-02
    3.3894835682E-02    3.3490952616E-02    3.3091611670E-02    3.2696766006E-02
    3.2306344980E-02    3.1920288091E-02    3.1538589081E-02    3.1161205154E-02
    3.0788091067E-02    3.0419172782E-02    3.0054404780E-02    2.9693775584E-02
    2.9337243976E-02    2.8984766463E-02    2.8636269166E-02    2.8291714111E-02
    2.7951087999E-02    2.7614351317E-02    2.7281462438E-02    2.6952350866E-02
    2.6626979290E-02    2.6305335782E-02    2.5987382630E-02    2.5673080163E-02
    2.5362364216E-02    2.5055191839E-02    2.4751555386E-02    2.4451419017E-02
    2.4154745071E-02    2.3861478444E-02    2.3571564847E-02    2.3285003479E-02
    2.3001760410E-02    2.2721800031E-02    2.2445078789E-02    2.2171526061E-02
    2.1901150013E-02    2.1633918647E-02    2.1369798413E-02    2.1108754197E-02
    2.0850710883E-02    2.0595671221E-02    2.0343610458E-02    2.0094497098E-02
    1.9848298202E-02    1.9604955310E-02    1.9364442566E-02    1.9126750436E-02
    1.8891849457E-02    1.8659708833E-02    1.8430288872E-02    1.8203531688E-02
    1.7979444001E-02    1.7757998342E-02    1.7539166017E-02    1.7322917097E-02
    1.7109191383E-02    1.6897980399E-02    1.6689269114E-02    1.6483030879E-02
    1.6279237912E-02    1.6077852629E-02    1.5878825755E-02    1.5682162720E-02
    1.5487838857E-02    1.5295828455E-02    1.5106104755E-02    1.4918616206E-02
    1.4733348857E-02    1.4550292886E-02    1.4369424576E-02    1.4190719249E-02
    1.4014151128E-02    1.3839659221E-02    1.3667256683E-02    1.3496921706E-02
    1.3328631601E-02    1.3162362793E-02    1.2998080875E-02    1.2835748138E-02
    1.2675368275E-02    1.2516920489E-02    1.2360383178E-02    1.2205733920E-02
    1.2052932833E-02    1.1901959252E-02    1.1752810004E-02    1.1605465350E-02
    1.1459904808E-02    1.1316107146E-02    1.1174029833E-02    1.1033663349E-02
    1.0895000275E-02    1.0758021954E-02    1.0622709048E-02    1.0489041530E-02
    1.0356976695E-02    1.0226510813E-02    1.0097634680E-02    9.9703307378E-03
    9.8445807986E-03    9.7203660474E-03    9.5976457522E-03    9.4764172062E-03
    9.3566716576E-03    9.2383926415E-03    9.1215631207E-03    9.0061654822E-03
    8.8921628626E-03    8.7795493594E-03    8.6683186485E-03    8.5584553503E-03
    8.4499435627E-03    8.3427668572E-03    8.2368939208E-03    8.1323119604E-03
    8.0290187790E-03    7.9270000634E-03    7.8262410234E-03    7.7267263895E-03
    7.6284318873E-03    7.5313346684E-03    7.4354380585E-03    7.3407287840E-03
    7.2471931373E-03    7.1548169739E-03    7.0635843287E-03    6.9734597403E-03
    6.8844530956E-03    6.7965521281E-03    6.7097441767E-03    6.6240161831E-03
    6.5393546899E-03    6.4557301699E-03    6.3731393266E-03    6.2915776433E-03
    6.2110334645E-03    6.1314947748E-03    6.0529491959E-03    5.9753783320E-03
    5.8987597471E-03    5.8230986296E-03    5.7483842858E-03    5.6746056953E-03
    5.6017515092E-03    5.5298100485E-03    5.4587541386E-03    5.3885834526E-03
    5.3192932870E-03    5.2508735670E-03    5.1833139204E-03    5.1166036764E-03
    5.0507287806E-03    4.9856653379E-03    4.9214203547E-03    4.8579846503E-03
    4.7953487751E-03    4.7335030098E-03    4.6724373639E-03    4.6121326368E-03
    4.5525789599E-03    4.4937772672E-03    4.4357189771E-03    4.3783952646E-03
    4.3217970601E-03    4.2659150477E-03    4.2107269600E-03    4.1562326781E-03
    4.1024289394E-03    4.0493077557E-03    3.9968609188E-03    3.9450799988E-03
    3.8939563432E-03    3.8434664007E-03    3.7936159723E-03    3.7443993547E-03
    3.6958091420E-03    3.6478377293E-03    3.6004773117E-03    3.5537198828E-03
    3.5075421006E-03    3.4619523711E-03    3.4169441116E-03    3.3725104825E-03
    3.3286444647E-03    3.2853388583E-03    3.2425862821E-03    3.2003648485E-03
    3.1586827452E-03    3.1175338565E-03    3.0769118893E-03    3.0368103888E-03
    2.9972227375E-03    2.9581421546E-03    2.9195492532E-03    2.8814496160E-03
    2.8438387299E-03    2.8067108257E-03
 </PP_RHOATOM>
</UPF>"""
