// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cognitoidentity provides a client for Amazon Cognito Identity.
package cognitoidentity

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateIdentityPool = "CreateIdentityPool"

// CreateIdentityPoolRequest generates a request for the CreateIdentityPool operation.
func (c *CognitoIdentity) CreateIdentityPoolRequest(input *CreateIdentityPoolInput) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opCreateIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIdentityPoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IdentityPool{}
	req.Data = output
	return
}

// Creates a new identity pool. The identity pool is a store of user identity
// information that is specific to your AWS account. The limit on identity pools
// is 60 per account. You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) CreateIdentityPool(input *CreateIdentityPoolInput) (*IdentityPool, error) {
	req, out := c.CreateIdentityPoolRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIdentities = "DeleteIdentities"

// DeleteIdentitiesRequest generates a request for the DeleteIdentities operation.
func (c *CognitoIdentity) DeleteIdentitiesRequest(input *DeleteIdentitiesInput) (req *request.Request, output *DeleteIdentitiesOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIdentitiesOutput{}
	req.Data = output
	return
}

// Deletes identities from an identity pool. You can specify a list of 1-60
// identities that you want to delete.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) DeleteIdentities(input *DeleteIdentitiesInput) (*DeleteIdentitiesOutput, error) {
	req, out := c.DeleteIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIdentityPool = "DeleteIdentityPool"

// DeleteIdentityPoolRequest generates a request for the DeleteIdentityPool operation.
func (c *CognitoIdentity) DeleteIdentityPoolRequest(input *DeleteIdentityPoolInput) (req *request.Request, output *DeleteIdentityPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPoolInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteIdentityPoolOutput{}
	req.Data = output
	return
}

// Deletes a user pool. Once a pool is deleted, users will not be able to authenticate
// with the pool.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) DeleteIdentityPool(input *DeleteIdentityPoolInput) (*DeleteIdentityPoolOutput, error) {
	req, out := c.DeleteIdentityPoolRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdentity = "DescribeIdentity"

// DescribeIdentityRequest generates a request for the DescribeIdentity operation.
func (c *CognitoIdentity) DescribeIdentityRequest(input *DescribeIdentityInput) (req *request.Request, output *IdentityDescription) {
	op := &request.Operation{
		Name:       opDescribeIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IdentityDescription{}
	req.Data = output
	return
}

// Returns metadata related to the given identity, including when the identity
// was created and any associated linked logins.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) DescribeIdentity(input *DescribeIdentityInput) (*IdentityDescription, error) {
	req, out := c.DescribeIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdentityPool = "DescribeIdentityPool"

// DescribeIdentityPoolRequest generates a request for the DescribeIdentityPool operation.
func (c *CognitoIdentity) DescribeIdentityPoolRequest(input *DescribeIdentityPoolInput) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opDescribeIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityPoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IdentityPool{}
	req.Data = output
	return
}

// Gets details about a particular identity pool, including the pool name, ID
// description, creation date, and current number of users.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) DescribeIdentityPool(input *DescribeIdentityPoolInput) (*IdentityPool, error) {
	req, out := c.DescribeIdentityPoolRequest(input)
	err := req.Send()
	return out, err
}

const opGetCredentialsForIdentity = "GetCredentialsForIdentity"

// GetCredentialsForIdentityRequest generates a request for the GetCredentialsForIdentity operation.
func (c *CognitoIdentity) GetCredentialsForIdentityRequest(input *GetCredentialsForIdentityInput) (req *request.Request, output *GetCredentialsForIdentityOutput) {
	op := &request.Operation{
		Name:       opGetCredentialsForIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialsForIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCredentialsForIdentityOutput{}
	req.Data = output
	return
}

// Returns credentials for the the provided identity ID. Any provided logins
// will be validated against supported login providers. If the token is for
// cognito-identity.amazonaws.com, it will be passed through to AWS Security
// Token Service with the appropriate role for the token.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) GetCredentialsForIdentity(input *GetCredentialsForIdentityInput) (*GetCredentialsForIdentityOutput, error) {
	req, out := c.GetCredentialsForIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opGetId = "GetId"

// GetIdRequest generates a request for the GetId operation.
func (c *CognitoIdentity) GetIdRequest(input *GetIdInput) (req *request.Request, output *GetIdOutput) {
	op := &request.Operation{
		Name:       opGetId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdOutput{}
	req.Data = output
	return
}

// Generates (or retrieves) a Cognito ID. Supplying multiple logins will create
// an implicit linked account.
//
// token+";"+tokenSecret.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) GetId(input *GetIdInput) (*GetIdOutput, error) {
	req, out := c.GetIdRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityPoolRoles = "GetIdentityPoolRoles"

// GetIdentityPoolRolesRequest generates a request for the GetIdentityPoolRoles operation.
func (c *CognitoIdentity) GetIdentityPoolRolesRequest(input *GetIdentityPoolRolesInput) (req *request.Request, output *GetIdentityPoolRolesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPoolRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoolRolesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityPoolRolesOutput{}
	req.Data = output
	return
}

// Gets the roles for an identity pool.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) GetIdentityPoolRoles(input *GetIdentityPoolRolesInput) (*GetIdentityPoolRolesOutput, error) {
	req, out := c.GetIdentityPoolRolesRequest(input)
	err := req.Send()
	return out, err
}

const opGetOpenIdToken = "GetOpenIdToken"

// GetOpenIdTokenRequest generates a request for the GetOpenIdToken operation.
func (c *CognitoIdentity) GetOpenIdTokenRequest(input *GetOpenIdTokenInput) (req *request.Request, output *GetOpenIdTokenOutput) {
	op := &request.Operation{
		Name:       opGetOpenIdToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIdTokenInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOpenIdTokenOutput{}
	req.Data = output
	return
}

// Gets an OpenID token, using a known Cognito ID. This known Cognito ID is
// returned by GetId. You can optionally add additional logins for the identity.
// Supplying multiple logins creates an implicit link.
//
// The OpenId token is valid for 15 minutes.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) GetOpenIdToken(input *GetOpenIdTokenInput) (*GetOpenIdTokenOutput, error) {
	req, out := c.GetOpenIdTokenRequest(input)
	err := req.Send()
	return out, err
}

const opGetOpenIdTokenForDeveloperIdentity = "GetOpenIdTokenForDeveloperIdentity"

// GetOpenIdTokenForDeveloperIdentityRequest generates a request for the GetOpenIdTokenForDeveloperIdentity operation.
func (c *CognitoIdentity) GetOpenIdTokenForDeveloperIdentityRequest(input *GetOpenIdTokenForDeveloperIdentityInput) (req *request.Request, output *GetOpenIdTokenForDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opGetOpenIdTokenForDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIdTokenForDeveloperIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOpenIdTokenForDeveloperIdentityOutput{}
	req.Data = output
	return
}

// Registers (or retrieves) a Cognito IdentityId and an OpenID Connect token
// for a user authenticated by your backend authentication process. Supplying
// multiple logins will create an implicit linked account. You can only specify
// one developer provider as part of the Logins map, which is linked to the
// identity pool. The developer provider is the "domain" by which Cognito will
// refer to your users.
//
// You can use GetOpenIdTokenForDeveloperIdentity to create a new identity
// and to link new logins (that is, user credentials issued by a public provider
// or developer provider) to an existing identity. When you want to create a
// new identity, the IdentityId should be null. When you want to associate a
// new login with an existing authenticated/unauthenticated identity, you can
// do so by providing the existing IdentityId. This API will create the identity
// in the specified IdentityPoolId.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) GetOpenIdTokenForDeveloperIdentity(input *GetOpenIdTokenForDeveloperIdentityInput) (*GetOpenIdTokenForDeveloperIdentityOutput, error) {
	req, out := c.GetOpenIdTokenForDeveloperIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a request for the ListIdentities operation.
func (c *CognitoIdentity) ListIdentitiesRequest(input *ListIdentitiesInput) (req *request.Request, output *ListIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentitiesOutput{}
	req.Data = output
	return
}

// Lists the identities in a pool.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

const opListIdentityPools = "ListIdentityPools"

// ListIdentityPoolsRequest generates a request for the ListIdentityPools operation.
func (c *CognitoIdentity) ListIdentityPoolsRequest(input *ListIdentityPoolsInput) (req *request.Request, output *ListIdentityPoolsOutput) {
	op := &request.Operation{
		Name:       opListIdentityPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoolsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentityPoolsOutput{}
	req.Data = output
	return
}

// Lists all of the Cognito identity pools registered for your account.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) ListIdentityPools(input *ListIdentityPoolsInput) (*ListIdentityPoolsOutput, error) {
	req, out := c.ListIdentityPoolsRequest(input)
	err := req.Send()
	return out, err
}

const opLookupDeveloperIdentity = "LookupDeveloperIdentity"

// LookupDeveloperIdentityRequest generates a request for the LookupDeveloperIdentity operation.
func (c *CognitoIdentity) LookupDeveloperIdentityRequest(input *LookupDeveloperIdentityInput) (req *request.Request, output *LookupDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opLookupDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LookupDeveloperIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LookupDeveloperIdentityOutput{}
	req.Data = output
	return
}

// Retrieves the IdentityID associated with a DeveloperUserIdentifier or the
// list of DeveloperUserIdentifiers associated with an IdentityId for an existing
// identity. Either IdentityID or DeveloperUserIdentifier must not be null.
// If you supply only one of these values, the other value will be searched
// in the database and returned as a part of the response. If you supply both,
// DeveloperUserIdentifier will be matched against IdentityID. If the values
// are verified against the database, the response returns both values and is
// the same as the request. Otherwise a ResourceConflictException is thrown.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) LookupDeveloperIdentity(input *LookupDeveloperIdentityInput) (*LookupDeveloperIdentityOutput, error) {
	req, out := c.LookupDeveloperIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opMergeDeveloperIdentities = "MergeDeveloperIdentities"

// MergeDeveloperIdentitiesRequest generates a request for the MergeDeveloperIdentities operation.
func (c *CognitoIdentity) MergeDeveloperIdentitiesRequest(input *MergeDeveloperIdentitiesInput) (req *request.Request, output *MergeDeveloperIdentitiesOutput) {
	op := &request.Operation{
		Name:       opMergeDeveloperIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeDeveloperIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MergeDeveloperIdentitiesOutput{}
	req.Data = output
	return
}

// Merges two users having different IdentityIds, existing in the same identity
// pool, and identified by the same developer provider. You can use this action
// to request that discrete users be merged and identified as a single user
// in the Cognito environment. Cognito associates the given source user (SourceUserIdentifier)
// with the IdentityId of the DestinationUserIdentifier. Only developer-authenticated
// users can be merged. If the users to be merged are associated with the same
// public provider, but as two different users, an exception will be thrown.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) MergeDeveloperIdentities(input *MergeDeveloperIdentitiesInput) (*MergeDeveloperIdentitiesOutput, error) {
	req, out := c.MergeDeveloperIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityPoolRoles = "SetIdentityPoolRoles"

// SetIdentityPoolRolesRequest generates a request for the SetIdentityPoolRoles operation.
func (c *CognitoIdentity) SetIdentityPoolRolesRequest(input *SetIdentityPoolRolesInput) (req *request.Request, output *SetIdentityPoolRolesOutput) {
	op := &request.Operation{
		Name:       opSetIdentityPoolRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityPoolRolesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetIdentityPoolRolesOutput{}
	req.Data = output
	return
}

// Sets the roles for an identity pool. These roles are used when making calls
// to GetCredentialsForIdentity action.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) SetIdentityPoolRoles(input *SetIdentityPoolRolesInput) (*SetIdentityPoolRolesOutput, error) {
	req, out := c.SetIdentityPoolRolesRequest(input)
	err := req.Send()
	return out, err
}

const opUnlinkDeveloperIdentity = "UnlinkDeveloperIdentity"

// UnlinkDeveloperIdentityRequest generates a request for the UnlinkDeveloperIdentity operation.
func (c *CognitoIdentity) UnlinkDeveloperIdentityRequest(input *UnlinkDeveloperIdentityInput) (req *request.Request, output *UnlinkDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opUnlinkDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlinkDeveloperIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UnlinkDeveloperIdentityOutput{}
	req.Data = output
	return
}

// Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked developer
// users will be considered new identities next time they are seen. If, for
// a given Cognito identity, you remove all federated identities as well as
// the developer user identifier, the Cognito identity becomes inaccessible.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) UnlinkDeveloperIdentity(input *UnlinkDeveloperIdentityInput) (*UnlinkDeveloperIdentityOutput, error) {
	req, out := c.UnlinkDeveloperIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opUnlinkIdentity = "UnlinkIdentity"

// UnlinkIdentityRequest generates a request for the UnlinkIdentity operation.
func (c *CognitoIdentity) UnlinkIdentityRequest(input *UnlinkIdentityInput) (req *request.Request, output *UnlinkIdentityOutput) {
	op := &request.Operation{
		Name:       opUnlinkIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlinkIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UnlinkIdentityOutput{}
	req.Data = output
	return
}

// Unlinks a federated identity from an existing account. Unlinked logins will
// be considered new identities next time they are seen. Removing the last linked
// login will make this identity inaccessible.
//
// This is a public API. You do not need any credentials to call this API.
func (c *CognitoIdentity) UnlinkIdentity(input *UnlinkIdentityInput) (*UnlinkIdentityOutput, error) {
	req, out := c.UnlinkIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateIdentityPool = "UpdateIdentityPool"

// UpdateIdentityPoolRequest generates a request for the UpdateIdentityPool operation.
func (c *CognitoIdentity) UpdateIdentityPoolRequest(input *IdentityPool) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opUpdateIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IdentityPool{}
	}

	req = c.newRequest(op, input, output)
	output = &IdentityPool{}
	req.Data = output
	return
}

// Updates a user pool.
//
// You must use AWS Developer credentials to call this API.
func (c *CognitoIdentity) UpdateIdentityPool(input *IdentityPool) (*IdentityPool, error) {
	req, out := c.UpdateIdentityPoolRequest(input)
	err := req.Send()
	return out, err
}

// Input to the CreateIdentityPool action.
type CreateIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// TRUE if the identity pool supports unauthenticated logins.
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// The "domain" by which Cognito will refer to your users. This name acts as
	// a placeholder that allows your backend and the Cognito service to communicate
	// about the developer provider. For the DeveloperProviderName, you can use
	// letters as well as period (.), underscore (_), and dash (-).
	//
	// Once you have set a developer provider name, you cannot change it. Please
	// take care in setting this parameter.
	DeveloperProviderName *string `min:"1" type:"string"`

	// A string that you provide.
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []*string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIdentityPoolInput) GoString() string {
	return s.String()
}

// Credentials for the the provided identity ID.
type Credentials struct {
	_ struct{} `type:"structure"`

	// The Access Key portion of the credentials.
	AccessKeyId *string `type:"string"`

	// The date at which these credentials will expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Secret Access Key portion of the credentials
	SecretKey *string `type:"string"`

	// The Session Token portion of the credentials
	SessionToken *string `type:"string"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credentials) GoString() string {
	return s.String()
}

// Input to the DeleteIdentities action.
type DeleteIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// A list of 1-60 identities that you want to delete.
	IdentityIdsToDelete []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentitiesInput) GoString() string {
	return s.String()
}

// Returned in response to a successful DeleteIdentities operation.
type DeleteIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array of UnprocessedIdentityId objects, each of which contains an ErrorCode
	// and IdentityId.
	UnprocessedIdentityIds []*UnprocessedIdentityId `type:"list"`
}

// String returns the string representation
func (s DeleteIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentitiesOutput) GoString() string {
	return s.String()
}

// Input to the DeleteIdentityPool action.
type DeleteIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPoolInput) GoString() string {
	return s.String()
}

type DeleteIdentityPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPoolOutput) GoString() string {
	return s.String()
}

// Input to the DescribeIdentity action.
type DescribeIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityInput) GoString() string {
	return s.String()
}

// Input to the DescribeIdentityPool action.
type DescribeIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityPoolInput) GoString() string {
	return s.String()
}

// Input to the GetCredentialsForIdentity action.
type GetCredentialsForIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetCredentialsForIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialsForIdentityInput) GoString() string {
	return s.String()
}

// Returned in response to a successful GetCredentialsForIdentity operation.
type GetCredentialsForIdentityOutput struct {
	_ struct{} `type:"structure"`

	// Credentials for the the provided identity ID.
	Credentials *Credentials `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCredentialsForIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialsForIdentityOutput) GoString() string {
	return s.String()
}

// Input to the GetId action.
type GetIdInput struct {
	_ struct{} `type:"structure"`

	// A standard AWS account ID (9+ digits).
	AccountId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	//
	// The available provider names for Logins are as follows:  Facebook: graph.facebook.com
	//  Google: accounts.google.com  Amazon: www.amazon.com  Twitter: www.twitter.com
	//  Digits: www.digits.com
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdInput) GoString() string {
	return s.String()
}

// Returned in response to a GetId request.
type GetIdOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdOutput) GoString() string {
	return s.String()
}

// Input to the GetIdentityPoolRoles action.
type GetIdentityPoolRolesInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoolRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolRolesInput) GoString() string {
	return s.String()
}

// Returned in response to a successful GetIdentityPoolRoles operation.
type GetIdentityPoolRolesOutput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// The map of roles associated with this pool. Currently only authenticated
	// and unauthenticated roles are supported.
	Roles map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetIdentityPoolRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolRolesOutput) GoString() string {
	return s.String()
}

// Input to the GetOpenIdTokenForDeveloperIdentity action.
type GetOpenIdTokenForDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// Each name-value pair represents a user from a public provider or developer
	// provider. If the user is from a developer provider, the name-value pair will
	// follow the syntax "developer_provider_name": "developer_user_identifier".
	// The developer provider is the "domain" by which Cognito will refer to your
	// users; you provided this domain while creating/updating the identity pool.
	// The developer user identifier is an identifier from your backend that uniquely
	// identifies a user. When you create an identity pool, you can specify the
	// supported logins.
	Logins map[string]*string `type:"map" required:"true"`

	// The expiration time of the token, in seconds. You can specify a custom expiration
	// time for the token so that you can cache it. If you don't provide an expiration
	// time, the token is valid for 15 minutes. You can exchange the token with
	// Amazon STS for temporary AWS credentials, which are valid for a maximum of
	// one hour. The maximum token duration you can set is 24 hours. You should
	// take care in setting the expiration time for a token, as there are significant
	// security implications: an attacker could use a leaked token to access your
	// AWS resources for the token's duration.
	TokenDuration *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityInput) GoString() string {
	return s.String()
}

// Returned in response to a successful GetOpenIdTokenForDeveloperIdentity request.
type GetOpenIdTokenForDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An OpenID token.
	Token *string `type:"string"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// Input to the GetOpenIdToken action.
type GetOpenIdTokenInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// When using graph.facebook.com and www.amazon.com, supply the access_token
	// returned from the provider's authflow. For accounts.google.com or any other
	// OpenId Connect provider, always include the id_token.
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetOpenIdTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenInput) GoString() string {
	return s.String()
}

// Returned in response to a successful GetOpenIdToken request.
type GetOpenIdTokenOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID. Note that the IdentityId returned
	// may not match the one passed on input.
	IdentityId *string `min:"1" type:"string"`

	// An OpenID token, valid for 15 minutes.
	Token *string `type:"string"`
}

// String returns the string representation
func (s GetOpenIdTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenOutput) GoString() string {
	return s.String()
}

// A description of the identity.
type IdentityDescription struct {
	_ struct{} `type:"structure"`

	// Date on which the identity was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	Logins []*string `type:"list"`
}

// String returns the string representation
func (s IdentityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityDescription) GoString() string {
	return s.String()
}

// An object representing a Cognito identity pool.
type IdentityPool struct {
	_ struct{} `type:"structure"`

	// TRUE if the identity pool supports unauthenticated logins.
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// The "domain" by which Cognito will refer to your users.
	DeveloperProviderName *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A string that you provide.
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []*string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]*string `type:"map"`
}

// String returns the string representation
func (s IdentityPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityPool) GoString() string {
	return s.String()
}

// A description of the identity pool.
type IdentityPoolShortDescription struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// A string that you provide.
	IdentityPoolName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IdentityPoolShortDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityPoolShortDescription) GoString() string {
	return s.String()
}

// Input to the ListIdentities action.
type ListIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// An optional boolean parameter that allows you to hide disabled identities.
	// If omitted, the ListIdentities API will include disabled identities in the
	// response.
	HideDisabled *bool `type:"boolean"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The maximum number of identities to return.
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// The response to a ListIdentities request.
type ListIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An object containing a set of identities and associated mappings.
	Identities []*IdentityDescription `type:"list"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// Input to the ListIdentityPools action.
type ListIdentityPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identities to return.
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolsInput) GoString() string {
	return s.String()
}

// The result of a successful ListIdentityPools action.
type ListIdentityPoolsOutput struct {
	_ struct{} `type:"structure"`

	// The identity pools returned by the ListIdentityPools action.
	IdentityPools []*IdentityPoolShortDescription `type:"list"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolsOutput) GoString() string {
	return s.String()
}

// Input to the LookupDeveloperIdentityInput action.
type LookupDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique ID used by your backend authentication process to identify a user.
	// Typically, a developer identity provider would issue many developer user
	// identifiers, in keeping with the number of users.
	DeveloperUserIdentifier *string `min:"1" type:"string"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The maximum number of identities to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupDeveloperIdentityInput) GoString() string {
	return s.String()
}

// Returned in response to a successful LookupDeveloperIdentity action.
type LookupDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// This is the list of developer user identifiers associated with an identity
	// ID. Cognito supports the association of multiple developer user identifiers
	// with an identity ID.
	DeveloperUserIdentifierList []*string `type:"list"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// Input to the MergeDeveloperIdentities action.
type MergeDeveloperIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// User identifier for the destination user. The value should be a DeveloperUserIdentifier.
	DestinationUserIdentifier *string `min:"1" type:"string" required:"true"`

	// The "domain" by which Cognito will refer to your users. This is a (pseudo)
	// domain name that you provide while creating an identity pool. This name acts
	// as a placeholder that allows your backend and the Cognito service to communicate
	// about the developer provider. For the DeveloperProviderName, you can use
	// letters as well as period (.), underscore (_), and dash (-).
	DeveloperProviderName *string `min:"1" type:"string" required:"true"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// User identifier for the source user. The value should be a DeveloperUserIdentifier.
	SourceUserIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MergeDeveloperIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeDeveloperIdentitiesInput) GoString() string {
	return s.String()
}

// Returned in response to a successful MergeDeveloperIdentities action.
type MergeDeveloperIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MergeDeveloperIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeDeveloperIdentitiesOutput) GoString() string {
	return s.String()
}

// Input to the SetIdentityPoolRoles action.
type SetIdentityPoolRolesInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The map of roles associated with this pool. For a given role, the key will
	// be either "authenticated" or "unauthenticated" and the value will be the
	// Role ARN.
	Roles map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s SetIdentityPoolRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolRolesInput) GoString() string {
	return s.String()
}

type SetIdentityPoolRolesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityPoolRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolRolesOutput) GoString() string {
	return s.String()
}

// Input to the UnlinkDeveloperIdentity action.
type UnlinkDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// The "domain" by which Cognito will refer to your users.
	DeveloperProviderName *string `min:"1" type:"string" required:"true"`

	// A unique ID used by your backend authentication process to identify a user.
	DeveloperUserIdentifier *string `min:"1" type:"string" required:"true"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string" required:"true"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnlinkDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkDeveloperIdentityInput) GoString() string {
	return s.String()
}

type UnlinkDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlinkDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// Input to the UnlinkIdentity action.
type UnlinkIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	Logins map[string]*string `type:"map" required:"true"`

	// Provider names to unlink from this identity.
	LoginsToRemove []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UnlinkIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkIdentityInput) GoString() string {
	return s.String()
}

type UnlinkIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlinkIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkIdentityOutput) GoString() string {
	return s.String()
}

// An array of UnprocessedIdentityId objects, each of which contains an ErrorCode
// and IdentityId.
type UnprocessedIdentityId struct {
	_ struct{} `type:"structure"`

	// The error code indicating the type of error that occurred.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UnprocessedIdentityId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedIdentityId) GoString() string {
	return s.String()
}

const (
	// @enum ErrorCode
	ErrorCodeAccessDenied = "AccessDenied"
	// @enum ErrorCode
	ErrorCodeInternalServerError = "InternalServerError"
)
