/*
 * Copyright (c) 2017 Uber Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef JAEGERTRACING_LOGGING_H
#define JAEGERTRACING_LOGGING_H

#include <memory>
#include <string>

#include "jaegertracing/Compilers.h"

namespace jaegertracing {
namespace logging {

class Logger {
  public:
    virtual ~Logger() = default;

    virtual void error(const std::string& message) = 0;

    virtual void info(const std::string& message) = 0;
};

std::unique_ptr<Logger> nullLogger();

std::unique_ptr<Logger> consoleLogger();

}  // namespace logging
}  // namespace jaegertracing

#endif  // JAEGERTRACING_LOGGING_H
