// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appflow

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateConnectorProfile = "CreateConnectorProfile"

// CreateConnectorProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectorProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectorProfile for more information on using the CreateConnectorProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectorProfileRequest method.
//    req, resp := client.CreateConnectorProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile
func (c *Appflow) CreateConnectorProfileRequest(input *CreateConnectorProfileInput) (req *request.Request, output *CreateConnectorProfileOutput) {
	op := &request.Operation{
		Name:       opCreateConnectorProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/create-connector-profile",
	}

	if input == nil {
		input = &CreateConnectorProfileInput{}
	}

	output = &CreateConnectorProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectorProfile API operation for Amazon Appflow.
//
// Creates a new connector profile associated with your AWS account. There is
// a soft quota of 100 connector profiles per AWS account. If you need more
// connector profiles than this quota allows, you can submit a request to the
// Amazon AppFlow team through the Amazon AppFlow support channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation CreateConnectorProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota (such as the number of flows) to
//   be exceeded.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile
func (c *Appflow) CreateConnectorProfile(input *CreateConnectorProfileInput) (*CreateConnectorProfileOutput, error) {
	req, out := c.CreateConnectorProfileRequest(input)
	return out, req.Send()
}

// CreateConnectorProfileWithContext is the same as CreateConnectorProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectorProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) CreateConnectorProfileWithContext(ctx aws.Context, input *CreateConnectorProfileInput, opts ...request.Option) (*CreateConnectorProfileOutput, error) {
	req, out := c.CreateConnectorProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlow = "CreateFlow"

// CreateFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlow for more information on using the CreateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowRequest method.
//    req, resp := client.CreateFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow
func (c *Appflow) CreateFlowRequest(input *CreateFlowInput) (req *request.Request, output *CreateFlowOutput) {
	op := &request.Operation{
		Name:       opCreateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/create-flow",
	}

	if input == nil {
		input = &CreateFlowInput{}
	}

	output = &CreateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlow API operation for Amazon Appflow.
//
// Enables your application to create a new flow using Amazon AppFlow. You must
// create a connector profile before calling this API. Please note that the
// Request Syntax below shows syntax for multiple destinations, however, you
// can only transfer data to one item in this list at a time. Amazon AppFlow
// does not currently support flows to multiple destinations at once.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation CreateFlow for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota (such as the number of flows) to
//   be exceeded.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * ConnectorServerException
//   An error occurred when retrieving data from the connector endpoint.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow
func (c *Appflow) CreateFlow(input *CreateFlowInput) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	return out, req.Send()
}

// CreateFlowWithContext is the same as CreateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) CreateFlowWithContext(ctx aws.Context, input *CreateFlowInput, opts ...request.Option) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectorProfile = "DeleteConnectorProfile"

// DeleteConnectorProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectorProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectorProfile for more information on using the DeleteConnectorProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectorProfileRequest method.
//    req, resp := client.DeleteConnectorProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile
func (c *Appflow) DeleteConnectorProfileRequest(input *DeleteConnectorProfileInput) (req *request.Request, output *DeleteConnectorProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectorProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-connector-profile",
	}

	if input == nil {
		input = &DeleteConnectorProfileInput{}
	}

	output = &DeleteConnectorProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectorProfile API operation for Amazon Appflow.
//
// Enables you to delete an existing connector profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DeleteConnectorProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile
func (c *Appflow) DeleteConnectorProfile(input *DeleteConnectorProfileInput) (*DeleteConnectorProfileOutput, error) {
	req, out := c.DeleteConnectorProfileRequest(input)
	return out, req.Send()
}

// DeleteConnectorProfileWithContext is the same as DeleteConnectorProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectorProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DeleteConnectorProfileWithContext(ctx aws.Context, input *DeleteConnectorProfileInput, opts ...request.Option) (*DeleteConnectorProfileOutput, error) {
	req, out := c.DeleteConnectorProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlow = "DeleteFlow"

// DeleteFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlow for more information on using the DeleteFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowRequest method.
//    req, resp := client.DeleteFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow
func (c *Appflow) DeleteFlowRequest(input *DeleteFlowInput) (req *request.Request, output *DeleteFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-flow",
	}

	if input == nil {
		input = &DeleteFlowInput{}
	}

	output = &DeleteFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFlow API operation for Amazon Appflow.
//
// Enables your application to delete an existing flow. Before deleting the
// flow, Amazon AppFlow validates the request by checking the flow configuration
// and status. You can delete flows one at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DeleteFlow for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow
func (c *Appflow) DeleteFlow(input *DeleteFlowInput) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	return out, req.Send()
}

// DeleteFlowWithContext is the same as DeleteFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DeleteFlowWithContext(ctx aws.Context, input *DeleteFlowInput, opts ...request.Option) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectorEntity = "DescribeConnectorEntity"

// DescribeConnectorEntityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectorEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectorEntity for more information on using the DescribeConnectorEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectorEntityRequest method.
//    req, resp := client.DescribeConnectorEntityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity
func (c *Appflow) DescribeConnectorEntityRequest(input *DescribeConnectorEntityInput) (req *request.Request, output *DescribeConnectorEntityOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectorEntity,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-connector-entity",
	}

	if input == nil {
		input = &DescribeConnectorEntityInput{}
	}

	output = &DescribeConnectorEntityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectorEntity API operation for Amazon Appflow.
//
// Provides details regarding the entity used with the connector, with a description
// of the data model for each entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DescribeConnectorEntity for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * ConnectorServerException
//   An error occurred when retrieving data from the connector endpoint.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity
func (c *Appflow) DescribeConnectorEntity(input *DescribeConnectorEntityInput) (*DescribeConnectorEntityOutput, error) {
	req, out := c.DescribeConnectorEntityRequest(input)
	return out, req.Send()
}

// DescribeConnectorEntityWithContext is the same as DescribeConnectorEntity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectorEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeConnectorEntityWithContext(ctx aws.Context, input *DescribeConnectorEntityInput, opts ...request.Option) (*DescribeConnectorEntityOutput, error) {
	req, out := c.DescribeConnectorEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectorProfiles = "DescribeConnectorProfiles"

// DescribeConnectorProfilesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectorProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectorProfiles for more information on using the DescribeConnectorProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectorProfilesRequest method.
//    req, resp := client.DescribeConnectorProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles
func (c *Appflow) DescribeConnectorProfilesRequest(input *DescribeConnectorProfilesInput) (req *request.Request, output *DescribeConnectorProfilesOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectorProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-connector-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConnectorProfilesInput{}
	}

	output = &DescribeConnectorProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectorProfiles API operation for Amazon Appflow.
//
// Returns a list of connector-profile details matching the provided connector-profile
// names and connector-types. Both input lists are optional, and you can use
// them to filter the result.
//
// If no names or connector-types are provided, returns all connector profiles
// in a paginated form. If there is no match, this operation returns an empty
// list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DescribeConnectorProfiles for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles
func (c *Appflow) DescribeConnectorProfiles(input *DescribeConnectorProfilesInput) (*DescribeConnectorProfilesOutput, error) {
	req, out := c.DescribeConnectorProfilesRequest(input)
	return out, req.Send()
}

// DescribeConnectorProfilesWithContext is the same as DescribeConnectorProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectorProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeConnectorProfilesWithContext(ctx aws.Context, input *DescribeConnectorProfilesInput, opts ...request.Option) (*DescribeConnectorProfilesOutput, error) {
	req, out := c.DescribeConnectorProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConnectorProfilesPages iterates over the pages of a DescribeConnectorProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConnectorProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConnectorProfiles operation.
//    pageNum := 0
//    err := client.DescribeConnectorProfilesPages(params,
//        func(page *appflow.DescribeConnectorProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Appflow) DescribeConnectorProfilesPages(input *DescribeConnectorProfilesInput, fn func(*DescribeConnectorProfilesOutput, bool) bool) error {
	return c.DescribeConnectorProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConnectorProfilesPagesWithContext same as DescribeConnectorProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeConnectorProfilesPagesWithContext(ctx aws.Context, input *DescribeConnectorProfilesInput, fn func(*DescribeConnectorProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConnectorProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConnectorProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConnectorProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConnectors = "DescribeConnectors"

// DescribeConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectors for more information on using the DescribeConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectorsRequest method.
//    req, resp := client.DescribeConnectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors
func (c *Appflow) DescribeConnectorsRequest(input *DescribeConnectorsInput) (req *request.Request, output *DescribeConnectorsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectors,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConnectorsInput{}
	}

	output = &DescribeConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectors API operation for Amazon Appflow.
//
// Describes the connectors vended by Amazon AppFlow for specified connector
// types. If you don't specify a connector type, this operation describes all
// connectors vended by Amazon AppFlow. If there are more connectors than can
// be returned in one page, the response contains a nextToken object, which
// can be be passed in to the next call to the DescribeConnectors API operation
// to retrieve the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DescribeConnectors for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors
func (c *Appflow) DescribeConnectors(input *DescribeConnectorsInput) (*DescribeConnectorsOutput, error) {
	req, out := c.DescribeConnectorsRequest(input)
	return out, req.Send()
}

// DescribeConnectorsWithContext is the same as DescribeConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeConnectorsWithContext(ctx aws.Context, input *DescribeConnectorsInput, opts ...request.Option) (*DescribeConnectorsOutput, error) {
	req, out := c.DescribeConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConnectorsPages iterates over the pages of a DescribeConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConnectors operation.
//    pageNum := 0
//    err := client.DescribeConnectorsPages(params,
//        func(page *appflow.DescribeConnectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Appflow) DescribeConnectorsPages(input *DescribeConnectorsInput, fn func(*DescribeConnectorsOutput, bool) bool) error {
	return c.DescribeConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConnectorsPagesWithContext same as DescribeConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeConnectorsPagesWithContext(ctx aws.Context, input *DescribeConnectorsInput, fn func(*DescribeConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFlow = "DescribeFlow"

// DescribeFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlow for more information on using the DescribeFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowRequest method.
//    req, resp := client.DescribeFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow
func (c *Appflow) DescribeFlowRequest(input *DescribeFlowInput) (req *request.Request, output *DescribeFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-flow",
	}

	if input == nil {
		input = &DescribeFlowInput{}
	}

	output = &DescribeFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlow API operation for Amazon Appflow.
//
// Provides a description of the specified flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DescribeFlow for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow
func (c *Appflow) DescribeFlow(input *DescribeFlowInput) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	return out, req.Send()
}

// DescribeFlowWithContext is the same as DescribeFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeFlowWithContext(ctx aws.Context, input *DescribeFlowInput, opts ...request.Option) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlowExecutionRecords = "DescribeFlowExecutionRecords"

// DescribeFlowExecutionRecordsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowExecutionRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowExecutionRecords for more information on using the DescribeFlowExecutionRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowExecutionRecordsRequest method.
//    req, resp := client.DescribeFlowExecutionRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords
func (c *Appflow) DescribeFlowExecutionRecordsRequest(input *DescribeFlowExecutionRecordsInput) (req *request.Request, output *DescribeFlowExecutionRecordsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowExecutionRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-flow-execution-records",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFlowExecutionRecordsInput{}
	}

	output = &DescribeFlowExecutionRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowExecutionRecords API operation for Amazon Appflow.
//
// Fetches the execution history of the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation DescribeFlowExecutionRecords for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords
func (c *Appflow) DescribeFlowExecutionRecords(input *DescribeFlowExecutionRecordsInput) (*DescribeFlowExecutionRecordsOutput, error) {
	req, out := c.DescribeFlowExecutionRecordsRequest(input)
	return out, req.Send()
}

// DescribeFlowExecutionRecordsWithContext is the same as DescribeFlowExecutionRecords with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowExecutionRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeFlowExecutionRecordsWithContext(ctx aws.Context, input *DescribeFlowExecutionRecordsInput, opts ...request.Option) (*DescribeFlowExecutionRecordsOutput, error) {
	req, out := c.DescribeFlowExecutionRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFlowExecutionRecordsPages iterates over the pages of a DescribeFlowExecutionRecords operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFlowExecutionRecords method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFlowExecutionRecords operation.
//    pageNum := 0
//    err := client.DescribeFlowExecutionRecordsPages(params,
//        func(page *appflow.DescribeFlowExecutionRecordsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Appflow) DescribeFlowExecutionRecordsPages(input *DescribeFlowExecutionRecordsInput, fn func(*DescribeFlowExecutionRecordsOutput, bool) bool) error {
	return c.DescribeFlowExecutionRecordsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFlowExecutionRecordsPagesWithContext same as DescribeFlowExecutionRecordsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) DescribeFlowExecutionRecordsPagesWithContext(ctx aws.Context, input *DescribeFlowExecutionRecordsInput, fn func(*DescribeFlowExecutionRecordsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFlowExecutionRecordsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFlowExecutionRecordsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFlowExecutionRecordsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConnectorEntities = "ListConnectorEntities"

// ListConnectorEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectorEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectorEntities for more information on using the ListConnectorEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConnectorEntitiesRequest method.
//    req, resp := client.ListConnectorEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities
func (c *Appflow) ListConnectorEntitiesRequest(input *ListConnectorEntitiesInput) (req *request.Request, output *ListConnectorEntitiesOutput) {
	op := &request.Operation{
		Name:       opListConnectorEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/list-connector-entities",
	}

	if input == nil {
		input = &ListConnectorEntitiesInput{}
	}

	output = &ListConnectorEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectorEntities API operation for Amazon Appflow.
//
// Returns the list of available connector entities supported by Amazon AppFlow.
// For example, you can query Salesforce for Account and Opportunity entities,
// or query ServiceNow for the Incident entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation ListConnectorEntities for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * ConnectorServerException
//   An error occurred when retrieving data from the connector endpoint.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities
func (c *Appflow) ListConnectorEntities(input *ListConnectorEntitiesInput) (*ListConnectorEntitiesOutput, error) {
	req, out := c.ListConnectorEntitiesRequest(input)
	return out, req.Send()
}

// ListConnectorEntitiesWithContext is the same as ListConnectorEntities with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectorEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) ListConnectorEntitiesWithContext(ctx aws.Context, input *ListConnectorEntitiesInput, opts ...request.Option) (*ListConnectorEntitiesOutput, error) {
	req, out := c.ListConnectorEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFlows = "ListFlows"

// ListFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlows for more information on using the ListFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowsRequest method.
//    req, resp := client.ListFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows
func (c *Appflow) ListFlowsRequest(input *ListFlowsInput) (req *request.Request, output *ListFlowsOutput) {
	op := &request.Operation{
		Name:       opListFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/list-flows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowsInput{}
	}

	output = &ListFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlows API operation for Amazon Appflow.
//
// Lists all of the flows associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation ListFlows for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows
func (c *Appflow) ListFlows(input *ListFlowsInput) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	return out, req.Send()
}

// ListFlowsWithContext is the same as ListFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) ListFlowsWithContext(ctx aws.Context, input *ListFlowsInput, opts ...request.Option) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowsPages iterates over the pages of a ListFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlows operation.
//    pageNum := 0
//    err := client.ListFlowsPages(params,
//        func(page *appflow.ListFlowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Appflow) ListFlowsPages(input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool) error {
	return c.ListFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowsPagesWithContext same as ListFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) ListFlowsPagesWithContext(ctx aws.Context, input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource
func (c *Appflow) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Appflow.
//
// Retrieves the tags that are associated with a specified flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource
func (c *Appflow) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFlow = "StartFlow"

// StartFlowRequest generates a "aws/request.Request" representing the
// client's request for the StartFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFlow for more information on using the StartFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFlowRequest method.
//    req, resp := client.StartFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow
func (c *Appflow) StartFlowRequest(input *StartFlowInput) (req *request.Request, output *StartFlowOutput) {
	op := &request.Operation{
		Name:       opStartFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/start-flow",
	}

	if input == nil {
		input = &StartFlowInput{}
	}

	output = &StartFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFlow API operation for Amazon Appflow.
//
// Activates an existing flow. For on-demand flows, this operation runs the
// flow immediately. For schedule and event-triggered flows, this operation
// activates the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation StartFlow for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota (such as the number of flows) to
//   be exceeded.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow
func (c *Appflow) StartFlow(input *StartFlowInput) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	return out, req.Send()
}

// StartFlowWithContext is the same as StartFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StartFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) StartFlowWithContext(ctx aws.Context, input *StartFlowInput, opts ...request.Option) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFlow = "StopFlow"

// StopFlowRequest generates a "aws/request.Request" representing the
// client's request for the StopFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFlow for more information on using the StopFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFlowRequest method.
//    req, resp := client.StopFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow
func (c *Appflow) StopFlowRequest(input *StopFlowInput) (req *request.Request, output *StopFlowOutput) {
	op := &request.Operation{
		Name:       opStopFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/stop-flow",
	}

	if input == nil {
		input = &StopFlowInput{}
	}

	output = &StopFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFlow API operation for Amazon Appflow.
//
// Deactivates the existing flow. For on-demand flows, this operation returns
// an unsupportedOperationException error message. For schedule and event-triggered
// flows, this operation deactivates the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation StopFlow for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * UnsupportedOperationException
//   The requested operation is not supported for the current flow.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow
func (c *Appflow) StopFlow(input *StopFlowInput) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	return out, req.Send()
}

// StopFlowWithContext is the same as StopFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StopFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) StopFlowWithContext(ctx aws.Context, input *StopFlowInput, opts ...request.Option) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource
func (c *Appflow) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Appflow.
//
// Applies a tag to the specified flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource
func (c *Appflow) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource
func (c *Appflow) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Appflow.
//
// Removes a tag from the specified flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource
func (c *Appflow) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectorProfile = "UpdateConnectorProfile"

// UpdateConnectorProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectorProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectorProfile for more information on using the UpdateConnectorProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectorProfileRequest method.
//    req, resp := client.UpdateConnectorProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile
func (c *Appflow) UpdateConnectorProfileRequest(input *UpdateConnectorProfileInput) (req *request.Request, output *UpdateConnectorProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectorProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/update-connector-profile",
	}

	if input == nil {
		input = &UpdateConnectorProfileInput{}
	}

	output = &UpdateConnectorProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnectorProfile API operation for Amazon Appflow.
//
// Updates a given connector profile associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation UpdateConnectorProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile
func (c *Appflow) UpdateConnectorProfile(input *UpdateConnectorProfileInput) (*UpdateConnectorProfileOutput, error) {
	req, out := c.UpdateConnectorProfileRequest(input)
	return out, req.Send()
}

// UpdateConnectorProfileWithContext is the same as UpdateConnectorProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectorProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) UpdateConnectorProfileWithContext(ctx aws.Context, input *UpdateConnectorProfileInput, opts ...request.Option) (*UpdateConnectorProfileOutput, error) {
	req, out := c.UpdateConnectorProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlow = "UpdateFlow"

// UpdateFlowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlow for more information on using the UpdateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowRequest method.
//    req, resp := client.UpdateFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow
func (c *Appflow) UpdateFlowRequest(input *UpdateFlowInput) (req *request.Request, output *UpdateFlowOutput) {
	op := &request.Operation{
		Name:       opUpdateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/update-flow",
	}

	if input == nil {
		input = &UpdateFlowInput{}
	}

	output = &UpdateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlow API operation for Amazon Appflow.
//
// Updates an existing flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Appflow's
// API operation UpdateFlow for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request (such as the source or destination
//   connector profile) is not found.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota (such as the number of flows) to
//   be exceeded.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a flow with
//   the given name already exists within the account. Check for conflicting resource
//   names and try again.
//
//   * ConnectorAuthenticationException
//   An error occurred when authenticating with the connector endpoint.
//
//   * ConnectorServerException
//   An error occurred when retrieving data from the connector endpoint.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow
func (c *Appflow) UpdateFlow(input *UpdateFlowInput) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	return out, req.Send()
}

// UpdateFlowWithContext is the same as UpdateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Appflow) UpdateFlowWithContext(ctx aws.Context, input *UpdateFlowInput, opts ...request.Option) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The aggregation settings that you can use to customize the output format
// of your flow data.
type AggregationConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon AppFlow aggregates the flow records into a single
	// file, or leave them unaggregated.
	AggregationType *string `locationName:"aggregationType" type:"string" enum:"AggregationType"`
}

// String returns the string representation
func (s AggregationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregationConfig) GoString() string {
	return s.String()
}

// SetAggregationType sets the AggregationType field's value.
func (s *AggregationConfig) SetAggregationType(v string) *AggregationConfig {
	s.AggregationType = &v
	return s
}

// The connector-specific credentials required when using Amplitude.
type AmplitudeConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// A unique alphanumeric identifier used to authenticate a user, developer,
	// or calling program to your API.
	//
	// ApiKey is a required field
	ApiKey *string `locationName:"apiKey" type:"string" required:"true"`

	// The Secret Access Key portion of the credentials.
	//
	// SecretKey is a required field
	SecretKey *string `locationName:"secretKey" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AmplitudeConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AmplitudeConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmplitudeConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmplitudeConnectorProfileCredentials"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.SecretKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *AmplitudeConnectorProfileCredentials) SetApiKey(v string) *AmplitudeConnectorProfileCredentials {
	s.ApiKey = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *AmplitudeConnectorProfileCredentials) SetSecretKey(v string) *AmplitudeConnectorProfileCredentials {
	s.SecretKey = &v
	return s
}

// The connector-specific profile properties required when using Amplitude.
type AmplitudeConnectorProfileProperties struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AmplitudeConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AmplitudeConnectorProfileProperties) GoString() string {
	return s.String()
}

// The connector metadata specific to Amplitude.
type AmplitudeMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AmplitudeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AmplitudeMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Amplitude is being used as a source.
type AmplitudeSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Amplitude flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s AmplitudeSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AmplitudeSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmplitudeSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmplitudeSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *AmplitudeSourceProperties) SetObject(v string) *AmplitudeSourceProperties {
	s.Object = &v
	return s
}

// There was a conflict when processing the request (for example, a flow with
// the given name already exists within the account. Check for conflicting resource
// names and try again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error occurred when authenticating with the connector endpoint.
type ConnectorAuthenticationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConnectorAuthenticationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorAuthenticationException) GoString() string {
	return s.String()
}

func newErrorConnectorAuthenticationException(v protocol.ResponseMetadata) error {
	return &ConnectorAuthenticationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConnectorAuthenticationException) Code() string {
	return "ConnectorAuthenticationException"
}

// Message returns the exception's message.
func (s *ConnectorAuthenticationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConnectorAuthenticationException) OrigErr() error {
	return nil
}

func (s *ConnectorAuthenticationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConnectorAuthenticationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConnectorAuthenticationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration settings related to a given connector.
type ConnectorConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the connector can be used as a destination.
	CanUseAsDestination *bool `locationName:"canUseAsDestination" type:"boolean"`

	// Specifies whether the connector can be used as a source.
	CanUseAsSource *bool `locationName:"canUseAsSource" type:"boolean"`

	// Specifies connector-specific metadata such as oAuthScopes, supportedRegions,
	// privateLinkServiceUrl, and so on.
	ConnectorMetadata *ConnectorMetadata `locationName:"connectorMetadata" type:"structure"`

	// Specifies if PrivateLink is enabled for that connector.
	IsPrivateLinkEnabled *bool `locationName:"isPrivateLinkEnabled" type:"boolean"`

	// Specifies if a PrivateLink endpoint URL is required.
	IsPrivateLinkEndpointUrlRequired *bool `locationName:"isPrivateLinkEndpointUrlRequired" type:"boolean"`

	// Lists the connectors that are available for use as destinations.
	SupportedDestinationConnectors []*string `locationName:"supportedDestinationConnectors" type:"list"`

	// Specifies the supported flow frequency for that connector.
	SupportedSchedulingFrequencies []*string `locationName:"supportedSchedulingFrequencies" type:"list"`

	// Specifies the supported trigger types for the flow.
	SupportedTriggerTypes []*string `locationName:"supportedTriggerTypes" type:"list"`
}

// String returns the string representation
func (s ConnectorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorConfiguration) GoString() string {
	return s.String()
}

// SetCanUseAsDestination sets the CanUseAsDestination field's value.
func (s *ConnectorConfiguration) SetCanUseAsDestination(v bool) *ConnectorConfiguration {
	s.CanUseAsDestination = &v
	return s
}

// SetCanUseAsSource sets the CanUseAsSource field's value.
func (s *ConnectorConfiguration) SetCanUseAsSource(v bool) *ConnectorConfiguration {
	s.CanUseAsSource = &v
	return s
}

// SetConnectorMetadata sets the ConnectorMetadata field's value.
func (s *ConnectorConfiguration) SetConnectorMetadata(v *ConnectorMetadata) *ConnectorConfiguration {
	s.ConnectorMetadata = v
	return s
}

// SetIsPrivateLinkEnabled sets the IsPrivateLinkEnabled field's value.
func (s *ConnectorConfiguration) SetIsPrivateLinkEnabled(v bool) *ConnectorConfiguration {
	s.IsPrivateLinkEnabled = &v
	return s
}

// SetIsPrivateLinkEndpointUrlRequired sets the IsPrivateLinkEndpointUrlRequired field's value.
func (s *ConnectorConfiguration) SetIsPrivateLinkEndpointUrlRequired(v bool) *ConnectorConfiguration {
	s.IsPrivateLinkEndpointUrlRequired = &v
	return s
}

// SetSupportedDestinationConnectors sets the SupportedDestinationConnectors field's value.
func (s *ConnectorConfiguration) SetSupportedDestinationConnectors(v []*string) *ConnectorConfiguration {
	s.SupportedDestinationConnectors = v
	return s
}

// SetSupportedSchedulingFrequencies sets the SupportedSchedulingFrequencies field's value.
func (s *ConnectorConfiguration) SetSupportedSchedulingFrequencies(v []*string) *ConnectorConfiguration {
	s.SupportedSchedulingFrequencies = v
	return s
}

// SetSupportedTriggerTypes sets the SupportedTriggerTypes field's value.
func (s *ConnectorConfiguration) SetSupportedTriggerTypes(v []*string) *ConnectorConfiguration {
	s.SupportedTriggerTypes = v
	return s
}

// The high-level entity that can be queried in Amazon AppFlow. For example,
// a Salesforce entity might be an Account or Opportunity, whereas a ServiceNow
// entity might be an Incident.
type ConnectorEntity struct {
	_ struct{} `type:"structure"`

	// Specifies whether the connector entity is a parent or a category and has
	// more entities nested underneath it. If another call is made with entitiesPath
	// = "the_current_entity_name_with_hasNestedEntities_true", then it returns
	// the nested entities underneath it. This provides a way to retrieve all supported
	// entities in a recursive fashion.
	HasNestedEntities *bool `locationName:"hasNestedEntities" type:"boolean"`

	// The label applied to the connector entity.
	Label *string `locationName:"label" type:"string"`

	// The name of the connector entity.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ConnectorEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorEntity) GoString() string {
	return s.String()
}

// SetHasNestedEntities sets the HasNestedEntities field's value.
func (s *ConnectorEntity) SetHasNestedEntities(v bool) *ConnectorEntity {
	s.HasNestedEntities = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ConnectorEntity) SetLabel(v string) *ConnectorEntity {
	s.Label = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectorEntity) SetName(v string) *ConnectorEntity {
	s.Name = &v
	return s
}

// Describes the data model of a connector field. For example, for an account
// entity, the fields would be account name, account ID, and so on.
type ConnectorEntityField struct {
	_ struct{} `type:"structure"`

	// A description of the connector entity field.
	Description *string `locationName:"description" type:"string"`

	// The properties applied to a field when the connector is being used as a destination.
	DestinationProperties *DestinationFieldProperties `locationName:"destinationProperties" type:"structure"`

	// The unique identifier of the connector field.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" type:"string" required:"true"`

	// The label applied to a connector entity field.
	Label *string `locationName:"label" type:"string"`

	// The properties that can be applied to a field when the connector is being
	// used as a source.
	SourceProperties *SourceFieldProperties `locationName:"sourceProperties" type:"structure"`

	// Contains details regarding the supported FieldType, including the corresponding
	// filterOperators and supportedValues.
	SupportedFieldTypeDetails *SupportedFieldTypeDetails `locationName:"supportedFieldTypeDetails" type:"structure"`
}

// String returns the string representation
func (s ConnectorEntityField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorEntityField) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ConnectorEntityField) SetDescription(v string) *ConnectorEntityField {
	s.Description = &v
	return s
}

// SetDestinationProperties sets the DestinationProperties field's value.
func (s *ConnectorEntityField) SetDestinationProperties(v *DestinationFieldProperties) *ConnectorEntityField {
	s.DestinationProperties = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *ConnectorEntityField) SetIdentifier(v string) *ConnectorEntityField {
	s.Identifier = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ConnectorEntityField) SetLabel(v string) *ConnectorEntityField {
	s.Label = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *ConnectorEntityField) SetSourceProperties(v *SourceFieldProperties) *ConnectorEntityField {
	s.SourceProperties = v
	return s
}

// SetSupportedFieldTypeDetails sets the SupportedFieldTypeDetails field's value.
func (s *ConnectorEntityField) SetSupportedFieldTypeDetails(v *SupportedFieldTypeDetails) *ConnectorEntityField {
	s.SupportedFieldTypeDetails = v
	return s
}

// A structure to specify connector-specific metadata such as oAuthScopes, supportedRegions,
// privateLinkServiceUrl, and so on.
type ConnectorMetadata struct {
	_ struct{} `type:"structure"`

	// The connector metadata specific to Amplitude.
	Amplitude *AmplitudeMetadata `type:"structure"`

	// The connector metadata specific to Datadog.
	Datadog *DatadogMetadata `type:"structure"`

	// The connector metadata specific to Dynatrace.
	Dynatrace *DynatraceMetadata `type:"structure"`

	// The connector metadata specific to Amazon EventBridge.
	EventBridge *EventBridgeMetadata `type:"structure"`

	// The connector metadata specific to Google Analytics.
	GoogleAnalytics *GoogleAnalyticsMetadata `type:"structure"`

	// The connector metadata specific to Infor Nexus.
	InforNexus *InforNexusMetadata `type:"structure"`

	// The connector metadata specific to Marketo.
	Marketo *MarketoMetadata `type:"structure"`

	// The connector metadata specific to Amazon Redshift.
	Redshift *RedshiftMetadata `type:"structure"`

	// The connector metadata specific to Amazon S3.
	S3 *S3Metadata `type:"structure"`

	// The connector metadata specific to Salesforce.
	Salesforce *SalesforceMetadata `type:"structure"`

	// The connector metadata specific to ServiceNow.
	ServiceNow *ServiceNowMetadata `type:"structure"`

	// The connector metadata specific to Singular.
	Singular *SingularMetadata `type:"structure"`

	// The connector metadata specific to Slack.
	Slack *SlackMetadata `type:"structure"`

	// The connector metadata specific to Snowflake.
	Snowflake *SnowflakeMetadata `type:"structure"`

	// The connector metadata specific to Trend Micro.
	Trendmicro *TrendmicroMetadata `type:"structure"`

	// The connector metadata specific to Upsolver.
	Upsolver *UpsolverMetadata `type:"structure"`

	// The connector metadata specific to Veeva.
	Veeva *VeevaMetadata `type:"structure"`

	// The connector metadata specific to Zendesk.
	Zendesk *ZendeskMetadata `type:"structure"`
}

// String returns the string representation
func (s ConnectorMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorMetadata) GoString() string {
	return s.String()
}

// SetAmplitude sets the Amplitude field's value.
func (s *ConnectorMetadata) SetAmplitude(v *AmplitudeMetadata) *ConnectorMetadata {
	s.Amplitude = v
	return s
}

// SetDatadog sets the Datadog field's value.
func (s *ConnectorMetadata) SetDatadog(v *DatadogMetadata) *ConnectorMetadata {
	s.Datadog = v
	return s
}

// SetDynatrace sets the Dynatrace field's value.
func (s *ConnectorMetadata) SetDynatrace(v *DynatraceMetadata) *ConnectorMetadata {
	s.Dynatrace = v
	return s
}

// SetEventBridge sets the EventBridge field's value.
func (s *ConnectorMetadata) SetEventBridge(v *EventBridgeMetadata) *ConnectorMetadata {
	s.EventBridge = v
	return s
}

// SetGoogleAnalytics sets the GoogleAnalytics field's value.
func (s *ConnectorMetadata) SetGoogleAnalytics(v *GoogleAnalyticsMetadata) *ConnectorMetadata {
	s.GoogleAnalytics = v
	return s
}

// SetInforNexus sets the InforNexus field's value.
func (s *ConnectorMetadata) SetInforNexus(v *InforNexusMetadata) *ConnectorMetadata {
	s.InforNexus = v
	return s
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorMetadata) SetMarketo(v *MarketoMetadata) *ConnectorMetadata {
	s.Marketo = v
	return s
}

// SetRedshift sets the Redshift field's value.
func (s *ConnectorMetadata) SetRedshift(v *RedshiftMetadata) *ConnectorMetadata {
	s.Redshift = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *ConnectorMetadata) SetS3(v *S3Metadata) *ConnectorMetadata {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorMetadata) SetSalesforce(v *SalesforceMetadata) *ConnectorMetadata {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorMetadata) SetServiceNow(v *ServiceNowMetadata) *ConnectorMetadata {
	s.ServiceNow = v
	return s
}

// SetSingular sets the Singular field's value.
func (s *ConnectorMetadata) SetSingular(v *SingularMetadata) *ConnectorMetadata {
	s.Singular = v
	return s
}

// SetSlack sets the Slack field's value.
func (s *ConnectorMetadata) SetSlack(v *SlackMetadata) *ConnectorMetadata {
	s.Slack = v
	return s
}

// SetSnowflake sets the Snowflake field's value.
func (s *ConnectorMetadata) SetSnowflake(v *SnowflakeMetadata) *ConnectorMetadata {
	s.Snowflake = v
	return s
}

// SetTrendmicro sets the Trendmicro field's value.
func (s *ConnectorMetadata) SetTrendmicro(v *TrendmicroMetadata) *ConnectorMetadata {
	s.Trendmicro = v
	return s
}

// SetUpsolver sets the Upsolver field's value.
func (s *ConnectorMetadata) SetUpsolver(v *UpsolverMetadata) *ConnectorMetadata {
	s.Upsolver = v
	return s
}

// SetVeeva sets the Veeva field's value.
func (s *ConnectorMetadata) SetVeeva(v *VeevaMetadata) *ConnectorMetadata {
	s.Veeva = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorMetadata) SetZendesk(v *ZendeskMetadata) *ConnectorMetadata {
	s.Zendesk = v
	return s
}

// Used by select connectors for which the OAuth workflow is supported, such
// as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
type ConnectorOAuthRequest struct {
	_ struct{} `type:"structure"`

	// The code provided by the connector when it has been authenticated via the
	// connected app.
	AuthCode *string `locationName:"authCode" type:"string"`

	// The URL to which the authentication server redirects the browser after authorization
	// has been granted.
	RedirectUri *string `locationName:"redirectUri" type:"string"`
}

// String returns the string representation
func (s ConnectorOAuthRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorOAuthRequest) GoString() string {
	return s.String()
}

// SetAuthCode sets the AuthCode field's value.
func (s *ConnectorOAuthRequest) SetAuthCode(v string) *ConnectorOAuthRequest {
	s.AuthCode = &v
	return s
}

// SetRedirectUri sets the RedirectUri field's value.
func (s *ConnectorOAuthRequest) SetRedirectUri(v string) *ConnectorOAuthRequest {
	s.RedirectUri = &v
	return s
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided Amplitude source fields.
	Amplitude *string `type:"string" enum:"AmplitudeConnectorOperator"`

	// The operation to be performed on the provided Datadog source fields.
	Datadog *string `type:"string" enum:"DatadogConnectorOperator"`

	// The operation to be performed on the provided Dynatrace source fields.
	Dynatrace *string `type:"string" enum:"DynatraceConnectorOperator"`

	// The operation to be performed on the provided Google Analytics source fields.
	GoogleAnalytics *string `type:"string" enum:"GoogleAnalyticsConnectorOperator"`

	// The operation to be performed on the provided Infor Nexus source fields.
	InforNexus *string `type:"string" enum:"InforNexusConnectorOperator"`

	// The operation to be performed on the provided Marketo source fields.
	Marketo *string `type:"string" enum:"MarketoConnectorOperator"`

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 *string `type:"string" enum:"S3ConnectorOperator"`

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce *string `type:"string" enum:"SalesforceConnectorOperator"`

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow *string `type:"string" enum:"ServiceNowConnectorOperator"`

	// The operation to be performed on the provided Singular source fields.
	Singular *string `type:"string" enum:"SingularConnectorOperator"`

	// The operation to be performed on the provided Slack source fields.
	Slack *string `type:"string" enum:"SlackConnectorOperator"`

	// The operation to be performed on the provided Trend Micro source fields.
	Trendmicro *string `type:"string" enum:"TrendmicroConnectorOperator"`

	// The operation to be performed on the provided Veeva source fields.
	Veeva *string `type:"string" enum:"VeevaConnectorOperator"`

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk *string `type:"string" enum:"ZendeskConnectorOperator"`
}

// String returns the string representation
func (s ConnectorOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorOperator) GoString() string {
	return s.String()
}

// SetAmplitude sets the Amplitude field's value.
func (s *ConnectorOperator) SetAmplitude(v string) *ConnectorOperator {
	s.Amplitude = &v
	return s
}

// SetDatadog sets the Datadog field's value.
func (s *ConnectorOperator) SetDatadog(v string) *ConnectorOperator {
	s.Datadog = &v
	return s
}

// SetDynatrace sets the Dynatrace field's value.
func (s *ConnectorOperator) SetDynatrace(v string) *ConnectorOperator {
	s.Dynatrace = &v
	return s
}

// SetGoogleAnalytics sets the GoogleAnalytics field's value.
func (s *ConnectorOperator) SetGoogleAnalytics(v string) *ConnectorOperator {
	s.GoogleAnalytics = &v
	return s
}

// SetInforNexus sets the InforNexus field's value.
func (s *ConnectorOperator) SetInforNexus(v string) *ConnectorOperator {
	s.InforNexus = &v
	return s
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorOperator) SetMarketo(v string) *ConnectorOperator {
	s.Marketo = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *ConnectorOperator) SetS3(v string) *ConnectorOperator {
	s.S3 = &v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorOperator) SetSalesforce(v string) *ConnectorOperator {
	s.Salesforce = &v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorOperator) SetServiceNow(v string) *ConnectorOperator {
	s.ServiceNow = &v
	return s
}

// SetSingular sets the Singular field's value.
func (s *ConnectorOperator) SetSingular(v string) *ConnectorOperator {
	s.Singular = &v
	return s
}

// SetSlack sets the Slack field's value.
func (s *ConnectorOperator) SetSlack(v string) *ConnectorOperator {
	s.Slack = &v
	return s
}

// SetTrendmicro sets the Trendmicro field's value.
func (s *ConnectorOperator) SetTrendmicro(v string) *ConnectorOperator {
	s.Trendmicro = &v
	return s
}

// SetVeeva sets the Veeva field's value.
func (s *ConnectorOperator) SetVeeva(v string) *ConnectorOperator {
	s.Veeva = &v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorOperator) SetZendesk(v string) *ConnectorOperator {
	s.Zendesk = &v
	return s
}

// Describes an instance of a connector. This includes the provided name, credentials
// ARN, connection-mode, and so on. To keep the API intuitive and extensible,
// the fields that are common to all types of connector profiles are explicitly
// specified at the top level. The rest of the connector-specific properties
// are available via the connectorProfileProperties field.
type ConnectorProfile struct {
	_ struct{} `type:"structure"`

	// Indicates the connection mode and if it is public or private.
	ConnectionMode *string `locationName:"connectionMode" type:"string" enum:"ConnectionMode"`

	// The Amazon Resource Name (ARN) of the connector profile.
	ConnectorProfileArn *string `locationName:"connectorProfileArn" type:"string"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in the AWS account.
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string"`

	// The connector-specific properties of the profile configuration.
	ConnectorProfileProperties *ConnectorProfileProperties `locationName:"connectorProfileProperties" type:"structure"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorType *string `locationName:"connectorType" type:"string" enum:"ConnectorType"`

	// Specifies when the connector profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the connector profile credentials.
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// Specifies when the connector profile was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`
}

// String returns the string representation
func (s ConnectorProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorProfile) GoString() string {
	return s.String()
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *ConnectorProfile) SetConnectionMode(v string) *ConnectorProfile {
	s.ConnectionMode = &v
	return s
}

// SetConnectorProfileArn sets the ConnectorProfileArn field's value.
func (s *ConnectorProfile) SetConnectorProfileArn(v string) *ConnectorProfile {
	s.ConnectorProfileArn = &v
	return s
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *ConnectorProfile) SetConnectorProfileName(v string) *ConnectorProfile {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorProfileProperties sets the ConnectorProfileProperties field's value.
func (s *ConnectorProfile) SetConnectorProfileProperties(v *ConnectorProfileProperties) *ConnectorProfile {
	s.ConnectorProfileProperties = v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *ConnectorProfile) SetConnectorType(v string) *ConnectorProfile {
	s.ConnectorType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ConnectorProfile) SetCreatedAt(v time.Time) *ConnectorProfile {
	s.CreatedAt = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *ConnectorProfile) SetCredentialsArn(v string) *ConnectorProfile {
	s.CredentialsArn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ConnectorProfile) SetLastUpdatedAt(v time.Time) *ConnectorProfile {
	s.LastUpdatedAt = &v
	return s
}

// Defines the connector-specific configuration and credentials for the connector
// profile.
type ConnectorProfileConfig struct {
	_ struct{} `type:"structure"`

	// The connector-specific credentials required by each connector.
	//
	// ConnectorProfileCredentials is a required field
	ConnectorProfileCredentials *ConnectorProfileCredentials `locationName:"connectorProfileCredentials" type:"structure" required:"true"`

	// The connector-specific properties of the profile configuration.
	//
	// ConnectorProfileProperties is a required field
	ConnectorProfileProperties *ConnectorProfileProperties `locationName:"connectorProfileProperties" type:"structure" required:"true"`
}

// String returns the string representation
func (s ConnectorProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorProfileConfig"}
	if s.ConnectorProfileCredentials == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileCredentials"))
	}
	if s.ConnectorProfileProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileProperties"))
	}
	if s.ConnectorProfileCredentials != nil {
		if err := s.ConnectorProfileCredentials.Validate(); err != nil {
			invalidParams.AddNested("ConnectorProfileCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ConnectorProfileProperties != nil {
		if err := s.ConnectorProfileProperties.Validate(); err != nil {
			invalidParams.AddNested("ConnectorProfileProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileCredentials sets the ConnectorProfileCredentials field's value.
func (s *ConnectorProfileConfig) SetConnectorProfileCredentials(v *ConnectorProfileCredentials) *ConnectorProfileConfig {
	s.ConnectorProfileCredentials = v
	return s
}

// SetConnectorProfileProperties sets the ConnectorProfileProperties field's value.
func (s *ConnectorProfileConfig) SetConnectorProfileProperties(v *ConnectorProfileProperties) *ConnectorProfileConfig {
	s.ConnectorProfileProperties = v
	return s
}

// The connector-specific credentials required by a connector.
type ConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The connector-specific credentials required when using Amplitude.
	Amplitude *AmplitudeConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Datadog.
	Datadog *DatadogConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Dynatrace.
	Dynatrace *DynatraceConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Infor Nexus.
	InforNexus *InforNexusConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Marketo.
	Marketo *MarketoConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Amazon Redshift.
	Redshift *RedshiftConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Salesforce.
	Salesforce *SalesforceConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using ServiceNow.
	ServiceNow *ServiceNowConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Singular.
	Singular *SingularConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Slack.
	Slack *SlackConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Snowflake.
	Snowflake *SnowflakeConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Trend Micro.
	Trendmicro *TrendmicroConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Veeva.
	Veeva *VeevaConnectorProfileCredentials `type:"structure"`

	// The connector-specific credentials required when using Zendesk.
	Zendesk *ZendeskConnectorProfileCredentials `type:"structure"`
}

// String returns the string representation
func (s ConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorProfileCredentials"}
	if s.Amplitude != nil {
		if err := s.Amplitude.Validate(); err != nil {
			invalidParams.AddNested("Amplitude", err.(request.ErrInvalidParams))
		}
	}
	if s.Datadog != nil {
		if err := s.Datadog.Validate(); err != nil {
			invalidParams.AddNested("Datadog", err.(request.ErrInvalidParams))
		}
	}
	if s.Dynatrace != nil {
		if err := s.Dynatrace.Validate(); err != nil {
			invalidParams.AddNested("Dynatrace", err.(request.ErrInvalidParams))
		}
	}
	if s.GoogleAnalytics != nil {
		if err := s.GoogleAnalytics.Validate(); err != nil {
			invalidParams.AddNested("GoogleAnalytics", err.(request.ErrInvalidParams))
		}
	}
	if s.InforNexus != nil {
		if err := s.InforNexus.Validate(); err != nil {
			invalidParams.AddNested("InforNexus", err.(request.ErrInvalidParams))
		}
	}
	if s.Marketo != nil {
		if err := s.Marketo.Validate(); err != nil {
			invalidParams.AddNested("Marketo", err.(request.ErrInvalidParams))
		}
	}
	if s.Redshift != nil {
		if err := s.Redshift.Validate(); err != nil {
			invalidParams.AddNested("Redshift", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNow != nil {
		if err := s.ServiceNow.Validate(); err != nil {
			invalidParams.AddNested("ServiceNow", err.(request.ErrInvalidParams))
		}
	}
	if s.Singular != nil {
		if err := s.Singular.Validate(); err != nil {
			invalidParams.AddNested("Singular", err.(request.ErrInvalidParams))
		}
	}
	if s.Slack != nil {
		if err := s.Slack.Validate(); err != nil {
			invalidParams.AddNested("Slack", err.(request.ErrInvalidParams))
		}
	}
	if s.Snowflake != nil {
		if err := s.Snowflake.Validate(); err != nil {
			invalidParams.AddNested("Snowflake", err.(request.ErrInvalidParams))
		}
	}
	if s.Trendmicro != nil {
		if err := s.Trendmicro.Validate(); err != nil {
			invalidParams.AddNested("Trendmicro", err.(request.ErrInvalidParams))
		}
	}
	if s.Veeva != nil {
		if err := s.Veeva.Validate(); err != nil {
			invalidParams.AddNested("Veeva", err.(request.ErrInvalidParams))
		}
	}
	if s.Zendesk != nil {
		if err := s.Zendesk.Validate(); err != nil {
			invalidParams.AddNested("Zendesk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmplitude sets the Amplitude field's value.
func (s *ConnectorProfileCredentials) SetAmplitude(v *AmplitudeConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Amplitude = v
	return s
}

// SetDatadog sets the Datadog field's value.
func (s *ConnectorProfileCredentials) SetDatadog(v *DatadogConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Datadog = v
	return s
}

// SetDynatrace sets the Dynatrace field's value.
func (s *ConnectorProfileCredentials) SetDynatrace(v *DynatraceConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Dynatrace = v
	return s
}

// SetGoogleAnalytics sets the GoogleAnalytics field's value.
func (s *ConnectorProfileCredentials) SetGoogleAnalytics(v *GoogleAnalyticsConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.GoogleAnalytics = v
	return s
}

// SetInforNexus sets the InforNexus field's value.
func (s *ConnectorProfileCredentials) SetInforNexus(v *InforNexusConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.InforNexus = v
	return s
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorProfileCredentials) SetMarketo(v *MarketoConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Marketo = v
	return s
}

// SetRedshift sets the Redshift field's value.
func (s *ConnectorProfileCredentials) SetRedshift(v *RedshiftConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Redshift = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorProfileCredentials) SetSalesforce(v *SalesforceConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorProfileCredentials) SetServiceNow(v *ServiceNowConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.ServiceNow = v
	return s
}

// SetSingular sets the Singular field's value.
func (s *ConnectorProfileCredentials) SetSingular(v *SingularConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Singular = v
	return s
}

// SetSlack sets the Slack field's value.
func (s *ConnectorProfileCredentials) SetSlack(v *SlackConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Slack = v
	return s
}

// SetSnowflake sets the Snowflake field's value.
func (s *ConnectorProfileCredentials) SetSnowflake(v *SnowflakeConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Snowflake = v
	return s
}

// SetTrendmicro sets the Trendmicro field's value.
func (s *ConnectorProfileCredentials) SetTrendmicro(v *TrendmicroConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Trendmicro = v
	return s
}

// SetVeeva sets the Veeva field's value.
func (s *ConnectorProfileCredentials) SetVeeva(v *VeevaConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Veeva = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorProfileCredentials) SetZendesk(v *ZendeskConnectorProfileCredentials) *ConnectorProfileCredentials {
	s.Zendesk = v
	return s
}

// The connector-specific profile properties required by each connector.
type ConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The connector-specific properties required by Amplitude.
	Amplitude *AmplitudeConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Datadog.
	Datadog *DatadogConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Dynatrace.
	Dynatrace *DynatraceConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Infor Nexus.
	InforNexus *InforNexusConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Marketo.
	Marketo *MarketoConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Amazon Redshift.
	Redshift *RedshiftConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Salesforce.
	Salesforce *SalesforceConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by serviceNow.
	ServiceNow *ServiceNowConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Singular.
	Singular *SingularConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Slack.
	Slack *SlackConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Snowflake.
	Snowflake *SnowflakeConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Trend Micro.
	Trendmicro *TrendmicroConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Veeva.
	Veeva *VeevaConnectorProfileProperties `type:"structure"`

	// The connector-specific properties required by Zendesk.
	Zendesk *ZendeskConnectorProfileProperties `type:"structure"`
}

// String returns the string representation
func (s ConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorProfileProperties"}
	if s.Datadog != nil {
		if err := s.Datadog.Validate(); err != nil {
			invalidParams.AddNested("Datadog", err.(request.ErrInvalidParams))
		}
	}
	if s.Dynatrace != nil {
		if err := s.Dynatrace.Validate(); err != nil {
			invalidParams.AddNested("Dynatrace", err.(request.ErrInvalidParams))
		}
	}
	if s.InforNexus != nil {
		if err := s.InforNexus.Validate(); err != nil {
			invalidParams.AddNested("InforNexus", err.(request.ErrInvalidParams))
		}
	}
	if s.Marketo != nil {
		if err := s.Marketo.Validate(); err != nil {
			invalidParams.AddNested("Marketo", err.(request.ErrInvalidParams))
		}
	}
	if s.Redshift != nil {
		if err := s.Redshift.Validate(); err != nil {
			invalidParams.AddNested("Redshift", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNow != nil {
		if err := s.ServiceNow.Validate(); err != nil {
			invalidParams.AddNested("ServiceNow", err.(request.ErrInvalidParams))
		}
	}
	if s.Slack != nil {
		if err := s.Slack.Validate(); err != nil {
			invalidParams.AddNested("Slack", err.(request.ErrInvalidParams))
		}
	}
	if s.Snowflake != nil {
		if err := s.Snowflake.Validate(); err != nil {
			invalidParams.AddNested("Snowflake", err.(request.ErrInvalidParams))
		}
	}
	if s.Veeva != nil {
		if err := s.Veeva.Validate(); err != nil {
			invalidParams.AddNested("Veeva", err.(request.ErrInvalidParams))
		}
	}
	if s.Zendesk != nil {
		if err := s.Zendesk.Validate(); err != nil {
			invalidParams.AddNested("Zendesk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmplitude sets the Amplitude field's value.
func (s *ConnectorProfileProperties) SetAmplitude(v *AmplitudeConnectorProfileProperties) *ConnectorProfileProperties {
	s.Amplitude = v
	return s
}

// SetDatadog sets the Datadog field's value.
func (s *ConnectorProfileProperties) SetDatadog(v *DatadogConnectorProfileProperties) *ConnectorProfileProperties {
	s.Datadog = v
	return s
}

// SetDynatrace sets the Dynatrace field's value.
func (s *ConnectorProfileProperties) SetDynatrace(v *DynatraceConnectorProfileProperties) *ConnectorProfileProperties {
	s.Dynatrace = v
	return s
}

// SetGoogleAnalytics sets the GoogleAnalytics field's value.
func (s *ConnectorProfileProperties) SetGoogleAnalytics(v *GoogleAnalyticsConnectorProfileProperties) *ConnectorProfileProperties {
	s.GoogleAnalytics = v
	return s
}

// SetInforNexus sets the InforNexus field's value.
func (s *ConnectorProfileProperties) SetInforNexus(v *InforNexusConnectorProfileProperties) *ConnectorProfileProperties {
	s.InforNexus = v
	return s
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorProfileProperties) SetMarketo(v *MarketoConnectorProfileProperties) *ConnectorProfileProperties {
	s.Marketo = v
	return s
}

// SetRedshift sets the Redshift field's value.
func (s *ConnectorProfileProperties) SetRedshift(v *RedshiftConnectorProfileProperties) *ConnectorProfileProperties {
	s.Redshift = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorProfileProperties) SetSalesforce(v *SalesforceConnectorProfileProperties) *ConnectorProfileProperties {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorProfileProperties) SetServiceNow(v *ServiceNowConnectorProfileProperties) *ConnectorProfileProperties {
	s.ServiceNow = v
	return s
}

// SetSingular sets the Singular field's value.
func (s *ConnectorProfileProperties) SetSingular(v *SingularConnectorProfileProperties) *ConnectorProfileProperties {
	s.Singular = v
	return s
}

// SetSlack sets the Slack field's value.
func (s *ConnectorProfileProperties) SetSlack(v *SlackConnectorProfileProperties) *ConnectorProfileProperties {
	s.Slack = v
	return s
}

// SetSnowflake sets the Snowflake field's value.
func (s *ConnectorProfileProperties) SetSnowflake(v *SnowflakeConnectorProfileProperties) *ConnectorProfileProperties {
	s.Snowflake = v
	return s
}

// SetTrendmicro sets the Trendmicro field's value.
func (s *ConnectorProfileProperties) SetTrendmicro(v *TrendmicroConnectorProfileProperties) *ConnectorProfileProperties {
	s.Trendmicro = v
	return s
}

// SetVeeva sets the Veeva field's value.
func (s *ConnectorProfileProperties) SetVeeva(v *VeevaConnectorProfileProperties) *ConnectorProfileProperties {
	s.Veeva = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorProfileProperties) SetZendesk(v *ZendeskConnectorProfileProperties) *ConnectorProfileProperties {
	s.Zendesk = v
	return s
}

// An error occurred when retrieving data from the connector endpoint.
type ConnectorServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConnectorServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorServerException) GoString() string {
	return s.String()
}

func newErrorConnectorServerException(v protocol.ResponseMetadata) error {
	return &ConnectorServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConnectorServerException) Code() string {
	return "ConnectorServerException"
}

// Message returns the exception's message.
func (s *ConnectorServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConnectorServerException) OrigErr() error {
	return nil
}

func (s *ConnectorServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConnectorServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConnectorServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateConnectorProfileInput struct {
	_ struct{} `type:"structure"`

	// Indicates the connection mode and specifies whether it is public or private.
	// Private flows use AWS PrivateLink to route data over AWS infrastructure without
	// exposing it to the public internet.
	//
	// ConnectionMode is a required field
	ConnectionMode *string `locationName:"connectionMode" type:"string" required:"true" enum:"ConnectionMode"`

	// Defines the connector-specific configuration and credentials.
	//
	// ConnectorProfileConfig is a required field
	ConnectorProfileConfig *ConnectorProfileConfig `locationName:"connectorProfileConfig" type:"structure" required:"true"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in your AWS account.
	//
	// ConnectorProfileName is a required field
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string" required:"true"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// ConnectorType is a required field
	ConnectorType *string `locationName:"connectorType" type:"string" required:"true" enum:"ConnectorType"`

	// The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you
	// provide for encryption. This is required if you do not want to use the Amazon
	// AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow
	// uses the Amazon AppFlow-managed KMS key.
	KmsArn *string `locationName:"kmsArn" min:"20" type:"string"`
}

// String returns the string representation
func (s CreateConnectorProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorProfileInput"}
	if s.ConnectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionMode"))
	}
	if s.ConnectorProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileConfig"))
	}
	if s.ConnectorProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileName"))
	}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.KmsArn != nil && len(*s.KmsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsArn", 20))
	}
	if s.ConnectorProfileConfig != nil {
		if err := s.ConnectorProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("ConnectorProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *CreateConnectorProfileInput) SetConnectionMode(v string) *CreateConnectorProfileInput {
	s.ConnectionMode = &v
	return s
}

// SetConnectorProfileConfig sets the ConnectorProfileConfig field's value.
func (s *CreateConnectorProfileInput) SetConnectorProfileConfig(v *ConnectorProfileConfig) *CreateConnectorProfileInput {
	s.ConnectorProfileConfig = v
	return s
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *CreateConnectorProfileInput) SetConnectorProfileName(v string) *CreateConnectorProfileInput {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *CreateConnectorProfileInput) SetConnectorType(v string) *CreateConnectorProfileInput {
	s.ConnectorType = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *CreateConnectorProfileInput) SetKmsArn(v string) *CreateConnectorProfileInput {
	s.KmsArn = &v
	return s
}

type CreateConnectorProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector profile.
	ConnectorProfileArn *string `locationName:"connectorProfileArn" type:"string"`
}

// String returns the string representation
func (s CreateConnectorProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorProfileOutput) GoString() string {
	return s.String()
}

// SetConnectorProfileArn sets the ConnectorProfileArn field's value.
func (s *CreateConnectorProfileOutput) SetConnectorProfileArn(v string) *CreateConnectorProfileOutput {
	s.ConnectorProfileArn = &v
	return s
}

type CreateFlowInput struct {
	_ struct{} `type:"structure"`

	// A description of the flow you want to create.
	Description *string `locationName:"description" type:"string"`

	// The configuration that controls how Amazon AppFlow places data in the destination
	// connector.
	//
	// DestinationFlowConfigList is a required field
	DestinationFlowConfigList []*DestinationFlowConfig `locationName:"destinationFlowConfigList" type:"list" required:"true"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you
	// provide for encryption. This is required if you do not want to use the Amazon
	// AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow
	// uses the Amazon AppFlow-managed KMS key.
	KmsArn *string `locationName:"kmsArn" min:"20" type:"string"`

	// The configuration that controls how Amazon AppFlow retrieves data from the
	// source connector.
	//
	// SourceFlowConfig is a required field
	SourceFlowConfig *SourceFlowConfig `locationName:"sourceFlowConfig" type:"structure" required:"true"`

	// The tags used to organize, track, or control access for your flow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of tasks that Amazon AppFlow performs while transferring the data
	// in the flow run.
	//
	// Tasks is a required field
	Tasks []*Task `locationName:"tasks" type:"list" required:"true"`

	// The trigger settings that determine how and when the flow runs.
	//
	// TriggerConfig is a required field
	TriggerConfig *TriggerConfig `locationName:"triggerConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowInput"}
	if s.DestinationFlowConfigList == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationFlowConfigList"))
	}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.KmsArn != nil && len(*s.KmsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsArn", 20))
	}
	if s.SourceFlowConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFlowConfig"))
	}
	if s.Tasks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tasks"))
	}
	if s.TriggerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerConfig"))
	}
	if s.DestinationFlowConfigList != nil {
		for i, v := range s.DestinationFlowConfigList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DestinationFlowConfigList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceFlowConfig != nil {
		if err := s.SourceFlowConfig.Validate(); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tasks != nil {
		for i, v := range s.Tasks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tasks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerConfig != nil {
		if err := s.TriggerConfig.Validate(); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFlowInput) SetDescription(v string) *CreateFlowInput {
	s.Description = &v
	return s
}

// SetDestinationFlowConfigList sets the DestinationFlowConfigList field's value.
func (s *CreateFlowInput) SetDestinationFlowConfigList(v []*DestinationFlowConfig) *CreateFlowInput {
	s.DestinationFlowConfigList = v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *CreateFlowInput) SetFlowName(v string) *CreateFlowInput {
	s.FlowName = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *CreateFlowInput) SetKmsArn(v string) *CreateFlowInput {
	s.KmsArn = &v
	return s
}

// SetSourceFlowConfig sets the SourceFlowConfig field's value.
func (s *CreateFlowInput) SetSourceFlowConfig(v *SourceFlowConfig) *CreateFlowInput {
	s.SourceFlowConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFlowInput) SetTags(v map[string]*string) *CreateFlowInput {
	s.Tags = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *CreateFlowInput) SetTasks(v []*Task) *CreateFlowInput {
	s.Tasks = v
	return s
}

// SetTriggerConfig sets the TriggerConfig field's value.
func (s *CreateFlowInput) SetTriggerConfig(v *TriggerConfig) *CreateFlowInput {
	s.TriggerConfig = v
	return s
}

type CreateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string `locationName:"flowArn" type:"string"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`
}

// String returns the string representation
func (s CreateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *CreateFlowOutput) SetFlowArn(v string) *CreateFlowOutput {
	s.FlowArn = &v
	return s
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *CreateFlowOutput) SetFlowStatus(v string) *CreateFlowOutput {
	s.FlowStatus = &v
	return s
}

// The connector-specific credentials required by Datadog.
type DatadogConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// A unique alphanumeric identifier used to authenticate a user, developer,
	// or calling program to your API.
	//
	// ApiKey is a required field
	ApiKey *string `locationName:"apiKey" type:"string" required:"true"`

	// Application keys, in conjunction with your API key, give you full access
	// to Datadog’s programmatic API. Application keys are associated with the
	// user account that created them. The application key is used to log all requests
	// made to the API.
	//
	// ApplicationKey is a required field
	ApplicationKey *string `locationName:"applicationKey" type:"string" required:"true"`
}

// String returns the string representation
func (s DatadogConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatadogConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatadogConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatadogConnectorProfileCredentials"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.ApplicationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *DatadogConnectorProfileCredentials) SetApiKey(v string) *DatadogConnectorProfileCredentials {
	s.ApiKey = &v
	return s
}

// SetApplicationKey sets the ApplicationKey field's value.
func (s *DatadogConnectorProfileCredentials) SetApplicationKey(v string) *DatadogConnectorProfileCredentials {
	s.ApplicationKey = &v
	return s
}

// The connector-specific profile properties required by Datadog.
type DatadogConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Datadog resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s DatadogConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatadogConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatadogConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatadogConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *DatadogConnectorProfileProperties) SetInstanceUrl(v string) *DatadogConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Datadog.
type DatadogMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DatadogMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatadogMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Datadog is being used as a source.
type DatadogSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Datadog flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s DatadogSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatadogSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatadogSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatadogSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *DatadogSourceProperties) SetObject(v string) *DatadogSourceProperties {
	s.Object = &v
	return s
}

type DeleteConnectorProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in your account.
	//
	// ConnectorProfileName is a required field
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string" required:"true"`

	// Indicates whether Amazon AppFlow should delete the profile, even if it is
	// currently in use in one or more flows.
	ForceDelete *bool `locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation
func (s DeleteConnectorProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectorProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectorProfileInput"}
	if s.ConnectorProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *DeleteConnectorProfileInput) SetConnectorProfileName(v string) *DeleteConnectorProfileInput {
	s.ConnectorProfileName = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteConnectorProfileInput) SetForceDelete(v bool) *DeleteConnectorProfileInput {
	s.ForceDelete = &v
	return s
}

type DeleteConnectorProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectorProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectorProfileOutput) GoString() string {
	return s.String()
}

type DeleteFlowInput struct {
	_ struct{} `type:"structure"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`

	// Indicates whether Amazon AppFlow should delete the flow, even if it is currently
	// in use.
	ForceDelete *bool `locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation
func (s DeleteFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowInput"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *DeleteFlowInput) SetFlowName(v string) *DeleteFlowInput {
	s.FlowName = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteFlowInput) SetForceDelete(v bool) *DeleteFlowInput {
	s.ForceDelete = &v
	return s
}

type DeleteFlowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowOutput) GoString() string {
	return s.String()
}

type DescribeConnectorEntityInput struct {
	_ struct{} `type:"structure"`

	// The entity name for that connector.
	//
	// ConnectorEntityName is a required field
	ConnectorEntityName *string `locationName:"connectorEntityName" type:"string" required:"true"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in the AWS account.
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string"`

	// The type of connector application, such as Salesforce, Amplitude, and so
	// on.
	ConnectorType *string `locationName:"connectorType" type:"string" enum:"ConnectorType"`
}

// String returns the string representation
func (s DescribeConnectorEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectorEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectorEntityInput"}
	if s.ConnectorEntityName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorEntityName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorEntityName sets the ConnectorEntityName field's value.
func (s *DescribeConnectorEntityInput) SetConnectorEntityName(v string) *DescribeConnectorEntityInput {
	s.ConnectorEntityName = &v
	return s
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *DescribeConnectorEntityInput) SetConnectorProfileName(v string) *DescribeConnectorEntityInput {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *DescribeConnectorEntityInput) SetConnectorType(v string) *DescribeConnectorEntityInput {
	s.ConnectorType = &v
	return s
}

type DescribeConnectorEntityOutput struct {
	_ struct{} `type:"structure"`

	// Describes the fields for that connector entity. For example, for an account
	// entity, the fields would be account name, account ID, and so on.
	//
	// ConnectorEntityFields is a required field
	ConnectorEntityFields []*ConnectorEntityField `locationName:"connectorEntityFields" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeConnectorEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorEntityOutput) GoString() string {
	return s.String()
}

// SetConnectorEntityFields sets the ConnectorEntityFields field's value.
func (s *DescribeConnectorEntityOutput) SetConnectorEntityFields(v []*ConnectorEntityField) *DescribeConnectorEntityOutput {
	s.ConnectorEntityFields = v
	return s
}

type DescribeConnectorProfilesInput struct {
	_ struct{} `type:"structure"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in the AWS account.
	ConnectorProfileNames []*string `locationName:"connectorProfileNames" type:"list"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorType *string `locationName:"connectorType" type:"string" enum:"ConnectorType"`

	// Specifies the maximum number of items that should be returned in the result
	// set. The default for maxResults is 20 (for all paginated API operations).
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeConnectorProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectorProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectorProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileNames sets the ConnectorProfileNames field's value.
func (s *DescribeConnectorProfilesInput) SetConnectorProfileNames(v []*string) *DescribeConnectorProfilesInput {
	s.ConnectorProfileNames = v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *DescribeConnectorProfilesInput) SetConnectorType(v string) *DescribeConnectorProfilesInput {
	s.ConnectorType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConnectorProfilesInput) SetMaxResults(v int64) *DescribeConnectorProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectorProfilesInput) SetNextToken(v string) *DescribeConnectorProfilesInput {
	s.NextToken = &v
	return s
}

type DescribeConnectorProfilesOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the connector profiles associated with the flow.
	ConnectorProfileDetails []*ConnectorProfile `locationName:"connectorProfileDetails" type:"list"`

	// The pagination token for the next page of data. If nextToken=null, this means
	// that all records have been fetched.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeConnectorProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorProfilesOutput) GoString() string {
	return s.String()
}

// SetConnectorProfileDetails sets the ConnectorProfileDetails field's value.
func (s *DescribeConnectorProfilesOutput) SetConnectorProfileDetails(v []*ConnectorProfile) *DescribeConnectorProfilesOutput {
	s.ConnectorProfileDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectorProfilesOutput) SetNextToken(v string) *DescribeConnectorProfilesOutput {
	s.NextToken = &v
	return s
}

type DescribeConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorTypes []*string `locationName:"connectorTypes" type:"list"`

	// The pagination token for the next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorsInput) GoString() string {
	return s.String()
}

// SetConnectorTypes sets the ConnectorTypes field's value.
func (s *DescribeConnectorsInput) SetConnectorTypes(v []*string) *DescribeConnectorsInput {
	s.ConnectorTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectorsInput) SetNextToken(v string) *DescribeConnectorsInput {
	s.NextToken = &v
	return s
}

type DescribeConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// The configuration that is applied to the connectors used in the flow.
	ConnectorConfigurations map[string]*ConnectorConfiguration `locationName:"connectorConfigurations" type:"map"`

	// The pagination token for the next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectorConfigurations sets the ConnectorConfigurations field's value.
func (s *DescribeConnectorsOutput) SetConnectorConfigurations(v map[string]*ConnectorConfiguration) *DescribeConnectorsOutput {
	s.ConnectorConfigurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectorsOutput) SetNextToken(v string) *DescribeConnectorsOutput {
	s.NextToken = &v
	return s
}

type DescribeFlowExecutionRecordsInput struct {
	_ struct{} `type:"structure"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`

	// Specifies the maximum number of items that should be returned in the result
	// set. The default for maxResults is 20 (for all paginated API operations).
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeFlowExecutionRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowExecutionRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowExecutionRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowExecutionRecordsInput"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *DescribeFlowExecutionRecordsInput) SetFlowName(v string) *DescribeFlowExecutionRecordsInput {
	s.FlowName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeFlowExecutionRecordsInput) SetMaxResults(v int64) *DescribeFlowExecutionRecordsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowExecutionRecordsInput) SetNextToken(v string) *DescribeFlowExecutionRecordsInput {
	s.NextToken = &v
	return s
}

type DescribeFlowExecutionRecordsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of all instances when this flow was run.
	FlowExecutions []*ExecutionRecord `locationName:"flowExecutions" type:"list"`

	// The pagination token for the next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeFlowExecutionRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowExecutionRecordsOutput) GoString() string {
	return s.String()
}

// SetFlowExecutions sets the FlowExecutions field's value.
func (s *DescribeFlowExecutionRecordsOutput) SetFlowExecutions(v []*ExecutionRecord) *DescribeFlowExecutionRecordsOutput {
	s.FlowExecutions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowExecutionRecordsOutput) SetNextToken(v string) *DescribeFlowExecutionRecordsOutput {
	s.NextToken = &v
	return s
}

type DescribeFlowInput struct {
	_ struct{} `type:"structure"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowInput"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *DescribeFlowInput) SetFlowName(v string) *DescribeFlowInput {
	s.FlowName = &v
	return s
}

type DescribeFlowOutput struct {
	_ struct{} `type:"structure"`

	// Specifies when the flow was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ARN of the user who created the flow.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A description of the flow.
	Description *string `locationName:"description" type:"string"`

	// The configuration that controls how Amazon AppFlow transfers data to the
	// destination connector.
	DestinationFlowConfigList []*DestinationFlowConfig `locationName:"destinationFlowConfigList" type:"list"`

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	FlowName *string `locationName:"flowName" type:"string"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`

	// Contains an error message if the flow status is in a suspended or error state.
	// This applies only to scheduled or event-triggered flows.
	FlowStatusMessage *string `locationName:"flowStatusMessage" type:"string"`

	// The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you
	// provide for encryption. This is required if you do not want to use the Amazon
	// AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow
	// uses the Amazon AppFlow-managed KMS key.
	KmsArn *string `locationName:"kmsArn" min:"20" type:"string"`

	// Describes the details of the most recent flow run.
	LastRunExecutionDetails *ExecutionDetails `locationName:"lastRunExecutionDetails" type:"structure"`

	// Specifies when the flow was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Specifies the user name of the account that performed the most recent update.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" type:"string"`

	// The configuration that controls how Amazon AppFlow retrieves data from the
	// source connector.
	SourceFlowConfig *SourceFlowConfig `locationName:"sourceFlowConfig" type:"structure"`

	// The tags used to organize, track, or control access for your flow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of tasks that Amazon AppFlow performs while transferring the data
	// in the flow run.
	Tasks []*Task `locationName:"tasks" type:"list"`

	// The trigger settings that determine how and when the flow runs.
	TriggerConfig *TriggerConfig `locationName:"triggerConfig" type:"structure"`
}

// String returns the string representation
func (s DescribeFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeFlowOutput) SetCreatedAt(v time.Time) *DescribeFlowOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeFlowOutput) SetCreatedBy(v string) *DescribeFlowOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeFlowOutput) SetDescription(v string) *DescribeFlowOutput {
	s.Description = &v
	return s
}

// SetDestinationFlowConfigList sets the DestinationFlowConfigList field's value.
func (s *DescribeFlowOutput) SetDestinationFlowConfigList(v []*DestinationFlowConfig) *DescribeFlowOutput {
	s.DestinationFlowConfigList = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowOutput) SetFlowArn(v string) *DescribeFlowOutput {
	s.FlowArn = &v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *DescribeFlowOutput) SetFlowName(v string) *DescribeFlowOutput {
	s.FlowName = &v
	return s
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *DescribeFlowOutput) SetFlowStatus(v string) *DescribeFlowOutput {
	s.FlowStatus = &v
	return s
}

// SetFlowStatusMessage sets the FlowStatusMessage field's value.
func (s *DescribeFlowOutput) SetFlowStatusMessage(v string) *DescribeFlowOutput {
	s.FlowStatusMessage = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *DescribeFlowOutput) SetKmsArn(v string) *DescribeFlowOutput {
	s.KmsArn = &v
	return s
}

// SetLastRunExecutionDetails sets the LastRunExecutionDetails field's value.
func (s *DescribeFlowOutput) SetLastRunExecutionDetails(v *ExecutionDetails) *DescribeFlowOutput {
	s.LastRunExecutionDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeFlowOutput) SetLastUpdatedAt(v time.Time) *DescribeFlowOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *DescribeFlowOutput) SetLastUpdatedBy(v string) *DescribeFlowOutput {
	s.LastUpdatedBy = &v
	return s
}

// SetSourceFlowConfig sets the SourceFlowConfig field's value.
func (s *DescribeFlowOutput) SetSourceFlowConfig(v *SourceFlowConfig) *DescribeFlowOutput {
	s.SourceFlowConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeFlowOutput) SetTags(v map[string]*string) *DescribeFlowOutput {
	s.Tags = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *DescribeFlowOutput) SetTasks(v []*Task) *DescribeFlowOutput {
	s.Tasks = v
	return s
}

// SetTriggerConfig sets the TriggerConfig field's value.
func (s *DescribeFlowOutput) SetTriggerConfig(v *TriggerConfig) *DescribeFlowOutput {
	s.TriggerConfig = v
	return s
}

// This stores the information that is required to query a particular connector.
type DestinationConnectorProperties struct {
	_ struct{} `type:"structure"`

	// The properties required to query Amazon EventBridge.
	EventBridge *EventBridgeDestinationProperties `type:"structure"`

	// The properties required to query Amazon Redshift.
	Redshift *RedshiftDestinationProperties `type:"structure"`

	// The properties required to query Amazon S3.
	S3 *S3DestinationProperties `type:"structure"`

	// The properties required to query Salesforce.
	Salesforce *SalesforceDestinationProperties `type:"structure"`

	// The properties required to query Snowflake.
	Snowflake *SnowflakeDestinationProperties `type:"structure"`

	// The properties required to query Upsolver.
	Upsolver *UpsolverDestinationProperties `type:"structure"`
}

// String returns the string representation
func (s DestinationConnectorProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationConnectorProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConnectorProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConnectorProperties"}
	if s.EventBridge != nil {
		if err := s.EventBridge.Validate(); err != nil {
			invalidParams.AddNested("EventBridge", err.(request.ErrInvalidParams))
		}
	}
	if s.Redshift != nil {
		if err := s.Redshift.Validate(); err != nil {
			invalidParams.AddNested("Redshift", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.Snowflake != nil {
		if err := s.Snowflake.Validate(); err != nil {
			invalidParams.AddNested("Snowflake", err.(request.ErrInvalidParams))
		}
	}
	if s.Upsolver != nil {
		if err := s.Upsolver.Validate(); err != nil {
			invalidParams.AddNested("Upsolver", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBridge sets the EventBridge field's value.
func (s *DestinationConnectorProperties) SetEventBridge(v *EventBridgeDestinationProperties) *DestinationConnectorProperties {
	s.EventBridge = v
	return s
}

// SetRedshift sets the Redshift field's value.
func (s *DestinationConnectorProperties) SetRedshift(v *RedshiftDestinationProperties) *DestinationConnectorProperties {
	s.Redshift = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *DestinationConnectorProperties) SetS3(v *S3DestinationProperties) *DestinationConnectorProperties {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *DestinationConnectorProperties) SetSalesforce(v *SalesforceDestinationProperties) *DestinationConnectorProperties {
	s.Salesforce = v
	return s
}

// SetSnowflake sets the Snowflake field's value.
func (s *DestinationConnectorProperties) SetSnowflake(v *SnowflakeDestinationProperties) *DestinationConnectorProperties {
	s.Snowflake = v
	return s
}

// SetUpsolver sets the Upsolver field's value.
func (s *DestinationConnectorProperties) SetUpsolver(v *UpsolverDestinationProperties) *DestinationConnectorProperties {
	s.Upsolver = v
	return s
}

// The properties that can be applied to a field when connector is being used
// as a destination.
type DestinationFieldProperties struct {
	_ struct{} `type:"structure"`

	// Specifies if the destination field can be created by the current user.
	IsCreatable *bool `locationName:"isCreatable" type:"boolean"`

	// Specifies if the destination field can have a null value.
	IsNullable *bool `locationName:"isNullable" type:"boolean"`

	// Specifies whether the field can be updated during an UPDATE or UPSERT write
	// operation.
	IsUpdatable *bool `locationName:"isUpdatable" type:"boolean"`

	// Specifies if the flow run can either insert new rows in the destination field
	// if they do not already exist, or update them if they do.
	IsUpsertable *bool `locationName:"isUpsertable" type:"boolean"`

	// A list of supported write operations. For each write operation listed, this
	// field can be used in idFieldNames when that write operation is present as
	// a destination option.
	SupportedWriteOperations []*string `locationName:"supportedWriteOperations" type:"list"`
}

// String returns the string representation
func (s DestinationFieldProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationFieldProperties) GoString() string {
	return s.String()
}

// SetIsCreatable sets the IsCreatable field's value.
func (s *DestinationFieldProperties) SetIsCreatable(v bool) *DestinationFieldProperties {
	s.IsCreatable = &v
	return s
}

// SetIsNullable sets the IsNullable field's value.
func (s *DestinationFieldProperties) SetIsNullable(v bool) *DestinationFieldProperties {
	s.IsNullable = &v
	return s
}

// SetIsUpdatable sets the IsUpdatable field's value.
func (s *DestinationFieldProperties) SetIsUpdatable(v bool) *DestinationFieldProperties {
	s.IsUpdatable = &v
	return s
}

// SetIsUpsertable sets the IsUpsertable field's value.
func (s *DestinationFieldProperties) SetIsUpsertable(v bool) *DestinationFieldProperties {
	s.IsUpsertable = &v
	return s
}

// SetSupportedWriteOperations sets the SupportedWriteOperations field's value.
func (s *DestinationFieldProperties) SetSupportedWriteOperations(v []*string) *DestinationFieldProperties {
	s.SupportedWriteOperations = v
	return s
}

// Contains information about the configuration of destination connectors present
// in the flow.
type DestinationFlowConfig struct {
	_ struct{} `type:"structure"`

	// The name of the connector profile. This name must be unique for each connector
	// profile in the AWS account.
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// ConnectorType is a required field
	ConnectorType *string `locationName:"connectorType" type:"string" required:"true" enum:"ConnectorType"`

	// This stores the information that is required to query a particular connector.
	//
	// DestinationConnectorProperties is a required field
	DestinationConnectorProperties *DestinationConnectorProperties `locationName:"destinationConnectorProperties" type:"structure" required:"true"`
}

// String returns the string representation
func (s DestinationFlowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationFlowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationFlowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationFlowConfig"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.DestinationConnectorProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConnectorProperties"))
	}
	if s.DestinationConnectorProperties != nil {
		if err := s.DestinationConnectorProperties.Validate(); err != nil {
			invalidParams.AddNested("DestinationConnectorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *DestinationFlowConfig) SetConnectorProfileName(v string) *DestinationFlowConfig {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *DestinationFlowConfig) SetConnectorType(v string) *DestinationFlowConfig {
	s.ConnectorType = &v
	return s
}

// SetDestinationConnectorProperties sets the DestinationConnectorProperties field's value.
func (s *DestinationFlowConfig) SetDestinationConnectorProperties(v *DestinationConnectorProperties) *DestinationFlowConfig {
	s.DestinationConnectorProperties = v
	return s
}

// The connector-specific profile credentials required by Dynatrace.
type DynatraceConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The API tokens used by Dynatrace API to authenticate various API calls.
	//
	// ApiToken is a required field
	ApiToken *string `locationName:"apiToken" type:"string" required:"true"`
}

// String returns the string representation
func (s DynatraceConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynatraceConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynatraceConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynatraceConnectorProfileCredentials"}
	if s.ApiToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiToken sets the ApiToken field's value.
func (s *DynatraceConnectorProfileCredentials) SetApiToken(v string) *DynatraceConnectorProfileCredentials {
	s.ApiToken = &v
	return s
}

// The connector-specific profile properties required by Dynatrace.
type DynatraceConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Dynatrace resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s DynatraceConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynatraceConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynatraceConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynatraceConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *DynatraceConnectorProfileProperties) SetInstanceUrl(v string) *DynatraceConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Dynatrace.
type DynatraceMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DynatraceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynatraceMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Dynatrace is being used as a source.
type DynatraceSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Dynatrace flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s DynatraceSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynatraceSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynatraceSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynatraceSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *DynatraceSourceProperties) SetObject(v string) *DynatraceSourceProperties {
	s.Object = &v
	return s
}

// The settings that determine how Amazon AppFlow handles an error when placing
// data in the destination. For example, this setting would determine if the
// flow should fail after one insertion error, or continue and attempt to insert
// every record regardless of the initial failure. ErrorHandlingConfig is a
// part of the destination connector details.
type ErrorHandlingConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the Amazon S3 bucket.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`

	// Specifies the Amazon S3 bucket prefix.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// Specifies if the flow should fail after the first instance of a failure when
	// attempting to place data in the destination.
	FailOnFirstDestinationError *bool `locationName:"failOnFirstDestinationError" type:"boolean"`
}

// String returns the string representation
func (s ErrorHandlingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorHandlingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorHandlingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorHandlingConfig"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *ErrorHandlingConfig) SetBucketName(v string) *ErrorHandlingConfig {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *ErrorHandlingConfig) SetBucketPrefix(v string) *ErrorHandlingConfig {
	s.BucketPrefix = &v
	return s
}

// SetFailOnFirstDestinationError sets the FailOnFirstDestinationError field's value.
func (s *ErrorHandlingConfig) SetFailOnFirstDestinationError(v bool) *ErrorHandlingConfig {
	s.FailOnFirstDestinationError = &v
	return s
}

// Provides details in the event of a failed flow, including the failure count
// and the related error messages.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the error message that appears if a flow fails.
	ExecutionMessage *string `locationName:"executionMessage" type:"string"`

	// Specifies the failure count for the attempted flow.
	PutFailuresCount *int64 `locationName:"putFailuresCount" type:"long"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetExecutionMessage sets the ExecutionMessage field's value.
func (s *ErrorInfo) SetExecutionMessage(v string) *ErrorInfo {
	s.ExecutionMessage = &v
	return s
}

// SetPutFailuresCount sets the PutFailuresCount field's value.
func (s *ErrorInfo) SetPutFailuresCount(v int64) *ErrorInfo {
	s.PutFailuresCount = &v
	return s
}

// The properties that are applied when Amazon EventBridge is being used as
// a destination.
type EventBridgeDestinationProperties struct {
	_ struct{} `type:"structure"`

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the
	// flow should fail after one insertion error, or continue and attempt to insert
	// every record regardless of the initial failure. ErrorHandlingConfig is a
	// part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig `locationName:"errorHandlingConfig" type:"structure"`

	// The object specified in the Amazon EventBridge flow destination.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s EventBridgeDestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventBridgeDestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventBridgeDestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventBridgeDestinationProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.ErrorHandlingConfig != nil {
		if err := s.ErrorHandlingConfig.Validate(); err != nil {
			invalidParams.AddNested("ErrorHandlingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorHandlingConfig sets the ErrorHandlingConfig field's value.
func (s *EventBridgeDestinationProperties) SetErrorHandlingConfig(v *ErrorHandlingConfig) *EventBridgeDestinationProperties {
	s.ErrorHandlingConfig = v
	return s
}

// SetObject sets the Object field's value.
func (s *EventBridgeDestinationProperties) SetObject(v string) *EventBridgeDestinationProperties {
	s.Object = &v
	return s
}

// The connector metadata specific to Amazon EventBridge.
type EventBridgeMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EventBridgeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventBridgeMetadata) GoString() string {
	return s.String()
}

// Describes the details of the flow run, including the timestamp, status, and
// message.
type ExecutionDetails struct {
	_ struct{} `type:"structure"`

	// Describes the details of the most recent flow run.
	MostRecentExecutionMessage *string `locationName:"mostRecentExecutionMessage" type:"string"`

	// Specifies the status of the most recent flow run.
	MostRecentExecutionStatus *string `locationName:"mostRecentExecutionStatus" type:"string" enum:"ExecutionStatus"`

	// Specifies the time of the most recent flow run.
	MostRecentExecutionTime *time.Time `locationName:"mostRecentExecutionTime" type:"timestamp"`
}

// String returns the string representation
func (s ExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionDetails) GoString() string {
	return s.String()
}

// SetMostRecentExecutionMessage sets the MostRecentExecutionMessage field's value.
func (s *ExecutionDetails) SetMostRecentExecutionMessage(v string) *ExecutionDetails {
	s.MostRecentExecutionMessage = &v
	return s
}

// SetMostRecentExecutionStatus sets the MostRecentExecutionStatus field's value.
func (s *ExecutionDetails) SetMostRecentExecutionStatus(v string) *ExecutionDetails {
	s.MostRecentExecutionStatus = &v
	return s
}

// SetMostRecentExecutionTime sets the MostRecentExecutionTime field's value.
func (s *ExecutionDetails) SetMostRecentExecutionTime(v time.Time) *ExecutionDetails {
	s.MostRecentExecutionTime = &v
	return s
}

// Specifies information about the past flow run instances for a given flow.
type ExecutionRecord struct {
	_ struct{} `type:"structure"`

	// Specifies the identifier of the given flow run.
	ExecutionId *string `locationName:"executionId" type:"string"`

	// Describes the result of the given flow run.
	ExecutionResult *ExecutionResult `locationName:"executionResult" type:"structure"`

	// Specifies the flow run status and whether it is in progress, has completed
	// successfully, or has failed.
	ExecutionStatus *string `locationName:"executionStatus" type:"string" enum:"ExecutionStatus"`

	// Specifies the time of the most recent update.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Specifies the start time of the flow run.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`
}

// String returns the string representation
func (s ExecutionRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionRecord) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *ExecutionRecord) SetExecutionId(v string) *ExecutionRecord {
	s.ExecutionId = &v
	return s
}

// SetExecutionResult sets the ExecutionResult field's value.
func (s *ExecutionRecord) SetExecutionResult(v *ExecutionResult) *ExecutionRecord {
	s.ExecutionResult = v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *ExecutionRecord) SetExecutionStatus(v string) *ExecutionRecord {
	s.ExecutionStatus = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ExecutionRecord) SetLastUpdatedAt(v time.Time) *ExecutionRecord {
	s.LastUpdatedAt = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *ExecutionRecord) SetStartedAt(v time.Time) *ExecutionRecord {
	s.StartedAt = &v
	return s
}

// Specifies the end result of the flow run.
type ExecutionResult struct {
	_ struct{} `type:"structure"`

	// The total number of bytes processed by the flow run.
	BytesProcessed *int64 `locationName:"bytesProcessed" type:"long"`

	// The total number of bytes written as a result of the flow run.
	BytesWritten *int64 `locationName:"bytesWritten" type:"long"`

	// Provides any error message information related to the flow run.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// The number of records processed in the flow run.
	RecordsProcessed *int64 `locationName:"recordsProcessed" type:"long"`
}

// String returns the string representation
func (s ExecutionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionResult) GoString() string {
	return s.String()
}

// SetBytesProcessed sets the BytesProcessed field's value.
func (s *ExecutionResult) SetBytesProcessed(v int64) *ExecutionResult {
	s.BytesProcessed = &v
	return s
}

// SetBytesWritten sets the BytesWritten field's value.
func (s *ExecutionResult) SetBytesWritten(v int64) *ExecutionResult {
	s.BytesWritten = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *ExecutionResult) SetErrorInfo(v *ErrorInfo) *ExecutionResult {
	s.ErrorInfo = v
	return s
}

// SetRecordsProcessed sets the RecordsProcessed field's value.
func (s *ExecutionResult) SetRecordsProcessed(v int64) *ExecutionResult {
	s.RecordsProcessed = &v
	return s
}

// Contains details regarding the supported field type and the operators that
// can be applied for filtering.
type FieldTypeDetails struct {
	_ struct{} `type:"structure"`

	// The type of field, such as string, integer, date, and so on.
	//
	// FieldType is a required field
	FieldType *string `locationName:"fieldType" type:"string" required:"true"`

	// The list of operators supported by a field.
	//
	// FilterOperators is a required field
	FilterOperators []*string `locationName:"filterOperators" type:"list" required:"true"`

	// The list of values that a field can contain. For example, a Boolean fieldType
	// can have two values: "true" and "false".
	SupportedValues []*string `locationName:"supportedValues" type:"list"`
}

// String returns the string representation
func (s FieldTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldTypeDetails) GoString() string {
	return s.String()
}

// SetFieldType sets the FieldType field's value.
func (s *FieldTypeDetails) SetFieldType(v string) *FieldTypeDetails {
	s.FieldType = &v
	return s
}

// SetFilterOperators sets the FilterOperators field's value.
func (s *FieldTypeDetails) SetFilterOperators(v []*string) *FieldTypeDetails {
	s.FilterOperators = v
	return s
}

// SetSupportedValues sets the SupportedValues field's value.
func (s *FieldTypeDetails) SetSupportedValues(v []*string) *FieldTypeDetails {
	s.SupportedValues = v
	return s
}

// The properties of the flow, such as its source, destination, trigger type,
// and so on.
type FlowDefinition struct {
	_ struct{} `type:"structure"`

	// Specifies when the flow was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ARN of the user who created the flow.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A user-entered description of the flow.
	Description *string `locationName:"description" type:"string"`

	// Specifies the destination connector type, such as Salesforce, Amazon S3,
	// Amplitude, and so on.
	DestinationConnectorType *string `locationName:"destinationConnectorType" type:"string" enum:"ConnectorType"`

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	FlowName *string `locationName:"flowName" type:"string"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`

	// Describes the details of the most recent flow run.
	LastRunExecutionDetails *ExecutionDetails `locationName:"lastRunExecutionDetails" type:"structure"`

	// Specifies when the flow was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Specifies the account user name that most recently updated the flow.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" type:"string"`

	// Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude,
	// and so on.
	SourceConnectorType *string `locationName:"sourceConnectorType" type:"string" enum:"ConnectorType"`

	// The tags used to organize, track, or control access for your flow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Specifies the type of flow trigger. This can be OnDemand, Scheduled, or Event.
	TriggerType *string `locationName:"triggerType" type:"string" enum:"TriggerType"`
}

// String returns the string representation
func (s FlowDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowDefinition) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowDefinition) SetCreatedAt(v time.Time) *FlowDefinition {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *FlowDefinition) SetCreatedBy(v string) *FlowDefinition {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FlowDefinition) SetDescription(v string) *FlowDefinition {
	s.Description = &v
	return s
}

// SetDestinationConnectorType sets the DestinationConnectorType field's value.
func (s *FlowDefinition) SetDestinationConnectorType(v string) *FlowDefinition {
	s.DestinationConnectorType = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *FlowDefinition) SetFlowArn(v string) *FlowDefinition {
	s.FlowArn = &v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *FlowDefinition) SetFlowName(v string) *FlowDefinition {
	s.FlowName = &v
	return s
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *FlowDefinition) SetFlowStatus(v string) *FlowDefinition {
	s.FlowStatus = &v
	return s
}

// SetLastRunExecutionDetails sets the LastRunExecutionDetails field's value.
func (s *FlowDefinition) SetLastRunExecutionDetails(v *ExecutionDetails) *FlowDefinition {
	s.LastRunExecutionDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *FlowDefinition) SetLastUpdatedAt(v time.Time) *FlowDefinition {
	s.LastUpdatedAt = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *FlowDefinition) SetLastUpdatedBy(v string) *FlowDefinition {
	s.LastUpdatedBy = &v
	return s
}

// SetSourceConnectorType sets the SourceConnectorType field's value.
func (s *FlowDefinition) SetSourceConnectorType(v string) *FlowDefinition {
	s.SourceConnectorType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FlowDefinition) SetTags(v map[string]*string) *FlowDefinition {
	s.Tags = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *FlowDefinition) SetTriggerType(v string) *FlowDefinition {
	s.TriggerType = &v
	return s
}

// The connector-specific profile credentials required by Google Analytics.
type GoogleAnalyticsConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The credentials used to access protected Google Analytics resources.
	AccessToken *string `locationName:"accessToken" type:"string" sensitive:"true"`

	// The identifier for the desired client.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// ClientSecret is a required field
	ClientSecret *string `locationName:"clientSecret" type:"string" required:"true" sensitive:"true"`

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest `locationName:"oAuthRequest" type:"structure"`

	// The credentials used to acquire new access tokens. This is required only
	// for OAuth2 access tokens, and is not required for OAuth1 access tokens.
	RefreshToken *string `locationName:"refreshToken" type:"string"`
}

// String returns the string representation
func (s GoogleAnalyticsConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GoogleAnalyticsConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GoogleAnalyticsConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GoogleAnalyticsConnectorProfileCredentials"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GoogleAnalyticsConnectorProfileCredentials) SetAccessToken(v string) *GoogleAnalyticsConnectorProfileCredentials {
	s.AccessToken = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *GoogleAnalyticsConnectorProfileCredentials) SetClientId(v string) *GoogleAnalyticsConnectorProfileCredentials {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *GoogleAnalyticsConnectorProfileCredentials) SetClientSecret(v string) *GoogleAnalyticsConnectorProfileCredentials {
	s.ClientSecret = &v
	return s
}

// SetOAuthRequest sets the OAuthRequest field's value.
func (s *GoogleAnalyticsConnectorProfileCredentials) SetOAuthRequest(v *ConnectorOAuthRequest) *GoogleAnalyticsConnectorProfileCredentials {
	s.OAuthRequest = v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *GoogleAnalyticsConnectorProfileCredentials) SetRefreshToken(v string) *GoogleAnalyticsConnectorProfileCredentials {
	s.RefreshToken = &v
	return s
}

// The connector-specific profile properties required by Google Analytics.
type GoogleAnalyticsConnectorProfileProperties struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GoogleAnalyticsConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GoogleAnalyticsConnectorProfileProperties) GoString() string {
	return s.String()
}

// The connector metadata specific to Google Analytics.
type GoogleAnalyticsMetadata struct {
	_ struct{} `type:"structure"`

	// The desired authorization scope for the Google Analytics account.
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list"`
}

// String returns the string representation
func (s GoogleAnalyticsMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GoogleAnalyticsMetadata) GoString() string {
	return s.String()
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *GoogleAnalyticsMetadata) SetOAuthScopes(v []*string) *GoogleAnalyticsMetadata {
	s.OAuthScopes = v
	return s
}

// The properties that are applied when Google Analytics is being used as a
// source.
type GoogleAnalyticsSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Google Analytics flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s GoogleAnalyticsSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GoogleAnalyticsSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GoogleAnalyticsSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GoogleAnalyticsSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *GoogleAnalyticsSourceProperties) SetObject(v string) *GoogleAnalyticsSourceProperties {
	s.Object = &v
	return s
}

// Specifies the configuration used when importing incremental records from
// the source.
type IncrementalPullConfig struct {
	_ struct{} `type:"structure"`

	// A field that specifies the date time or timestamp field as the criteria to
	// use when importing incremental records from the source.
	DatetimeTypeFieldName *string `locationName:"datetimeTypeFieldName" type:"string"`
}

// String returns the string representation
func (s IncrementalPullConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncrementalPullConfig) GoString() string {
	return s.String()
}

// SetDatetimeTypeFieldName sets the DatetimeTypeFieldName field's value.
func (s *IncrementalPullConfig) SetDatetimeTypeFieldName(v string) *IncrementalPullConfig {
	s.DatetimeTypeFieldName = &v
	return s
}

// The connector-specific profile credentials required by Infor Nexus.
type InforNexusConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The Access Key portion of the credentials.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true" sensitive:"true"`

	// The encryption keys used to encrypt data.
	//
	// Datakey is a required field
	Datakey *string `locationName:"datakey" type:"string" required:"true"`

	// The secret key used to sign requests.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true"`

	// The identifier for the user.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s InforNexusConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InforNexusConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InforNexusConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InforNexusConnectorProfileCredentials"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.Datakey == nil {
		invalidParams.Add(request.NewErrParamRequired("Datakey"))
	}
	if s.SecretAccessKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretAccessKey"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *InforNexusConnectorProfileCredentials) SetAccessKeyId(v string) *InforNexusConnectorProfileCredentials {
	s.AccessKeyId = &v
	return s
}

// SetDatakey sets the Datakey field's value.
func (s *InforNexusConnectorProfileCredentials) SetDatakey(v string) *InforNexusConnectorProfileCredentials {
	s.Datakey = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *InforNexusConnectorProfileCredentials) SetSecretAccessKey(v string) *InforNexusConnectorProfileCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *InforNexusConnectorProfileCredentials) SetUserId(v string) *InforNexusConnectorProfileCredentials {
	s.UserId = &v
	return s
}

// The connector-specific profile properties required by Infor Nexus.
type InforNexusConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Infor Nexus resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s InforNexusConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InforNexusConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InforNexusConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InforNexusConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *InforNexusConnectorProfileProperties) SetInstanceUrl(v string) *InforNexusConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Infor Nexus.
type InforNexusMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s InforNexusMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InforNexusMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Infor Nexus is being used as a source.
type InforNexusSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Infor Nexus flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s InforNexusSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InforNexusSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InforNexusSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InforNexusSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *InforNexusSourceProperties) SetObject(v string) *InforNexusSourceProperties {
	s.Object = &v
	return s
}

// An internal service error occurred during the processing of your request.
// Try again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListConnectorEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The name of the connector profile. The name is unique for each ConnectorProfile
	// in the AWS account, and is used to query the downstream connector.
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorType *string `locationName:"connectorType" type:"string" enum:"ConnectorType"`

	// This optional parameter is specific to connector implementation. Some connectors
	// support multiple levels or categories of entities. You can find out the list
	// of roots for such providers by sending a request without the entitiesPath
	// parameter. If the connector supports entities at different roots, this initial
	// request returns the list of roots. Otherwise, this request returns all entities
	// supported by the provider.
	EntitiesPath *string `locationName:"entitiesPath" type:"string"`
}

// String returns the string representation
func (s ListConnectorEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorEntitiesInput) GoString() string {
	return s.String()
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *ListConnectorEntitiesInput) SetConnectorProfileName(v string) *ListConnectorEntitiesInput {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *ListConnectorEntitiesInput) SetConnectorType(v string) *ListConnectorEntitiesInput {
	s.ConnectorType = &v
	return s
}

// SetEntitiesPath sets the EntitiesPath field's value.
func (s *ListConnectorEntitiesInput) SetEntitiesPath(v string) *ListConnectorEntitiesInput {
	s.EntitiesPath = &v
	return s
}

type ListConnectorEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The response of ListConnectorEntities lists entities grouped by category.
	// This map's key represents the group name, and its value contains the list
	// of entities belonging to that group.
	//
	// ConnectorEntityMap is a required field
	ConnectorEntityMap map[string][]*ConnectorEntity `locationName:"connectorEntityMap" type:"map" required:"true"`
}

// String returns the string representation
func (s ListConnectorEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorEntitiesOutput) GoString() string {
	return s.String()
}

// SetConnectorEntityMap sets the ConnectorEntityMap field's value.
func (s *ListConnectorEntitiesOutput) SetConnectorEntityMap(v map[string][]*ConnectorEntity) *ListConnectorEntitiesOutput {
	s.ConnectorEntityMap = v
	return s
}

type ListFlowsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of items that should be returned in the result
	// set.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowsInput) SetMaxResults(v int64) *ListFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsInput) SetNextToken(v string) *ListFlowsInput {
	s.NextToken = &v
	return s
}

type ListFlowsOutput struct {
	_ struct{} `type:"structure"`

	// The list of flows associated with your account.
	Flows []*FlowDefinition `locationName:"flows" type:"list"`

	// The pagination token for next page of data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsOutput) GoString() string {
	return s.String()
}

// SetFlows sets the Flows field's value.
func (s *ListFlowsOutput) SetFlows(v []*FlowDefinition) *ListFlowsOutput {
	s.Flows = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsOutput) SetNextToken(v string) *ListFlowsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified flow.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for your flow.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The connector-specific profile credentials required by Marketo.
type MarketoConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The credentials used to access protected Marketo resources.
	AccessToken *string `locationName:"accessToken" type:"string" sensitive:"true"`

	// The identifier for the desired client.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// ClientSecret is a required field
	ClientSecret *string `locationName:"clientSecret" type:"string" required:"true" sensitive:"true"`

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest `locationName:"oAuthRequest" type:"structure"`
}

// String returns the string representation
func (s MarketoConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarketoConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarketoConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarketoConnectorProfileCredentials"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *MarketoConnectorProfileCredentials) SetAccessToken(v string) *MarketoConnectorProfileCredentials {
	s.AccessToken = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *MarketoConnectorProfileCredentials) SetClientId(v string) *MarketoConnectorProfileCredentials {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *MarketoConnectorProfileCredentials) SetClientSecret(v string) *MarketoConnectorProfileCredentials {
	s.ClientSecret = &v
	return s
}

// SetOAuthRequest sets the OAuthRequest field's value.
func (s *MarketoConnectorProfileCredentials) SetOAuthRequest(v *ConnectorOAuthRequest) *MarketoConnectorProfileCredentials {
	s.OAuthRequest = v
	return s
}

// The connector-specific profile properties required when using Marketo.
type MarketoConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Marketo resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s MarketoConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarketoConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarketoConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarketoConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *MarketoConnectorProfileProperties) SetInstanceUrl(v string) *MarketoConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Marketo.
type MarketoMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MarketoMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarketoMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Marketo flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s MarketoSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarketoSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarketoSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarketoSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *MarketoSourceProperties) SetObject(v string) *MarketoSourceProperties {
	s.Object = &v
	return s
}

// Determines the prefix that Amazon AppFlow applies to the destination folder
// name. You can name your destination folders according to the flow frequency
// and date.
type PrefixConfig struct {
	_ struct{} `type:"structure"`

	// Determines the format of the prefix, and whether it applies to the file name,
	// file path, or both.
	PrefixFormat *string `locationName:"prefixFormat" type:"string" enum:"PrefixFormat"`

	// Determines the level of granularity that's included in the prefix.
	PrefixType *string `locationName:"prefixType" type:"string" enum:"PrefixType"`
}

// String returns the string representation
func (s PrefixConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixConfig) GoString() string {
	return s.String()
}

// SetPrefixFormat sets the PrefixFormat field's value.
func (s *PrefixConfig) SetPrefixFormat(v string) *PrefixConfig {
	s.PrefixFormat = &v
	return s
}

// SetPrefixType sets the PrefixType field's value.
func (s *PrefixConfig) SetPrefixType(v string) *PrefixConfig {
	s.PrefixType = &v
	return s
}

// The connector-specific profile credentials required when using Amazon Redshift.
type RedshiftConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The password that corresponds to the user name.
	//
	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true" sensitive:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftConnectorProfileCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *RedshiftConnectorProfileCredentials) SetPassword(v string) *RedshiftConnectorProfileCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftConnectorProfileCredentials) SetUsername(v string) *RedshiftConnectorProfileCredentials {
	s.Username = &v
	return s
}

// The connector-specific profile properties when using Amazon Redshift.
type RedshiftConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// A name for the associated Amazon S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The object key for the destination bucket in which Amazon AppFlow places
	// the files.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The JDBC URL of the Amazon Redshift cluster.
	//
	// DatabaseUrl is a required field
	DatabaseUrl *string `locationName:"databaseUrl" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftConnectorProfileProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.DatabaseUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseUrl"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *RedshiftConnectorProfileProperties) SetBucketName(v string) *RedshiftConnectorProfileProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *RedshiftConnectorProfileProperties) SetBucketPrefix(v string) *RedshiftConnectorProfileProperties {
	s.BucketPrefix = &v
	return s
}

// SetDatabaseUrl sets the DatabaseUrl field's value.
func (s *RedshiftConnectorProfileProperties) SetDatabaseUrl(v string) *RedshiftConnectorProfileProperties {
	s.DatabaseUrl = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RedshiftConnectorProfileProperties) SetRoleArn(v string) *RedshiftConnectorProfileProperties {
	s.RoleArn = &v
	return s
}

// The properties that are applied when Amazon Redshift is being used as a destination.
type RedshiftDestinationProperties struct {
	_ struct{} `type:"structure"`

	// The object key for the bucket in which Amazon AppFlow places the destination
	// files.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Amazon Redshift destination. For example, this setting would
	// determine if the flow should fail after one insertion error, or continue
	// and attempt to insert every record regardless of the initial failure. ErrorHandlingConfig
	// is a part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig `locationName:"errorHandlingConfig" type:"structure"`

	// The intermediate bucket that Amazon AppFlow uses when moving data into Amazon
	// Redshift.
	//
	// IntermediateBucketName is a required field
	IntermediateBucketName *string `locationName:"intermediateBucketName" min:"3" type:"string" required:"true"`

	// The object specified in the Amazon Redshift flow destination.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationProperties"}
	if s.IntermediateBucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("IntermediateBucketName"))
	}
	if s.IntermediateBucketName != nil && len(*s.IntermediateBucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IntermediateBucketName", 3))
	}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.ErrorHandlingConfig != nil {
		if err := s.ErrorHandlingConfig.Validate(); err != nil {
			invalidParams.AddNested("ErrorHandlingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *RedshiftDestinationProperties) SetBucketPrefix(v string) *RedshiftDestinationProperties {
	s.BucketPrefix = &v
	return s
}

// SetErrorHandlingConfig sets the ErrorHandlingConfig field's value.
func (s *RedshiftDestinationProperties) SetErrorHandlingConfig(v *ErrorHandlingConfig) *RedshiftDestinationProperties {
	s.ErrorHandlingConfig = v
	return s
}

// SetIntermediateBucketName sets the IntermediateBucketName field's value.
func (s *RedshiftDestinationProperties) SetIntermediateBucketName(v string) *RedshiftDestinationProperties {
	s.IntermediateBucketName = &v
	return s
}

// SetObject sets the Object field's value.
func (s *RedshiftDestinationProperties) SetObject(v string) *RedshiftDestinationProperties {
	s.Object = &v
	return s
}

// The connector metadata specific to Amazon Redshift.
type RedshiftMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RedshiftMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftMetadata) GoString() string {
	return s.String()
}

// The resource specified in the request (such as the source or destination
// connector profile) is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The properties that are applied when Amazon S3 is used as a destination.
type S3DestinationProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name in which Amazon AppFlow places the transferred
	// data.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The object key for the destination bucket in which Amazon AppFlow places
	// the files.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The configuration that determines how Amazon AppFlow should format the flow
	// output data when Amazon S3 is used as the destination.
	S3OutputFormatConfig *S3OutputFormatConfig `locationName:"s3OutputFormatConfig" type:"structure"`
}

// String returns the string representation
func (s S3DestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3DestinationProperties) SetBucketName(v string) *S3DestinationProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *S3DestinationProperties) SetBucketPrefix(v string) *S3DestinationProperties {
	s.BucketPrefix = &v
	return s
}

// SetS3OutputFormatConfig sets the S3OutputFormatConfig field's value.
func (s *S3DestinationProperties) SetS3OutputFormatConfig(v *S3OutputFormatConfig) *S3DestinationProperties {
	s.S3OutputFormatConfig = v
	return s
}

// The connector metadata specific to Amazon S3.
type S3Metadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s S3Metadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Metadata) GoString() string {
	return s.String()
}

// The configuration that determines how Amazon AppFlow should format the flow
// output data when Amazon S3 is used as the destination.
type S3OutputFormatConfig struct {
	_ struct{} `type:"structure"`

	// The aggregation settings that you can use to customize the output format
	// of your flow data.
	AggregationConfig *AggregationConfig `locationName:"aggregationConfig" type:"structure"`

	// Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
	FileType *string `locationName:"fileType" type:"string" enum:"FileType"`

	// Determines the prefix that Amazon AppFlow applies to the folder name in the
	// Amazon S3 bucket. You can name folders according to the flow frequency and
	// date.
	PrefixConfig *PrefixConfig `locationName:"prefixConfig" type:"structure"`
}

// String returns the string representation
func (s S3OutputFormatConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3OutputFormatConfig) GoString() string {
	return s.String()
}

// SetAggregationConfig sets the AggregationConfig field's value.
func (s *S3OutputFormatConfig) SetAggregationConfig(v *AggregationConfig) *S3OutputFormatConfig {
	s.AggregationConfig = v
	return s
}

// SetFileType sets the FileType field's value.
func (s *S3OutputFormatConfig) SetFileType(v string) *S3OutputFormatConfig {
	s.FileType = &v
	return s
}

// SetPrefixConfig sets the PrefixConfig field's value.
func (s *S3OutputFormatConfig) SetPrefixConfig(v *PrefixConfig) *S3OutputFormatConfig {
	s.PrefixConfig = v
	return s
}

// The properties that are applied when Amazon S3 is being used as the flow
// source.
type S3SourceProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name where the source files are stored.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`
}

// String returns the string representation
func (s S3SourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SourceProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3SourceProperties) SetBucketName(v string) *S3SourceProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *S3SourceProperties) SetBucketPrefix(v string) *S3SourceProperties {
	s.BucketPrefix = &v
	return s
}

// The connector-specific profile credentials required when using Salesforce.
type SalesforceConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The credentials used to access protected Salesforce resources.
	AccessToken *string `locationName:"accessToken" type:"string" sensitive:"true"`

	// The secret manager ARN, which contains the client ID and client secret of
	// the connected app.
	ClientCredentialsArn *string `locationName:"clientCredentialsArn" min:"20" type:"string" sensitive:"true"`

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest `locationName:"oAuthRequest" type:"structure"`

	// The credentials used to acquire new access tokens.
	RefreshToken *string `locationName:"refreshToken" type:"string"`
}

// String returns the string representation
func (s SalesforceConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceConnectorProfileCredentials"}
	if s.ClientCredentialsArn != nil && len(*s.ClientCredentialsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCredentialsArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *SalesforceConnectorProfileCredentials) SetAccessToken(v string) *SalesforceConnectorProfileCredentials {
	s.AccessToken = &v
	return s
}

// SetClientCredentialsArn sets the ClientCredentialsArn field's value.
func (s *SalesforceConnectorProfileCredentials) SetClientCredentialsArn(v string) *SalesforceConnectorProfileCredentials {
	s.ClientCredentialsArn = &v
	return s
}

// SetOAuthRequest sets the OAuthRequest field's value.
func (s *SalesforceConnectorProfileCredentials) SetOAuthRequest(v *ConnectorOAuthRequest) *SalesforceConnectorProfileCredentials {
	s.OAuthRequest = v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *SalesforceConnectorProfileCredentials) SetRefreshToken(v string) *SalesforceConnectorProfileCredentials {
	s.RefreshToken = &v
	return s
}

// The connector-specific profile properties required when using Salesforce.
type SalesforceConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Salesforce resource.
	InstanceUrl *string `locationName:"instanceUrl" type:"string"`

	// Indicates whether the connector profile applies to a sandbox or production
	// environment.
	IsSandboxEnvironment *bool `locationName:"isSandboxEnvironment" type:"boolean"`
}

// String returns the string representation
func (s SalesforceConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceConnectorProfileProperties) GoString() string {
	return s.String()
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *SalesforceConnectorProfileProperties) SetInstanceUrl(v string) *SalesforceConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// SetIsSandboxEnvironment sets the IsSandboxEnvironment field's value.
func (s *SalesforceConnectorProfileProperties) SetIsSandboxEnvironment(v bool) *SalesforceConnectorProfileProperties {
	s.IsSandboxEnvironment = &v
	return s
}

// The properties that are applied when Salesforce is being used as a destination.
type SalesforceDestinationProperties struct {
	_ struct{} `type:"structure"`

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Salesforce destination. For example, this setting would determine
	// if the flow should fail after one insertion error, or continue and attempt
	// to insert every record regardless of the initial failure. ErrorHandlingConfig
	// is a part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig `locationName:"errorHandlingConfig" type:"structure"`

	// The name of the field that Amazon AppFlow uses as an ID when performing a
	// write operation such as update or delete.
	IdFieldNames []*string `locationName:"idFieldNames" type:"list"`

	// The object specified in the Salesforce flow destination.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`

	// This specifies the type of write operation to be performed in Salesforce.
	// When the value is UPSERT, then idFieldNames is required.
	WriteOperationType *string `locationName:"writeOperationType" type:"string" enum:"WriteOperationType"`
}

// String returns the string representation
func (s SalesforceDestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceDestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceDestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceDestinationProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.ErrorHandlingConfig != nil {
		if err := s.ErrorHandlingConfig.Validate(); err != nil {
			invalidParams.AddNested("ErrorHandlingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorHandlingConfig sets the ErrorHandlingConfig field's value.
func (s *SalesforceDestinationProperties) SetErrorHandlingConfig(v *ErrorHandlingConfig) *SalesforceDestinationProperties {
	s.ErrorHandlingConfig = v
	return s
}

// SetIdFieldNames sets the IdFieldNames field's value.
func (s *SalesforceDestinationProperties) SetIdFieldNames(v []*string) *SalesforceDestinationProperties {
	s.IdFieldNames = v
	return s
}

// SetObject sets the Object field's value.
func (s *SalesforceDestinationProperties) SetObject(v string) *SalesforceDestinationProperties {
	s.Object = &v
	return s
}

// SetWriteOperationType sets the WriteOperationType field's value.
func (s *SalesforceDestinationProperties) SetWriteOperationType(v string) *SalesforceDestinationProperties {
	s.WriteOperationType = &v
	return s
}

// The connector metadata specific to Salesforce.
type SalesforceMetadata struct {
	_ struct{} `type:"structure"`

	// The desired authorization scope for the Salesforce account.
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list"`
}

// String returns the string representation
func (s SalesforceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceMetadata) GoString() string {
	return s.String()
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *SalesforceMetadata) SetOAuthScopes(v []*string) *SalesforceMetadata {
	s.OAuthScopes = v
	return s
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {
	_ struct{} `type:"structure"`

	// The flag that enables dynamic fetching of new (recently added) fields in
	// the Salesforce objects while running a flow.
	EnableDynamicFieldUpdate *bool `locationName:"enableDynamicFieldUpdate" type:"boolean"`

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords *bool `locationName:"includeDeletedRecords" type:"boolean"`

	// The object specified in the Salesforce flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s SalesforceSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableDynamicFieldUpdate sets the EnableDynamicFieldUpdate field's value.
func (s *SalesforceSourceProperties) SetEnableDynamicFieldUpdate(v bool) *SalesforceSourceProperties {
	s.EnableDynamicFieldUpdate = &v
	return s
}

// SetIncludeDeletedRecords sets the IncludeDeletedRecords field's value.
func (s *SalesforceSourceProperties) SetIncludeDeletedRecords(v bool) *SalesforceSourceProperties {
	s.IncludeDeletedRecords = &v
	return s
}

// SetObject sets the Object field's value.
func (s *SalesforceSourceProperties) SetObject(v string) *SalesforceSourceProperties {
	s.Object = &v
	return s
}

// Specifies the configuration details of a schedule-triggered flow as defined
// by the user. Currently, these settings only apply to the Scheduled trigger
// type.
type ScheduledTriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode *string `locationName:"dataPullMode" type:"string" enum:"DataPullMode"`

	// Specifies the scheduled end time for a schedule-triggered flow.
	ScheduleEndTime *time.Time `locationName:"scheduleEndTime" type:"timestamp"`

	// The scheduling expression that determines the rate at which the schedule
	// will run, for example rate(5minutes).
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `locationName:"scheduleExpression" type:"string" required:"true"`

	// Specifies the scheduled start time for a schedule-triggered flow.
	ScheduleStartTime *time.Time `locationName:"scheduleStartTime" type:"timestamp"`

	// Specifies the time zone used when referring to the date and time of a scheduled-triggered
	// flow.
	Timezone *string `locationName:"timezone" type:"string"`
}

// String returns the string representation
func (s ScheduledTriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledTriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledTriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledTriggerProperties"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataPullMode sets the DataPullMode field's value.
func (s *ScheduledTriggerProperties) SetDataPullMode(v string) *ScheduledTriggerProperties {
	s.DataPullMode = &v
	return s
}

// SetScheduleEndTime sets the ScheduleEndTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleEndTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleEndTime = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduledTriggerProperties) SetScheduleExpression(v string) *ScheduledTriggerProperties {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleStartTime sets the ScheduleStartTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleStartTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleStartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ScheduledTriggerProperties) SetTimezone(v string) *ScheduledTriggerProperties {
	s.Timezone = &v
	return s
}

// The connector-specific profile credentials required when using ServiceNow.
type ServiceNowConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The password that corresponds to the user name.
	//
	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true" sensitive:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowConnectorProfileCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *ServiceNowConnectorProfileCredentials) SetPassword(v string) *ServiceNowConnectorProfileCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *ServiceNowConnectorProfileCredentials) SetUsername(v string) *ServiceNowConnectorProfileCredentials {
	s.Username = &v
	return s
}

// The connector-specific profile properties required when using ServiceNow.
type ServiceNowConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the ServiceNow resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *ServiceNowConnectorProfileProperties) SetInstanceUrl(v string) *ServiceNowConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to ServiceNow.
type ServiceNowMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ServiceNowMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the ServiceNow flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ServiceNowSourceProperties) SetObject(v string) *ServiceNowSourceProperties {
	s.Object = &v
	return s
}

// The request would cause a service quota (such as the number of flows) to
// be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connector-specific profile credentials required when using Singular.
type SingularConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// A unique alphanumeric identifier used to authenticate a user, developer,
	// or calling program to your API.
	//
	// ApiKey is a required field
	ApiKey *string `locationName:"apiKey" type:"string" required:"true"`
}

// String returns the string representation
func (s SingularConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingularConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingularConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingularConnectorProfileCredentials"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *SingularConnectorProfileCredentials) SetApiKey(v string) *SingularConnectorProfileCredentials {
	s.ApiKey = &v
	return s
}

// The connector-specific profile properties required when using Singular.
type SingularConnectorProfileProperties struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SingularConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingularConnectorProfileProperties) GoString() string {
	return s.String()
}

// The connector metadata specific to Singular.
type SingularMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SingularMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingularMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when Singular is being used as a source.
type SingularSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Singular flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s SingularSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingularSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingularSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingularSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *SingularSourceProperties) SetObject(v string) *SingularSourceProperties {
	s.Object = &v
	return s
}

// The connector-specific profile credentials required when using Slack.
type SlackConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The credentials used to access protected Slack resources.
	AccessToken *string `locationName:"accessToken" type:"string" sensitive:"true"`

	// The identifier for the client.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// ClientSecret is a required field
	ClientSecret *string `locationName:"clientSecret" type:"string" required:"true" sensitive:"true"`

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest `locationName:"oAuthRequest" type:"structure"`
}

// String returns the string representation
func (s SlackConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlackConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SlackConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SlackConnectorProfileCredentials"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *SlackConnectorProfileCredentials) SetAccessToken(v string) *SlackConnectorProfileCredentials {
	s.AccessToken = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *SlackConnectorProfileCredentials) SetClientId(v string) *SlackConnectorProfileCredentials {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *SlackConnectorProfileCredentials) SetClientSecret(v string) *SlackConnectorProfileCredentials {
	s.ClientSecret = &v
	return s
}

// SetOAuthRequest sets the OAuthRequest field's value.
func (s *SlackConnectorProfileCredentials) SetOAuthRequest(v *ConnectorOAuthRequest) *SlackConnectorProfileCredentials {
	s.OAuthRequest = v
	return s
}

// The connector-specific profile properties required when using Slack.
type SlackConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Slack resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s SlackConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlackConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SlackConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SlackConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *SlackConnectorProfileProperties) SetInstanceUrl(v string) *SlackConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Slack.
type SlackMetadata struct {
	_ struct{} `type:"structure"`

	// The desired authorization scope for the Slack account.
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list"`
}

// String returns the string representation
func (s SlackMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlackMetadata) GoString() string {
	return s.String()
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *SlackMetadata) SetOAuthScopes(v []*string) *SlackMetadata {
	s.OAuthScopes = v
	return s
}

// The properties that are applied when Slack is being used as a source.
type SlackSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Slack flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s SlackSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlackSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SlackSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SlackSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *SlackSourceProperties) SetObject(v string) *SlackSourceProperties {
	s.Object = &v
	return s
}

// The connector-specific profile credentials required when using Snowflake.
type SnowflakeConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The password that corresponds to the user name.
	//
	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true" sensitive:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s SnowflakeConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnowflakeConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnowflakeConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnowflakeConnectorProfileCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *SnowflakeConnectorProfileCredentials) SetPassword(v string) *SnowflakeConnectorProfileCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *SnowflakeConnectorProfileCredentials) SetUsername(v string) *SnowflakeConnectorProfileCredentials {
	s.Username = &v
	return s
}

// The connector-specific profile properties required when using Snowflake.
type SnowflakeConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The name of the account.
	AccountName *string `locationName:"accountName" type:"string"`

	// The name of the Amazon S3 bucket associated with Snowflake.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The Snowflake Private Link service name to be used for private data transfers.
	PrivateLinkServiceName *string `locationName:"privateLinkServiceName" type:"string"`

	// The AWS Region of the Snowflake account.
	Region *string `locationName:"region" type:"string"`

	// The name of the Amazon S3 stage that was created while setting up an Amazon
	// S3 stage in the Snowflake account. This is written in the following format:
	// < Database>< Schema><Stage Name>.
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`

	// The name of the Snowflake warehouse.
	//
	// Warehouse is a required field
	Warehouse *string `locationName:"warehouse" type:"string" required:"true"`
}

// String returns the string representation
func (s SnowflakeConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnowflakeConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnowflakeConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnowflakeConnectorProfileProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.Stage == nil {
		invalidParams.Add(request.NewErrParamRequired("Stage"))
	}
	if s.Warehouse == nil {
		invalidParams.Add(request.NewErrParamRequired("Warehouse"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *SnowflakeConnectorProfileProperties) SetAccountName(v string) *SnowflakeConnectorProfileProperties {
	s.AccountName = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *SnowflakeConnectorProfileProperties) SetBucketName(v string) *SnowflakeConnectorProfileProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *SnowflakeConnectorProfileProperties) SetBucketPrefix(v string) *SnowflakeConnectorProfileProperties {
	s.BucketPrefix = &v
	return s
}

// SetPrivateLinkServiceName sets the PrivateLinkServiceName field's value.
func (s *SnowflakeConnectorProfileProperties) SetPrivateLinkServiceName(v string) *SnowflakeConnectorProfileProperties {
	s.PrivateLinkServiceName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SnowflakeConnectorProfileProperties) SetRegion(v string) *SnowflakeConnectorProfileProperties {
	s.Region = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *SnowflakeConnectorProfileProperties) SetStage(v string) *SnowflakeConnectorProfileProperties {
	s.Stage = &v
	return s
}

// SetWarehouse sets the Warehouse field's value.
func (s *SnowflakeConnectorProfileProperties) SetWarehouse(v string) *SnowflakeConnectorProfileProperties {
	s.Warehouse = &v
	return s
}

// The properties that are applied when Snowflake is being used as a destination.
type SnowflakeDestinationProperties struct {
	_ struct{} `type:"structure"`

	// The object key for the destination bucket in which Amazon AppFlow places
	// the files.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Snowflake destination. For example, this setting would determine
	// if the flow should fail after one insertion error, or continue and attempt
	// to insert every record regardless of the initial failure. ErrorHandlingConfig
	// is a part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig `locationName:"errorHandlingConfig" type:"structure"`

	// The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
	//
	// IntermediateBucketName is a required field
	IntermediateBucketName *string `locationName:"intermediateBucketName" min:"3" type:"string" required:"true"`

	// The object specified in the Snowflake flow destination.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s SnowflakeDestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnowflakeDestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnowflakeDestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnowflakeDestinationProperties"}
	if s.IntermediateBucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("IntermediateBucketName"))
	}
	if s.IntermediateBucketName != nil && len(*s.IntermediateBucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IntermediateBucketName", 3))
	}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.ErrorHandlingConfig != nil {
		if err := s.ErrorHandlingConfig.Validate(); err != nil {
			invalidParams.AddNested("ErrorHandlingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *SnowflakeDestinationProperties) SetBucketPrefix(v string) *SnowflakeDestinationProperties {
	s.BucketPrefix = &v
	return s
}

// SetErrorHandlingConfig sets the ErrorHandlingConfig field's value.
func (s *SnowflakeDestinationProperties) SetErrorHandlingConfig(v *ErrorHandlingConfig) *SnowflakeDestinationProperties {
	s.ErrorHandlingConfig = v
	return s
}

// SetIntermediateBucketName sets the IntermediateBucketName field's value.
func (s *SnowflakeDestinationProperties) SetIntermediateBucketName(v string) *SnowflakeDestinationProperties {
	s.IntermediateBucketName = &v
	return s
}

// SetObject sets the Object field's value.
func (s *SnowflakeDestinationProperties) SetObject(v string) *SnowflakeDestinationProperties {
	s.Object = &v
	return s
}

// The connector metadata specific to Snowflake.
type SnowflakeMetadata struct {
	_ struct{} `type:"structure"`

	// Specifies the supported AWS Regions when using Snowflake.
	SupportedRegions []*string `locationName:"supportedRegions" type:"list"`
}

// String returns the string representation
func (s SnowflakeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnowflakeMetadata) GoString() string {
	return s.String()
}

// SetSupportedRegions sets the SupportedRegions field's value.
func (s *SnowflakeMetadata) SetSupportedRegions(v []*string) *SnowflakeMetadata {
	s.SupportedRegions = v
	return s
}

// Specifies the information that is required to query a particular connector.
type SourceConnectorProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the information that is required for querying Amplitude.
	Amplitude *AmplitudeSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Datadog.
	Datadog *DatadogSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Dynatrace.
	Dynatrace *DynatraceSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Google Analytics.
	GoogleAnalytics *GoogleAnalyticsSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Infor Nexus.
	InforNexus *InforNexusSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Marketo.
	Marketo *MarketoSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Amazon S3.
	S3 *S3SourceProperties `type:"structure"`

	// Specifies the information that is required for querying Salesforce.
	Salesforce *SalesforceSourceProperties `type:"structure"`

	// Specifies the information that is required for querying ServiceNow.
	ServiceNow *ServiceNowSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Singular.
	Singular *SingularSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Slack.
	Slack *SlackSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Trend Micro.
	Trendmicro *TrendmicroSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Veeva.
	Veeva *VeevaSourceProperties `type:"structure"`

	// Specifies the information that is required for querying Zendesk.
	Zendesk *ZendeskSourceProperties `type:"structure"`
}

// String returns the string representation
func (s SourceConnectorProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceConnectorProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConnectorProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConnectorProperties"}
	if s.Amplitude != nil {
		if err := s.Amplitude.Validate(); err != nil {
			invalidParams.AddNested("Amplitude", err.(request.ErrInvalidParams))
		}
	}
	if s.Datadog != nil {
		if err := s.Datadog.Validate(); err != nil {
			invalidParams.AddNested("Datadog", err.(request.ErrInvalidParams))
		}
	}
	if s.Dynatrace != nil {
		if err := s.Dynatrace.Validate(); err != nil {
			invalidParams.AddNested("Dynatrace", err.(request.ErrInvalidParams))
		}
	}
	if s.GoogleAnalytics != nil {
		if err := s.GoogleAnalytics.Validate(); err != nil {
			invalidParams.AddNested("GoogleAnalytics", err.(request.ErrInvalidParams))
		}
	}
	if s.InforNexus != nil {
		if err := s.InforNexus.Validate(); err != nil {
			invalidParams.AddNested("InforNexus", err.(request.ErrInvalidParams))
		}
	}
	if s.Marketo != nil {
		if err := s.Marketo.Validate(); err != nil {
			invalidParams.AddNested("Marketo", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNow != nil {
		if err := s.ServiceNow.Validate(); err != nil {
			invalidParams.AddNested("ServiceNow", err.(request.ErrInvalidParams))
		}
	}
	if s.Singular != nil {
		if err := s.Singular.Validate(); err != nil {
			invalidParams.AddNested("Singular", err.(request.ErrInvalidParams))
		}
	}
	if s.Slack != nil {
		if err := s.Slack.Validate(); err != nil {
			invalidParams.AddNested("Slack", err.(request.ErrInvalidParams))
		}
	}
	if s.Trendmicro != nil {
		if err := s.Trendmicro.Validate(); err != nil {
			invalidParams.AddNested("Trendmicro", err.(request.ErrInvalidParams))
		}
	}
	if s.Veeva != nil {
		if err := s.Veeva.Validate(); err != nil {
			invalidParams.AddNested("Veeva", err.(request.ErrInvalidParams))
		}
	}
	if s.Zendesk != nil {
		if err := s.Zendesk.Validate(); err != nil {
			invalidParams.AddNested("Zendesk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmplitude sets the Amplitude field's value.
func (s *SourceConnectorProperties) SetAmplitude(v *AmplitudeSourceProperties) *SourceConnectorProperties {
	s.Amplitude = v
	return s
}

// SetDatadog sets the Datadog field's value.
func (s *SourceConnectorProperties) SetDatadog(v *DatadogSourceProperties) *SourceConnectorProperties {
	s.Datadog = v
	return s
}

// SetDynatrace sets the Dynatrace field's value.
func (s *SourceConnectorProperties) SetDynatrace(v *DynatraceSourceProperties) *SourceConnectorProperties {
	s.Dynatrace = v
	return s
}

// SetGoogleAnalytics sets the GoogleAnalytics field's value.
func (s *SourceConnectorProperties) SetGoogleAnalytics(v *GoogleAnalyticsSourceProperties) *SourceConnectorProperties {
	s.GoogleAnalytics = v
	return s
}

// SetInforNexus sets the InforNexus field's value.
func (s *SourceConnectorProperties) SetInforNexus(v *InforNexusSourceProperties) *SourceConnectorProperties {
	s.InforNexus = v
	return s
}

// SetMarketo sets the Marketo field's value.
func (s *SourceConnectorProperties) SetMarketo(v *MarketoSourceProperties) *SourceConnectorProperties {
	s.Marketo = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *SourceConnectorProperties) SetS3(v *S3SourceProperties) *SourceConnectorProperties {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *SourceConnectorProperties) SetSalesforce(v *SalesforceSourceProperties) *SourceConnectorProperties {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *SourceConnectorProperties) SetServiceNow(v *ServiceNowSourceProperties) *SourceConnectorProperties {
	s.ServiceNow = v
	return s
}

// SetSingular sets the Singular field's value.
func (s *SourceConnectorProperties) SetSingular(v *SingularSourceProperties) *SourceConnectorProperties {
	s.Singular = v
	return s
}

// SetSlack sets the Slack field's value.
func (s *SourceConnectorProperties) SetSlack(v *SlackSourceProperties) *SourceConnectorProperties {
	s.Slack = v
	return s
}

// SetTrendmicro sets the Trendmicro field's value.
func (s *SourceConnectorProperties) SetTrendmicro(v *TrendmicroSourceProperties) *SourceConnectorProperties {
	s.Trendmicro = v
	return s
}

// SetVeeva sets the Veeva field's value.
func (s *SourceConnectorProperties) SetVeeva(v *VeevaSourceProperties) *SourceConnectorProperties {
	s.Veeva = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *SourceConnectorProperties) SetZendesk(v *ZendeskSourceProperties) *SourceConnectorProperties {
	s.Zendesk = v
	return s
}

// The properties that can be applied to a field when the connector is being
// used as a source.
type SourceFieldProperties struct {
	_ struct{} `type:"structure"`

	// Indicates if the field can be queried.
	IsQueryable *bool `locationName:"isQueryable" type:"boolean"`

	// Indicates whether the field can be returned in a search result.
	IsRetrievable *bool `locationName:"isRetrievable" type:"boolean"`
}

// String returns the string representation
func (s SourceFieldProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceFieldProperties) GoString() string {
	return s.String()
}

// SetIsQueryable sets the IsQueryable field's value.
func (s *SourceFieldProperties) SetIsQueryable(v bool) *SourceFieldProperties {
	s.IsQueryable = &v
	return s
}

// SetIsRetrievable sets the IsRetrievable field's value.
func (s *SourceFieldProperties) SetIsRetrievable(v bool) *SourceFieldProperties {
	s.IsRetrievable = &v
	return s
}

// Contains information about the configuration of the source connector used
// in the flow.
type SourceFlowConfig struct {
	_ struct{} `type:"structure"`

	// The name of the connector profile. This name must be unique for each connector
	// profile in the AWS account.
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string"`

	// The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// ConnectorType is a required field
	ConnectorType *string `locationName:"connectorType" type:"string" required:"true" enum:"ConnectorType"`

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are
	// used when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig `locationName:"incrementalPullConfig" type:"structure"`

	// Specifies the information that is required to query a particular source connector.
	//
	// SourceConnectorProperties is a required field
	SourceConnectorProperties *SourceConnectorProperties `locationName:"sourceConnectorProperties" type:"structure" required:"true"`
}

// String returns the string representation
func (s SourceFlowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceFlowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceFlowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceFlowConfig"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.SourceConnectorProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConnectorProperties"))
	}
	if s.SourceConnectorProperties != nil {
		if err := s.SourceConnectorProperties.Validate(); err != nil {
			invalidParams.AddNested("SourceConnectorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *SourceFlowConfig) SetConnectorProfileName(v string) *SourceFlowConfig {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *SourceFlowConfig) SetConnectorType(v string) *SourceFlowConfig {
	s.ConnectorType = &v
	return s
}

// SetIncrementalPullConfig sets the IncrementalPullConfig field's value.
func (s *SourceFlowConfig) SetIncrementalPullConfig(v *IncrementalPullConfig) *SourceFlowConfig {
	s.IncrementalPullConfig = v
	return s
}

// SetSourceConnectorProperties sets the SourceConnectorProperties field's value.
func (s *SourceFlowConfig) SetSourceConnectorProperties(v *SourceConnectorProperties) *SourceFlowConfig {
	s.SourceConnectorProperties = v
	return s
}

type StartFlowInput struct {
	_ struct{} `type:"structure"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFlowInput"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *StartFlowInput) SetFlowName(v string) *StartFlowInput {
	s.FlowName = &v
	return s
}

type StartFlowOutput struct {
	_ struct{} `type:"structure"`

	// Returns the internal execution ID of an on-demand flow when the flow is started.
	// For scheduled or event-triggered flows, this value is null.
	ExecutionId *string `locationName:"executionId" type:"string"`

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string `locationName:"flowArn" type:"string"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`
}

// String returns the string representation
func (s StartFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartFlowOutput) SetExecutionId(v string) *StartFlowOutput {
	s.ExecutionId = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowOutput) SetFlowArn(v string) *StartFlowOutput {
	s.FlowArn = &v
	return s
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *StartFlowOutput) SetFlowStatus(v string) *StartFlowOutput {
	s.FlowStatus = &v
	return s
}

type StopFlowInput struct {
	_ struct{} `type:"structure"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFlowInput"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowName sets the FlowName field's value.
func (s *StopFlowInput) SetFlowName(v string) *StopFlowInput {
	s.FlowName = &v
	return s
}

type StopFlowOutput struct {
	_ struct{} `type:"structure"`

	// The flow's Amazon Resource Name (ARN).
	FlowArn *string `locationName:"flowArn" type:"string"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`
}

// String returns the string representation
func (s StopFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowOutput) SetFlowArn(v string) *StopFlowOutput {
	s.FlowArn = &v
	return s
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *StopFlowOutput) SetFlowStatus(v string) *StopFlowOutput {
	s.FlowStatus = &v
	return s
}

// Contains details regarding all the supported FieldTypes and their corresponding
// filterOperators and supportedValues.
type SupportedFieldTypeDetails struct {
	_ struct{} `type:"structure"`

	// The initial supported version for fieldType. If this is later changed to
	// a different version, v2 will be introduced.
	//
	// V1 is a required field
	V1 *FieldTypeDetails `locationName:"v1" type:"structure" required:"true"`
}

// String returns the string representation
func (s SupportedFieldTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedFieldTypeDetails) GoString() string {
	return s.String()
}

// SetV1 sets the V1 field's value.
func (s *SupportedFieldTypeDetails) SetV1(v *FieldTypeDetails) *SupportedFieldTypeDetails {
	s.V1 = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for your flow.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A class for modeling different type of tasks. Task implementation varies
// based on the TaskType.
type Task struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator `locationName:"connectorOperator" type:"structure"`

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string `locationName:"destinationField" type:"string"`

	// The source fields to which a particular task is applied.
	//
	// SourceFields is a required field
	SourceFields []*string `locationName:"sourceFields" type:"list" required:"true"`

	// A map used to store task-related information. The execution service looks
	// for particular information based on the TaskType.
	TaskProperties map[string]*string `locationName:"taskProperties" type:"map"`

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// TaskType is a required field
	TaskType *string `locationName:"taskType" type:"string" required:"true" enum:"TaskType"`
}

// String returns the string representation
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Task) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Task) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Task"}
	if s.SourceFields == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFields"))
	}
	if s.TaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorOperator sets the ConnectorOperator field's value.
func (s *Task) SetConnectorOperator(v *ConnectorOperator) *Task {
	s.ConnectorOperator = v
	return s
}

// SetDestinationField sets the DestinationField field's value.
func (s *Task) SetDestinationField(v string) *Task {
	s.DestinationField = &v
	return s
}

// SetSourceFields sets the SourceFields field's value.
func (s *Task) SetSourceFields(v []*string) *Task {
	s.SourceFields = v
	return s
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *Task) SetTaskProperties(v map[string]*string) *Task {
	s.TaskProperties = v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *Task) SetTaskType(v string) *Task {
	s.TaskType = &v
	return s
}

// The connector-specific profile credentials required when using Trend Micro.
type TrendmicroConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The Secret Access Key portion of the credentials.
	//
	// ApiSecretKey is a required field
	ApiSecretKey *string `locationName:"apiSecretKey" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s TrendmicroConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrendmicroConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrendmicroConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrendmicroConnectorProfileCredentials"}
	if s.ApiSecretKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiSecretKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiSecretKey sets the ApiSecretKey field's value.
func (s *TrendmicroConnectorProfileCredentials) SetApiSecretKey(v string) *TrendmicroConnectorProfileCredentials {
	s.ApiSecretKey = &v
	return s
}

// The connector-specific profile properties required when using Trend Micro.
type TrendmicroConnectorProfileProperties struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TrendmicroConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrendmicroConnectorProfileProperties) GoString() string {
	return s.String()
}

// The connector metadata specific to Trend Micro.
type TrendmicroMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TrendmicroMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrendmicroMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when using Trend Micro as a flow source.
type TrendmicroSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Trend Micro flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s TrendmicroSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrendmicroSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrendmicroSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrendmicroSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *TrendmicroSourceProperties) SetObject(v string) *TrendmicroSourceProperties {
	s.Object = &v
	return s
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow as defined
	// by the user. Currently, these settings only apply to the Scheduled trigger
	// type.
	TriggerProperties *TriggerProperties `locationName:"triggerProperties" type:"structure"`

	// Specifies the type of flow trigger. This can be OnDemand, Scheduled, or Event.
	//
	// TriggerType is a required field
	TriggerType *string `locationName:"triggerType" type:"string" required:"true" enum:"TriggerType"`
}

// String returns the string representation
func (s TriggerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerConfig"}
	if s.TriggerType == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerType"))
	}
	if s.TriggerProperties != nil {
		if err := s.TriggerProperties.Validate(); err != nil {
			invalidParams.AddNested("TriggerProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTriggerProperties sets the TriggerProperties field's value.
func (s *TriggerConfig) SetTriggerProperties(v *TriggerProperties) *TriggerConfig {
	s.TriggerProperties = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *TriggerConfig) SetTriggerType(v string) *TriggerConfig {
	s.TriggerType = &v
	return s
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow as defined
	// by the user.
	Scheduled *ScheduledTriggerProperties `type:"structure"`
}

// String returns the string representation
func (s TriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerProperties"}
	if s.Scheduled != nil {
		if err := s.Scheduled.Validate(); err != nil {
			invalidParams.AddNested("Scheduled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduled sets the Scheduled field's value.
func (s *TriggerProperties) SetScheduled(v *ScheduledTriggerProperties) *TriggerProperties {
	s.Scheduled = v
	return s
}

// The requested operation is not supported for the current flow.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys associated with the tag that you want to remove from your flow.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateConnectorProfileInput struct {
	_ struct{} `type:"structure"`

	// Indicates the connection mode and if it is public or private.
	//
	// ConnectionMode is a required field
	ConnectionMode *string `locationName:"connectionMode" type:"string" required:"true" enum:"ConnectionMode"`

	// Defines the connector-specific profile configuration and credentials.
	//
	// ConnectorProfileConfig is a required field
	ConnectorProfileConfig *ConnectorProfileConfig `locationName:"connectorProfileConfig" type:"structure" required:"true"`

	// The name of the connector profile and is unique for each ConnectorProfile
	// in the AWS Account.
	//
	// ConnectorProfileName is a required field
	ConnectorProfileName *string `locationName:"connectorProfileName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConnectorProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectorProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectorProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectorProfileInput"}
	if s.ConnectionMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionMode"))
	}
	if s.ConnectorProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileConfig"))
	}
	if s.ConnectorProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorProfileName"))
	}
	if s.ConnectorProfileConfig != nil {
		if err := s.ConnectorProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("ConnectorProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *UpdateConnectorProfileInput) SetConnectionMode(v string) *UpdateConnectorProfileInput {
	s.ConnectionMode = &v
	return s
}

// SetConnectorProfileConfig sets the ConnectorProfileConfig field's value.
func (s *UpdateConnectorProfileInput) SetConnectorProfileConfig(v *ConnectorProfileConfig) *UpdateConnectorProfileInput {
	s.ConnectorProfileConfig = v
	return s
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *UpdateConnectorProfileInput) SetConnectorProfileName(v string) *UpdateConnectorProfileInput {
	s.ConnectorProfileName = &v
	return s
}

type UpdateConnectorProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector profile.
	ConnectorProfileArn *string `locationName:"connectorProfileArn" type:"string"`
}

// String returns the string representation
func (s UpdateConnectorProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectorProfileOutput) GoString() string {
	return s.String()
}

// SetConnectorProfileArn sets the ConnectorProfileArn field's value.
func (s *UpdateConnectorProfileOutput) SetConnectorProfileArn(v string) *UpdateConnectorProfileOutput {
	s.ConnectorProfileArn = &v
	return s
}

type UpdateFlowInput struct {
	_ struct{} `type:"structure"`

	// A description of the flow.
	Description *string `locationName:"description" type:"string"`

	// The configuration that controls how Amazon AppFlow transfers data to the
	// destination connector.
	//
	// DestinationFlowConfigList is a required field
	DestinationFlowConfigList []*DestinationFlowConfig `locationName:"destinationFlowConfigList" type:"list" required:"true"`

	// The specified name of the flow. Spaces are not allowed. Use underscores (_)
	// or hyphens (-) only.
	//
	// FlowName is a required field
	FlowName *string `locationName:"flowName" type:"string" required:"true"`

	// Contains information about the configuration of the source connector used
	// in the flow.
	SourceFlowConfig *SourceFlowConfig `locationName:"sourceFlowConfig" type:"structure"`

	// A list of tasks that Amazon AppFlow performs while transferring the data
	// in the flow run.
	//
	// Tasks is a required field
	Tasks []*Task `locationName:"tasks" type:"list" required:"true"`

	// The trigger settings that determine how and when the flow runs.
	//
	// TriggerConfig is a required field
	TriggerConfig *TriggerConfig `locationName:"triggerConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowInput"}
	if s.DestinationFlowConfigList == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationFlowConfigList"))
	}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.Tasks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tasks"))
	}
	if s.TriggerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerConfig"))
	}
	if s.DestinationFlowConfigList != nil {
		for i, v := range s.DestinationFlowConfigList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DestinationFlowConfigList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceFlowConfig != nil {
		if err := s.SourceFlowConfig.Validate(); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tasks != nil {
		for i, v := range s.Tasks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tasks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerConfig != nil {
		if err := s.TriggerConfig.Validate(); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowInput) SetDescription(v string) *UpdateFlowInput {
	s.Description = &v
	return s
}

// SetDestinationFlowConfigList sets the DestinationFlowConfigList field's value.
func (s *UpdateFlowInput) SetDestinationFlowConfigList(v []*DestinationFlowConfig) *UpdateFlowInput {
	s.DestinationFlowConfigList = v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *UpdateFlowInput) SetFlowName(v string) *UpdateFlowInput {
	s.FlowName = &v
	return s
}

// SetSourceFlowConfig sets the SourceFlowConfig field's value.
func (s *UpdateFlowInput) SetSourceFlowConfig(v *SourceFlowConfig) *UpdateFlowInput {
	s.SourceFlowConfig = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *UpdateFlowInput) SetTasks(v []*Task) *UpdateFlowInput {
	s.Tasks = v
	return s
}

// SetTriggerConfig sets the TriggerConfig field's value.
func (s *UpdateFlowInput) SetTriggerConfig(v *TriggerConfig) *UpdateFlowInput {
	s.TriggerConfig = v
	return s
}

type UpdateFlowOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the current status of the flow.
	FlowStatus *string `locationName:"flowStatus" type:"string" enum:"FlowStatus"`
}

// String returns the string representation
func (s UpdateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutput) GoString() string {
	return s.String()
}

// SetFlowStatus sets the FlowStatus field's value.
func (s *UpdateFlowOutput) SetFlowStatus(v string) *UpdateFlowOutput {
	s.FlowStatus = &v
	return s
}

// The properties that are applied when Upsolver is used as a destination.
type UpsolverDestinationProperties struct {
	_ struct{} `type:"structure"`

	// The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred
	// data.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"16" type:"string" required:"true"`

	// The object key for the destination Upsolver Amazon S3 bucket in which Amazon
	// AppFlow places the files.
	BucketPrefix *string `locationName:"bucketPrefix" type:"string"`

	// The configuration that determines how data is formatted when Upsolver is
	// used as the flow destination.
	//
	// S3OutputFormatConfig is a required field
	S3OutputFormatConfig *UpsolverS3OutputFormatConfig `locationName:"s3OutputFormatConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpsolverDestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpsolverDestinationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpsolverDestinationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpsolverDestinationProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 16))
	}
	if s.S3OutputFormatConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputFormatConfig"))
	}
	if s.S3OutputFormatConfig != nil {
		if err := s.S3OutputFormatConfig.Validate(); err != nil {
			invalidParams.AddNested("S3OutputFormatConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *UpsolverDestinationProperties) SetBucketName(v string) *UpsolverDestinationProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *UpsolverDestinationProperties) SetBucketPrefix(v string) *UpsolverDestinationProperties {
	s.BucketPrefix = &v
	return s
}

// SetS3OutputFormatConfig sets the S3OutputFormatConfig field's value.
func (s *UpsolverDestinationProperties) SetS3OutputFormatConfig(v *UpsolverS3OutputFormatConfig) *UpsolverDestinationProperties {
	s.S3OutputFormatConfig = v
	return s
}

// The connector metadata specific to Upsolver.
type UpsolverMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpsolverMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpsolverMetadata) GoString() string {
	return s.String()
}

// The configuration that determines how Amazon AppFlow formats the flow output
// data when Upsolver is used as the destination.
type UpsolverS3OutputFormatConfig struct {
	_ struct{} `type:"structure"`

	// The aggregation settings that you can use to customize the output format
	// of your flow data.
	AggregationConfig *AggregationConfig `locationName:"aggregationConfig" type:"structure"`

	// Indicates the file type that Amazon AppFlow places in the Upsolver Amazon
	// S3 bucket.
	FileType *string `locationName:"fileType" type:"string" enum:"FileType"`

	// Determines the prefix that Amazon AppFlow applies to the destination folder
	// name. You can name your destination folders according to the flow frequency
	// and date.
	//
	// PrefixConfig is a required field
	PrefixConfig *PrefixConfig `locationName:"prefixConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpsolverS3OutputFormatConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpsolverS3OutputFormatConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpsolverS3OutputFormatConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpsolverS3OutputFormatConfig"}
	if s.PrefixConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PrefixConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationConfig sets the AggregationConfig field's value.
func (s *UpsolverS3OutputFormatConfig) SetAggregationConfig(v *AggregationConfig) *UpsolverS3OutputFormatConfig {
	s.AggregationConfig = v
	return s
}

// SetFileType sets the FileType field's value.
func (s *UpsolverS3OutputFormatConfig) SetFileType(v string) *UpsolverS3OutputFormatConfig {
	s.FileType = &v
	return s
}

// SetPrefixConfig sets the PrefixConfig field's value.
func (s *UpsolverS3OutputFormatConfig) SetPrefixConfig(v *PrefixConfig) *UpsolverS3OutputFormatConfig {
	s.PrefixConfig = v
	return s
}

// The request has invalid or missing parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connector-specific profile credentials required when using Veeva.
type VeevaConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The password that corresponds to the user name.
	//
	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true" sensitive:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s VeevaConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VeevaConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VeevaConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VeevaConnectorProfileCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *VeevaConnectorProfileCredentials) SetPassword(v string) *VeevaConnectorProfileCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *VeevaConnectorProfileCredentials) SetUsername(v string) *VeevaConnectorProfileCredentials {
	s.Username = &v
	return s
}

// The connector-specific profile properties required when using Veeva.
type VeevaConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Veeva resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s VeevaConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VeevaConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VeevaConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VeevaConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *VeevaConnectorProfileProperties) SetInstanceUrl(v string) *VeevaConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Veeva.
type VeevaMetadata struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VeevaMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VeevaMetadata) GoString() string {
	return s.String()
}

// The properties that are applied when using Veeva as a flow source.
type VeevaSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Veeva flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s VeevaSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VeevaSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VeevaSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VeevaSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *VeevaSourceProperties) SetObject(v string) *VeevaSourceProperties {
	s.Object = &v
	return s
}

// The connector-specific profile credentials required when using Zendesk.
type ZendeskConnectorProfileCredentials struct {
	_ struct{} `type:"structure"`

	// The credentials used to access protected Zendesk resources.
	AccessToken *string `locationName:"accessToken" type:"string" sensitive:"true"`

	// The identifier for the desired client.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	//
	// ClientSecret is a required field
	ClientSecret *string `locationName:"clientSecret" type:"string" required:"true" sensitive:"true"`

	// The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest `locationName:"oAuthRequest" type:"structure"`
}

// String returns the string representation
func (s ZendeskConnectorProfileCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZendeskConnectorProfileCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZendeskConnectorProfileCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZendeskConnectorProfileCredentials"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ZendeskConnectorProfileCredentials) SetAccessToken(v string) *ZendeskConnectorProfileCredentials {
	s.AccessToken = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ZendeskConnectorProfileCredentials) SetClientId(v string) *ZendeskConnectorProfileCredentials {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *ZendeskConnectorProfileCredentials) SetClientSecret(v string) *ZendeskConnectorProfileCredentials {
	s.ClientSecret = &v
	return s
}

// SetOAuthRequest sets the OAuthRequest field's value.
func (s *ZendeskConnectorProfileCredentials) SetOAuthRequest(v *ConnectorOAuthRequest) *ZendeskConnectorProfileCredentials {
	s.OAuthRequest = v
	return s
}

// The connector-specific profile properties required when using Zendesk.
type ZendeskConnectorProfileProperties struct {
	_ struct{} `type:"structure"`

	// The location of the Zendesk resource.
	//
	// InstanceUrl is a required field
	InstanceUrl *string `locationName:"instanceUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s ZendeskConnectorProfileProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZendeskConnectorProfileProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZendeskConnectorProfileProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZendeskConnectorProfileProperties"}
	if s.InstanceUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceUrl sets the InstanceUrl field's value.
func (s *ZendeskConnectorProfileProperties) SetInstanceUrl(v string) *ZendeskConnectorProfileProperties {
	s.InstanceUrl = &v
	return s
}

// The connector metadata specific to Zendesk.
type ZendeskMetadata struct {
	_ struct{} `type:"structure"`

	// The desired authorization scope for the Zendesk account.
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list"`
}

// String returns the string representation
func (s ZendeskMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZendeskMetadata) GoString() string {
	return s.String()
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *ZendeskMetadata) SetOAuthScopes(v []*string) *ZendeskMetadata {
	s.OAuthScopes = v
	return s
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Zendesk flow source.
	//
	// Object is a required field
	Object *string `locationName:"object" type:"string" required:"true"`
}

// String returns the string representation
func (s ZendeskSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZendeskSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZendeskSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZendeskSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ZendeskSourceProperties) SetObject(v string) *ZendeskSourceProperties {
	s.Object = &v
	return s
}

const (
	// AggregationTypeNone is a AggregationType enum value
	AggregationTypeNone = "None"

	// AggregationTypeSingleFile is a AggregationType enum value
	AggregationTypeSingleFile = "SingleFile"
)

// AggregationType_Values returns all elements of the AggregationType enum
func AggregationType_Values() []string {
	return []string{
		AggregationTypeNone,
		AggregationTypeSingleFile,
	}
}

const (
	// AmplitudeConnectorOperatorBetween is a AmplitudeConnectorOperator enum value
	AmplitudeConnectorOperatorBetween = "BETWEEN"
)

// AmplitudeConnectorOperator_Values returns all elements of the AmplitudeConnectorOperator enum
func AmplitudeConnectorOperator_Values() []string {
	return []string{
		AmplitudeConnectorOperatorBetween,
	}
}

const (
	// ConnectionModePublic is a ConnectionMode enum value
	ConnectionModePublic = "Public"

	// ConnectionModePrivate is a ConnectionMode enum value
	ConnectionModePrivate = "Private"
)

// ConnectionMode_Values returns all elements of the ConnectionMode enum
func ConnectionMode_Values() []string {
	return []string{
		ConnectionModePublic,
		ConnectionModePrivate,
	}
}

const (
	// ConnectorTypeSalesforce is a ConnectorType enum value
	ConnectorTypeSalesforce = "Salesforce"

	// ConnectorTypeSingular is a ConnectorType enum value
	ConnectorTypeSingular = "Singular"

	// ConnectorTypeSlack is a ConnectorType enum value
	ConnectorTypeSlack = "Slack"

	// ConnectorTypeRedshift is a ConnectorType enum value
	ConnectorTypeRedshift = "Redshift"

	// ConnectorTypeS3 is a ConnectorType enum value
	ConnectorTypeS3 = "S3"

	// ConnectorTypeMarketo is a ConnectorType enum value
	ConnectorTypeMarketo = "Marketo"

	// ConnectorTypeGoogleanalytics is a ConnectorType enum value
	ConnectorTypeGoogleanalytics = "Googleanalytics"

	// ConnectorTypeZendesk is a ConnectorType enum value
	ConnectorTypeZendesk = "Zendesk"

	// ConnectorTypeServicenow is a ConnectorType enum value
	ConnectorTypeServicenow = "Servicenow"

	// ConnectorTypeDatadog is a ConnectorType enum value
	ConnectorTypeDatadog = "Datadog"

	// ConnectorTypeTrendmicro is a ConnectorType enum value
	ConnectorTypeTrendmicro = "Trendmicro"

	// ConnectorTypeSnowflake is a ConnectorType enum value
	ConnectorTypeSnowflake = "Snowflake"

	// ConnectorTypeDynatrace is a ConnectorType enum value
	ConnectorTypeDynatrace = "Dynatrace"

	// ConnectorTypeInfornexus is a ConnectorType enum value
	ConnectorTypeInfornexus = "Infornexus"

	// ConnectorTypeAmplitude is a ConnectorType enum value
	ConnectorTypeAmplitude = "Amplitude"

	// ConnectorTypeVeeva is a ConnectorType enum value
	ConnectorTypeVeeva = "Veeva"

	// ConnectorTypeEventBridge is a ConnectorType enum value
	ConnectorTypeEventBridge = "EventBridge"

	// ConnectorTypeUpsolver is a ConnectorType enum value
	ConnectorTypeUpsolver = "Upsolver"
)

// ConnectorType_Values returns all elements of the ConnectorType enum
func ConnectorType_Values() []string {
	return []string{
		ConnectorTypeSalesforce,
		ConnectorTypeSingular,
		ConnectorTypeSlack,
		ConnectorTypeRedshift,
		ConnectorTypeS3,
		ConnectorTypeMarketo,
		ConnectorTypeGoogleanalytics,
		ConnectorTypeZendesk,
		ConnectorTypeServicenow,
		ConnectorTypeDatadog,
		ConnectorTypeTrendmicro,
		ConnectorTypeSnowflake,
		ConnectorTypeDynatrace,
		ConnectorTypeInfornexus,
		ConnectorTypeAmplitude,
		ConnectorTypeVeeva,
		ConnectorTypeEventBridge,
		ConnectorTypeUpsolver,
	}
}

const (
	// DataPullModeIncremental is a DataPullMode enum value
	DataPullModeIncremental = "Incremental"

	// DataPullModeComplete is a DataPullMode enum value
	DataPullModeComplete = "Complete"
)

// DataPullMode_Values returns all elements of the DataPullMode enum
func DataPullMode_Values() []string {
	return []string{
		DataPullModeIncremental,
		DataPullModeComplete,
	}
}

const (
	// DatadogConnectorOperatorProjection is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorProjection = "PROJECTION"

	// DatadogConnectorOperatorBetween is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorBetween = "BETWEEN"

	// DatadogConnectorOperatorEqualTo is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorEqualTo = "EQUAL_TO"

	// DatadogConnectorOperatorAddition is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorAddition = "ADDITION"

	// DatadogConnectorOperatorMultiplication is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorMultiplication = "MULTIPLICATION"

	// DatadogConnectorOperatorDivision is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorDivision = "DIVISION"

	// DatadogConnectorOperatorSubtraction is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorSubtraction = "SUBTRACTION"

	// DatadogConnectorOperatorMaskAll is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorMaskAll = "MASK_ALL"

	// DatadogConnectorOperatorMaskFirstN is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// DatadogConnectorOperatorMaskLastN is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorMaskLastN = "MASK_LAST_N"

	// DatadogConnectorOperatorValidateNonNull is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// DatadogConnectorOperatorValidateNonZero is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// DatadogConnectorOperatorValidateNonNegative is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// DatadogConnectorOperatorValidateNumeric is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// DatadogConnectorOperatorNoOp is a DatadogConnectorOperator enum value
	DatadogConnectorOperatorNoOp = "NO_OP"
)

// DatadogConnectorOperator_Values returns all elements of the DatadogConnectorOperator enum
func DatadogConnectorOperator_Values() []string {
	return []string{
		DatadogConnectorOperatorProjection,
		DatadogConnectorOperatorBetween,
		DatadogConnectorOperatorEqualTo,
		DatadogConnectorOperatorAddition,
		DatadogConnectorOperatorMultiplication,
		DatadogConnectorOperatorDivision,
		DatadogConnectorOperatorSubtraction,
		DatadogConnectorOperatorMaskAll,
		DatadogConnectorOperatorMaskFirstN,
		DatadogConnectorOperatorMaskLastN,
		DatadogConnectorOperatorValidateNonNull,
		DatadogConnectorOperatorValidateNonZero,
		DatadogConnectorOperatorValidateNonNegative,
		DatadogConnectorOperatorValidateNumeric,
		DatadogConnectorOperatorNoOp,
	}
}

const (
	// DynatraceConnectorOperatorProjection is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorProjection = "PROJECTION"

	// DynatraceConnectorOperatorBetween is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorBetween = "BETWEEN"

	// DynatraceConnectorOperatorEqualTo is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorEqualTo = "EQUAL_TO"

	// DynatraceConnectorOperatorAddition is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorAddition = "ADDITION"

	// DynatraceConnectorOperatorMultiplication is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorMultiplication = "MULTIPLICATION"

	// DynatraceConnectorOperatorDivision is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorDivision = "DIVISION"

	// DynatraceConnectorOperatorSubtraction is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorSubtraction = "SUBTRACTION"

	// DynatraceConnectorOperatorMaskAll is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorMaskAll = "MASK_ALL"

	// DynatraceConnectorOperatorMaskFirstN is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// DynatraceConnectorOperatorMaskLastN is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorMaskLastN = "MASK_LAST_N"

	// DynatraceConnectorOperatorValidateNonNull is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// DynatraceConnectorOperatorValidateNonZero is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// DynatraceConnectorOperatorValidateNonNegative is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// DynatraceConnectorOperatorValidateNumeric is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// DynatraceConnectorOperatorNoOp is a DynatraceConnectorOperator enum value
	DynatraceConnectorOperatorNoOp = "NO_OP"
)

// DynatraceConnectorOperator_Values returns all elements of the DynatraceConnectorOperator enum
func DynatraceConnectorOperator_Values() []string {
	return []string{
		DynatraceConnectorOperatorProjection,
		DynatraceConnectorOperatorBetween,
		DynatraceConnectorOperatorEqualTo,
		DynatraceConnectorOperatorAddition,
		DynatraceConnectorOperatorMultiplication,
		DynatraceConnectorOperatorDivision,
		DynatraceConnectorOperatorSubtraction,
		DynatraceConnectorOperatorMaskAll,
		DynatraceConnectorOperatorMaskFirstN,
		DynatraceConnectorOperatorMaskLastN,
		DynatraceConnectorOperatorValidateNonNull,
		DynatraceConnectorOperatorValidateNonZero,
		DynatraceConnectorOperatorValidateNonNegative,
		DynatraceConnectorOperatorValidateNumeric,
		DynatraceConnectorOperatorNoOp,
	}
}

const (
	// ExecutionStatusInProgress is a ExecutionStatus enum value
	ExecutionStatusInProgress = "InProgress"

	// ExecutionStatusSuccessful is a ExecutionStatus enum value
	ExecutionStatusSuccessful = "Successful"

	// ExecutionStatusError is a ExecutionStatus enum value
	ExecutionStatusError = "Error"
)

// ExecutionStatus_Values returns all elements of the ExecutionStatus enum
func ExecutionStatus_Values() []string {
	return []string{
		ExecutionStatusInProgress,
		ExecutionStatusSuccessful,
		ExecutionStatusError,
	}
}

const (
	// FileTypeCsv is a FileType enum value
	FileTypeCsv = "CSV"

	// FileTypeJson is a FileType enum value
	FileTypeJson = "JSON"

	// FileTypeParquet is a FileType enum value
	FileTypeParquet = "PARQUET"
)

// FileType_Values returns all elements of the FileType enum
func FileType_Values() []string {
	return []string{
		FileTypeCsv,
		FileTypeJson,
		FileTypeParquet,
	}
}

const (
	// FlowStatusActive is a FlowStatus enum value
	FlowStatusActive = "Active"

	// FlowStatusDeprecated is a FlowStatus enum value
	FlowStatusDeprecated = "Deprecated"

	// FlowStatusDeleted is a FlowStatus enum value
	FlowStatusDeleted = "Deleted"

	// FlowStatusDraft is a FlowStatus enum value
	FlowStatusDraft = "Draft"

	// FlowStatusErrored is a FlowStatus enum value
	FlowStatusErrored = "Errored"

	// FlowStatusSuspended is a FlowStatus enum value
	FlowStatusSuspended = "Suspended"
)

// FlowStatus_Values returns all elements of the FlowStatus enum
func FlowStatus_Values() []string {
	return []string{
		FlowStatusActive,
		FlowStatusDeprecated,
		FlowStatusDeleted,
		FlowStatusDraft,
		FlowStatusErrored,
		FlowStatusSuspended,
	}
}

const (
	// GoogleAnalyticsConnectorOperatorProjection is a GoogleAnalyticsConnectorOperator enum value
	GoogleAnalyticsConnectorOperatorProjection = "PROJECTION"

	// GoogleAnalyticsConnectorOperatorBetween is a GoogleAnalyticsConnectorOperator enum value
	GoogleAnalyticsConnectorOperatorBetween = "BETWEEN"
)

// GoogleAnalyticsConnectorOperator_Values returns all elements of the GoogleAnalyticsConnectorOperator enum
func GoogleAnalyticsConnectorOperator_Values() []string {
	return []string{
		GoogleAnalyticsConnectorOperatorProjection,
		GoogleAnalyticsConnectorOperatorBetween,
	}
}

const (
	// InforNexusConnectorOperatorProjection is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorProjection = "PROJECTION"

	// InforNexusConnectorOperatorBetween is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorBetween = "BETWEEN"

	// InforNexusConnectorOperatorEqualTo is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorEqualTo = "EQUAL_TO"

	// InforNexusConnectorOperatorAddition is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorAddition = "ADDITION"

	// InforNexusConnectorOperatorMultiplication is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorMultiplication = "MULTIPLICATION"

	// InforNexusConnectorOperatorDivision is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorDivision = "DIVISION"

	// InforNexusConnectorOperatorSubtraction is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorSubtraction = "SUBTRACTION"

	// InforNexusConnectorOperatorMaskAll is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorMaskAll = "MASK_ALL"

	// InforNexusConnectorOperatorMaskFirstN is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// InforNexusConnectorOperatorMaskLastN is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorMaskLastN = "MASK_LAST_N"

	// InforNexusConnectorOperatorValidateNonNull is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// InforNexusConnectorOperatorValidateNonZero is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// InforNexusConnectorOperatorValidateNonNegative is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// InforNexusConnectorOperatorValidateNumeric is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// InforNexusConnectorOperatorNoOp is a InforNexusConnectorOperator enum value
	InforNexusConnectorOperatorNoOp = "NO_OP"
)

// InforNexusConnectorOperator_Values returns all elements of the InforNexusConnectorOperator enum
func InforNexusConnectorOperator_Values() []string {
	return []string{
		InforNexusConnectorOperatorProjection,
		InforNexusConnectorOperatorBetween,
		InforNexusConnectorOperatorEqualTo,
		InforNexusConnectorOperatorAddition,
		InforNexusConnectorOperatorMultiplication,
		InforNexusConnectorOperatorDivision,
		InforNexusConnectorOperatorSubtraction,
		InforNexusConnectorOperatorMaskAll,
		InforNexusConnectorOperatorMaskFirstN,
		InforNexusConnectorOperatorMaskLastN,
		InforNexusConnectorOperatorValidateNonNull,
		InforNexusConnectorOperatorValidateNonZero,
		InforNexusConnectorOperatorValidateNonNegative,
		InforNexusConnectorOperatorValidateNumeric,
		InforNexusConnectorOperatorNoOp,
	}
}

const (
	// MarketoConnectorOperatorProjection is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorProjection = "PROJECTION"

	// MarketoConnectorOperatorLessThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorLessThan = "LESS_THAN"

	// MarketoConnectorOperatorGreaterThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorGreaterThan = "GREATER_THAN"

	// MarketoConnectorOperatorBetween is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorBetween = "BETWEEN"

	// MarketoConnectorOperatorAddition is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorAddition = "ADDITION"

	// MarketoConnectorOperatorMultiplication is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMultiplication = "MULTIPLICATION"

	// MarketoConnectorOperatorDivision is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorDivision = "DIVISION"

	// MarketoConnectorOperatorSubtraction is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorSubtraction = "SUBTRACTION"

	// MarketoConnectorOperatorMaskAll is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskAll = "MASK_ALL"

	// MarketoConnectorOperatorMaskFirstN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// MarketoConnectorOperatorMaskLastN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskLastN = "MASK_LAST_N"

	// MarketoConnectorOperatorValidateNonNull is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// MarketoConnectorOperatorValidateNonZero is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// MarketoConnectorOperatorValidateNonNegative is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// MarketoConnectorOperatorValidateNumeric is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// MarketoConnectorOperatorNoOp is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorNoOp = "NO_OP"
)

// MarketoConnectorOperator_Values returns all elements of the MarketoConnectorOperator enum
func MarketoConnectorOperator_Values() []string {
	return []string{
		MarketoConnectorOperatorProjection,
		MarketoConnectorOperatorLessThan,
		MarketoConnectorOperatorGreaterThan,
		MarketoConnectorOperatorBetween,
		MarketoConnectorOperatorAddition,
		MarketoConnectorOperatorMultiplication,
		MarketoConnectorOperatorDivision,
		MarketoConnectorOperatorSubtraction,
		MarketoConnectorOperatorMaskAll,
		MarketoConnectorOperatorMaskFirstN,
		MarketoConnectorOperatorMaskLastN,
		MarketoConnectorOperatorValidateNonNull,
		MarketoConnectorOperatorValidateNonZero,
		MarketoConnectorOperatorValidateNonNegative,
		MarketoConnectorOperatorValidateNumeric,
		MarketoConnectorOperatorNoOp,
	}
}

const (
	// OperatorProjection is a Operator enum value
	OperatorProjection = "PROJECTION"

	// OperatorLessThan is a Operator enum value
	OperatorLessThan = "LESS_THAN"

	// OperatorGreaterThan is a Operator enum value
	OperatorGreaterThan = "GREATER_THAN"

	// OperatorContains is a Operator enum value
	OperatorContains = "CONTAINS"

	// OperatorBetween is a Operator enum value
	OperatorBetween = "BETWEEN"

	// OperatorLessThanOrEqualTo is a Operator enum value
	OperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// OperatorGreaterThanOrEqualTo is a Operator enum value
	OperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// OperatorEqualTo is a Operator enum value
	OperatorEqualTo = "EQUAL_TO"

	// OperatorNotEqualTo is a Operator enum value
	OperatorNotEqualTo = "NOT_EQUAL_TO"

	// OperatorAddition is a Operator enum value
	OperatorAddition = "ADDITION"

	// OperatorMultiplication is a Operator enum value
	OperatorMultiplication = "MULTIPLICATION"

	// OperatorDivision is a Operator enum value
	OperatorDivision = "DIVISION"

	// OperatorSubtraction is a Operator enum value
	OperatorSubtraction = "SUBTRACTION"

	// OperatorMaskAll is a Operator enum value
	OperatorMaskAll = "MASK_ALL"

	// OperatorMaskFirstN is a Operator enum value
	OperatorMaskFirstN = "MASK_FIRST_N"

	// OperatorMaskLastN is a Operator enum value
	OperatorMaskLastN = "MASK_LAST_N"

	// OperatorValidateNonNull is a Operator enum value
	OperatorValidateNonNull = "VALIDATE_NON_NULL"

	// OperatorValidateNonZero is a Operator enum value
	OperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// OperatorValidateNonNegative is a Operator enum value
	OperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// OperatorValidateNumeric is a Operator enum value
	OperatorValidateNumeric = "VALIDATE_NUMERIC"

	// OperatorNoOp is a Operator enum value
	OperatorNoOp = "NO_OP"
)

// Operator_Values returns all elements of the Operator enum
func Operator_Values() []string {
	return []string{
		OperatorProjection,
		OperatorLessThan,
		OperatorGreaterThan,
		OperatorContains,
		OperatorBetween,
		OperatorLessThanOrEqualTo,
		OperatorGreaterThanOrEqualTo,
		OperatorEqualTo,
		OperatorNotEqualTo,
		OperatorAddition,
		OperatorMultiplication,
		OperatorDivision,
		OperatorSubtraction,
		OperatorMaskAll,
		OperatorMaskFirstN,
		OperatorMaskLastN,
		OperatorValidateNonNull,
		OperatorValidateNonZero,
		OperatorValidateNonNegative,
		OperatorValidateNumeric,
		OperatorNoOp,
	}
}

const (
	// OperatorPropertiesKeysValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValue = "VALUE"

	// OperatorPropertiesKeysValues is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValues = "VALUES"

	// OperatorPropertiesKeysDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDataType = "DATA_TYPE"

	// OperatorPropertiesKeysUpperBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysUpperBound = "UPPER_BOUND"

	// OperatorPropertiesKeysLowerBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysLowerBound = "LOWER_BOUND"

	// OperatorPropertiesKeysSourceDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSourceDataType = "SOURCE_DATA_TYPE"

	// OperatorPropertiesKeysDestinationDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDestinationDataType = "DESTINATION_DATA_TYPE"

	// OperatorPropertiesKeysValidationAction is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValidationAction = "VALIDATION_ACTION"

	// OperatorPropertiesKeysMaskValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskValue = "MASK_VALUE"

	// OperatorPropertiesKeysMaskLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskLength = "MASK_LENGTH"

	// OperatorPropertiesKeysTruncateLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysTruncateLength = "TRUNCATE_LENGTH"

	// OperatorPropertiesKeysMathOperationFieldsOrder is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMathOperationFieldsOrder = "MATH_OPERATION_FIELDS_ORDER"

	// OperatorPropertiesKeysConcatFormat is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysConcatFormat = "CONCAT_FORMAT"

	// OperatorPropertiesKeysSubfieldCategoryMap is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSubfieldCategoryMap = "SUBFIELD_CATEGORY_MAP"
)

// OperatorPropertiesKeys_Values returns all elements of the OperatorPropertiesKeys enum
func OperatorPropertiesKeys_Values() []string {
	return []string{
		OperatorPropertiesKeysValue,
		OperatorPropertiesKeysValues,
		OperatorPropertiesKeysDataType,
		OperatorPropertiesKeysUpperBound,
		OperatorPropertiesKeysLowerBound,
		OperatorPropertiesKeysSourceDataType,
		OperatorPropertiesKeysDestinationDataType,
		OperatorPropertiesKeysValidationAction,
		OperatorPropertiesKeysMaskValue,
		OperatorPropertiesKeysMaskLength,
		OperatorPropertiesKeysTruncateLength,
		OperatorPropertiesKeysMathOperationFieldsOrder,
		OperatorPropertiesKeysConcatFormat,
		OperatorPropertiesKeysSubfieldCategoryMap,
	}
}

const (
	// PrefixFormatYear is a PrefixFormat enum value
	PrefixFormatYear = "YEAR"

	// PrefixFormatMonth is a PrefixFormat enum value
	PrefixFormatMonth = "MONTH"

	// PrefixFormatDay is a PrefixFormat enum value
	PrefixFormatDay = "DAY"

	// PrefixFormatHour is a PrefixFormat enum value
	PrefixFormatHour = "HOUR"

	// PrefixFormatMinute is a PrefixFormat enum value
	PrefixFormatMinute = "MINUTE"
)

// PrefixFormat_Values returns all elements of the PrefixFormat enum
func PrefixFormat_Values() []string {
	return []string{
		PrefixFormatYear,
		PrefixFormatMonth,
		PrefixFormatDay,
		PrefixFormatHour,
		PrefixFormatMinute,
	}
}

const (
	// PrefixTypeFilename is a PrefixType enum value
	PrefixTypeFilename = "FILENAME"

	// PrefixTypePath is a PrefixType enum value
	PrefixTypePath = "PATH"

	// PrefixTypePathAndFilename is a PrefixType enum value
	PrefixTypePathAndFilename = "PATH_AND_FILENAME"
)

// PrefixType_Values returns all elements of the PrefixType enum
func PrefixType_Values() []string {
	return []string{
		PrefixTypeFilename,
		PrefixTypePath,
		PrefixTypePathAndFilename,
	}
}

const (
	// S3ConnectorOperatorProjection is a S3ConnectorOperator enum value
	S3ConnectorOperatorProjection = "PROJECTION"

	// S3ConnectorOperatorLessThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThan = "LESS_THAN"

	// S3ConnectorOperatorGreaterThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThan = "GREATER_THAN"

	// S3ConnectorOperatorBetween is a S3ConnectorOperator enum value
	S3ConnectorOperatorBetween = "BETWEEN"

	// S3ConnectorOperatorLessThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorGreaterThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorEqualTo = "EQUAL_TO"

	// S3ConnectorOperatorNotEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// S3ConnectorOperatorAddition is a S3ConnectorOperator enum value
	S3ConnectorOperatorAddition = "ADDITION"

	// S3ConnectorOperatorMultiplication is a S3ConnectorOperator enum value
	S3ConnectorOperatorMultiplication = "MULTIPLICATION"

	// S3ConnectorOperatorDivision is a S3ConnectorOperator enum value
	S3ConnectorOperatorDivision = "DIVISION"

	// S3ConnectorOperatorSubtraction is a S3ConnectorOperator enum value
	S3ConnectorOperatorSubtraction = "SUBTRACTION"

	// S3ConnectorOperatorMaskAll is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskAll = "MASK_ALL"

	// S3ConnectorOperatorMaskFirstN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// S3ConnectorOperatorMaskLastN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskLastN = "MASK_LAST_N"

	// S3ConnectorOperatorValidateNonNull is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// S3ConnectorOperatorValidateNonZero is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// S3ConnectorOperatorValidateNonNegative is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// S3ConnectorOperatorValidateNumeric is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// S3ConnectorOperatorNoOp is a S3ConnectorOperator enum value
	S3ConnectorOperatorNoOp = "NO_OP"
)

// S3ConnectorOperator_Values returns all elements of the S3ConnectorOperator enum
func S3ConnectorOperator_Values() []string {
	return []string{
		S3ConnectorOperatorProjection,
		S3ConnectorOperatorLessThan,
		S3ConnectorOperatorGreaterThan,
		S3ConnectorOperatorBetween,
		S3ConnectorOperatorLessThanOrEqualTo,
		S3ConnectorOperatorGreaterThanOrEqualTo,
		S3ConnectorOperatorEqualTo,
		S3ConnectorOperatorNotEqualTo,
		S3ConnectorOperatorAddition,
		S3ConnectorOperatorMultiplication,
		S3ConnectorOperatorDivision,
		S3ConnectorOperatorSubtraction,
		S3ConnectorOperatorMaskAll,
		S3ConnectorOperatorMaskFirstN,
		S3ConnectorOperatorMaskLastN,
		S3ConnectorOperatorValidateNonNull,
		S3ConnectorOperatorValidateNonZero,
		S3ConnectorOperatorValidateNonNegative,
		S3ConnectorOperatorValidateNumeric,
		S3ConnectorOperatorNoOp,
	}
}

const (
	// SalesforceConnectorOperatorProjection is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorProjection = "PROJECTION"

	// SalesforceConnectorOperatorLessThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThan = "LESS_THAN"

	// SalesforceConnectorOperatorContains is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorContains = "CONTAINS"

	// SalesforceConnectorOperatorGreaterThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThan = "GREATER_THAN"

	// SalesforceConnectorOperatorBetween is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorBetween = "BETWEEN"

	// SalesforceConnectorOperatorLessThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorGreaterThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorEqualTo = "EQUAL_TO"

	// SalesforceConnectorOperatorNotEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// SalesforceConnectorOperatorAddition is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorAddition = "ADDITION"

	// SalesforceConnectorOperatorMultiplication is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMultiplication = "MULTIPLICATION"

	// SalesforceConnectorOperatorDivision is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorDivision = "DIVISION"

	// SalesforceConnectorOperatorSubtraction is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorSubtraction = "SUBTRACTION"

	// SalesforceConnectorOperatorMaskAll is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskAll = "MASK_ALL"

	// SalesforceConnectorOperatorMaskFirstN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// SalesforceConnectorOperatorMaskLastN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskLastN = "MASK_LAST_N"

	// SalesforceConnectorOperatorValidateNonNull is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// SalesforceConnectorOperatorValidateNonZero is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// SalesforceConnectorOperatorValidateNonNegative is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// SalesforceConnectorOperatorValidateNumeric is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// SalesforceConnectorOperatorNoOp is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNoOp = "NO_OP"
)

// SalesforceConnectorOperator_Values returns all elements of the SalesforceConnectorOperator enum
func SalesforceConnectorOperator_Values() []string {
	return []string{
		SalesforceConnectorOperatorProjection,
		SalesforceConnectorOperatorLessThan,
		SalesforceConnectorOperatorContains,
		SalesforceConnectorOperatorGreaterThan,
		SalesforceConnectorOperatorBetween,
		SalesforceConnectorOperatorLessThanOrEqualTo,
		SalesforceConnectorOperatorGreaterThanOrEqualTo,
		SalesforceConnectorOperatorEqualTo,
		SalesforceConnectorOperatorNotEqualTo,
		SalesforceConnectorOperatorAddition,
		SalesforceConnectorOperatorMultiplication,
		SalesforceConnectorOperatorDivision,
		SalesforceConnectorOperatorSubtraction,
		SalesforceConnectorOperatorMaskAll,
		SalesforceConnectorOperatorMaskFirstN,
		SalesforceConnectorOperatorMaskLastN,
		SalesforceConnectorOperatorValidateNonNull,
		SalesforceConnectorOperatorValidateNonZero,
		SalesforceConnectorOperatorValidateNonNegative,
		SalesforceConnectorOperatorValidateNumeric,
		SalesforceConnectorOperatorNoOp,
	}
}

const (
	// ScheduleFrequencyTypeByminute is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeByminute = "BYMINUTE"

	// ScheduleFrequencyTypeHourly is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeHourly = "HOURLY"

	// ScheduleFrequencyTypeDaily is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeDaily = "DAILY"

	// ScheduleFrequencyTypeWeekly is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeWeekly = "WEEKLY"

	// ScheduleFrequencyTypeMonthly is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeMonthly = "MONTHLY"

	// ScheduleFrequencyTypeOnce is a ScheduleFrequencyType enum value
	ScheduleFrequencyTypeOnce = "ONCE"
)

// ScheduleFrequencyType_Values returns all elements of the ScheduleFrequencyType enum
func ScheduleFrequencyType_Values() []string {
	return []string{
		ScheduleFrequencyTypeByminute,
		ScheduleFrequencyTypeHourly,
		ScheduleFrequencyTypeDaily,
		ScheduleFrequencyTypeWeekly,
		ScheduleFrequencyTypeMonthly,
		ScheduleFrequencyTypeOnce,
	}
}

const (
	// ServiceNowConnectorOperatorProjection is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorProjection = "PROJECTION"

	// ServiceNowConnectorOperatorContains is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorContains = "CONTAINS"

	// ServiceNowConnectorOperatorLessThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThan = "LESS_THAN"

	// ServiceNowConnectorOperatorGreaterThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThan = "GREATER_THAN"

	// ServiceNowConnectorOperatorBetween is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorBetween = "BETWEEN"

	// ServiceNowConnectorOperatorLessThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorGreaterThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorEqualTo = "EQUAL_TO"

	// ServiceNowConnectorOperatorNotEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// ServiceNowConnectorOperatorAddition is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorAddition = "ADDITION"

	// ServiceNowConnectorOperatorMultiplication is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMultiplication = "MULTIPLICATION"

	// ServiceNowConnectorOperatorDivision is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorDivision = "DIVISION"

	// ServiceNowConnectorOperatorSubtraction is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorSubtraction = "SUBTRACTION"

	// ServiceNowConnectorOperatorMaskAll is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskAll = "MASK_ALL"

	// ServiceNowConnectorOperatorMaskFirstN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ServiceNowConnectorOperatorMaskLastN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ServiceNowConnectorOperatorValidateNonNull is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ServiceNowConnectorOperatorValidateNonZero is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ServiceNowConnectorOperatorValidateNonNegative is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ServiceNowConnectorOperatorValidateNumeric is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ServiceNowConnectorOperatorNoOp is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNoOp = "NO_OP"
)

// ServiceNowConnectorOperator_Values returns all elements of the ServiceNowConnectorOperator enum
func ServiceNowConnectorOperator_Values() []string {
	return []string{
		ServiceNowConnectorOperatorProjection,
		ServiceNowConnectorOperatorContains,
		ServiceNowConnectorOperatorLessThan,
		ServiceNowConnectorOperatorGreaterThan,
		ServiceNowConnectorOperatorBetween,
		ServiceNowConnectorOperatorLessThanOrEqualTo,
		ServiceNowConnectorOperatorGreaterThanOrEqualTo,
		ServiceNowConnectorOperatorEqualTo,
		ServiceNowConnectorOperatorNotEqualTo,
		ServiceNowConnectorOperatorAddition,
		ServiceNowConnectorOperatorMultiplication,
		ServiceNowConnectorOperatorDivision,
		ServiceNowConnectorOperatorSubtraction,
		ServiceNowConnectorOperatorMaskAll,
		ServiceNowConnectorOperatorMaskFirstN,
		ServiceNowConnectorOperatorMaskLastN,
		ServiceNowConnectorOperatorValidateNonNull,
		ServiceNowConnectorOperatorValidateNonZero,
		ServiceNowConnectorOperatorValidateNonNegative,
		ServiceNowConnectorOperatorValidateNumeric,
		ServiceNowConnectorOperatorNoOp,
	}
}

const (
	// SingularConnectorOperatorProjection is a SingularConnectorOperator enum value
	SingularConnectorOperatorProjection = "PROJECTION"

	// SingularConnectorOperatorEqualTo is a SingularConnectorOperator enum value
	SingularConnectorOperatorEqualTo = "EQUAL_TO"

	// SingularConnectorOperatorAddition is a SingularConnectorOperator enum value
	SingularConnectorOperatorAddition = "ADDITION"

	// SingularConnectorOperatorMultiplication is a SingularConnectorOperator enum value
	SingularConnectorOperatorMultiplication = "MULTIPLICATION"

	// SingularConnectorOperatorDivision is a SingularConnectorOperator enum value
	SingularConnectorOperatorDivision = "DIVISION"

	// SingularConnectorOperatorSubtraction is a SingularConnectorOperator enum value
	SingularConnectorOperatorSubtraction = "SUBTRACTION"

	// SingularConnectorOperatorMaskAll is a SingularConnectorOperator enum value
	SingularConnectorOperatorMaskAll = "MASK_ALL"

	// SingularConnectorOperatorMaskFirstN is a SingularConnectorOperator enum value
	SingularConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// SingularConnectorOperatorMaskLastN is a SingularConnectorOperator enum value
	SingularConnectorOperatorMaskLastN = "MASK_LAST_N"

	// SingularConnectorOperatorValidateNonNull is a SingularConnectorOperator enum value
	SingularConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// SingularConnectorOperatorValidateNonZero is a SingularConnectorOperator enum value
	SingularConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// SingularConnectorOperatorValidateNonNegative is a SingularConnectorOperator enum value
	SingularConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// SingularConnectorOperatorValidateNumeric is a SingularConnectorOperator enum value
	SingularConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// SingularConnectorOperatorNoOp is a SingularConnectorOperator enum value
	SingularConnectorOperatorNoOp = "NO_OP"
)

// SingularConnectorOperator_Values returns all elements of the SingularConnectorOperator enum
func SingularConnectorOperator_Values() []string {
	return []string{
		SingularConnectorOperatorProjection,
		SingularConnectorOperatorEqualTo,
		SingularConnectorOperatorAddition,
		SingularConnectorOperatorMultiplication,
		SingularConnectorOperatorDivision,
		SingularConnectorOperatorSubtraction,
		SingularConnectorOperatorMaskAll,
		SingularConnectorOperatorMaskFirstN,
		SingularConnectorOperatorMaskLastN,
		SingularConnectorOperatorValidateNonNull,
		SingularConnectorOperatorValidateNonZero,
		SingularConnectorOperatorValidateNonNegative,
		SingularConnectorOperatorValidateNumeric,
		SingularConnectorOperatorNoOp,
	}
}

const (
	// SlackConnectorOperatorProjection is a SlackConnectorOperator enum value
	SlackConnectorOperatorProjection = "PROJECTION"

	// SlackConnectorOperatorLessThan is a SlackConnectorOperator enum value
	SlackConnectorOperatorLessThan = "LESS_THAN"

	// SlackConnectorOperatorGreaterThan is a SlackConnectorOperator enum value
	SlackConnectorOperatorGreaterThan = "GREATER_THAN"

	// SlackConnectorOperatorBetween is a SlackConnectorOperator enum value
	SlackConnectorOperatorBetween = "BETWEEN"

	// SlackConnectorOperatorLessThanOrEqualTo is a SlackConnectorOperator enum value
	SlackConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// SlackConnectorOperatorGreaterThanOrEqualTo is a SlackConnectorOperator enum value
	SlackConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// SlackConnectorOperatorEqualTo is a SlackConnectorOperator enum value
	SlackConnectorOperatorEqualTo = "EQUAL_TO"

	// SlackConnectorOperatorAddition is a SlackConnectorOperator enum value
	SlackConnectorOperatorAddition = "ADDITION"

	// SlackConnectorOperatorMultiplication is a SlackConnectorOperator enum value
	SlackConnectorOperatorMultiplication = "MULTIPLICATION"

	// SlackConnectorOperatorDivision is a SlackConnectorOperator enum value
	SlackConnectorOperatorDivision = "DIVISION"

	// SlackConnectorOperatorSubtraction is a SlackConnectorOperator enum value
	SlackConnectorOperatorSubtraction = "SUBTRACTION"

	// SlackConnectorOperatorMaskAll is a SlackConnectorOperator enum value
	SlackConnectorOperatorMaskAll = "MASK_ALL"

	// SlackConnectorOperatorMaskFirstN is a SlackConnectorOperator enum value
	SlackConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// SlackConnectorOperatorMaskLastN is a SlackConnectorOperator enum value
	SlackConnectorOperatorMaskLastN = "MASK_LAST_N"

	// SlackConnectorOperatorValidateNonNull is a SlackConnectorOperator enum value
	SlackConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// SlackConnectorOperatorValidateNonZero is a SlackConnectorOperator enum value
	SlackConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// SlackConnectorOperatorValidateNonNegative is a SlackConnectorOperator enum value
	SlackConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// SlackConnectorOperatorValidateNumeric is a SlackConnectorOperator enum value
	SlackConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// SlackConnectorOperatorNoOp is a SlackConnectorOperator enum value
	SlackConnectorOperatorNoOp = "NO_OP"
)

// SlackConnectorOperator_Values returns all elements of the SlackConnectorOperator enum
func SlackConnectorOperator_Values() []string {
	return []string{
		SlackConnectorOperatorProjection,
		SlackConnectorOperatorLessThan,
		SlackConnectorOperatorGreaterThan,
		SlackConnectorOperatorBetween,
		SlackConnectorOperatorLessThanOrEqualTo,
		SlackConnectorOperatorGreaterThanOrEqualTo,
		SlackConnectorOperatorEqualTo,
		SlackConnectorOperatorAddition,
		SlackConnectorOperatorMultiplication,
		SlackConnectorOperatorDivision,
		SlackConnectorOperatorSubtraction,
		SlackConnectorOperatorMaskAll,
		SlackConnectorOperatorMaskFirstN,
		SlackConnectorOperatorMaskLastN,
		SlackConnectorOperatorValidateNonNull,
		SlackConnectorOperatorValidateNonZero,
		SlackConnectorOperatorValidateNonNegative,
		SlackConnectorOperatorValidateNumeric,
		SlackConnectorOperatorNoOp,
	}
}

const (
	// TaskTypeArithmetic is a TaskType enum value
	TaskTypeArithmetic = "Arithmetic"

	// TaskTypeFilter is a TaskType enum value
	TaskTypeFilter = "Filter"

	// TaskTypeMap is a TaskType enum value
	TaskTypeMap = "Map"

	// TaskTypeMask is a TaskType enum value
	TaskTypeMask = "Mask"

	// TaskTypeMerge is a TaskType enum value
	TaskTypeMerge = "Merge"

	// TaskTypeTruncate is a TaskType enum value
	TaskTypeTruncate = "Truncate"

	// TaskTypeValidate is a TaskType enum value
	TaskTypeValidate = "Validate"
)

// TaskType_Values returns all elements of the TaskType enum
func TaskType_Values() []string {
	return []string{
		TaskTypeArithmetic,
		TaskTypeFilter,
		TaskTypeMap,
		TaskTypeMask,
		TaskTypeMerge,
		TaskTypeTruncate,
		TaskTypeValidate,
	}
}

const (
	// TrendmicroConnectorOperatorProjection is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorProjection = "PROJECTION"

	// TrendmicroConnectorOperatorEqualTo is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorEqualTo = "EQUAL_TO"

	// TrendmicroConnectorOperatorAddition is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorAddition = "ADDITION"

	// TrendmicroConnectorOperatorMultiplication is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorMultiplication = "MULTIPLICATION"

	// TrendmicroConnectorOperatorDivision is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorDivision = "DIVISION"

	// TrendmicroConnectorOperatorSubtraction is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorSubtraction = "SUBTRACTION"

	// TrendmicroConnectorOperatorMaskAll is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorMaskAll = "MASK_ALL"

	// TrendmicroConnectorOperatorMaskFirstN is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// TrendmicroConnectorOperatorMaskLastN is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorMaskLastN = "MASK_LAST_N"

	// TrendmicroConnectorOperatorValidateNonNull is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// TrendmicroConnectorOperatorValidateNonZero is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// TrendmicroConnectorOperatorValidateNonNegative is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// TrendmicroConnectorOperatorValidateNumeric is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// TrendmicroConnectorOperatorNoOp is a TrendmicroConnectorOperator enum value
	TrendmicroConnectorOperatorNoOp = "NO_OP"
)

// TrendmicroConnectorOperator_Values returns all elements of the TrendmicroConnectorOperator enum
func TrendmicroConnectorOperator_Values() []string {
	return []string{
		TrendmicroConnectorOperatorProjection,
		TrendmicroConnectorOperatorEqualTo,
		TrendmicroConnectorOperatorAddition,
		TrendmicroConnectorOperatorMultiplication,
		TrendmicroConnectorOperatorDivision,
		TrendmicroConnectorOperatorSubtraction,
		TrendmicroConnectorOperatorMaskAll,
		TrendmicroConnectorOperatorMaskFirstN,
		TrendmicroConnectorOperatorMaskLastN,
		TrendmicroConnectorOperatorValidateNonNull,
		TrendmicroConnectorOperatorValidateNonZero,
		TrendmicroConnectorOperatorValidateNonNegative,
		TrendmicroConnectorOperatorValidateNumeric,
		TrendmicroConnectorOperatorNoOp,
	}
}

const (
	// TriggerTypeScheduled is a TriggerType enum value
	TriggerTypeScheduled = "Scheduled"

	// TriggerTypeEvent is a TriggerType enum value
	TriggerTypeEvent = "Event"

	// TriggerTypeOnDemand is a TriggerType enum value
	TriggerTypeOnDemand = "OnDemand"
)

// TriggerType_Values returns all elements of the TriggerType enum
func TriggerType_Values() []string {
	return []string{
		TriggerTypeScheduled,
		TriggerTypeEvent,
		TriggerTypeOnDemand,
	}
}

const (
	// VeevaConnectorOperatorProjection is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorProjection = "PROJECTION"

	// VeevaConnectorOperatorLessThan is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorLessThan = "LESS_THAN"

	// VeevaConnectorOperatorGreaterThan is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorGreaterThan = "GREATER_THAN"

	// VeevaConnectorOperatorContains is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorContains = "CONTAINS"

	// VeevaConnectorOperatorBetween is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorBetween = "BETWEEN"

	// VeevaConnectorOperatorLessThanOrEqualTo is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// VeevaConnectorOperatorGreaterThanOrEqualTo is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// VeevaConnectorOperatorEqualTo is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorEqualTo = "EQUAL_TO"

	// VeevaConnectorOperatorNotEqualTo is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// VeevaConnectorOperatorAddition is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorAddition = "ADDITION"

	// VeevaConnectorOperatorMultiplication is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorMultiplication = "MULTIPLICATION"

	// VeevaConnectorOperatorDivision is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorDivision = "DIVISION"

	// VeevaConnectorOperatorSubtraction is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorSubtraction = "SUBTRACTION"

	// VeevaConnectorOperatorMaskAll is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorMaskAll = "MASK_ALL"

	// VeevaConnectorOperatorMaskFirstN is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// VeevaConnectorOperatorMaskLastN is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorMaskLastN = "MASK_LAST_N"

	// VeevaConnectorOperatorValidateNonNull is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// VeevaConnectorOperatorValidateNonZero is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// VeevaConnectorOperatorValidateNonNegative is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// VeevaConnectorOperatorValidateNumeric is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// VeevaConnectorOperatorNoOp is a VeevaConnectorOperator enum value
	VeevaConnectorOperatorNoOp = "NO_OP"
)

// VeevaConnectorOperator_Values returns all elements of the VeevaConnectorOperator enum
func VeevaConnectorOperator_Values() []string {
	return []string{
		VeevaConnectorOperatorProjection,
		VeevaConnectorOperatorLessThan,
		VeevaConnectorOperatorGreaterThan,
		VeevaConnectorOperatorContains,
		VeevaConnectorOperatorBetween,
		VeevaConnectorOperatorLessThanOrEqualTo,
		VeevaConnectorOperatorGreaterThanOrEqualTo,
		VeevaConnectorOperatorEqualTo,
		VeevaConnectorOperatorNotEqualTo,
		VeevaConnectorOperatorAddition,
		VeevaConnectorOperatorMultiplication,
		VeevaConnectorOperatorDivision,
		VeevaConnectorOperatorSubtraction,
		VeevaConnectorOperatorMaskAll,
		VeevaConnectorOperatorMaskFirstN,
		VeevaConnectorOperatorMaskLastN,
		VeevaConnectorOperatorValidateNonNull,
		VeevaConnectorOperatorValidateNonZero,
		VeevaConnectorOperatorValidateNonNegative,
		VeevaConnectorOperatorValidateNumeric,
		VeevaConnectorOperatorNoOp,
	}
}

// The possible write operations in the destination connector. When this value
// is not provided, this defaults to the INSERT operation.
const (
	// WriteOperationTypeInsert is a WriteOperationType enum value
	WriteOperationTypeInsert = "INSERT"

	// WriteOperationTypeUpsert is a WriteOperationType enum value
	WriteOperationTypeUpsert = "UPSERT"

	// WriteOperationTypeUpdate is a WriteOperationType enum value
	WriteOperationTypeUpdate = "UPDATE"
)

// WriteOperationType_Values returns all elements of the WriteOperationType enum
func WriteOperationType_Values() []string {
	return []string{
		WriteOperationTypeInsert,
		WriteOperationTypeUpsert,
		WriteOperationTypeUpdate,
	}
}

const (
	// ZendeskConnectorOperatorProjection is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorProjection = "PROJECTION"

	// ZendeskConnectorOperatorGreaterThan is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorGreaterThan = "GREATER_THAN"

	// ZendeskConnectorOperatorAddition is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorAddition = "ADDITION"

	// ZendeskConnectorOperatorMultiplication is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMultiplication = "MULTIPLICATION"

	// ZendeskConnectorOperatorDivision is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorDivision = "DIVISION"

	// ZendeskConnectorOperatorSubtraction is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorSubtraction = "SUBTRACTION"

	// ZendeskConnectorOperatorMaskAll is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskAll = "MASK_ALL"

	// ZendeskConnectorOperatorMaskFirstN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ZendeskConnectorOperatorMaskLastN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ZendeskConnectorOperatorValidateNonNull is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ZendeskConnectorOperatorValidateNonZero is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ZendeskConnectorOperatorValidateNonNegative is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ZendeskConnectorOperatorValidateNumeric is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ZendeskConnectorOperatorNoOp is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorNoOp = "NO_OP"
)

// ZendeskConnectorOperator_Values returns all elements of the ZendeskConnectorOperator enum
func ZendeskConnectorOperator_Values() []string {
	return []string{
		ZendeskConnectorOperatorProjection,
		ZendeskConnectorOperatorGreaterThan,
		ZendeskConnectorOperatorAddition,
		ZendeskConnectorOperatorMultiplication,
		ZendeskConnectorOperatorDivision,
		ZendeskConnectorOperatorSubtraction,
		ZendeskConnectorOperatorMaskAll,
		ZendeskConnectorOperatorMaskFirstN,
		ZendeskConnectorOperatorMaskLastN,
		ZendeskConnectorOperatorValidateNonNull,
		ZendeskConnectorOperatorValidateNonZero,
		ZendeskConnectorOperatorValidateNonNegative,
		ZendeskConnectorOperatorValidateNumeric,
		ZendeskConnectorOperatorNoOp,
	}
}
